/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.util;

import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.util.FormattingVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public final class JsoupUtils {
    private JsoupUtils() {
    }

    public static Element emptyElement() {
        return new Element("div");
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element.childNodes().isEmpty();
    }

    public static Element parseBody(String html) {
        Element body = Jsoup.parseBodyFragment((String)html).body();
        Elements children = body.children();
        if (children.isEmpty()) {
            return JsoupUtils.emptyElement();
        }
        if (children.size() == 1) {
            return children.first();
        }
        return body.tagName("div");
    }

    public static String getPlainText(Element element) {
        return JsoupUtils.getPlainText(element, Integer.MAX_VALUE);
    }

    public static String getPlainText(Element element, int maxLineLength) {
        Preconditions.checkNotNull((Object)element, (Object)"element should not be null");
        Preconditions.checkArgument((maxLineLength > 0 ? 1 : 0) != 0, (Object)"maxLineLength should be greater than 0");
        FormattingVisitor formatter = new FormattingVisitor(maxLineLength);
        NodeTraversor.traverse((NodeVisitor)formatter, (Node)element);
        String string = formatter.toString().replace("\n\n\n", "\n");
        if (string.startsWith("\n")) {
            string = string.substring(1);
        }
        return string.replace("\n", System.lineSeparator());
    }
}

