/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.forgesvc;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseFiles;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcAttachment;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcCategory;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcCategorySection;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcFile;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcMember;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.project.CurseAttachment;
import com.therandomlabs.curseapi.project.CurseMember;
import com.therandomlabs.curseapi.project.CurseProject;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import org.jsoup.nodes.Element;

final class ForgeSvcProject
extends CurseProject {
    private int id;
    private String name;
    private List<ForgeSvcMember> authors;
    private Set<ForgeSvcAttachment> attachments;
    private HttpUrl websiteUrl;
    private int gameId;
    private String summary;
    private int downloadCount;
    private Set<ForgeSvcCategory> categories;
    private int primaryCategoryId;
    private ForgeSvcCategorySection categorySection;
    private String slug;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateReleased;
    private ZonedDateTime dateModified;
    private boolean isExperiemental;
    private transient CurseGame game;
    private transient Element description;
    private transient CurseFiles<CurseFile> files;

    ForgeSvcProject() {
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CurseMember author() {
        return this.authors.get(0);
    }

    @Override
    public Set<CurseMember> authors() {
        return new LinkedHashSet<CurseMember>(this.authors);
    }

    @Override
    public Set<CurseAttachment> attachments() {
        return this.attachments.stream().filter(attachment -> !attachment.isLogo()).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public CurseAttachment logo() {
        for (ForgeSvcAttachment attachment : this.attachments) {
            if (!attachment.isLogo()) continue;
            return attachment;
        }
        return CurseAttachment.PLACEHOLDER_LOGO;
    }

    @Override
    public HttpUrl url() {
        return this.websiteUrl;
    }

    @Override
    public int gameID() {
        return this.gameId;
    }

    @Override
    public CurseGame game() throws CurseException {
        if (this.game == null) {
            Optional<CurseGame> optionalGame = CurseAPI.game(this.gameId);
            if (!optionalGame.isPresent()) {
                throw new CurseException("Could not retrieve game for project: " + this);
            }
            this.game = optionalGame.get();
        }
        return this.game;
    }

    @Override
    public CurseGame refreshGame() throws CurseException {
        this.game = null;
        return this.game();
    }

    @Override
    public String summary() {
        return this.summary;
    }

    @Override
    public Element description() throws CurseException {
        if (this.description == null) {
            Optional<Element> optionalDescription = CurseAPI.projectDescription(this.id);
            if (!optionalDescription.isPresent()) {
                throw new CurseException("Failed to retrieve description for project: " + this);
            }
            this.description = optionalDescription.get();
        }
        return this.description;
    }

    @Override
    public Element refreshDescription() throws CurseException {
        this.description = null;
        return this.description();
    }

    @Override
    public int downloadCount() {
        return this.downloadCount;
    }

    @Override
    public CurseFiles<CurseFile> files() throws CurseException {
        if (this.files == null) {
            this.files = CurseAPI.files(this.id).orElse(null);
            if (this.files == null) {
                throw new CurseException("Failed to retrieve project files: " + this);
            }
            for (CurseFile file : this.files) {
                if (!(file instanceof ForgeSvcFile)) continue;
                ((ForgeSvcFile)file).setProject(this);
            }
        }
        return new CurseFiles<CurseFile>((Collection<CurseFile>)this.files);
    }

    @Override
    public CurseFiles<CurseFile> refreshFiles() throws CurseException {
        this.files = null;
        return this.files();
    }

    @Override
    public HttpUrl fileURL(int fileID) {
        CursePreconditions.checkFileID(fileID, "fileID");
        return HttpUrl.get((String)(this.websiteUrl + "/files/" + fileID));
    }

    @Override
    public CurseCategory primaryCategory() {
        for (CurseCategory curseCategory : this.categories) {
            if (curseCategory.id() != this.primaryCategoryId) continue;
            return curseCategory;
        }
        throw new IllegalStateException("Primary category not found");
    }

    @Override
    public Set<CurseCategory> categories() {
        return new LinkedHashSet<CurseCategory>(this.categories);
    }

    @Override
    public CurseCategorySection categorySection() {
        return this.categorySection;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.dateCreated;
    }

    @Override
    public ZonedDateTime lastUpdateTime() {
        return this.dateReleased;
    }

    @Override
    public ZonedDateTime lastModificationTime() {
        return this.dateModified;
    }

    @Override
    public boolean experimental() {
        return this.isExperiemental;
    }
}

