/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.forgesvc;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.file.CurseAlternateFile;
import com.therandomlabs.curseapi.file.CurseDependency;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseFileStatus;
import com.therandomlabs.curseapi.file.CurseReleaseType;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcAlternateFile;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcDependency;
import com.therandomlabs.curseapi.project.CurseProject;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ForgeSvcFile
extends CurseFile {
    private int projectId;
    private int id;
    private String displayName;
    private String fileName;
    private ZonedDateTime fileDate;
    private long fileLength;
    private int releaseType;
    private int fileStatus;
    private HttpUrl downloadUrl;
    private int alternateFileId;
    private Set<ForgeSvcDependency> dependencies;
    private Set<String> gameVersion;
    private transient ForgeSvcAlternateFile alternateFile;
    private transient boolean dependenciesInitialized;
    private transient CurseProject project;

    ForgeSvcFile() {
    }

    @Override
    public int projectID() {
        return this.projectId;
    }

    @Override
    public @NonNull CurseProject project() throws CurseException {
        if (this.project == null) {
            Optional<CurseProject> optionalProject = CurseAPI.project(this.projectId);
            if (!optionalProject.isPresent()) {
                throw new CurseException("Failed to retrieve CurseProject: " + this);
            }
            this.project = optionalProject.get();
        }
        return this.project;
    }

    @Override
    public CurseProject refreshProject() throws CurseException {
        this.project = null;
        return this.project();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public String nameOnDisk() {
        return this.fileName;
    }

    @Override
    public ZonedDateTime uploadTime() {
        return this.fileDate;
    }

    @Override
    public long fileSize() {
        return this.fileLength;
    }

    @Override
    public CurseReleaseType releaseType() {
        return CurseReleaseType.fromID(this.releaseType);
    }

    @Override
    public CurseFileStatus status() {
        return CurseFileStatus.fromID(this.fileStatus);
    }

    @Override
    public HttpUrl downloadURL() {
        return this.downloadUrl;
    }

    @Override
    public int alternateFileID() {
        return this.alternateFileId;
    }

    @Override
    public CurseAlternateFile alternateFile() {
        if (!this.hasAlternateFile()) {
            return null;
        }
        if (this.alternateFile == null) {
            this.alternateFile = new ForgeSvcAlternateFile(this, this.project);
        }
        return this.alternateFile;
    }

    @Override
    public Set<CurseDependency> dependencies() {
        if (!this.dependenciesInitialized) {
            for (ForgeSvcDependency dependency : this.dependencies) {
                dependency.setDependent(this);
            }
            this.dependenciesInitialized = true;
        }
        return new HashSet<CurseDependency>(this.dependencies);
    }

    @Override
    public Set<String> gameVersionStrings() {
        return new LinkedHashSet<String>(this.gameVersion);
    }

    void setProjectID(int id) {
        this.projectId = id;
    }

    void setProject(CurseProject project) {
        this.project = project;
    }
}

