/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.project.CurseProject;
import com.therandomlabs.curseapi.util.JsoupUtils;
import com.therandomlabs.curseapi.util.OkHttpUtils;
import java.nio.file.Path;
import java.util.Optional;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;

public interface ExistingCurseFile {
    public HttpUrl downloadURL() throws CurseException;

    default public void download(Path path) throws CurseException {
        OkHttpUtils.download(this.downloadURL(), path);
    }

    default public Path downloadToDirectory(Path directory) throws CurseException {
        HttpUrl url = this.downloadURL();
        return OkHttpUtils.downloadToDirectory(url, directory, OkHttpUtils.getFileNameFromURLPath(url));
    }

    public HttpUrl refreshDownloadURL() throws CurseException;

    public Element changelog() throws CurseException;

    default public String changelogPlainText() throws CurseException {
        return this.changelogPlainText(Integer.MAX_VALUE);
    }

    default public String changelogPlainText(int maxLineLength) throws CurseException {
        Preconditions.checkArgument((maxLineLength > 0 ? 1 : 0) != 0, (Object)"maxLineLength should be greater than 0");
        return JsoupUtils.getPlainText(this.changelog(), maxLineLength).trim();
    }

    public Element refreshChangelog() throws CurseException;

    public static class Existing
    extends BasicCurseFile.Immutable
    implements ExistingCurseFile {
        private transient @Nullable HttpUrl downloadURL;
        private transient @Nullable Element changelog;

        public Existing(int projectID, int fileID) {
            super(projectID, fileID);
        }

        @Override
        public @NonNull CurseProject project() throws CurseException {
            CurseProject project = super.project();
            if (project == null) {
                throw new CurseException("Project does not exist: " + this);
            }
            return project;
        }

        @Override
        public HttpUrl url() throws CurseException {
            return this.project().fileURL(this.id());
        }

        @Override
        public HttpUrl downloadURL() throws CurseException {
            if (this.downloadURL == null) {
                Optional<HttpUrl> optionalDownloadURL = CurseAPI.fileDownloadURL(this.projectID(), this.id());
                if (!optionalDownloadURL.isPresent()) {
                    throw new CurseException("File does not exist: " + this);
                }
                this.downloadURL = optionalDownloadURL.get();
            }
            return this.downloadURL;
        }

        @Override
        public HttpUrl refreshDownloadURL() throws CurseException {
            this.downloadURL = null;
            return this.downloadURL();
        }

        @Override
        public Element changelog() throws CurseException {
            if (this.changelog == null) {
                Optional<Element> optionalChangelog = CurseAPI.fileChangelog(this.projectID(), this.id());
                if (!optionalChangelog.isPresent()) {
                    throw new CurseException("File does not exist: " + this);
                }
                this.changelog = optionalChangelog.get();
            }
            return this.changelog;
        }

        @Override
        public Element refreshChangelog() throws CurseException {
            this.changelog = null;
            return this.changelog();
        }
    }
}

