/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.toml;

import com.electronwill.toml.FastStringWriter;
import com.electronwill.toml.TomlException;
import com.electronwill.toml.TomlReader;
import com.electronwill.toml.TomlWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Map;

public final class Toml {
    public static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalEnd().optionalEnd().toFormatter();

    private Toml() {
    }

    public static String writeToString(Map<String, Object> data) throws IOException {
        FastStringWriter writer = new FastStringWriter();
        Toml.write(data, writer);
        return writer.toString();
    }

    public static void write(Map<String, Object> data, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        Toml.write(data, out);
    }

    public static void write(Map<String, Object> data, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        Toml.write(data, writer);
    }

    public static void write(Map<String, Object> data, Writer writer) throws IOException {
        TomlWriter tw = new TomlWriter(writer);
        tw.write(data);
        tw.close();
    }

    public static void write(Map<String, Object> data, Writer writer, int indentSize, boolean indentWithSpaces) throws IOException {
        TomlWriter tw = new TomlWriter(writer, indentSize, indentWithSpaces);
        tw.write(data);
        tw.close();
    }

    public static Map<String, Object> read(String toml) throws TomlException {
        return Toml.read(toml, false);
    }

    public static Map<String, Object> read(String toml, boolean strictAsciiBareKeys) {
        TomlReader tr = new TomlReader(toml, strictAsciiBareKeys);
        return tr.read();
    }

    public static Map<String, Object> read(File file) throws IOException, TomlException {
        return Toml.read(file, false);
    }

    public static Map<String, Object> read(File file, boolean strictAsciiBareKeys) throws IOException, TomlException {
        return Toml.read(new FileInputStream(file), strictAsciiBareKeys);
    }

    public static Map<String, Object> read(InputStream in) throws IOException, TomlException {
        return Toml.read(in, false);
    }

    public static Map<String, Object> read(InputStream in, boolean strictAsciiBareKeys) throws IOException, TomlException {
        return Toml.read(new InputStreamReader(in, StandardCharsets.UTF_8), in.available(), strictAsciiBareKeys);
    }

    public static Map<String, Object> read(Reader reader, int bufferSize, boolean strictAsciiBareKeys) throws IOException, TomlException {
        int read;
        StringBuilder sb = new StringBuilder(bufferSize);
        char[] buf = new char[8192];
        while ((read = reader.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        TomlReader tr = new TomlReader(sb.toString(), strictAsciiBareKeys);
        return tr.read();
    }
}

