/*
 * Decompiled with CFR 0.152.
 */
package nl.thedutchmc.httplib;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Http {
    private static boolean debugMode = false;

    public Http() {
    }

    public Http(boolean debugMode) {
        Http.debugMode = debugMode;
    }

    public ResponseObject makeRequest(RequestMethod method, String targetUrl, HashMap<String, String> params, MediaFormat requestBodyFormat, String requestBody, HashMap<String, String> customHeaders) throws MalformedURLException, IOException {
        Http http;
        String sParams = "";
        if (params != null) {
            sParams = "?" + Http.hashMapToString(params);
        }
        String sMethod = "";
        switch (method) {
            case GET: {
                sMethod = "GET";
                break;
            }
            case POST: {
                sMethod = "POST";
                break;
            }
            case PUT: {
                sMethod = "PUT";
                break;
            }
            case DELETE: {
                sMethod = "DELETE";
            }
        }
        URL url = new URL(targetUrl + sParams);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(sMethod);
        conn.setDoOutput(true);
        if (customHeaders != null) {
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (requestBody != null) {
            byte[] postData = requestBody.getBytes(StandardCharsets.UTF_8);
            conn.setRequestProperty("Content-Type", requestBodyFormat.getApplicationType());
            conn.setRequestProperty("Charset", "utf-8");
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Length", Integer.toString(postData.length));
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.write(postData);
            wr.flush();
        } else if (method == RequestMethod.POST) {
            requestBody = " ";
            conn.setRequestProperty("Content-Length", Integer.toString(requestBody.getBytes(StandardCharsets.UTF_8).length));
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.write(requestBody.getBytes(StandardCharsets.UTF_8));
            wr.flush();
        }
        String result = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            result = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            Http.logDebug("HttpRequest: " + (Object)((Object)method) + "::" + targetUrl);
            Http.logDebug("HttpRequest: " + conn.getResponseCode() + "::" + conn.getResponseMessage());
            Http.logDebug("HttpRequest ErrorStream: \n" + new BufferedReader(new InputStreamReader(conn.getErrorStream())).lines().collect(Collectors.joining("\n")));
            e.printStackTrace();
        }
        conn.disconnect();
        Http http2 = http = new Http();
        http2.getClass();
        return http2.new ResponseObject(result, conn.getResponseCode(), conn.getResponseMessage());
    }

    public static String hashMapToString(HashMap<String, String> input) {
        if (input == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int index = 1;
        for (Map.Entry<String, String> entry : input.entrySet()) {
            try {
                result.append(URLEncoder.encode(entry.getKey(), Charsets.UTF_8.toString()));
                result.append("=");
                result.append(URLEncoder.encode(entry.getValue(), Charsets.UTF_8.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (index != input.size()) {
                result.append("&");
            }
            ++index;
        }
        return result.toString();
    }

    private static void logDebug(Object log) {
        if (!debugMode) {
            return;
        }
        DateTimeFormatter f = DateTimeFormatter.ofPattern("kk:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        System.out.println("[" + now.format(f) + "][DEBUG][HttpLib] " + log.toString());
    }

    public class ResponseObject {
        private String content;
        private String connectionMessage;
        private int responseCode;

        public ResponseObject(String content, int responseCode, String connectionMessage) {
            this.content = content;
            this.responseCode = responseCode;
            this.connectionMessage = connectionMessage;
        }

        public String getMessage() {
            return this.content;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getConnectionMessage() {
            return this.connectionMessage;
        }
    }

    public static enum MediaFormat {
        JSON("application/json"),
        JPEG("application/jpeg"),
        PNG("application/png"),
        XML("application/xml"),
        X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded");

        private String applicationType;

        private MediaFormat(String applicationType) {
            this.applicationType = applicationType;
        }

        public String getApplicationType() {
            return this.applicationType;
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

