/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public class SoterTaskThread {
    private static final String TAG = "Soter.SoterTaskThread";
    private static final String HANDLER_THREAD_NAME = "SoterGenKeyHandlerThreadName";
    private static volatile SoterTaskThread mInstance = null;
    private Handler mTaskHandler = null;
    private Handler mMainLooperHandler = null;

    private SoterTaskThread() {
        HandlerThread taskHandlerThread = new HandlerThread(HANDLER_THREAD_NAME);
        taskHandlerThread.start();
        this.mTaskHandler = new Handler(taskHandlerThread.getLooper());
        this.mMainLooperHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoterTaskThread getInstance() {
        if (mInstance == null) {
            Class<SoterTaskThread> clazz = SoterTaskThread.class;
            synchronized (SoterTaskThread.class) {
                if (mInstance == null) {
                    mInstance = new SoterTaskThread();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return mInstance;
            }
        }
        return mInstance;
    }

    public void postToWorker(Runnable task) {
        this.mTaskHandler.post(task);
    }

    public void postToWorkerDelayed(Runnable task, long delayInMs) {
        this.mTaskHandler.postDelayed(task, delayInMs);
    }

    public void postToMainThread(Runnable task) {
        this.mMainLooperHandler.post(task);
    }

    public void postToMainThreadDelayed(Runnable task, long delayInMs) {
        this.mMainLooperHandler.postDelayed(task, delayInMs);
    }
}

