/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_callback;

import com.tencent.soter.core.model.SoterCoreResult;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;

public abstract class SoterProcessResultBase<T>
extends SoterCoreResult
implements SoterProcessErrCode {
    private T extData = null;

    SoterProcessResultBase() {
        super(-1);
    }

    protected SoterProcessResultBase(int errCode, String errMsg) {
        this(errCode, errMsg, null);
    }

    protected SoterProcessResultBase(int errCode, String errMsg, T extData) {
        super(errCode, errMsg);
        switch (errCode) {
            case 1002: {
                this.errMsg = "get support soter failed remotely";
                break;
            }
            case 1003: {
                this.errMsg = "upload app secure key";
                break;
            }
            case 1004: {
                this.errMsg = "upload auth key failed";
                break;
            }
            case 1008: {
                this.errMsg = "not initialized yet. please make sure you've already called SoterWrapperApi.init(...) and call backed";
                break;
            }
            case 1011: {
                this.errMsg = "context instance already released. should not happen normally, you can try to call again";
                break;
            }
            case 1013: {
                this.errMsg = "there must be at least 1 biometric enrolled in system to complete this process. please check it previously";
                break;
            }
            case 1014: {
                this.errMsg = "get challenge failed";
                break;
            }
            case 1019: {
                this.errMsg = "upload or verify signature in server side failed";
            }
        }
        if (!SoterCoreUtil.isNullOrNil((String)errMsg)) {
            this.errMsg = errMsg;
        }
        this.extData = extData;
    }

    protected SoterProcessResultBase(int errCode) {
        this(errCode, "", null);
    }

    protected SoterProcessResultBase(int errCode, T extData) {
        this(errCode, "", extData);
    }

    public T getExtData() {
        return this.extData;
    }

    public String toString() {
        if (this.getExtData() == null) {
            return super.toString();
        }
        return String.format("total: %s, extData: %s", super.toString(), this.getExtData().toString());
    }
}

