/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.HandlerThread;
import android.os.Process;
import android.support.annotation.NonNull;
import android.util.Log;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.ISoterLogger;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreData;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.core.model.SoterDelegate;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessNoExtResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessResultBase;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_net.ISoterNetCallback;
import com.tencent.soter.wrapper.wrap_net.IWrapGetSupportNet;
import com.tencent.soter.wrapper.wrap_task.BaseSoterTask;
import com.tencent.soter.wrapper.wrap_task.InitializeParam;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;
import java.nio.charset.Charset;

public class TaskInit
extends BaseSoterTask {
    private static final String TAG = "Soter.TaskInit";
    private static final String SOTER_STATUS_SHARED_PREFERENCE_NAME = "soter_status";
    private static final String DEVICE_INFO = SoterCore.generateRemoteCheckRequestParam();
    private static final String DEVICE_INFO_DIGEST = SoterCoreUtil.getMessageDigest((byte[])DEVICE_INFO.getBytes(Charset.forName("UTF-8")));
    private static final String SOTER_TRIGGERED_OOM_FLAG_PREFERENCE_NAME = "soter_triggered_oom" + DEVICE_INFO_DIGEST;
    private static final String SOTER_TRIGGERED_OOM_COUNT_PREFERENCE_NAME = "soter_triggered_oom_count" + DEVICE_INFO_DIGEST;
    private static final int MAX_SALT_STR_LEN = 16;
    private static final int MAX_CUSTOM_KEY_LEN = 24;
    private boolean isNativeSupport = false;
    private IWrapGetSupportNet getSupportNetWrapper;
    private String distinguishSalt = "";
    private String customAskName = "";
    private int[] scenes;
    private SoterDelegate.ISoterDelegate wrapperDelegate = new SoterDelegate.ISoterDelegate(){

        @SuppressLint(value={"ApplySharedPref"})
        public void onTriggeredOOM() {
            SLogger.w((String)TaskInit.TAG, (String)"soter: on trigger OOM, using wrapper implement", (Object[])new Object[0]);
            SharedPreferences preferences = SoterDataCenter.getInstance().getStatusSharedPreference();
            if (preferences != null) {
                SharedPreferences.Editor editor = preferences.edit();
                int count = preferences.getInt(SOTER_TRIGGERED_OOM_COUNT_PREFERENCE_NAME, 0);
                editor.putInt(SOTER_TRIGGERED_OOM_COUNT_PREFERENCE_NAME, count + 1);
                editor.commit();
            }
        }

        public boolean isTriggeredOOM() {
            SharedPreferences preferences = SoterDataCenter.getInstance().getStatusSharedPreference();
            if (preferences != null) {
                int count = preferences.getInt(SOTER_TRIGGERED_OOM_COUNT_PREFERENCE_NAME, 0);
                SLogger.i((String)TaskInit.TAG, (String)"soter: is triggered OOM: %b", (Object[])new Object[]{count});
                return count >= 10;
            }
            return false;
        }

        public void reset() {
            SharedPreferences preferences = SoterDataCenter.getInstance().getStatusSharedPreference();
            if (preferences != null) {
                preferences.edit().putInt(SOTER_TRIGGERED_OOM_COUNT_PREFERENCE_NAME, 0).apply();
            }
        }
    };

    public TaskInit(Context context, @NonNull InitializeParam param) {
        HandlerThread customTaskHandlerThread;
        ISoterLogger loggerImp = param.getSoterLogger();
        if (loggerImp != null) {
            SLogger.setLogImp((ISoterLogger)loggerImp);
        }
        if ((customTaskHandlerThread = param.getCustomTaskHandlerThread()) != null) {
            SoterTaskThread.getInstance().setTaskHandlerThread(customTaskHandlerThread);
        }
        SoterDataCenter.getInstance().setStatusSharedPreference(context.getSharedPreferences(SOTER_STATUS_SHARED_PREFERENCE_NAME, 0));
        SoterDelegate.setImplement((SoterDelegate.ISoterDelegate)this.wrapperDelegate);
        SoterCore.tryToInitSoterBeforeTreble();
        SoterCore.tryToInitSoterTreble((Context)context);
        SoterCore.setUp();
        this.isNativeSupport = SoterCore.isNativeSupportSoter() && (SoterCore.isSupportFingerprint((Context)context) || SoterCore.isSupportBiometric((Context)context, (int)2));
        this.getSupportNetWrapper = param.getGetSupportNetWrapper();
        this.scenes = param.getScenes();
        this.distinguishSalt = param.getDistinguishSalt();
        this.customAskName = param.getCustomAppSecureKeyName();
    }

    @Override
    boolean preExecute() {
        if (SoterDataCenter.getInstance().isSupportSoter()) {
            SLogger.e((String)TAG, (String)"soter: duplicate initialize soter", (Object[])new Object[0]);
            this.callback(new SoterProcessNoExtResult(1028, "soter already have initialized"));
            return true;
        }
        if (SoterCoreUtil.isNullOrNil((int[])this.scenes)) {
            SLogger.e((String)TAG, (String)"soter: the salt string used to distinguish is longer than 24", (Object[])new Object[0]);
            this.callback(new SoterProcessNoExtResult(1024, "no business scene provided"));
            return true;
        }
        if (SoterCoreUtil.nullAsNil((String)this.distinguishSalt).length() > 16) {
            SLogger.w((String)TAG, (String)"soter: the salt string used to distinguish is longer than 24. soter will try to make it compat", (Object[])new Object[0]);
            String compatMd5 = this.getCompatDistinguishSalt(this.distinguishSalt);
            if (SoterCoreUtil.isNullOrNil((String)compatMd5)) {
                SLogger.w((String)TAG, (String)"soter: saltlen compat failed!!", (Object[])new Object[0]);
                this.callback(new SoterProcessNoExtResult(1025, "the account salt length is too long"));
                return true;
            }
            this.distinguishSalt = compatMd5;
        }
        if (!SoterCoreUtil.isNullOrNil((String)this.customAskName) && this.customAskName.length() > 24) {
            SLogger.e((String)TAG, (String)"soter: the passed ask name is too long (larger than 24).", (Object[])new Object[0]);
            this.callback(new SoterProcessNoExtResult(1026, "the passed ask name is too long (larger than 24)"));
            return true;
        }
        if (this.getSupportNetWrapper == null) {
            SLogger.w((String)TAG, (String)"soter: it is strongly recommended to check device support from server, so you'd better provider a net wrapper to check it", (Object[])new Object[0]);
        }
        if (!SoterCoreUtil.isNullOrNil((String)this.customAskName)) {
            SLogger.i((String)TAG, (String)"soter: provided valid ASK name", (Object[])new Object[0]);
            SoterCoreData.getInstance().setAskName(this.customAskName);
        }
        SoterTaskThread.getInstance().postToWorker(new Runnable(){

            @Override
            public void run() {
                TaskInit.this.generateAuthKeyNames(TaskInit.this.distinguishSalt, TaskInit.this.scenes);
                TaskInit.this.removeAbnormalKeys();
            }
        });
        return false;
    }

    private String getCompatDistinguishSalt(@NonNull String previousSalt) {
        String saltMd5 = SoterCoreUtil.getMessageDigest((byte[])previousSalt.getBytes(Charset.forName("UTF-8")));
        if (!SoterCoreUtil.isNullOrNil((String)saltMd5) && saltMd5.length() >= 16) {
            return saltMd5.substring(0, 16);
        }
        Log.e((String)TAG, (String)"soter: not valid md5 implement!!");
        return null;
    }

    private void removeAbnormalKeys() {
        SharedPreferences preferences = SoterDataCenter.getInstance().getStatusSharedPreference();
        int askStatus = preferences.getInt(SoterCoreData.getInstance().getAskName(), -1);
        SLogger.d((String)TAG, (String)"soter: ask status: %d", (Object[])new Object[]{askStatus});
        if (this.isKeyStatusInvalid(askStatus) && SoterCore.hasAppGlobalSecureKey()) {
            SLogger.i((String)TAG, (String)"invalid ask, remove all key", (Object[])new Object[0]);
            SoterCore.removeAppGlobalSecureKey();
            for (int scene : this.scenes) {
                String keyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(scene, (Object)"");
                SoterCore.removeAuthKey((String)keyName, (boolean)false);
            }
        } else {
            for (int scene : this.scenes) {
                String keyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(scene, (Object)"");
                if (SoterCoreUtil.isNullOrNil((String)keyName)) continue;
                int keyStatus = preferences.getInt(keyName, 0);
                SLogger.d((String)TAG, (String)"soter: %s status: %d", (Object[])new Object[]{keyName, keyStatus});
                if (!this.isKeyStatusInvalid(keyStatus) || !SoterCore.hasAuthKey((String)keyName)) continue;
                SLogger.i((String)TAG, (String)"remove invalid ask: %s", (Object[])new Object[]{keyName});
                SoterCore.removeAuthKey((String)keyName, (boolean)false);
            }
        }
    }

    @Override
    boolean isSingleInstance() {
        return true;
    }

    @Override
    void onRemovedFromTaskPoolActively() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void execute() {
        if (this.isNativeSupport) {
            if (this.getSupportNetWrapper == null) {
                SoterDataCenter.getInstance().setSupportSoter(true);
                SoterDataCenter.getInstance().setInit(true);
                this.callback(new SoterProcessNoExtResult(0));
                return;
            } else {
                this.getSupportNetWrapper.setRequest(new IWrapGetSupportNet.GetSupportRequest(DEVICE_INFO));
                this.getSupportNetWrapper.setCallback(new ISoterNetCallback<IWrapGetSupportNet.GetSupportResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void onNetEnd(IWrapGetSupportNet.GetSupportResult callbackDataModel) {
                        if (callbackDataModel != null) {
                            SLogger.i((String)TaskInit.TAG, (String)"soter: got support tag from backend: %b", (Object[])new Object[]{callbackDataModel.isSupport});
                            Class<SoterDataCenter> clazz = SoterDataCenter.class;
                            synchronized (SoterDataCenter.class) {
                                SoterDataCenter.getInstance().setSupportSoter(callbackDataModel.isSupport);
                                SoterDataCenter.getInstance().setInit(true);
                                SoterDataCenter.getInstance().setSupportType(callbackDataModel.supportType);
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                TaskInit.this.callback(new SoterProcessNoExtResult(0));
                                return;
                            }
                        }
                        SLogger.w((String)TaskInit.TAG, (String)"soter: not return data from remote", (Object[])new Object[0]);
                        Class<SoterDataCenter> clazz = SoterDataCenter.class;
                        synchronized (SoterDataCenter.class) {
                            SoterDataCenter.getInstance().setSupportSoter(false);
                            SoterDataCenter.getInstance().setInit(true);
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            TaskInit.this.callback(new SoterProcessNoExtResult(1002));
                            return;
                        }
                    }
                });
                this.getSupportNetWrapper.execute();
            }
            return;
        }
        SLogger.w((String)TAG, (String)("soter: TaskInit check isNativeSupport[" + this.isNativeSupport + "]"), (Object[])new Object[0]);
        this.callback(new SoterProcessNoExtResult(2));
        Class<SoterDataCenter> clazz = SoterDataCenter.class;
        synchronized (SoterDataCenter.class) {
            SoterDataCenter.getInstance().setSupportSoter(false);
            SoterDataCenter.getInstance().setInit(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    void onExecuteCallback(SoterProcessResultBase result) {
    }

    @SuppressLint(value={"DefaultLocale"})
    protected void generateAuthKeyNames(String distinguishSalt, int[] scenes) {
        for (int scene : scenes) {
            String authKeyName = String.format("%suid%d_%s_scene%d", "Wechat", Process.myUid(), SoterCoreUtil.nullAsNil((String)distinguishSalt), scene);
            SoterDataCenter.getInstance().getAuthKeyNames().put(scene, (Object)authKeyName);
        }
    }

    private boolean isKeyStatusInvalid(int keyStatus) {
        return keyStatus != 0;
    }
}

