/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm.exception;

import apijson.Log;
import apijson.StringUtil;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.SQLConfig;
import apijson.orm.exception.ConditionErrorException;
import apijson.orm.exception.ConflictException;
import apijson.orm.exception.NotExistException;
import apijson.orm.exception.NotLoggedInException;
import apijson.orm.exception.OutOfRangeException;
import apijson.orm.exception.UnsupportedDataTypeException;
import java.io.UnsupportedEncodingException;
import java.net.HttpRetryException;
import java.sql.SQLException;
import java.util.concurrent.TimeoutException;

public class CommonException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Integer code;
    private String environment;

    public CommonException setCode(Integer code) {
        this.code = code;
        return this;
    }

    public Integer getCode() {
        if (this.code == null) {
            this.code = CommonException.getCode(this.getCause());
        }
        return this.code;
    }

    public static int getCode(Throwable e) {
        Throwable t;
        Integer code;
        boolean isCommon = Log.DEBUG && e instanceof CommonException;
        Integer n = code = isCommon ? ((CommonException)e).getCode() : null;
        if (code != null) {
            return code;
        }
        Throwable throwable = t = isCommon ? e.getCause() : e;
        if (t == null) {
            return 500;
        }
        if (t instanceof HttpRetryException) {
            return ((HttpRetryException)t).responseCode();
        }
        if (t instanceof UnsupportedEncodingException) {
            return 400;
        }
        if (t instanceof IllegalAccessException) {
            return 401;
        }
        if (t instanceof UnsupportedOperationException) {
            return 403;
        }
        if (t instanceof NotExistException) {
            return 404;
        }
        if (t instanceof IllegalArgumentException) {
            return 406;
        }
        if (t instanceof NotLoggedInException) {
            return 407;
        }
        if (t instanceof TimeoutException) {
            return 408;
        }
        if (t instanceof ConflictException) {
            return 409;
        }
        if (t instanceof ConditionErrorException) {
            return 412;
        }
        if (t instanceof UnsupportedDataTypeException) {
            return 415;
        }
        if (t instanceof OutOfRangeException) {
            return 416;
        }
        if (t instanceof NullPointerException) {
            return 417;
        }
        return 500;
    }

    public static String getMsg(Throwable e) {
        if (e == null) {
            return null;
        }
        String msg = e.getMessage();
        if (msg != null) {
            return msg;
        }
        Throwable t = e.getCause();
        return t == null ? null : t.getMessage();
    }

    public CommonException setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public CommonException(Throwable t) {
        this(null, t);
    }

    public CommonException(String msg, Throwable t) {
        super(msg == null && t != null ? t.getMessage() : null, t);
    }

    public CommonException(int code, String msg) {
        this(code, msg, null);
    }

    public CommonException(int code, String msg, Throwable t) {
        this(msg, t);
        this.setCode(code);
    }

    public CommonException(Throwable t, String environment) {
        this(null, t);
        this.setEnvironment(environment);
    }

    public static Exception wrap(Exception e, SQLConfig config) {
        if (!Log.DEBUG && e instanceof SQLException) {
            return new SQLException("\u6570\u636e\u5e93\u9a71\u52a8\u6267\u884c\u5f02\u5e38SQLException\uff0c\u975e Log.DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u663e\u793a\u8be6\u60c5\uff0c\u907f\u514d\u6cc4\u6f0f\u771f\u5b9e\u6a21\u5f0f\u540d\u3001\u8868\u540d\u7b49\u9690\u79c1\u4fe1\u606f", e);
        }
        if (Log.DEBUG && (!(e instanceof CommonException) || ((CommonException)e).getEnvironment() == null)) {
            try {
                Object db = config == null ? AbstractSQLConfig.DEFAULT_DATABASE : (config instanceof AbstractSQLConfig ? ((AbstractSQLConfig)config).getSQLDatabase() : config.getDatabase());
                String dbVersion = config.getDBVersion();
                if (StringUtil.isEmpty(dbVersion)) {
                    dbVersion = "<!-- \u8bf7\u586b\u5199\u7248\u672c\u53f7\uff0c\u4f8b\u5982 8.0 -->";
                }
                db = db != null ? (String)db + " " + dbVersion : (config.isMySQL() ? "MYSQL " + dbVersion : (config.isPostgreSQL() ? "POSTGRESQL " + dbVersion : (config.isSQLServer() ? "SQLSERVER " + dbVersion : (config.isOracle() ? "ORACLE " + dbVersion : (config.isDb2() ? "DB2 " + dbVersion : (config.isDameng() ? "DAMENG " + dbVersion : (config.isClickHouse() ? "CLICKHOUSE " + dbVersion : (config.isTDengine() ? "TDENGINE " + dbVersion : "<!-- \u8bf7\u586b\u5199\uff0c\u4f8b\u5982 MySQL 5.7\u3002\u83b7\u53d6\u5230\u7684\u9ed8\u8ba4\u6570\u636e\u5e93\u4e3a " + AbstractSQLConfig.DEFAULT_DATABASE + " -->"))))))));
                String env = " **\u73af\u5883\u4fe1\u606f**  \n \u7cfb\u7edf: " + Log.OS_NAME + " " + Log.OS_VERSION + " \n \u6570\u636e\u5e93: " + (String)db + " \n JDK: " + Log.JAVA_VERSION + " " + Log.OS_ARCH + " \n APIJSON: 7.0.3";
                if (e instanceof CommonException) {
                    ((CommonException)e).setEnvironment(env);
                    return e;
                }
                return new CommonException(e, env);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return e;
    }
}

