/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.StringUtil;
import apijson.orm.Entry;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Pair
extends Entry<String, String> {
    private static final Map<String, Class<?>> CLASS_MAP = new HashMap();

    public boolean isEmpty(boolean trim) {
        return !StringUtil.isNotEmpty((String)this.key, trim) && !StringUtil.isNotEmpty((String)this.value, trim);
    }

    public static <K, V> boolean isCorrect(Entry<K, V> pair) {
        return pair != null && StringUtil.isNotEmpty(pair.getValue(), true);
    }

    public String toPairString() {
        return Pair.toPairString((String)this.getKey(), (String)this.getValue());
    }

    public static String toPairString(String typeKey, String valueKey) {
        return (String)(typeKey == null ? "" : typeKey + ":") + valueKey;
    }

    public static String toPairString(Class<?> type, Object value) {
        return Pair.toPairString(type == null ? null : type.getSimpleName(), StringUtil.getString(value));
    }

    public static Entry<String, String> parseEntry(String pair) {
        return Pair.parseEntry(pair, false);
    }

    public static Entry<String, String> parseEntry(String pair, boolean isRightValueDefault) {
        return Pair.parseEntry(pair, isRightValueDefault, null);
    }

    public static Entry<String, String> parseEntry(String pair, boolean isRightValueDefault, String defaultValue) {
        pair = StringUtil.getString(pair);
        Entry<String, String> entry = new Entry<String, String>();
        if (!pair.isEmpty()) {
            int index = pair.indexOf(":");
            if (index < 0) {
                entry.setKey(isRightValueDefault ? pair : defaultValue);
                entry.setValue(isRightValueDefault ? defaultValue : pair);
            } else {
                entry.setKey(pair.substring(0, index));
                entry.setValue(pair.substring(index + 1, pair.length()));
            }
        }
        return entry;
    }

    public static Entry<String, String> parseVariableEntry(String pair) {
        return Pair.parseEntry(pair, false, Object.class.getSimpleName());
    }

    public static Entry<Class<?>, Object> parseVariableEntry(String pair, Map<String, Object> valueMap) {
        pair = StringUtil.getString(pair);
        Entry entry = new Entry();
        if (!pair.isEmpty()) {
            int index = pair.contains(":") ? pair.indexOf(":") : -1;
            entry.setKey(CLASS_MAP.get(index < 0 ? Object.class.getSimpleName() : pair.substring(0, index)));
            entry.setValue(valueMap == null ? null : valueMap.get(pair.substring(index + 1, pair.length())));
        }
        return entry;
    }

    static {
        CLASS_MAP.put(Boolean.TYPE.getSimpleName(), Boolean.TYPE);
        CLASS_MAP.put(Integer.TYPE.getSimpleName(), Integer.TYPE);
        CLASS_MAP.put(Long.TYPE.getSimpleName(), Long.TYPE);
        CLASS_MAP.put(Float.TYPE.getSimpleName(), Float.TYPE);
        CLASS_MAP.put(Double.TYPE.getSimpleName(), Double.TYPE);
        CLASS_MAP.put(Boolean.class.getSimpleName(), Boolean.class);
        CLASS_MAP.put(Integer.class.getSimpleName(), Integer.class);
        CLASS_MAP.put(Long.class.getSimpleName(), Long.class);
        CLASS_MAP.put(Float.class.getSimpleName(), Float.class);
        CLASS_MAP.put(Double.class.getSimpleName(), Double.class);
        CLASS_MAP.put(Object.class.getSimpleName(), Object.class);
        CLASS_MAP.put(String.class.getSimpleName(), String.class);
        CLASS_MAP.put(Collection.class.getSimpleName(), Collection.class);
        CLASS_MAP.put(Map.class.getSimpleName(), Map.class);
        CLASS_MAP.put(JSONObject.class.getSimpleName(), JSONObject.class);
        CLASS_MAP.put(JSONArray.class.getSimpleName(), JSONArray.class);
    }
}

