/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.NotNull;
import apijson.StringUtil;
import apijson.orm.Logic;
import apijson.orm.SQLConfig;
import com.alibaba.fastjson.JSONObject;
import java.util.List;

public class Join {
    private String path;
    private String joinType;
    private String table;
    private String alias;
    private int count = 1;
    private List<On> onList;
    private JSONObject request;
    private JSONObject outer;
    private SQLConfig joinConfig;
    private SQLConfig cacheConfig;
    private SQLConfig outerConfig;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<On> getOnList() {
        return this.onList;
    }

    public void setOnList(List<On> onList) {
        this.onList = onList;
    }

    public JSONObject getRequest() {
        return this.request;
    }

    public void setRequest(JSONObject request) {
        this.request = request;
    }

    public JSONObject getOuter() {
        return this.outer;
    }

    public void setOuter(JSONObject outer) {
        this.outer = outer;
    }

    public SQLConfig getJoinConfig() {
        return this.joinConfig;
    }

    public void setJoinConfig(SQLConfig joinConfig) {
        this.joinConfig = joinConfig;
    }

    public SQLConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(SQLConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public SQLConfig getOuterConfig() {
        return this.outerConfig;
    }

    public void setOuterConfig(SQLConfig outerConfig) {
        this.outerConfig = outerConfig;
    }

    public boolean isOne2One() {
        return !this.isOne2Many();
    }

    public boolean isOne2Many() {
        return this.count != 1 || this.path != null && this.path.contains("[]");
    }

    public boolean isAppJoin() {
        return "@".equals(this.getJoinType());
    }

    public boolean isLeftJoin() {
        return "<".equals(this.getJoinType());
    }

    public boolean isRightJoin() {
        return ">".equals(this.getJoinType());
    }

    public boolean isCrossJoin() {
        return "*".equals(this.getJoinType());
    }

    public boolean isInnerJoin() {
        return "&".equals(this.getJoinType());
    }

    public boolean isFullJoin() {
        String jt = this.getJoinType();
        return "".equals(jt) || "|".equals(jt);
    }

    public boolean isOuterJoin() {
        return "!".equals(this.getJoinType());
    }

    public boolean isSideJoin() {
        return "^".equals(this.getJoinType());
    }

    public boolean isAntiJoin() {
        return "(".equals(this.getJoinType());
    }

    public boolean isForeignJoin() {
        return ")".equals(this.getJoinType());
    }

    public boolean isLeftOrRightJoin() {
        String jt = this.getJoinType();
        return "<".equals(jt) || ">".equals(jt);
    }

    public boolean canCacheViceTable() {
        String jt = this.getJoinType();
        return "@".equals(jt) || "<".equals(jt) || ">".equals(jt) || "&".equals(jt) || "*".equals(jt) || ")".equals(jt);
    }

    public boolean isSQLJoin() {
        return !this.isAppJoin();
    }

    public static boolean isSQLJoin(Join j) {
        return j != null && j.isSQLJoin();
    }

    public static boolean isAppJoin(Join j) {
        return j != null && j.isAppJoin();
    }

    public static boolean isLeftOrRightJoin(Join j) {
        return j != null && j.isLeftOrRightJoin();
    }

    public static class On {
        private String originKey;
        private String originValue;
        private Logic logic;
        private String relateType;
        private String key;
        private String targetTable;
        private String targetAlias;
        private String targetKey;

        public String getOriginKey() {
            return this.originKey;
        }

        public void setOriginKey(String originKey) {
            this.originKey = originKey;
        }

        public String getOriginValue() {
            return this.originValue;
        }

        public void setOriginValue(String originValue) {
            this.originValue = originValue;
        }

        public Logic getLogic() {
            return this.logic;
        }

        public void setLogic(Logic logic) {
            this.logic = logic;
        }

        public String getRelateType() {
            return this.relateType;
        }

        public void setRelateType(String relateType) {
            this.relateType = relateType;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setTargetTable(String targetTable) {
            this.targetTable = targetTable;
        }

        public String getTargetTable() {
            return this.targetTable;
        }

        public void setTargetAlias(String targetAlias) {
            this.targetAlias = targetAlias;
        }

        public String getTargetAlias() {
            return this.targetAlias;
        }

        public String getTargetKey() {
            return this.targetKey;
        }

        public void setTargetKey(String targetKey) {
            this.targetKey = targetKey;
        }

        public void setKeyAndType(String joinType, String table, @NotNull String originKey) throws Exception {
            String k;
            if (!originKey.endsWith("@")) {
                throw new IllegalArgumentException(joinType + "/.../" + table + "/" + originKey + " \u4e2d\u5b57\u7b26 " + originKey + " \u4e0d\u5408\u6cd5\uff01join:'.../refKey' \u4e2d refKey \u5fc5\u987b\u4ee5 @ \u7ed3\u5c3e\uff01");
            }
            originKey = originKey.substring(0, originKey.length() - 1);
            if (originKey.endsWith("{}")) {
                this.setRelateType("{}");
                k = originKey.substring(0, originKey.length() - 2);
            } else if (originKey.endsWith("<>")) {
                this.setRelateType("<>");
                k = originKey.substring(0, originKey.length() - 2);
            } else if (originKey.endsWith("$")) {
                k = originKey.substring(0, originKey.length() - 1);
                char c = k.isEmpty() ? (char)'\u0000' : k.charAt(k.length() - 1);
                Object t = "$";
                if (c == '%' || c == '_' || c == '?') {
                    char c2;
                    t = c + (String)t;
                    char c3 = c2 = (k = k.substring(0, k.length() - 1)).isEmpty() ? (char)'\u0000' : (char)k.charAt(k.length() - 1);
                    if (c2 == '%' || c2 == '_' || c2 == '?') {
                        if (c2 == c) {
                            throw new IllegalArgumentException(originKey + ":value \u4e2d\u5b57\u7b26 " + k + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8 key \u4e2d\u6709\u8fde\u7eed\u76f8\u540c\u7684\u5360\u4f4d\u7b26\uff01");
                        }
                        t = c2 + (String)t;
                        k = k.substring(0, k.length() - 1);
                    } else if (c == '?') {
                        throw new IllegalArgumentException(originKey + ":value \u4e2d\u5b57\u7b26 " + originKey + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8\u53ea\u6709\u5355\u72ec\u7684 '?'\uff0c\u5fc5\u987b\u548c '%', '_' \u4e4b\u4e00\u914d\u5408\u4f7f\u7528 \uff01");
                    }
                }
                this.setRelateType((String)t);
            } else if (originKey.endsWith("~")) {
                boolean ignoreCase = originKey.endsWith("*~");
                this.setRelateType(ignoreCase ? "*~" : "~");
                k = originKey.substring(0, originKey.length() - (ignoreCase ? 2 : 1));
            } else if (originKey.endsWith(">=")) {
                this.setRelateType(">=");
                k = originKey.substring(0, originKey.length() - 2);
            } else if (originKey.endsWith("<=")) {
                this.setRelateType("<=");
                k = originKey.substring(0, originKey.length() - 2);
            } else if (originKey.endsWith(">")) {
                this.setRelateType(">");
                k = originKey.substring(0, originKey.length() - 1);
            } else if (originKey.endsWith("<")) {
                this.setRelateType("<");
                k = originKey.substring(0, originKey.length() - 1);
            } else {
                this.setRelateType("");
                k = originKey;
            }
            if (k != null && (k.contains("&") || k.contains("|"))) {
                throw new UnsupportedOperationException(joinType + "/.../" + table + "/" + originKey + " \u4e2d\u5b57\u7b26 " + k + " \u4e0d\u5408\u6cd5\uff01\u4e0e\u6216\u975e\u903b\u8f91\u7b26\u4ec5\u652f\u6301 '!' \u975e\u903b\u8f91\u7b26 \uff01");
            }
            Logic l = new Logic(k);
            this.setLogic(l);
            if (!StringUtil.isName(l.getKey())) {
                throw new IllegalArgumentException(joinType + "/.../" + table + "/" + originKey + " \u4e2d\u5b57\u7b26 " + l.getKey() + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u7b26\u5408\u5b57\u6bb5\u547d\u540d\u683c\u5f0f\uff01");
            }
            this.setKey(l.getKey());
        }
    }
}

