/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.JSONObject;
import apijson.JSONResponse;
import apijson.Log;
import apijson.MethodAccess;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractParser;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.Entry;
import apijson.orm.JSONRequest;
import apijson.orm.Logic;
import apijson.orm.OnParseCallback;
import apijson.orm.Operation;
import apijson.orm.ParserCreator;
import apijson.orm.SQLConfig;
import apijson.orm.SQLCreator;
import apijson.orm.SQLExecutor;
import apijson.orm.Verifier;
import apijson.orm.Visitor;
import apijson.orm.exception.ConflictException;
import apijson.orm.exception.NotLoggedInException;
import apijson.orm.exception.UnsupportedDataTypeException;
import apijson.orm.model.Access;
import apijson.orm.model.AllColumn;
import apijson.orm.model.AllColumnComment;
import apijson.orm.model.AllTable;
import apijson.orm.model.AllTableComment;
import apijson.orm.model.Column;
import apijson.orm.model.Document;
import apijson.orm.model.ExtendedProperty;
import apijson.orm.model.Function;
import apijson.orm.model.PgAttribute;
import apijson.orm.model.PgClass;
import apijson.orm.model.Request;
import apijson.orm.model.Script;
import apijson.orm.model.SysColumn;
import apijson.orm.model.SysTable;
import apijson.orm.model.Table;
import apijson.orm.model.TestRecord;
import com.alibaba.fastjson.JSONArray;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public abstract class AbstractVerifier<T>
implements Verifier<T>,
AbstractSQLConfig.IdCallback<T> {
    private static final String TAG = "AbstractVerifier";
    public static boolean IS_UPDATE_MUST_HAVE_ID_CONDITION = true;
    public static boolean ENABLE_VERIFY_ROLE = true;
    public static boolean ENABLE_VERIFY_CONTENT = true;
    public static final String UNKNOWN = "UNKNOWN";
    public static final String LOGIN = "LOGIN";
    public static final String CONTACT = "CONTACT";
    public static final String CIRCLE = "CIRCLE";
    public static final String OWNER = "OWNER";
    public static final String ADMIN = "ADMIN";
    public static ParserCreator PARSER_CREATOR;
    public static ScriptEngineManager SCRIPT_ENGINE_MANAGER;
    public static ScriptEngine SCRIPT_ENGINE;
    public static Map<String, Entry<String, Object>> ROLE_MAP;
    public static List<String> OPERATION_KEY_LIST;
    @NotNull
    public static Map<String, Map<RequestMethod, String[]>> SYSTEM_ACCESS_MAP;
    @NotNull
    public static Map<String, Map<RequestMethod, String[]>> ACCESS_MAP;
    @NotNull
    public static Map<String, Map<String, Object>> ACCESS_FAKE_DELETE_MAP;
    @NotNull
    public static Map<String, SortedMap<Integer, com.alibaba.fastjson.JSONObject>> REQUEST_MAP;
    private static String VERIFY_LENGTH_RULE;
    private static Pattern VERIFY_LENGTH_PATTERN;
    @NotNull
    public static final Map<String, Pattern> COMPILE_MAP;
    @NotNull
    protected Visitor<T> visitor;
    protected Object visitorId;

    public static HashMap<RequestMethod, String[]> getAccessMap(MethodAccess access) {
        if (access == null) {
            return null;
        }
        HashMap<RequestMethod, String[]> map = new HashMap<RequestMethod, String[]>();
        map.put(RequestMethod.GET, access.GET());
        map.put(RequestMethod.HEAD, access.HEAD());
        map.put(RequestMethod.GETS, access.GETS());
        map.put(RequestMethod.HEADS, access.HEADS());
        map.put(RequestMethod.POST, access.POST());
        map.put(RequestMethod.PUT, access.PUT());
        map.put(RequestMethod.DELETE, access.DELETE());
        return map;
    }

    @Override
    public String getVisitorIdKey(SQLConfig config) {
        return config.getUserIdKey();
    }

    @Override
    public String getIdKey(String database, String schema, String datasource, String table) {
        return JSONObject.KEY_ID;
    }

    @Override
    public String getUserIdKey(String database, String schema, String datasource, String table) {
        return JSONObject.KEY_USER_ID;
    }

    @Override
    public T newId(RequestMethod method, String database, String schema, String datasource, String table) {
        return (T)Long.valueOf(System.currentTimeMillis());
    }

    @Override
    @NotNull
    public Visitor<T> getVisitor() {
        return this.visitor;
    }

    @Override
    public AbstractVerifier<T> setVisitor(Visitor<T> visitor) {
        this.visitor = visitor;
        this.visitorId = visitor == null ? null : visitor.getId();
        return this;
    }

    @Override
    public boolean verifyAccess(SQLConfig config) throws Exception {
        String table;
        if (!ENABLE_VERIFY_ROLE) {
            throw new UnsupportedOperationException("AbstractVerifier.ENABLE_VERIFY_ROLE == false \u65f6\u4e0d\u652f\u6301\u6821\u9a8c\u89d2\u8272\u6743\u9650\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractVerifier.ENABLE_VERIFY_ROLE = true \uff01");
        }
        String string = table = config == null ? null : config.getTable();
        if (table == null) {
            return true;
        }
        String role = config.getRole();
        if (role == null) {
            role = UNKNOWN;
        } else {
            if (!ROLE_MAP.containsKey(role)) {
                Set<String> NAMES = ROLE_MAP.keySet();
                throw new IllegalArgumentException("\u89d2\u8272 " + role + " \u4e0d\u5b58\u5728\uff01\u53ea\u80fd\u662f[" + StringUtil.getString(NAMES.toArray()) + "]\u4e2d\u7684\u4e00\u79cd\uff01");
            }
            if (!role.equals(UNKNOWN)) {
                this.verifyLogin();
            }
        }
        RequestMethod method = config.getMethod();
        this.verifyRole(config, table, method, role);
        return true;
    }

    @Override
    public void verifyRole(SQLConfig config, String table, RequestMethod method, String role) throws Exception {
        this.verifyAllowRole(config, table, method, role);
        this.verifyUseRole(config, table, method, role);
    }

    public void verifyAllowRole(SQLConfig config, String table, RequestMethod method, String role) throws Exception {
        Log.d(TAG, "verifyAllowRole  table = " + table + "; method = " + method + "; role = " + role);
        if (table == null) {
            String string = table = config == null ? null : config.getTable();
        }
        if (table != null) {
            Map<RequestMethod, String[]> map;
            if (method == null) {
                RequestMethod requestMethod = method = config == null ? RequestMethod.GET : config.getMethod();
            }
            if (role == null) {
                String string = role = config == null ? UNKNOWN : config.getRole();
            }
            if ((map = ACCESS_MAP.get(table)) == null || !Arrays.asList(map.get((Object)method)).contains(role)) {
                throw new IllegalAccessException(table + " \u4e0d\u5141\u8bb8 " + role + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
            }
        }
    }

    public void verifyUseRole(SQLConfig config, String table, RequestMethod method, String role) throws Exception {
        Log.d(TAG, "verifyUseRole  table = " + table + "; method = " + method + "; role = " + role);
        String visitorIdKey = this.getVisitorIdKey(config);
        if (table == null) {
            String string = table = config == null ? null : config.getTable();
        }
        if (method == null) {
            RequestMethod requestMethod = method = config == null ? RequestMethod.GET : config.getMethod();
        }
        if (role == null) {
            role = config == null ? UNKNOWN : config.getRole();
        }
        switch (role) {
            case "LOGIN": {
                break;
            }
            case "CONTACT": 
            case "CIRCLE": {
                ArrayList<Object> list;
                ArrayList<Object> arrayList = list = this.visitor.getContactIdList() == null ? new ArrayList<Object>() : new ArrayList<T>(this.visitor.getContactIdList());
                if (CIRCLE.equals(role)) {
                    list.add(this.visitorId);
                }
                Object requestId = config.getWhere(visitorIdKey, true);
                Collection requestIdArray = (Collection)config.getWhere(visitorIdKey + "{}", true);
                if (requestId != null) {
                    if (requestIdArray == null) {
                        requestIdArray = new JSONArray();
                    }
                    requestIdArray.add(requestId);
                }
                if (requestIdArray == null) {
                    config.putWhere(visitorIdKey + "{}", JSON.parseArray(list), true);
                    break;
                }
                for (Object id : requestIdArray) {
                    if (id == null) continue;
                    if (id instanceof Number) {
                        if (((Number)id).longValue() > 0L && list.contains(Long.valueOf("" + id))) continue;
                        throw new IllegalAccessException(visitorIdKey + " = " + id + " \u7684 " + table + " \u4e0d\u5141\u8bb8 " + role + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
                    }
                    if (id instanceof String) {
                        if (!StringUtil.isEmpty(id) && list.contains(id)) continue;
                        throw new IllegalAccessException(visitorIdKey + " = " + id + " \u7684 " + table + " \u4e0d\u5141\u8bb8 " + role + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
                    }
                    throw new UnsupportedDataTypeException(table + ".id \u7c7b\u578b\u9519\u8bef\uff0c\u7c7b\u578b\u5fc5\u987b\u662f Long/String\uff01");
                }
                break;
            }
            case "OWNER": {
                if (config.getMethod() == RequestMethod.POST) {
                    List<String> c = config.getColumn();
                    List<List<Object>> ovs = config.getValues();
                    if (c == null || c.isEmpty() || ovs == null || ovs.isEmpty()) {
                        throw new IllegalArgumentException("POST \u8bf7\u6c42\u5fc5\u987b\u5728Table\u5185\u8bbe\u7f6e\u8981\u4fdd\u5b58\u7684 key:value \uff01");
                    }
                    int index = c.indexOf(visitorIdKey);
                    if (index >= 0) {
                        for (List<Object> ovl : ovs) {
                            Object oid;
                            Object object = oid = ovl == null || index >= ovl.size() ? null : ovl.get(index);
                            if (oid != null && StringUtil.getString(oid).equals("" + this.visitorId)) continue;
                            throw new IllegalAccessException(visitorIdKey + " = " + oid + " \u7684 " + table + " \u4e0d\u5141\u8bb8 " + role + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
                        }
                        break;
                    }
                    ArrayList<String> nc = new ArrayList<String>(c);
                    nc.add(visitorIdKey);
                    config.setColumn(nc);
                    ArrayList<List<Object>> nvs = new ArrayList<List<Object>>();
                    for (List<Object> ovl : ovs) {
                        ArrayList<Object> nvl = ovl == null || ovl.isEmpty() ? new ArrayList<Object>() : new ArrayList<Object>(ovl);
                        nvl.add(this.visitorId);
                        nvs.add(nvl);
                    }
                    config.setValues(nvs);
                    break;
                }
                Object requestId = config.getWhere(visitorIdKey, true);
                if (requestId != null && !StringUtil.getString(requestId).equals(StringUtil.getString(this.visitorId))) {
                    throw new IllegalAccessException(visitorIdKey + " = " + requestId + " \u7684 " + table + " \u4e0d\u5141\u8bb8 " + role + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
                }
                config.putWhere(visitorIdKey, this.visitorId, true);
                break;
            }
            case "ADMIN": {
                this.verifyAdmin();
                break;
            }
        }
    }

    @Override
    public void verifyLogin() throws Exception {
        if (this.visitorId == null) {
            throw new NotLoggedInException("\u672a\u767b\u5f55\u6216\u767b\u5f55\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u518d\u64cd\u4f5c\uff01");
        }
        if (this.visitorId instanceof Number) {
            if (((Number)this.visitorId).longValue() <= 0L) {
                throw new NotLoggedInException("\u672a\u767b\u5f55\u6216\u767b\u5f55\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u518d\u64cd\u4f5c\uff01");
            }
        } else if (this.visitorId instanceof String) {
            if (StringUtil.isEmpty(this.visitorId, true)) {
                throw new NotLoggedInException("\u672a\u767b\u5f55\u6216\u767b\u5f55\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u518d\u64cd\u4f5c\uff01");
            }
        } else {
            throw new UnsupportedDataTypeException("visitorId \u53ea\u80fd\u662f Long \u6216 String \u7c7b\u578b\uff01");
        }
    }

    @Override
    public void verifyAdmin() throws Exception {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301 ADMIN \u89d2\u8272\uff01\u5982\u679c\u8981\u652f\u6301\u5c31\u5728\u5b50\u7c7b\u91cd\u5199\u8fd9\u4e2a\u65b9\u6cd5\u6765\u6821\u9a8c ADMIN \u89d2\u8272\uff0c\u4e0d\u901a\u8fc7\u5219 throw IllegalAccessException!");
    }

    @Override
    public void verifyRepeat(String table, String key, Object value) throws Exception {
        this.verifyRepeat(table, key, value, 0L);
    }

    @Override
    public void verifyRepeat(String table, String key, Object value, long exceptId) throws Exception {
        com.alibaba.fastjson.JSONObject repeat;
        if (key == null || value == null) {
            Log.e(TAG, "verifyRepeat  key == null || value == null >> return;");
            return;
        }
        if (value instanceof JSON) {
            throw new UnsupportedDataTypeException(key + ":value \u4e2dvalue\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3aJSON\uff01");
        }
        JSONRequest request = new JSONRequest(key, value);
        if (exceptId > 0L) {
            request.put(JSONRequest.KEY_ID + "!", (Object)exceptId);
        }
        com.alibaba.fastjson.JSONObject jSONObject = repeat = (repeat = this.createParser().setMethod(RequestMethod.HEAD).setNeedVerify(true).parseResponse(new JSONRequest(table, (Object)request))) == null ? null : repeat.getJSONObject(table);
        if (repeat == null) {
            throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef  verifyRepeat  repeat == null");
        }
        if (repeat.getIntValue("count") > 0) {
            throw new ConflictException(key + ": " + value + " \u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
    }

    @Override
    public com.alibaba.fastjson.JSONObject verifyRequest(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject request, int maxUpdateCount, String database, String schema, SQLCreator creator) throws Exception {
        return AbstractVerifier.verifyRequest(method, name, target, request, maxUpdateCount, database, schema, this, creator);
    }

    public static com.alibaba.fastjson.JSONObject verifyRequest(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject request, SQLCreator creator) throws Exception {
        return AbstractVerifier.verifyRequest(method, name, target, request, AbstractParser.MAX_UPDATE_COUNT, creator);
    }

    public static com.alibaba.fastjson.JSONObject verifyRequest(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject request, int maxUpdateCount, SQLCreator creator) throws Exception {
        return AbstractVerifier.verifyRequest(method, name, target, request, maxUpdateCount, null, null, null, creator);
    }

    public static <T> com.alibaba.fastjson.JSONObject verifyRequest(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject request, int maxUpdateCount, String database, String schema, AbstractSQLConfig.IdCallback<T> idCallback, SQLCreator creator) throws Exception {
        return AbstractVerifier.verifyRequest(method, name, target, request, maxUpdateCount, database, schema, null, idCallback, creator);
    }

    public static <T> com.alibaba.fastjson.JSONObject verifyRequest(final @NotNull RequestMethod method, final String name, com.alibaba.fastjson.JSONObject target, final com.alibaba.fastjson.JSONObject request, final int maxUpdateCount, final String database, final String schema, final String datasource, final AbstractSQLConfig.IdCallback<T> idCallback, final SQLCreator creator) throws Exception {
        if (!ENABLE_VERIFY_CONTENT) {
            throw new UnsupportedOperationException("AbstractVerifier.ENABLE_VERIFY_CONTENT == false \u65f6\u4e0d\u652f\u6301\u6821\u9a8c\u8bf7\u6c42\u4f20\u53c2\u5185\u5bb9\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractVerifier.ENABLE_VERIFY_CONTENT = true \uff01");
        }
        Log.i(TAG, "verifyRequest  method = " + method + "; name = " + name + "; target = \n" + JSON.toJSONString(target) + "\n request = \n" + JSON.toJSONString(request));
        if (target == null || request == null) {
            Log.i(TAG, "verifyRequest  target == null || request == null >> return null;");
            return null;
        }
        return AbstractVerifier.parse(method, name, target, request, database, schema, idCallback, creator, new OnParseCallback(){

            @Override
            public com.alibaba.fastjson.JSONObject onParseJSONObject(String key, com.alibaba.fastjson.JSONObject tobj, com.alibaba.fastjson.JSONObject robj) throws Exception {
                if (robj == null) {
                    if (tobj != null) {
                        throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c\u8bf7\u5728 " + name + " \u5185\u4f20 " + key + ":{} \uff01");
                    }
                } else if (JSONObject.isTableKey(key)) {
                    String finalIdKey;
                    String db = request.getString("@database");
                    String sh = request.getString("@schema");
                    String ds = request.getString("@datasource");
                    if (StringUtil.isEmpty(db, false)) {
                        db = database;
                    }
                    if (StringUtil.isEmpty(sh, false)) {
                        sh = schema;
                    }
                    if (StringUtil.isEmpty(ds, false)) {
                        ds = datasource;
                    }
                    String idKey = idCallback == null ? null : idCallback.getIdKey(db, sh, ds, key);
                    String string = finalIdKey = StringUtil.isEmpty(idKey, false) ? JSONObject.KEY_ID : idKey;
                    if (method == RequestMethod.POST) {
                        if (robj.containsKey((Object)finalIdKey)) {
                            throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u4e0d\u80fd\u4f20 " + finalIdKey + " \uff01");
                        }
                    } else {
                        Boolean atLeastOne;
                        Boolean bl = atLeastOne = tobj == null ? null : tobj.getBoolean(Operation.IS_ID_CONDITION_MUST.name());
                        if (Boolean.TRUE.equals(atLeastOne) || RequestMethod.isUpdateMethod(method)) {
                            AbstractVerifier.verifyId(method.name(), name, key, robj, finalIdKey, maxUpdateCount, atLeastOne != null ? atLeastOne : IS_UPDATE_MUST_HAVE_ID_CONDITION);
                            String userIdKey = idCallback == null ? null : idCallback.getUserIdKey(db, sh, ds, key);
                            String finalUserIdKey = StringUtil.isEmpty(userIdKey, false) ? JSONObject.KEY_USER_ID : userIdKey;
                            AbstractVerifier.verifyId(method.name(), name, key, robj, finalUserIdKey, maxUpdateCount, false);
                        }
                    }
                }
                return AbstractVerifier.verifyRequest(method, key, tobj, robj, maxUpdateCount, database, schema, idCallback, creator);
            }

            @Override
            protected JSONArray onParseJSONArray(String key, JSONArray tarray, JSONArray rarray) throws Exception {
                if ((method == RequestMethod.POST || method == RequestMethod.PUT) && JSONRequest.isArrayKey(key)) {
                    if (rarray == null || rarray.isEmpty()) {
                        throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c\u8bf7\u5728 " + name + " \u5185\u4f20 " + key + ":[{ ... }] \uff0c\u6279\u91cf\u65b0\u589e Table[]:value \u4e2d value \u5fc5\u987b\u662f\u5305\u542b\u8868\u5bf9\u8c61\u7684\u975e\u7a7a\u6570\u7ec4\uff01\u5176\u4e2d\u6bcf\u4e2a\u5b50\u9879 { ... } \u90fd\u662f tag:" + key.substring(0, key.length() - 2) + " \u5bf9\u5e94\u5355\u4e2a\u65b0\u589e\u7684 structure \uff01");
                    }
                    if (rarray.size() > maxUpdateCount) {
                        throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + key + ":[{ ... }] \u4e2d [] \u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 " + maxUpdateCount + " \uff01");
                    }
                }
                return super.onParseJSONArray(key, tarray, rarray);
            }
        });
    }

    private static void verifyId(@NotNull String method, @NotNull String name, @NotNull String key, @NotNull com.alibaba.fastjson.JSONObject robj, @NotNull String idKey, int maxUpdateCount, boolean atLeastOne) {
        Object id = robj.get((Object)idKey);
        if (id != null && !(id instanceof Number) && !(id instanceof String)) {
            throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idKey + ":value \u4e2dvalue\u7684\u7c7b\u578b\u53ea\u80fd\u662f Long \u6216 String \uff01");
        }
        String idInKey = idKey + "{}";
        String idRefInKey = robj.getString(idKey + "{}@");
        JSONArray idIn = null;
        try {
            idIn = robj.getJSONArray(idInKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idInKey + ":value \u4e2dvalue\u7684\u7c7b\u578b\u53ea\u80fd\u662f [Long] \uff01");
        }
        if (idIn == null) {
            if (atLeastOne && id == null && idRefInKey == null) {
                throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762 " + idKey + "," + idInKey + "," + idKey + "{}@ \u81f3\u5c11\u4f20\u5176\u4e2d\u4e00\u4e2a\uff01");
            }
        } else {
            if (idIn.size() > maxUpdateCount) {
                throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idInKey + ":[] \u4e2d[]\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 " + maxUpdateCount + " \uff01");
            }
            for (int i = 0; i < idIn.size(); ++i) {
                Object o = idIn.get(i);
                if (o == null) {
                    throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idInKey + ":[] \u4e2d\u6240\u6709\u9879\u90fd\u4e0d\u80fd\u4e3a [ null, <= 0 \u7684\u6570\u5b57, \u7a7a\u5b57\u7b26\u4e32 \"\" ] \u4e2d\u4efb\u4f55\u4e00\u4e2a \uff01");
                }
                if (o instanceof Number) {
                    if (((Number)o).longValue() > 0L) continue;
                    throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idInKey + ":[] \u4e2d\u6240\u6709\u9879\u90fd\u4e0d\u80fd\u4e3a [ null, <= 0 \u7684\u6570\u5b57, \u7a7a\u5b57\u7b26\u4e32 \"\" ] \u4e2d\u4efb\u4f55\u4e00\u4e2a \uff01");
                }
                if (o instanceof String) {
                    if (!StringUtil.isEmpty(o, true)) continue;
                    throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idInKey + ":[] \u4e2d\u6240\u6709\u9879\u90fd\u4e0d\u80fd\u4e3a [ null, <= 0 \u7684\u6570\u5b57, \u7a7a\u5b57\u7b26\u4e32 \"\" ] \u4e2d\u4efb\u4f55\u4e00\u4e2a \uff01");
                }
                throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + "/" + key + " \u91cc\u9762\u7684 " + idInKey + ":[] \u4e2d\u6240\u6709\u9879\u7684\u7c7b\u578b\u90fd\u53ea\u80fd\u662f Long \u6216 String \uff01");
            }
        }
    }

    @Override
    public com.alibaba.fastjson.JSONObject verifyResponse(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject response, String database, String schema, SQLCreator creator, OnParseCallback callback) throws Exception {
        return AbstractVerifier.verifyResponse(method, name, target, response, database, schema, this, creator, callback);
    }

    public static com.alibaba.fastjson.JSONObject verifyResponse(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject response, SQLCreator creator, OnParseCallback callback) throws Exception {
        return AbstractVerifier.verifyResponse(method, name, target, response, null, null, null, creator, callback);
    }

    public static <T> com.alibaba.fastjson.JSONObject verifyResponse(final @NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject response, final String database, final String schema, final AbstractSQLConfig.IdCallback<T> idKeyCallback, final SQLCreator creator, final OnParseCallback callback) throws Exception {
        Log.i(TAG, "verifyResponse  method = " + method + "; name = " + name + "; target = \n" + JSON.toJSONString(target) + "\n response = \n" + JSON.toJSONString(response));
        if (target == null || response == null) {
            Log.i(TAG, "verifyResponse  target == null || response == null >> return response;");
            return response;
        }
        return AbstractVerifier.parse(method, name, target, response, database, schema, idKeyCallback, creator, callback != null ? callback : new OnParseCallback(){

            @Override
            protected com.alibaba.fastjson.JSONObject onParseJSONObject(String key, com.alibaba.fastjson.JSONObject tobj, com.alibaba.fastjson.JSONObject robj) throws Exception {
                return AbstractVerifier.verifyResponse(method, key, tobj, robj, database, schema, idKeyCallback, creator, callback);
            }
        });
    }

    public static com.alibaba.fastjson.JSONObject parse(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject real, SQLCreator creator, @NotNull OnParseCallback callback) throws Exception {
        return AbstractVerifier.parse(method, name, target, real, null, null, null, creator, callback);
    }

    public static <T> com.alibaba.fastjson.JSONObject parse(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject real, String database, String schema, AbstractSQLConfig.IdCallback<T> idCallback, SQLCreator creator, @NotNull OnParseCallback callback) throws Exception {
        return AbstractVerifier.parse(method, name, target, real, database, schema, null, idCallback, creator, callback);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> com.alibaba.fastjson.JSONObject parse(@NotNull RequestMethod method, String name, com.alibaba.fastjson.JSONObject target, com.alibaba.fastjson.JSONObject real, String database, String schema, String datasource, AbstractSQLConfig.IdCallback<T> idCallback, SQLCreator creator, @NotNull OnParseCallback callback) throws Exception {
        Set ifSet;
        String[] partialFails;
        String[] uniques;
        void var33_46;
        com.alibaba.fastjson.JSONObject ifObj;
        if (target == null) {
            return null;
        }
        com.alibaba.fastjson.JSONObject type = target.getJSONObject(Operation.TYPE.name());
        com.alibaba.fastjson.JSONObject verify = target.getJSONObject(Operation.VERIFY.name());
        com.alibaba.fastjson.JSONObject insert = target.getJSONObject(Operation.INSERT.name());
        com.alibaba.fastjson.JSONObject update = target.getJSONObject(Operation.UPDATE.name());
        com.alibaba.fastjson.JSONObject replace = target.getJSONObject(Operation.REPLACE.name());
        String exist = StringUtil.getString(target.getString(Operation.EXIST.name()));
        String unique = StringUtil.getString(target.getString(Operation.UNIQUE.name()));
        String remove = StringUtil.getString(target.getString(Operation.REMOVE.name()));
        String must = StringUtil.getString(target.getString(Operation.MUST.name()));
        String refuse = StringUtil.getString(target.getString(Operation.REFUSE.name()));
        Object _if = target.get((Object)Operation.IF.name());
        boolean ifIsStr = _if instanceof String && StringUtil.isNotEmpty(_if, true);
        com.alibaba.fastjson.JSONObject jSONObject = ifObj = !ifIsStr && _if instanceof com.alibaba.fastjson.JSONObject ? (com.alibaba.fastjson.JSONObject)_if : null;
        if (ifObj == null && _if != null && !ifIsStr) {
            throw new IllegalArgumentException(name + ": { " + Operation.IF.name() + ": value } \u4e2d value \u7c7b\u578b\u9519\u8bef\uff01\u53ea\u5141\u8bb8 String, JSONObject\uff01");
        }
        String allowPartialUpdateFail = StringUtil.getString(target.getString(Operation.ALLOW_PARTIAL_UPDATE_FAIL.name()));
        String[] removes = StringUtil.split(remove);
        if (removes != null && removes.length > 0) {
            for (String r : removes) {
                real.remove((Object)r);
            }
        }
        String[] musts = StringUtil.split(must);
        HashSet<String> mustSet = new HashSet<String>();
        if (musts != null && musts.length > 0) {
            for (String s : musts) {
                if (real.get((Object)s) == null && real.get((Object)(s + "@")) == null) {
                    throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + " \u91cc\u9762\u4e0d\u80fd\u7f3a\u5c11 " + s + " \u7b49[" + must + "]\u5185\u7684\u4efb\u4f55\u5b57\u6bb5\uff01");
                }
                mustSet.add(s);
            }
        }
        HashSet<String> objKeySet = new HashSet<String>();
        LinkedHashSet set = new LinkedHashSet(target.entrySet());
        if (!set.isEmpty()) {
            for (Map.Entry entry : set) {
                Object object;
                Object tvalue;
                String key = entry == null ? null : (String)entry.getKey();
                if (key == null || OPERATION_KEY_LIST.contains(key) || !callback.onParse(key, tvalue = entry.getValue(), object = real.get((Object)key))) continue;
                if (tvalue instanceof com.alibaba.fastjson.JSONObject) {
                    if (object != null && !(object instanceof com.alibaba.fastjson.JSONObject)) {
                        throw new UnsupportedDataTypeException(key + ":value \u7684 value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f OBJECT \uff0c\u7ed3\u6784\u4e3a {} !");
                    }
                    tvalue = callback.onParseJSONObject(key, (com.alibaba.fastjson.JSONObject)tvalue, (com.alibaba.fastjson.JSONObject)object);
                    objKeySet.add(key);
                } else if (tvalue instanceof JSONArray) {
                    if (object != null && !(object instanceof JSONArray)) {
                        throw new UnsupportedDataTypeException(key + ":value \u7684 value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f ARRAY \uff0c\u7ed3\u6784\u4e3a [] !");
                    }
                    tvalue = callback.onParseJSONArray(key, (JSONArray)tvalue, (JSONArray)object);
                    if ((method == RequestMethod.POST || method == RequestMethod.PUT) && JSONRequest.isArrayKey(key)) {
                        objKeySet.add(key);
                    }
                } else {
                    tvalue = callback.onParseObject(key, tvalue, object);
                }
                if (tvalue == null) continue;
                real.put(key, tvalue);
            }
        }
        Set rkset = real.keySet();
        String[] refuses = StringUtil.split(refuse);
        HashSet<String> refuseSet = new HashSet<String>();
        if (refuses != null && refuses.length > 0) {
            HashSet<String> notRefuseSet = new HashSet<String>();
            for (String rfs : refuses) {
                if (rfs == null) continue;
                if (rfs.startsWith("!")) {
                    if (notRefuseSet.contains(rfs = rfs.substring(1))) {
                        throw new ConflictException(Operation.REFUSE.name() + ":value \u4e2d\u51fa\u73b0\u4e86\u91cd\u590d\u7684 !" + rfs + " \uff01\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u4e5f\u4e0d\u5141\u8bb8\u4e00\u4e2a key \u548c\u53d6\u53cd !key \u540c\u65f6\u4f7f\u7528\uff01");
                    }
                    if (refuseSet.contains(rfs)) {
                        throw new ConflictException(Operation.REFUSE.name() + ":value \u4e2d\u540c\u65f6\u51fa\u73b0\u4e86 " + rfs + " \u548c !" + rfs + " \uff01\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u4e5f\u4e0d\u5141\u8bb8\u4e00\u4e2a key \u548c\u53d6\u53cd !key \u540c\u65f6\u4f7f\u7528\uff01");
                    }
                    if (rfs.equals("")) {
                        for (String key : rkset) {
                            if (key == null || key.startsWith("@") || notRefuseSet.contains(key) || mustSet.contains(key) || objKeySet.contains(key) || key.endsWith("@") && mustSet.contains(key.substring(0, key.length() - 1))) continue;
                            refuseSet.add(key);
                        }
                        continue;
                    }
                    notRefuseSet.add(rfs);
                    continue;
                }
                if (refuseSet.contains(rfs)) {
                    throw new ConflictException(Operation.REFUSE.name() + ":value \u4e2d\u51fa\u73b0\u4e86\u91cd\u590d\u7684 " + rfs + " \uff01\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u4e5f\u4e0d\u5141\u8bb8\u4e00\u4e2a key \u548c\u53d6\u53cd !key \u540c\u65f6\u4f7f\u7528\uff01");
                }
                if (notRefuseSet.contains(rfs)) {
                    throw new ConflictException(Operation.REFUSE.name() + ":value \u4e2d\u540c\u65f6\u51fa\u73b0\u4e86 " + rfs + " \u548c !" + rfs + " \uff01\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u4e5f\u4e0d\u5141\u8bb8\u4e00\u4e2a key \u548c\u53d6\u53cd !key \u540c\u65f6\u4f7f\u7528\uff01");
                }
                refuseSet.add(rfs);
            }
        }
        LinkedHashSet onKeys = new LinkedHashSet();
        for (String rk : rkset) {
            if (refuseSet.contains(rk)) {
                throw new IllegalArgumentException(method + "\u8bf7\u6c42\uff0c" + name + " \u91cc\u9762\u4e0d\u5141\u8bb8\u4f20 " + rk + " \u7b49" + StringUtil.getString(refuseSet) + "\u5185\u7684\u4efb\u4f55\u5b57\u6bb5\uff01");
            }
            if (rk == null) {
                real.remove((Object)rk);
                continue;
            }
            Object rv = real.get((Object)rk);
            if (rk.endsWith("()") && rv instanceof String) {
                throw new UnsupportedOperationException(method + " \u8bf7\u6c42\uff0c" + rk + " \u4e0d\u5408\u6cd5\uff01\u975e\u5f00\u653e\u8bf7\u6c42\u4e0d\u5141\u8bb8\u4f20\u8fdc\u7a0b\u51fd\u6570 key():\"fun()\" \uff01");
            }
            if (rk.startsWith("@") || rk.endsWith("@") || objKeySet.contains(rk)) continue;
            if (rv instanceof com.alibaba.fastjson.JSONObject) {
                throw new UnsupportedOperationException(method + " \u8bf7\u6c42\uff0c" + name + " \u91cc\u9762\u4e0d\u5141\u8bb8\u4f20 " + rk + ":{} \uff01");
            }
            if (method != RequestMethod.POST && method != RequestMethod.PUT || !(rv instanceof JSONArray) || !JSONRequest.isArrayKey(rk)) continue;
            throw new UnsupportedOperationException(method + " \u8bf7\u6c42\uff0c" + name + " \u91cc\u9762\u4e0d\u5141\u8bb8 " + rk + ":[] \u7b49\u672a\u5b9a\u4e49\u7684 Table[]:[{}] \u6279\u91cf\u64cd\u4f5c\u952e\u503c\u5bf9\uff01");
        }
        real = AbstractVerifier.operate(Operation.TYPE, type, real, creator);
        real = AbstractVerifier.operate(Operation.VERIFY, verify, real, creator);
        real = AbstractVerifier.operate(Operation.INSERT, insert, real, creator);
        real = AbstractVerifier.operate(Operation.UPDATE, update, real, creator);
        real = AbstractVerifier.operate(Operation.REPLACE, replace, real, creator);
        String string = real.getString("@database");
        String sh = real.getString("@schema");
        String ds = real.getString("@datasource");
        if (StringUtil.isEmpty(string, false)) {
            String string2 = database;
        }
        if (StringUtil.isEmpty(sh, false)) {
            sh = schema;
        }
        if (StringUtil.isEmpty(ds, false)) {
            ds = datasource;
        }
        String idKey = idCallback == null ? null : idCallback.getIdKey((String)var33_46, sh, ds, name);
        String finalIdKey = StringUtil.isEmpty(idKey, false) ? JSONObject.KEY_ID : idKey;
        String[] exists = StringUtil.split(exist);
        if (exists != null && exists.length > 0) {
            long exceptId = real.getLongValue(finalIdKey);
            String[] map = new HashMap();
            String[] stringArray = exists;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String e = stringArray[i];
                map.put(e, real.get((Object)e));
            }
            AbstractVerifier.verifyExist(name, (Map<String, Object>)map, exceptId, creator);
        }
        if ((uniques = StringUtil.split(unique)) != null && uniques.length > 0) {
            long exceptId = real.getLongValue(finalIdKey);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String u : uniques) {
                map.put(u, real.get((Object)u));
            }
            AbstractVerifier.verifyRepeat(name, map, exceptId, finalIdKey, creator);
        }
        if ((partialFails = StringUtil.split(allowPartialUpdateFail)) != null && partialFails.length > 0) {
            for (String key : partialFails) {
                if (!JSONObject.isArrayKey(key)) {
                    throw new IllegalArgumentException("\u540e\u7aef Request \u8868\u4e2d " + Operation.ALLOW_PARTIAL_UPDATE_FAIL.name() + ":value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4ee5 [] \u7ed3\u5c3e\uff01");
                }
                if (!(target.get((Object)key) instanceof Collection)) {
                    throw new IllegalArgumentException("\u540e\u7aef Request \u8868\u4e2d " + Operation.ALLOW_PARTIAL_UPDATE_FAIL.name() + ":value \u4e2d " + key + " \u5bf9\u5e94\u7684 " + key + ":[] \u4e0d\u5b58\u5728\uff01");
                }
                String k = key.substring(0, key.length() - 2);
                if (k.isEmpty()) {
                    throw new IllegalArgumentException("\u540e\u7aef Request \u8868\u4e2d " + Operation.ALLOW_PARTIAL_UPDATE_FAIL.name() + ":value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01[] \u524d\u5fc5\u987b\u6709\u540d\u5b57\uff01");
                }
                AbstractSQLConfig.ALLOW_PARTIAL_UPDATE_FAIL_TABLE_MAP.putIfAbsent(k, "");
            }
        }
        String[] nks = ifObj == null ? null : StringUtil.split(real.getString("@null"));
        Collection<Object> nkl = nks == null || nks.length <= 0 ? new HashSet() : Arrays.asList(nks);
        Set set2 = ifSet = ifObj == null ? null : ifObj.entrySet();
        if (ifIsStr || ifSet != null && !ifSet.isEmpty()) {
            String preCode = "var curObj = " + JSON.format(real) + ";";
            if (ifIsStr) {
                String ifStr = (String)_if;
                int ind = ifStr.indexOf(":");
                String lang = ind < 0 || ind > 20 ? null : ifStr.substring(0, ind);
                boolean isName = StringUtil.isName(lang);
                ScriptEngine engine = AbstractVerifier.getScriptEngine(isName ? lang : null);
                engine.eval(preCode + "\n" + (isName ? ifStr.substring(ind + 1) : ifStr));
            } else {
                for (Map.Entry entry : ifSet) {
                    String v;
                    String k = entry == null ? null : (String)entry.getKey();
                    String string3 = v = k == null ? null : (String)entry.getValue();
                    if (v instanceof String) {
                        int ind = k.indexOf(":");
                        String lang = ind < 0 || ind > 20 ? null : k.substring(0, ind);
                        boolean isName = StringUtil.isName(lang);
                        ScriptEngine engine = AbstractVerifier.getScriptEngine(isName ? lang : null);
                        k = isName ? k.substring(ind + 1) : k;
                        boolean isElse = StringUtil.isEmpty(k, false);
                        String code = preCode + "\n\n" + (isElse ? v : "if (" + k + ") {\n  " + v + "\n}");
                        engine.eval(code);
                        continue;
                    }
                    if (!(v instanceof com.alibaba.fastjson.JSONObject)) {
                        throw new IllegalArgumentException("Request \u8868 structure \u914d\u7f6e\u7684 " + Operation.IF.name() + ":{ " + k + ":value } \u4e2d value \u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u662f JSONObject {} \uff01");
                    }
                    if (!nkl.contains(k) && real.get((Object)k) == null) continue;
                    real = AbstractVerifier.parse(method, name, (com.alibaba.fastjson.JSONObject)v, real, database, schema, datasource, idCallback, creator, callback);
                }
            }
        }
        Log.i(TAG, "parse  return real = " + JSON.toJSONString(real));
        return real;
    }

    public static ScriptEngine getScriptEngine(String lang) {
        ScriptEngine engine;
        boolean isEmpty = StringUtil.isEmpty(lang, true);
        ScriptEngine scriptEngine = engine = isEmpty ? SCRIPT_ENGINE : SCRIPT_ENGINE_MANAGER.getEngineByName(lang);
        if (engine == null) {
            throw new NullPointerException("\u627e\u4e0d\u5230\u53ef\u6267\u884c " + (isEmpty ? "js" : lang) + " \u811a\u672c\u7684\u5f15\u64ce\uff01engine == null!");
        }
        return engine;
    }

    private static com.alibaba.fastjson.JSONObject operate(Operation opt, com.alibaba.fastjson.JSONObject targetChild, com.alibaba.fastjson.JSONObject real, SQLCreator creator) throws Exception {
        if (targetChild == null) {
            return real;
        }
        if (real == null) {
            throw new IllegalArgumentException("operate  real == null!!!");
        }
        LinkedHashSet set = new LinkedHashSet(targetChild.entrySet());
        for (Map.Entry e : set) {
            String tk = e == null ? null : (String)e.getKey();
            if (tk == null || OPERATION_KEY_LIST.contains(tk)) continue;
            Object tv = e.getValue();
            if (opt == Operation.TYPE) {
                AbstractVerifier.verifyType(tk, tv, real);
                continue;
            }
            if (opt == Operation.VERIFY) {
                AbstractVerifier.verifyValue(tk, tv, real, creator);
                continue;
            }
            if (opt == Operation.UPDATE) {
                real.put(tk, tv);
                continue;
            }
            if (real.containsKey((Object)tk)) {
                if (opt != Operation.REPLACE) continue;
                real.put(tk, tv);
                continue;
            }
            if (opt != Operation.INSERT) continue;
            real.put(tk, tv);
        }
        return real;
    }

    public static void verifyType(@NotNull String tk, Object tv, @NotNull com.alibaba.fastjson.JSONObject real) throws UnsupportedDataTypeException {
        if (!(tv instanceof String)) {
            throw new UnsupportedDataTypeException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c" + tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01Request\u8868\u6821\u9a8c\u89c4\u5219\u4e2d TYPE:{ key:value } \u4e2d\u7684value\u53ea\u80fd\u662fString\u7c7b\u578b\uff01");
        }
        AbstractVerifier.verifyType(tk, (String)tv, real.get((Object)tk));
    }

    public static void verifyType(@NotNull String tk, @NotNull String tv, Object rv) throws UnsupportedDataTypeException {
        AbstractVerifier.verifyType(tk, tv, rv, false);
    }

    public static void verifyType(@NotNull String tk, @NotNull String tv, Object rv, boolean isInArray) throws UnsupportedDataTypeException {
        if (rv == null) {
            return;
        }
        if (tv.endsWith("[]")) {
            AbstractVerifier.verifyType(tk, "ARRAY", rv);
            for (Object o : (Collection)rv) {
                AbstractVerifier.verifyType(tk, tv.substring(0, tv.length() - 2), o, true);
            }
            return;
        }
        switch (tv) {
            case "BOOLEAN": {
                if (rv instanceof Boolean) break;
                throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f BOOLEAN" + (isInArray ? "[] !" : " !"));
            }
            case "NUMBER": {
                try {
                    Long.parseLong(rv.toString());
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f NUMBER" + (isInArray ? "[] !" : " !"));
                }
            }
            case "DECIMAL": {
                try {
                    Double.parseDouble(rv.toString());
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f DECIMAL" + (isInArray ? "[] !" : " !"));
                }
            }
            case "STRING": {
                if (rv instanceof String) break;
                throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f STRING" + (isInArray ? "[] !" : " !"));
            }
            case "URL": {
                try {
                    new URL((String)rv);
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f URL" + (isInArray ? "[] !" : " !"));
                }
            }
            case "DATE": {
                try {
                    LocalDate.parse((String)rv);
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f\u683c\u5f0f\u4e3a YYYY-MM-DD\uff08\u4f8b\u5982 2020-02-20\uff09\u7684 DATE" + (isInArray ? "[] !" : " !"));
                }
            }
            case "TIME": {
                try {
                    LocalTime.parse((String)rv);
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f\u683c\u5f0f\u4e3a HH:mm:ss\uff08\u4f8b\u5982 12:01:30\uff09\u7684 TIME" + (isInArray ? "[] !" : " !"));
                }
            }
            case "DATETIME": {
                try {
                    LocalDateTime.parse((String)rv);
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f\u683c\u5f0f\u4e3a YYYY-MM-DDTHH:mm:ss\uff08\u4f8b\u5982 2020-02-20T12:01:30\uff09\u7684 DATETIME" + (isInArray ? "[] !" : " !"));
                }
            }
            case "OBJECT": {
                if (rv instanceof Map) break;
                throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f OBJECT" + (isInArray ? "[] !" : " !") + " OBJECT \u7ed3\u6784\u4e3a {} !");
            }
            case "ARRAY": {
                if (rv instanceof Collection) break;
                throw new UnsupportedDataTypeException(tk + ":value \u7684value\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f ARRAY" + (isInArray ? "[] !" : " !") + " ARRAY \u7ed3\u6784\u4e3a [] !");
            }
            default: {
                throw new UnsupportedDataTypeException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c\u7c7b\u578b " + tv + " \u4e0d\u5408\u6cd5\uff01Request\u8868\u6821\u9a8c\u89c4\u5219\u4e2d TYPE:{ key:value } \u4e2d\u7684 value \u5fc5\u987b\u662f [ BOOLEAN, NUMBER, DECIMAL, STRING, URL, DATE, TIME, DATETIME, OBJECT, ARRAY ] \u6216\u5b83\u4eec\u7684\u6570\u7ec4 [ BOOLEAN[], NUMBER[], DECIMAL[], STRING[], URL[], DATE[], TIME[], DATETIME[], OBJECT[], ARRAY[] ] \u4e2d\u7684\u4e00\u4e2a!");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void verifyValue(@NotNull String tk, @NotNull Object tv, @NotNull com.alibaba.fastjson.JSONObject real, SQLCreator creator) throws Exception {
        Iterator iterator;
        boolean isOr;
        Object rv;
        String rk;
        Logic logic;
        block23: {
            String[] tvs;
            Object rv2;
            String rk2;
            block22: {
                Iterator iterator2;
                boolean isOr2;
                Object rv3;
                String rk3;
                Logic logic2;
                block20: {
                    block21: {
                        block19: {
                            if (tv == null) {
                                throw new IllegalArgumentException("operate  operate == VERIFY " + tk + ":" + tv + " ,  >> tv == null!!!");
                            }
                            if (tk.endsWith("$")) {
                                AbstractVerifier.verifyCondition("$", real, tk, tv, creator);
                                return;
                            }
                            if (!tk.endsWith("~")) break block19;
                            logic2 = new Logic(tk.substring(0, tk.length() - 1));
                            rk3 = logic2.getKey();
                            rv3 = real.get((Object)rk3);
                            if (rv3 == null) {
                                return;
                            }
                            JSONArray array = AbstractSQLConfig.newJSONArray(tv);
                            isOr2 = false;
                            iterator2 = array.iterator();
                            break block20;
                        }
                        if (tk.endsWith("{}")) {
                            if (tv instanceof String) {
                                AbstractVerifier.verifyCondition("{}", real, tk, tv, creator);
                                return;
                            }
                            if (!(tv instanceof JSONArray)) throw new UnsupportedDataTypeException("\u670d\u52a1\u5668Request\u8868verify\u914d\u7f6e\u9519\u8bef\uff01");
                            Logic logic3 = new Logic(tk.substring(0, tk.length() - 2));
                            String rk4 = logic3.getKey();
                            Object rv4 = real.get((Object)rk4);
                            if (rv4 == null) {
                                return;
                            }
                            if (((JSONArray)tv).contains(rv4) != logic3.isNot()) return;
                            throw new IllegalArgumentException(rk4 + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
                        }
                        if (!tk.endsWith("{L}")) break block21;
                        if (!(tv instanceof String)) throw new UnsupportedDataTypeException("\u670d\u52a1\u5668Request\u8868verify\u914d\u7f6e\u9519\u8bef\uff01");
                        Logic logic4 = new Logic(tk.substring(0, tk.length() - 3));
                        rk2 = logic4.getKey();
                        rv2 = real.get((Object)rk2);
                        if (rv2 == null) {
                            return;
                        }
                        break block22;
                    }
                    if (!tk.endsWith("<>")) throw new IllegalArgumentException("\u670d\u52a1\u5668Request\u8868verify\u914d\u7f6e\u9519\u8bef\uff01");
                    logic = new Logic(tk.substring(0, tk.length() - 2));
                    rk = logic.getKey();
                    rv = real.get((Object)rk);
                    if (rv == null) {
                        return;
                    }
                    if (!(rv instanceof JSONArray)) {
                        throw new UnsupportedDataTypeException("\u670d\u52a1\u5668Request\u8868verify\u914d\u7f6e\u9519\u8bef\uff01");
                    }
                    JSONArray array = AbstractSQLConfig.newJSONArray(tv);
                    isOr = false;
                    iterator = array.iterator();
                    break block23;
                }
                while (iterator2.hasNext()) {
                    boolean m;
                    Object r = iterator2.next();
                    if (!(r instanceof String)) {
                        throw new UnsupportedDataTypeException(rk3 + ":" + rv3 + " \u4e2dvalue\u53ea\u652f\u6301 String \u6216 [String] \u7c7b\u578b\uff01");
                    }
                    Pattern reg = COMPILE_MAP.get(r);
                    if (reg == null) {
                        reg = Pattern.compile((String)r);
                    }
                    if (m = reg.matcher("" + rv3).matches()) {
                        if (logic2.isNot()) {
                            throw new IllegalArgumentException(rk3 + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
                        }
                        if (!logic2.isOr()) continue;
                        isOr2 = true;
                        break;
                    }
                    if (!logic2.isAnd()) continue;
                    throw new IllegalArgumentException(rk3 + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
                }
                if (isOr2) return;
                if (!logic2.isOr()) return;
                throw new IllegalArgumentException(rk3 + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
            }
            String[] m = tvs = tv.toString().split(",");
            int n = m.length;
            int reg = 0;
            while (reg < n) {
                String tvItem = m[reg];
                if (!AbstractVerifier.verifyRV(tvItem, rv2.toString())) {
                    throw new IllegalArgumentException(rk2 + ":value \u4e2dvalue\u957f\u5ea6\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
                }
                ++reg;
            }
            return;
        }
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (((JSONArray)rv).contains(o)) {
                if (logic.isNot()) {
                    throw new IllegalArgumentException(rk + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
                }
                if (!logic.isOr()) continue;
                isOr = true;
                break;
            }
            if (!logic.isAnd()) continue;
            throw new IllegalArgumentException(rk + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
        }
        if (isOr) return;
        if (!logic.isOr()) return;
        throw new IllegalArgumentException(rk + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d " + tk + ":" + tv + " !");
    }

    private static boolean verifyRV(String rule, String content) throws UnsupportedDataTypeException {
        String first = null;
        String second = null;
        Matcher matcher = VERIFY_LENGTH_PATTERN.matcher(rule);
        while (matcher.find()) {
            first = StringUtil.isEmpty(first) ? matcher.group("first") : first;
            second = StringUtil.isEmpty(second) ? matcher.group("second") : second;
        }
        if (StringUtil.isEmpty(first) || StringUtil.isEmpty(second)) {
            throw new UnsupportedDataTypeException("\u670d\u52a1\u5668Request\u8868verify\u914d\u7f6e\u9519\u8bef\uff01");
        }
        int secondNum = Integer.parseInt(second);
        switch (Objects.requireNonNull(first)) {
            case ">": {
                return content.length() > secondNum;
            }
            case ">=": {
                return content.length() >= secondNum;
            }
            case "<": {
                return content.length() < secondNum;
            }
            case "<=": {
                return content.length() <= secondNum;
            }
            case "<>": {
                return content.length() != secondNum;
            }
        }
        throw new UnsupportedDataTypeException("\u670d\u52a1\u5668Request\u8868verify\u914d\u7f6e\u9519\u8bef\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyCondition(@NotNull String funChar, @NotNull com.alibaba.fastjson.JSONObject real, @NotNull String tk, @NotNull Object tv, @NotNull SQLCreator creator) throws Exception {
        Logic logic = new Logic(tk.substring(0, tk.length() - funChar.length()));
        String rk = logic.getKey();
        Object rv = real.get((Object)rk);
        if (rv == null) {
            return;
        }
        if (rv instanceof String && ((String)rv).contains("'")) {
            throw new IllegalArgumentException(rk + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01value \u4e2d\u4e0d\u5141\u8bb8\u6709\u5355\u5f15\u53f7 ' \uff01");
        }
        SQLConfig config = creator.createSQLConfig().setMethod(RequestMethod.GET).setCount(1).setPage(0);
        config.setTest(true);
        config.putWhere(rv + logic.getChar() + funChar, tv, false);
        config.setCount(1);
        com.alibaba.fastjson.JSONObject result = null;
        try (SQLExecutor executor = creator.createSQLExecutor();){
            result = executor.execute(config, false);
        }
        if (result != null && !JSONResponse.isExist(result.getIntValue("count"))) {
            throw new IllegalArgumentException(rk + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5339\u914d '" + tk + "': '" + tv + "' \uff01");
        }
    }

    public static void verifyExist(String table, String key, Object value, long exceptId, @NotNull SQLCreator creator) throws Exception {
        if (key == null || value == null) {
            Log.e(TAG, "verifyExist  key == null || value == null >> return;");
            return;
        }
        if (value instanceof JSON) {
            throw new UnsupportedDataTypeException(key + ":value \u4e2dvalue\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3aJSON\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        AbstractVerifier.verifyExist(table, map, exceptId, creator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyExist(String table, Map<String, Object> param, long exceptId, @NotNull SQLCreator creator) throws Exception {
        if (param.isEmpty()) {
            Log.e(TAG, "verifyExist is empty >> return;");
            return;
        }
        SQLConfig config = creator.createSQLConfig().setMethod(RequestMethod.HEAD).setCount(1).setPage(0);
        config.setTable(table);
        param.forEach((key, value) -> config.putWhere((String)key, value, false));
        try (SQLExecutor executor = creator.createSQLExecutor();){
            com.alibaba.fastjson.JSONObject result = executor.execute(config, false);
            if (result == null) {
                throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef  verifyExist  result == null");
            }
            if (result.getIntValue("count") <= 0) {
                StringBuilder sb = new StringBuilder();
                param.forEach((key, value) -> sb.append("key:").append((String)key).append(" value:").append(value).append(" "));
                throw new ConflictException(sb + "\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01\u5982\u679c\u5fc5\u8981\u8bf7\u5148\u521b\u5efa\uff01");
            }
        }
    }

    public static void verifyRepeat(String table, String key, Object value, @NotNull SQLCreator creator) throws Exception {
        AbstractVerifier.verifyRepeat(table, key, value, 0L, creator);
    }

    public static void verifyRepeat(String table, String key, Object value, long exceptId, @NotNull SQLCreator creator) throws Exception {
        AbstractVerifier.verifyRepeat(table, key, value, exceptId, null, creator);
    }

    public static void verifyRepeat(String table, String key, Object value, long exceptId, String idKey, @NotNull SQLCreator creator) throws Exception {
        if (key == null || value == null) {
            Log.e(TAG, "verifyRepeat  key == null || value == null >> return;");
            return;
        }
        if (value instanceof JSON) {
            throw new UnsupportedDataTypeException(key + ":value \u4e2dvalue\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3aJSON\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        AbstractVerifier.verifyRepeat(table, map, exceptId, idKey, creator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyRepeat(String table, Map<String, Object> param, long exceptId, String idKey, @NotNull SQLCreator creator) throws Exception {
        if (param.isEmpty()) {
            Log.e(TAG, "verifyRepeat is empty >> return;");
            return;
        }
        String finalIdKey = StringUtil.isEmpty(idKey, false) ? JSONObject.KEY_ID : idKey;
        SQLConfig config = creator.createSQLConfig().setMethod(RequestMethod.HEAD).setCount(1).setPage(0);
        config.setTable(table);
        if (exceptId > 0L) {
            config.putWhere(finalIdKey + "!", exceptId, false);
        }
        param.forEach((key, value) -> config.putWhere((String)key, value, false));
        try (SQLExecutor executor = creator.createSQLExecutor();){
            com.alibaba.fastjson.JSONObject result = executor.execute(config, false);
            if (result == null) {
                throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef  verifyRepeat  result == null");
            }
            if (result.getIntValue("count") > 0) {
                StringBuilder sb = new StringBuilder();
                param.forEach((key, value) -> sb.append("key:").append((String)key).append(" value:").append(value).append(" "));
                throw new ConflictException(sb + "\u7684\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
        }
    }

    public static String getCacheKeyForRequest(String method, String tag) {
        return method + "/" + tag;
    }

    static {
        VERIFY_LENGTH_RULE = "(?<first>[>=<]*)(?<second>[0-9]*)";
        VERIFY_LENGTH_PATTERN = Pattern.compile(VERIFY_LENGTH_RULE);
        SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
        SCRIPT_ENGINE = SCRIPT_ENGINE_MANAGER.getEngineByName("js");
        ROLE_MAP = new LinkedHashMap<String, Entry<String, Object>>();
        ROLE_MAP.put(UNKNOWN, new Entry());
        ROLE_MAP.put(LOGIN, new Entry<String, Integer>("userId>", 0));
        ROLE_MAP.put(CONTACT, new Entry<String, String>("userId{}", "contactIdList"));
        ROLE_MAP.put(CIRCLE, new Entry<String, String>("userId-()", "verifyCircle()"));
        ROLE_MAP.put(OWNER, new Entry<String, String>("userId", "userId"));
        ROLE_MAP.put(ADMIN, new Entry<String, String>("userId-()", "verifyAdmin()"));
        OPERATION_KEY_LIST = new ArrayList<String>();
        OPERATION_KEY_LIST.add(Operation.TYPE.name());
        OPERATION_KEY_LIST.add(Operation.VERIFY.name());
        OPERATION_KEY_LIST.add(Operation.INSERT.name());
        OPERATION_KEY_LIST.add(Operation.UPDATE.name());
        OPERATION_KEY_LIST.add(Operation.REPLACE.name());
        OPERATION_KEY_LIST.add(Operation.EXIST.name());
        OPERATION_KEY_LIST.add(Operation.UNIQUE.name());
        OPERATION_KEY_LIST.add(Operation.REMOVE.name());
        OPERATION_KEY_LIST.add(Operation.MUST.name());
        OPERATION_KEY_LIST.add(Operation.REFUSE.name());
        OPERATION_KEY_LIST.add(Operation.IF.name());
        OPERATION_KEY_LIST.add(Operation.ALLOW_PARTIAL_UPDATE_FAIL.name());
        SYSTEM_ACCESS_MAP = new HashMap<String, Map<RequestMethod, String[]>>();
        SYSTEM_ACCESS_MAP.put(Access.class.getSimpleName(), AbstractVerifier.getAccessMap(Access.class.getAnnotation(MethodAccess.class)));
        SYSTEM_ACCESS_MAP.put(Function.class.getSimpleName(), AbstractVerifier.getAccessMap(Function.class.getAnnotation(MethodAccess.class)));
        SYSTEM_ACCESS_MAP.put(Script.class.getSimpleName(), AbstractVerifier.getAccessMap(Script.class.getAnnotation(MethodAccess.class)));
        SYSTEM_ACCESS_MAP.put(Request.class.getSimpleName(), AbstractVerifier.getAccessMap(Request.class.getAnnotation(MethodAccess.class)));
        if (Log.DEBUG) {
            SYSTEM_ACCESS_MAP.put(Table.class.getSimpleName(), AbstractVerifier.getAccessMap(Table.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(Column.class.getSimpleName(), AbstractVerifier.getAccessMap(Column.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(PgAttribute.class.getSimpleName(), AbstractVerifier.getAccessMap(PgAttribute.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(PgClass.class.getSimpleName(), AbstractVerifier.getAccessMap(PgClass.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(AllTable.class.getSimpleName(), AbstractVerifier.getAccessMap(AllTable.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(AllTableComment.class.getSimpleName(), AbstractVerifier.getAccessMap(AllTableComment.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(AllColumn.class.getSimpleName(), AbstractVerifier.getAccessMap(AllColumn.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(AllColumnComment.class.getSimpleName(), AbstractVerifier.getAccessMap(AllColumnComment.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(SysTable.class.getSimpleName(), AbstractVerifier.getAccessMap(SysTable.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(SysColumn.class.getSimpleName(), AbstractVerifier.getAccessMap(SysColumn.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(ExtendedProperty.class.getSimpleName(), AbstractVerifier.getAccessMap(ExtendedProperty.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(Document.class.getSimpleName(), AbstractVerifier.getAccessMap(Document.class.getAnnotation(MethodAccess.class)));
            SYSTEM_ACCESS_MAP.put(TestRecord.class.getSimpleName(), AbstractVerifier.getAccessMap(TestRecord.class.getAnnotation(MethodAccess.class)));
        }
        ACCESS_MAP = new HashMap<String, Map<RequestMethod, String[]>>(SYSTEM_ACCESS_MAP);
        REQUEST_MAP = new HashMap<String, SortedMap<Integer, com.alibaba.fastjson.JSONObject>>(ACCESS_MAP.size() * 7);
        COMPILE_MAP = new HashMap<String, Pattern>();
    }
}

