/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractParser;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.FunctionParser;
import apijson.orm.Parser;
import apijson.orm.exception.UnsupportedDataTypeException;
import apijson.orm.script.ScriptExecutor;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractFunctionParser<T>
implements FunctionParser<T> {
    private static final String TAG = "AbstractFunctionParser";
    public static boolean IS_PARSE_ARG_VALUE = false;
    public static boolean ENABLE_REMOTE_FUNCTION = true;
    public static boolean ENABLE_SCRIPT_FUNCTION = true;
    public static Map<String, ScriptExecutor> SCRIPT_EXECUTOR_MAP;
    public static Map<String, JSONObject> FUNCTION_MAP;
    private RequestMethod method;
    private String tag;
    private int version;
    private JSONObject request;
    private Parser<T> parser;
    private String key;
    private String parentPath;
    private String currentName;
    private JSONObject currentObject;

    public AbstractFunctionParser() {
        this(null, null, 0, null);
    }

    public AbstractFunctionParser(RequestMethod method, String tag, int version, @NotNull JSONObject request) {
        this.setMethod(method == null ? RequestMethod.GET : method);
        this.setTag(tag);
        this.setVersion(version);
        this.setRequest(request);
    }

    @Override
    public Parser<T> getParser() {
        return this.parser;
    }

    @Override
    public AbstractFunctionParser<T> setParser(Parser<T> parser) {
        this.parser = parser;
        return this;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public AbstractFunctionParser<T> setMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public AbstractFunctionParser<T> setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public AbstractFunctionParser<T> setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public AbstractFunctionParser<T> setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public AbstractFunctionParser<T> setParentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @Override
    public String getCurrentName() {
        return this.currentName;
    }

    @Override
    public AbstractFunctionParser<T> setCurrentName(String currentName) {
        this.currentName = currentName;
        return this;
    }

    @Override
    @NotNull
    public JSONObject getRequest() {
        return this.request;
    }

    @Override
    public AbstractFunctionParser<T> setRequest(@NotNull JSONObject request) {
        this.request = request;
        return this;
    }

    @Override
    @NotNull
    public JSONObject getCurrentObject() {
        return this.currentObject;
    }

    @Override
    public AbstractFunctionParser<T> setCurrentObject(@NotNull JSONObject currentObject) {
        this.currentObject = currentObject;
        return this;
    }

    public Boolean getArgBool(String path) {
        return this.getArgVal(path, Boolean.class);
    }

    public Integer getArgInt(String path) {
        return this.getArgVal(path, Integer.class);
    }

    public Long getArgLong(String path) {
        return this.getArgVal(path, Long.class);
    }

    public Float getArgFloat(String path) {
        return this.getArgVal(path, Float.class);
    }

    public Double getArgDouble(String path) {
        return this.getArgVal(path, Double.class);
    }

    public Number getArgNum(String path) {
        return this.getArgVal(path, Number.class);
    }

    public BigDecimal getArgDecimal(String path) {
        return this.getArgVal(path, BigDecimal.class);
    }

    public String getArgStr(String path) {
        T obj = this.getArgVal(path);
        return JSON.toJSONString(obj);
    }

    public JSONObject getArgObj(String path) {
        return this.getArgVal(path, JSONObject.class);
    }

    public JSONArray getArgArr(String path) {
        return this.getArgVal(path, JSONArray.class);
    }

    public <T> List<T> getArgList(String path) {
        return this.getArgList(path, null);
    }

    public <T> List<T> getArgList(String path, Class<T> clazz) {
        String s = this.getArgStr(path);
        return JSON.parseArray(s, clazz);
    }

    public <T> T getArgVal(String path) {
        return this.getArgVal(path, null);
    }

    public <T> T getArgVal(String path, Class<T> clazz) {
        return this.getArgVal(path, clazz, true);
    }

    public <T> T getArgVal(String path, Class<T> clazz, boolean tryAll) {
        T val = AbstractFunctionParser.getArgVal(this.getCurrentObject(), path, clazz);
        if (!tryAll || val != null) {
            return val;
        }
        Parser<T> p = this.getParser();
        String targetPath = AbstractParser.getValuePath(this.getParentPath(), path);
        return (T)(p == null ? null : p.getValueByPath(targetPath));
    }

    public static <T> T getArgVal(JSONObject obj, String path) {
        return AbstractFunctionParser.getArgVal(obj, path, null);
    }

    public static <T> T getArgVal(JSONObject obj, String path, Class<T> clazz) {
        Object v = AbstractParser.getValue(obj, StringUtil.splitPath(path));
        return (T)(clazz == null ? v : TypeUtils.cast(v, clazz, (ParserConfig)ParserConfig.getGlobalInstance()));
    }

    @Override
    public Object invoke(@NotNull String function, @NotNull JSONObject currentObject) throws Exception {
        return this.invoke(function, currentObject, false);
    }

    @Override
    public Object invoke(@NotNull String function, @NotNull JSONObject currentObject, boolean containRaw) throws Exception {
        return AbstractFunctionParser.invoke(this, function, currentObject, containRaw);
    }

    public static <T> Object invoke(@NotNull AbstractFunctionParser<T> parser, @NotNull String function, @NotNull JSONObject currentObject, boolean containRaw) throws Exception {
        List<String> ml;
        String lang;
        if (!ENABLE_REMOTE_FUNCTION) {
            throw new UnsupportedOperationException("AbstractFunctionParser.ENABLE_REMOTE_FUNCTION == false \u65f6\u4e0d\u652f\u6301\u8fdc\u7a0b\u51fd\u6570\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractFunctionParser.ENABLE_REMOTE_FUNCTION = true \uff01");
        }
        FunctionBean fb = AbstractFunctionParser.parseFunction(function, currentObject, false, containRaw);
        JSONObject row = FUNCTION_MAP.get(fb.getMethod());
        if (row == null) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " !");
        }
        String language = row.getString("language");
        String string = lang = "java".equalsIgnoreCase(language) ? null : language;
        if (!ENABLE_SCRIPT_FUNCTION && lang != null) {
            throw new UnsupportedOperationException("language = " + language + " \u4e0d\u5408\u6cd5\uff01AbstractFunctionParser.ENABLE_SCRIPT_FUNCTION == false \u65f6\u4e0d\u652f\u6301\u8fdc\u7a0b\u51fd\u6570\u4e2d\u7684\u811a\u672c\u5f62\u5f0f\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractFunctionParser.ENABLE_SCRIPT_FUNCTION = true \uff01");
        }
        if (lang != null && SCRIPT_EXECUTOR_MAP.get(lang) == null) {
            throw new ClassNotFoundException("\u627e\u4e0d\u5230\u811a\u672c\u8bed\u8a00 " + lang + " \u5bf9\u5e94\u7684\u6267\u884c\u5f15\u64ce\uff01\u8bf7\u5148\u4f9d\u8d56\u76f8\u5173\u5e93\u5e76\u5728\u540e\u7aef APIJSONFunctionParser<T> \u4e2d\u6ce8\u518c\uff01");
        }
        int version = row.getIntValue("version");
        if (parser.getVersion() < version) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8 version = " + parser.getVersion() + " \u7684\u8bf7\u6c42\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " ! \u5fc5\u987b\u6ee1\u8db3 version >= " + version + " !");
        }
        String tag = row.getString("tag");
        if (tag != null && !tag.equals(parser.getTag())) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8 tag = " + parser.getTag() + " \u7684\u8bf7\u6c42\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " ! \u5fc5\u987b\u6ee1\u8db3 tag = " + tag + " !");
        }
        Object[] methods = StringUtil.split(row.getString("methods"));
        List<String> list = ml = methods == null || methods.length <= 0 ? null : Arrays.asList(methods);
        if (ml != null && !ml.contains(parser.getMethod().toString())) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8 method = " + parser.getMethod() + " \u7684\u8bf7\u6c42\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " ! \u5fc5\u987b\u6ee1\u8db3 method \u5728 " + Arrays.toString(methods) + "\u5185 !");
        }
        try {
            return AbstractFunctionParser.invoke(parser, fb.getMethod(), fb.getTypes(), fb.getValues(), row.getString("returnType"), currentObject, SCRIPT_EXECUTOR_MAP.get(lang));
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + function + " \u5bf9\u5e94\u7684\u8fdc\u7a0b\u51fd\u6570 " + AbstractFunctionParser.getFunction(fb.getMethod(), fb.getKeys()) + " \u4e0d\u5728\u540e\u7aef " + parser.getClass().getName() + " \u5185\uff0c\u4e5f\u4e0d\u5728\u7236\u7c7b\u4e2d\uff01\u5982\u679c\u9700\u8981\u5219\u5148\u65b0\u589e\u5bf9\u5e94\u65b9\u6cd5\uff01\n\u8bf7\u68c0\u67e5\u51fd\u6570\u540d\u548c\u53c2\u6570\u6570\u91cf\u662f\u5426\u4e0e\u5df2\u5b9a\u4e49\u7684\u51fd\u6570\u4e00\u81f4\uff01\n\u4e14\u5fc5\u987b\u4e3a function(key0,key1,...) \u8fd9\u79cd\u5355\u51fd\u6570\u683c\u5f0f\uff01\nfunction \u5fc5\u987b\u7b26\u5408 Java \u51fd\u6570\u547d\u540d\uff0ckey \u662f\u7528\u4e8e\u5728 curObj \u5185\u53d6\u503c\u7684\u952e\uff01\n\u8c03\u7528\u65f6\u4e0d\u8981\u6709\u7a7a\u683c\uff01" + (Log.DEBUG ? e.getMessage() : ""));
            }
            if (e instanceof InvocationTargetException) {
                Throwable te = ((InvocationTargetException)e).getTargetException();
                if (!StringUtil.isEmpty(te.getMessage(), true)) {
                    throw te instanceof Exception ? (Exception)te : new Exception(te.getMessage());
                }
                throw new IllegalArgumentException("\u5b57\u7b26 " + function + " \u5bf9\u5e94\u7684\u8fdc\u7a0b\u51fd\u6570\u4f20\u53c2\u7c7b\u578b\u9519\u8bef\uff01\n\u8bf7\u68c0\u67e5 key:value \u4e2dvalue\u7684\u7c7b\u578b\u662f\u5426\u6ee1\u8db3\u5df2\u5b9a\u4e49\u7684\u51fd\u6570 " + AbstractFunctionParser.getFunction(fb.getMethod(), fb.getKeys()) + " \u7684\u8981\u6c42\uff01" + (Log.DEBUG ? e.getMessage() : ""));
            }
            throw e;
        }
    }

    public static <T> Object invoke(@NotNull AbstractFunctionParser<T> parser, @NotNull String methodName, @NotNull Class<?>[] parameterTypes, @NotNull Object[] args) throws Exception {
        return AbstractFunctionParser.invoke(parser, methodName, parameterTypes, args, null, null, null);
    }

    public static <T> Object invoke(@NotNull AbstractFunctionParser<T> parser, @NotNull String methodName, @NotNull Class<?>[] parameterTypes, @NotNull Object[] args, String returnType, JSONObject currentObject, ScriptExecutor scriptExecutor) throws Exception {
        if (scriptExecutor != null) {
            return AbstractFunctionParser.invokeScript(parser, methodName, parameterTypes, args, returnType, currentObject, scriptExecutor);
        }
        Method m = parser.getClass().getMethod(methodName, parameterTypes);
        if (Log.DEBUG) {
            String rt;
            String string = rt = Log.DEBUG && m.getReturnType() != null ? m.getReturnType().getSimpleName() : null;
            if ("void".equals(rt)) {
                rt = null;
            }
            if ("void".equals(returnType)) {
                returnType = null;
            }
            if (!(rt == returnType || rt != null && rt.equals(returnType))) {
                throw new WrongMethodTypeException("\u8fdc\u7a0b\u51fd\u6570 " + methodName + " \u7684\u5b9e\u9645\u8fd4\u56de\u503c\u7c7b\u578b " + rt + " \u4e0e Function \u8868\u4e2d\u7684\u914d\u7f6e\u7684 " + returnType + " \u4e0d\u5339\u914d\uff01");
            }
        }
        return m.invoke(parser, args);
    }

    public static <T> Object invokeScript(@NotNull AbstractFunctionParser<T> parser, @NotNull String methodName, @NotNull Class<?>[] parameterTypes, @NotNull Object[] args, String returnType, JSONObject currentObject, ScriptExecutor scriptExecutor) throws Exception {
        Object result = scriptExecutor.execute(parser, currentObject, methodName, args);
        if (Log.DEBUG && result != null) {
            Class<?> cls;
            String fullReturnType;
            Class<?> rt = result.getClass();
            String string = StringUtil.isSmallName(returnType) ? returnType : (fullReturnType = (returnType.startsWith("JSON") ? "com.alibaba.fastjson." : "java.lang.") + returnType);
            if (rt == null && returnType != null || rt != null && returnType == null) {
                throw new WrongMethodTypeException("\u8fdc\u7a0b\u51fd\u6570 " + methodName + " \u7684\u5b9e\u9645\u8fd4\u56de\u503c\u7c7b\u578b " + (rt == null ? null : rt.getName()) + " \u4e0e Function \u8868\u4e2d\u7684\u914d\u7f6e\u7684 " + fullReturnType + " \u4e0d\u5339\u914d\uff01");
            }
            try {
                cls = Class.forName(fullReturnType);
            }
            catch (Exception e) {
                throw new WrongMethodTypeException("\u8fdc\u7a0b\u51fd\u6570 " + methodName + " \u5728 Function \u8868\u4e2d\u7684\u914d\u7f6e\u7684\u7c7b\u578b " + returnType + " \u5bf9\u5e94\u7684 " + fullReturnType + " \u9519\u8bef\uff01\u5728 Java \u4e2d Class.forName \u627e\u4e0d\u5230\u8fd9\u4e2a\u7c7b\u578b\uff01");
            }
            if (!cls.isAssignableFrom(rt)) {
                throw new WrongMethodTypeException("\u8fdc\u7a0b\u51fd\u6570 " + methodName + " \u7684\u5b9e\u9645\u8fd4\u56de\u503c\u7c7b\u578b " + (rt == null ? null : rt.getName()) + " \u4e0e Function \u8868\u4e2d\u7684\u914d\u7f6e\u7684 " + returnType + " \u5bf9\u5e94\u7684 " + fullReturnType + " \u4e0d\u5339\u914d\uff01");
            }
        }
        Log.d(TAG, "invokeScript " + methodName + "(..) >>  result = " + result);
        return result;
    }

    @NotNull
    public static FunctionBean parseFunction(@NotNull String function, @NotNull JSONObject request, boolean isSQLFunction) throws Exception {
        return AbstractFunctionParser.parseFunction(function, request, isSQLFunction, false);
    }

    public static FunctionBean parseFunction(@NotNull String function, @NotNull JSONObject request, boolean isSQLFunction, boolean containRaw) throws Exception {
        Object[] values;
        Class[] types;
        String[] keys;
        int length;
        int start = function.indexOf("(");
        int end = function.lastIndexOf(")");
        String method = start <= 0 || end != function.length() - 1 ? null : function.substring(0, start);
        int dotInd = method == null ? -1 : method.indexOf(".");
        String schema = dotInd < 0 ? null : method.substring(0, dotInd);
        String string = method = dotInd < 0 ? method : method.substring(dotInd + 1);
        if (!StringUtil.isName(method)) {
            throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u51fd\u6570\u7684\u540d\u79f0 function \u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u7b26\u5408\u65b9\u6cd5\u547d\u540d\u89c4\u8303\uff01\u603b\u4f53\u5fc5\u987b\u4e3a function(key0,key1,...) \u8fd9\u79cd\u5355\u51fd\u6570\u683c\u5f0f\uff01\nfunction\u5fc5\u987b\u7b26\u5408 " + (isSQLFunction ? "SQL \u51fd\u6570/SQL \u5b58\u50a8\u8fc7\u7a0b" : "Java \u51fd\u6570") + " \u547d\u540d\uff0ckey \u662f\u7528\u4e8e\u5728 request \u5185\u53d6\u503c\u7684\u952e\uff01");
        }
        if (!isSQLFunction && schema != null) {
            throw new IllegalArgumentException("\u5b57\u7b26 " + schema + " \u4e0d\u5408\u6cd5\uff01\u8fdc\u7a0b\u51fd\u6570\u4e0d\u5141\u8bb8\u6307\u5b9a\u7c7b\u540d\uff01\u4e14\u5fc5\u987b\u4e3a function(key0,key1,...) \u8fd9\u79cd\u5355\u51fd\u6570\u683c\u5f0f\uff01\nfunction\u5fc5\u987b\u7b26\u5408 " + (isSQLFunction ? "SQL \u51fd\u6570/SQL \u5b58\u50a8\u8fc7\u7a0b" : "Java \u51fd\u6570") + " \u547d\u540d\uff0ckey \u662f\u7528\u4e8e\u5728 request \u5185\u53d6\u503c\u7684\u952e\uff01");
        }
        if (schema != null) {
            schema = AbstractFunctionParser.extractSchema(schema, null);
        }
        int n = length = (keys = StringUtil.split(function.substring(start + 1, end))) == null ? 0 : keys.length;
        if (isSQLFunction || IS_PARSE_ARG_VALUE) {
            types = new Class[length];
            values = new Object[length];
            for (int i = 0; i < length; ++i) {
                values[i] = AbstractFunctionParser.getArgValue(request, keys[i], containRaw);
                Object v = values[i];
                if (v == null) {
                    types[i] = Object.class;
                    values[i] = null;
                    break;
                }
                if (v instanceof Boolean) {
                    types[i] = Boolean.class;
                    continue;
                }
                if (v instanceof Number) {
                    types[i] = Number.class;
                    continue;
                }
                if (v instanceof String) {
                    types[i] = String.class;
                    continue;
                }
                if (v instanceof Map) {
                    types[i] = Map.class;
                    continue;
                }
                if (v instanceof Collection) {
                    types[i] = List.class;
                    values[i] = TypeUtils.cast(v, List.class, (ParserConfig)ParserConfig.getGlobalInstance());
                    continue;
                }
                throw new UnsupportedDataTypeException(keys[i] + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u8fdc\u7a0b\u51fd\u6570 key():" + function + " \u4e2d\u7684 arg \u5bf9\u5e94\u7684\u503c\u7c7b\u578b\u53ea\u80fd\u662f [Boolean, Number, String, JSONObject, JSONArray] \u4e2d\u7684\u4e00\u79cd\uff01");
            }
        } else {
            types = new Class[length + 1];
            types[0] = JSONObject.class;
            values = new Object[length + 1];
            values[0] = request;
            for (int i = 0; i < length; ++i) {
                types[i + 1] = String.class;
                values[i + 1] = keys[i];
            }
        }
        FunctionBean fb = new FunctionBean();
        fb.setFunction(function);
        fb.setSchema(schema);
        fb.setMethod(method);
        fb.setKeys(keys);
        fb.setTypes(types);
        fb.setValues(values);
        return fb;
    }

    public static void verifySchema(String sch, String table) {
        AbstractFunctionParser.extractSchema(sch, table);
    }

    public static String extractSchema(String sch, String table) {
        int ind;
        if (StringUtil.isEmpty(sch)) {
            return sch;
        }
        if (table == null) {
            table = "Table";
        }
        if ((ind = sch.indexOf("`")) > 0) {
            throw new IllegalArgumentException(table + ": { @key(): value } \u5bf9\u5e94\u5b58\u50a8\u8fc7\u7a0b value \u4e2d\u5b57\u7b26 " + sch + " \u4e0d\u5408\u6cd5\uff01`schema` \u5f53\u6709 ` \u5305\u88f9\u65f6\u4e00\u5b9a\u662f\u9996\u5c3e\u5404\u4e00\u4e2a\uff0c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01");
        }
        if (ind == 0) {
            if ((sch = sch.substring(1)).indexOf("`") != sch.length() - 1) {
                throw new IllegalArgumentException(table + ": { @key(): value } \u5bf9\u5e94\u5b58\u50a8\u8fc7\u7a0b value \u4e2d\u5b57\u7b26 `" + sch + " \u4e0d\u5408\u6cd5\uff01`schema` \u5f53\u6709 ` \u5305\u88f9\u65f6\u4e00\u5b9a\u662f\u9996\u5c3e\u5404\u4e00\u4e2a\uff0c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01");
            }
            sch = sch.substring(0, sch.length() - 1);
        }
        if (!AbstractSQLConfig.PATTERN_SCHEMA.matcher(sch).matches() || sch.contains("--")) {
            throw new IllegalArgumentException(table + ": { @key(): value } \u5bf9\u5e94\u5b58\u50a8\u8fc7\u7a0b value \u4e2d\u5b57\u7b26 " + sch + " \u4e0d\u5408\u6cd5\uff01schema.function(arg) \u4e2d schema \u5fc5\u987b\u7b26\u5408 \u6570\u636e\u5e93\u540d/\u6a21\u5f0f\u540d \u7684\u547d\u540d\u89c4\u5219\uff01\u4e00\u822c\u53ea\u80fd\u4f20\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff01\u4e0d\u5141\u8bb8 -- \u7b49\u53ef\u80fd\u5bfc\u81f4 SQL \u6ce8\u5165\u7684\u7b26\u53f7\uff01");
        }
        return sch;
    }

    public static String getFunction(String method, String[] keys) {
        String f = method + "(JSONObject request";
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                f = f + ", String " + keys[i];
            }
        }
        f = f + ")";
        return f;
    }

    public static <T> T getArgValue(@NotNull JSONObject currentObject, String keyOrValue) {
        return AbstractFunctionParser.getArgValue(currentObject, keyOrValue, false);
    }

    public static <T> T getArgValue(@NotNull JSONObject currentObject, String keyOrValue, boolean containRaw) {
        Object val;
        if (keyOrValue == null) {
            return null;
        }
        if (keyOrValue.endsWith("`") && keyOrValue.substring(1).indexOf("`") == keyOrValue.length() - 2) {
            return (T)currentObject.get((Object)keyOrValue.substring(1, keyOrValue.length() - 1));
        }
        if (keyOrValue.endsWith("'") && keyOrValue.substring(1).indexOf("'") == keyOrValue.length() - 2) {
            return (T)keyOrValue.substring(1, keyOrValue.length() - 1);
        }
        Object object = val = containRaw ? AbstractSQLConfig.RAW_MAP.get(keyOrValue) : null;
        if (val != null) {
            return (T)("".equals(val) ? keyOrValue : val);
        }
        if (StringUtil.isName(keyOrValue.startsWith("@") ? keyOrValue.substring(1) : keyOrValue)) {
            return (T)currentObject.get((Object)keyOrValue);
        }
        if ("true".equals(keyOrValue)) {
            return (T)Boolean.TRUE;
        }
        if ("false".equals(keyOrValue)) {
            return (T)Boolean.FALSE;
        }
        try {
            val = Double.valueOf(keyOrValue);
            return (T)val;
        }
        catch (Throwable e) {
            Log.d(TAG, "getArgValue  try {\n            val = Double.valueOf(keyOrValue);} catch (Throwable e) = " + e.getMessage());
            return (T)currentObject.get((Object)keyOrValue);
        }
    }

    static {
        FUNCTION_MAP = new HashMap<String, JSONObject>();
        SCRIPT_EXECUTOR_MAP = new HashMap<String, ScriptExecutor>();
    }

    public static class FunctionBean {
        private String function;
        private String schema;
        private String method;
        private String[] keys;
        private Class<?>[] types;
        private Object[] values;

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public void setKeys(String[] keys) {
            this.keys = keys;
        }

        public Class<?>[] getTypes() {
            return this.types;
        }

        public void setTypes(Class<?>[] types) {
            this.types = types;
        }

        public Object[] getValues() {
            return this.values;
        }

        public void setValues(Object[] values) {
            this.values = values;
        }

        public String toFunctionCallString(boolean useValue) {
            return this.toFunctionCallString(useValue, null);
        }

        public String toFunctionCallString(boolean useValue, String quote) {
            Object[] args;
            String s = this.getMethod() + "(";
            Object[] objectArray = args = useValue ? this.getValues() : this.getKeys();
            if (args != null && args.length > 0) {
                if (quote == null) {
                    quote = "'";
                }
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    s = s + (i <= 0 ? "" : ",") + (arg instanceof Boolean || arg instanceof Number ? arg : quote + arg + quote);
                }
            }
            return s + ")";
        }
    }
}

