/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.Join;
import apijson.orm.ObjectParser;
import apijson.orm.Parser;
import apijson.orm.Subquery;
import java.util.List;
import java.util.Map;

public interface SQLConfig<T> {
    public static final String DATABASE_MYSQL = "MYSQL";
    public static final String DATABASE_POSTGRESQL = "POSTGRESQL";
    public static final String DATABASE_SQLSERVER = "SQLSERVER";
    public static final String DATABASE_ORACLE = "ORACLE";
    public static final String DATABASE_DB2 = "DB2";
    public static final String DATABASE_MARIADB = "MARIADB";
    public static final String DATABASE_TIDB = "TIDB";
    public static final String DATABASE_DAMENG = "DAMENG";
    public static final String DATABASE_KINGBASE = "KINGBASE";
    public static final String DATABASE_ELASTICSEARCH = "ELASTICSEARCH";
    public static final String DATABASE_CLICKHOUSE = "CLICKHOUSE";
    public static final String DATABASE_HIVE = "HIVE";
    public static final String DATABASE_PRESTO = "PRESTO";
    public static final String DATABASE_TRINO = "TRINO";
    public static final String DATABASE_SNOWFLAKE = "SNOWFLAKE";
    public static final String DATABASE_DATABRICKS = "DATABRICKS";
    public static final String DATABASE_CASSANDRA = "CASSANDRA";
    public static final String DATABASE_INFLUXDB = "INFLUXDB";
    public static final String DATABASE_TDENGINE = "TDENGINE";
    public static final String DATABASE_REDIS = "REDIS";
    public static final String DATABASE_MQ = "MQ";
    public static final String SCHEMA_INFORMATION = "information_schema";
    public static final String SCHEMA_SYS = "sys";
    public static final String TABLE_SCHEMA = "table_schema";
    public static final String TABLE_NAME = "table_name";
    public static final int TYPE_CHILD = 0;
    public static final int TYPE_ITEM = 1;
    public static final int TYPE_ITEM_CHILD_0 = 2;

    public Parser<T> getParser();

    public AbstractSQLConfig setParser(Parser<T> var1);

    public ObjectParser getObjectParser();

    public AbstractSQLConfig setObjectParser(ObjectParser var1);

    public int getVersion();

    public AbstractSQLConfig setVersion(int var1);

    public String getTag();

    public AbstractSQLConfig setTag(String var1);

    public boolean isMySQL();

    public boolean isPostgreSQL();

    public boolean isSQLServer();

    public boolean isOracle();

    public boolean isDb2();

    public boolean isMariaDB();

    public boolean isTiDB();

    public boolean isDameng();

    public boolean isKingBase();

    public boolean isElasticsearch();

    public boolean isClickHouse();

    public boolean isHive();

    public boolean isPresto();

    public boolean isSnowflake();

    public boolean isDatabricks();

    public boolean isCassandra();

    public boolean isTrino();

    public boolean isInfluxDB();

    public boolean isTDengine();

    public boolean isRedis();

    public boolean isMQ();

    public boolean limitSQLCount();

    public boolean isWithAsEnable();

    public boolean allowPartialUpdateFailed();

    @NotNull
    public String getIdKey();

    @NotNull
    public String getUserIdKey();

    public String getDBVersion();

    @NotNull
    default public int[] getDBVersionNums() {
        String dbVersion = StringUtil.getNoBlankString(this.getDBVersion());
        if (dbVersion.isEmpty()) {
            return new int[]{0};
        }
        int index = dbVersion.indexOf("-");
        if (index > 0) {
            dbVersion = dbVersion.substring(0, index);
        }
        String[] ss = dbVersion.split("[.]");
        int[] nums = new int[Math.max(1, ss.length)];
        for (int i = 0; i < ss.length; ++i) {
            nums[i] = Integer.valueOf(ss[i]);
        }
        return nums;
    }

    public String getDBUri();

    public String getDBAccount();

    public String getDBPassword();

    public String getSQL(boolean var1) throws Exception;

    public boolean isTest();

    public SQLConfig setTest(boolean var1);

    public int getType();

    public SQLConfig setType(int var1);

    public int getCount();

    public SQLConfig setCount(int var1);

    public int getPage();

    public SQLConfig setPage(int var1);

    public int getQuery();

    public SQLConfig setQuery(int var1);

    public Boolean getCompat();

    public SQLConfig setCompat(Boolean var1);

    public int getPosition();

    public SQLConfig setPosition(int var1);

    public int getCache();

    public SQLConfig setCache(int var1);

    public boolean isExplain();

    public SQLConfig setExplain(boolean var1);

    public RequestMethod getMethod();

    public SQLConfig setMethod(RequestMethod var1);

    public Object getId();

    public SQLConfig setId(Object var1);

    public Object getIdIn();

    public SQLConfig setIdIn(Object var1);

    public Object getUserId();

    public SQLConfig setUserId(Object var1);

    public Object getUserIdIn();

    public SQLConfig setUserIdIn(Object var1);

    public String getRole();

    public SQLConfig setRole(String var1);

    public boolean isDistinct();

    public SQLConfig setDistinct(boolean var1);

    public String getDatabase();

    public SQLConfig setDatabase(String var1);

    public String getSchema();

    public SQLConfig setSchema(String var1);

    public String getDatasource();

    public SQLConfig setDatasource(String var1);

    public String getQuote();

    public List<String> getJson();

    public SQLConfig setJson(List<String> var1);

    public String getTable();

    public SQLConfig setTable(String var1);

    public String getSQLTable();

    public String getTablePath();

    public List<String> getRaw();

    public SQLConfig setRaw(List<String> var1);

    public Subquery getFrom();

    public SQLConfig setFrom(Subquery var1);

    public List<String> getColumn();

    public SQLConfig setColumn(List<String> var1);

    public List<List<Object>> getValues();

    public SQLConfig setValues(List<List<Object>> var1);

    public Map<String, Object> getContent();

    public SQLConfig setContent(Map<String, Object> var1);

    public Map<String, List<String>> getCombineMap();

    public SQLConfig setCombineMap(Map<String, List<String>> var1);

    public String getCombine();

    public SQLConfig setCombine(String var1);

    public Map<String, String> getCast();

    public SQLConfig setCast(Map<String, String> var1);

    public List<String> getNull();

    public SQLConfig setNull(List<String> var1);

    public Map<String, Object> getWhere();

    public SQLConfig setWhere(Map<String, Object> var1);

    public String getGroup();

    public SQLConfig setGroup(String var1);

    public Map<String, Object> getHaving();

    public SQLConfig setHaving(Map<String, Object> var1);

    public String getHavingCombine();

    public SQLConfig setHavingCombine(String var1);

    public String getOrder();

    public SQLConfig setOrder(String var1);

    public Object getWhere(String var1);

    public Object getWhere(String var1, boolean var2);

    public SQLConfig putWhere(String var1, Object var2, boolean var3);

    public boolean isPrepared();

    public SQLConfig setPrepared(boolean var1);

    public boolean isMain();

    public SQLConfig setMain(boolean var1);

    public List<Object> getPreparedValueList();

    public SQLConfig setPreparedValueList(List<Object> var1);

    public String getAlias();

    public SQLConfig setAlias(String var1);

    public String getWhereString(boolean var1) throws Exception;

    public String getRawSQL(String var1, Object var2) throws Exception;

    public String getRawSQL(String var1, Object var2, boolean var3) throws Exception;

    public boolean isKeyPrefix();

    public SQLConfig setKeyPrefix(boolean var1);

    public List<Join> getJoinList();

    public SQLConfig setJoinList(List<Join> var1);

    public boolean hasJoin();

    public String getSubqueryString(Subquery var1) throws Exception;

    public SQLConfig setProcedure(String var1);

    public List<Object> getWithAsExprPreparedValueList();

    public SQLConfig setWithAsExprPreparedValueList(List<Object> var1);

    public boolean isFakeDelete();

    public Map<String, Object> onFakeDelete(Map<String, Object> var1);
}

