/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractParser;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.Join;
import apijson.orm.Parser;
import apijson.orm.SQLConfig;
import apijson.orm.SQLExecutor;
import apijson.orm.exception.NotExistException;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractSQLExecutor<T>
implements SQLExecutor<T> {
    private static final String TAG = "AbstractSQLExecutor";
    public static String KEY_RAW_LIST = "@RAW@LIST";
    private Parser<T> parser;
    private int generatedSQLCount = 0;
    private int cachedSQLCount = 0;
    private int executedSQLCount = 0;
    private long executedSQLDuration = 0L;
    private long sqlResultDuration = 0L;
    protected Map<String, List<JSONObject>> cacheMap = new HashMap<String, List<JSONObject>>();
    protected Map<String, Connection> connectionMap = new HashMap<String, Connection>();
    protected Connection connection;
    private int transactionIsolation;
    private boolean isIsolationStatusSet = false;

    @Override
    public Parser<T> getParser() {
        return this.parser;
    }

    @Override
    public AbstractSQLExecutor setParser(Parser<T> parser) {
        this.parser = parser;
        return this;
    }

    @Override
    public int getGeneratedSQLCount() {
        return this.generatedSQLCount;
    }

    @Override
    public int getCachedSQLCount() {
        return this.cachedSQLCount;
    }

    @Override
    public int getExecutedSQLCount() {
        return this.executedSQLCount;
    }

    @Override
    public long getExecutedSQLDuration() {
        return this.executedSQLDuration;
    }

    @Override
    public long getSqlResultDuration() {
        return this.sqlResultDuration;
    }

    @Override
    public void putCache(String sql, List<JSONObject> list, SQLConfig config) {
        if (sql == null || list == null) {
            Log.i(TAG, "saveList  sql == null || list == null >> return;");
            return;
        }
        this.cacheMap.put(sql, list);
    }

    @Override
    public List<JSONObject> getCache(String sql, SQLConfig config) {
        return this.cacheMap.get(sql);
    }

    @Override
    public JSONObject getCacheItem(String sql, int position, SQLConfig config) {
        List<JSONObject> list = this.getCache(sql, config);
        return this.getCacheItem(list, position, config);
    }

    public JSONObject getCacheItem(List<JSONObject> list, int position, SQLConfig config) {
        if (list == null) {
            return null;
        }
        JSONObject result = position >= list.size() ? null : list.get(position);
        return result != null ? result : new JSONObject();
    }

    @Override
    public void removeCache(String sql, SQLConfig config) {
        if (sql == null) {
            Log.i(TAG, "removeList  sql == null >> return;");
            return;
        }
        this.cacheMap.remove(sql);
    }

    @Override
    public ResultSet executeQuery(@NotNull Statement statement, String sql) throws Exception {
        ResultSet rs = statement.executeQuery(sql);
        return rs;
    }

    @Override
    public int executeUpdate(@NotNull Statement statement, String sql) throws Exception {
        int c = statement.executeUpdate(sql);
        return c;
    }

    @Override
    public ResultSet execute(@NotNull Statement statement, String sql) throws Exception {
        statement.execute(sql);
        ResultSet rs = statement.getResultSet();
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject execute(@NotNull SQLConfig config, boolean unknownType) throws Exception {
        JSONObject result;
        HashMap<String, JSONObject> childMap;
        List<JSONObject> resultList;
        long startTime;
        int position;
        boolean isHead;
        boolean isExplain;
        String sql;
        block91: {
            long executedSQLStartTime = System.currentTimeMillis();
            sql = config.getSQL(false);
            if (StringUtil.isEmpty(sql, true)) {
                Log.e(TAG, "execute  StringUtil.isEmpty(sql, true) >> return null;");
                return null;
            }
            isExplain = config.isExplain();
            isHead = RequestMethod.isHeadMethod(config.getMethod(), true);
            position = config.getPosition();
            if (!isExplain) {
                ++this.generatedSQLCount;
            }
            startTime = System.currentTimeMillis();
            Log.d(TAG, "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\u5df2\u751f\u6210 " + this.generatedSQLCount + " \u6761 SQL\nexecute  startTime = " + startTime + "\ndatabase = " + StringUtil.getString(config.getDatabase()) + "; schema = " + StringUtil.getString(config.getSchema()) + "; sql = \n" + sql + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
            ResultSet rs = null;
            resultList = null;
            childMap = null;
            try {
                RequestMethod method;
                if (unknownType) {
                    if (!isExplain) {
                        ++this.executedSQLCount;
                        executedSQLStartTime = System.currentTimeMillis();
                    }
                    PreparedStatement statement = this.getStatement(config);
                    rs = this.execute(statement, sql);
                    int updateCount = statement.getUpdateCount();
                    if (!isExplain) {
                        this.executedSQLDuration += System.currentTimeMillis() - executedSQLStartTime;
                    }
                    result = new JSONObject(true);
                    result.put("count", (Object)updateCount);
                    result.put("update", (Object)(updateCount >= 0 ? 1 : 0));
                } else {
                    method = config.getMethod();
                    switch (method) {
                        case POST: 
                        case PUT: 
                        case DELETE: {
                            if (!isExplain) {
                                ++this.executedSQLCount;
                                executedSQLStartTime = System.currentTimeMillis();
                            }
                            int updateCount = this.executeUpdate(config);
                            if (!isExplain) {
                                this.executedSQLDuration += System.currentTimeMillis() - executedSQLStartTime;
                            }
                            if (updateCount <= 0) {
                                throw new IllegalAccessException("\u6ca1\u6743\u9650\u8bbf\u95ee\u6216\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
                            }
                            JSONObject result2 = AbstractParser.newSuccessResult();
                            result2.put("count", (Object)updateCount);
                            String idKey = config.getIdKey();
                            if (config.getId() != null) {
                                result2.put(idKey, config.getId());
                            }
                            if (config.getIdIn() != null) {
                                result2.put(idKey + "[]", config.getIdIn());
                            }
                            if (method == RequestMethod.PUT || method == RequestMethod.DELETE) {
                                config.setMethod(RequestMethod.GET);
                                this.removeCache(config.getSQL(false), config);
                                config.setMethod(method);
                            }
                            JSONObject jSONObject = result2;
                            return jSONObject;
                        }
                        case GET: 
                        case GETS: 
                        case HEAD: 
                        case HEADS: {
                            List<JSONObject> cache = this.getCache(sql, config);
                            result = this.getCacheItem(cache, position, config);
                            Log.i(TAG, ">>> execute  result = getCache('" + sql + "', " + position + ") = " + result);
                            if (result != null) {
                                if (!isExplain) {
                                    ++this.cachedSQLCount;
                                }
                                if (cache != null && cache.size() > 1) {
                                    result.put(KEY_RAW_LIST, cache);
                                }
                                Log.d(TAG, "\n\n execute  result != null >> return result;\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
                                JSONObject e = result;
                                return e;
                            }
                            if (!isExplain) {
                                ++this.executedSQLCount;
                                executedSQLStartTime = System.currentTimeMillis();
                            }
                            rs = this.executeQuery(config);
                            if (isExplain) break;
                            this.executedSQLDuration += System.currentTimeMillis() - executedSQLStartTime;
                            break;
                        }
                        default: {
                            Log.e(TAG, "execute  sql = " + sql + " ; method = " + (Object)((Object)config.getMethod()) + " >> return null;");
                            JSONObject e = null;
                            return e;
                        }
                    }
                }
                if (!isExplain && isHead) {
                    if (!rs.next()) {
                        method = AbstractParser.newErrorResult(new SQLException("\u6570\u636e\u5e93\u9519\u8bef, rs.next() \u5931\u8d25\uff01"));
                        return method;
                    }
                    result = AbstractParser.newSuccessResult();
                    if (config.isElasticsearch()) {
                        result.put("count", rs.getObject(1));
                    } else {
                        result.put("count", (Object)rs.getLong(1));
                    }
                    resultList = new ArrayList(1);
                    resultList.add(result);
                    break block91;
                }
                try {
                    rs.last();
                    resultList = new ArrayList<JSONObject>(rs.getRow());
                    rs.beforeFirst();
                }
                catch (Throwable e) {
                    int capacity;
                    Log.e(TAG, "try { rs.last(); resultList = new ArrayList<>(rs.getRow()); rs.beforeFirst(); >> } catch (Throwable e) = " + e.getMessage());
                    if (config.getId() != null) {
                        capacity = 1;
                    } else {
                        Object idIn = config.getIdIn();
                        if (idIn instanceof Collection) {
                            capacity = ((Collection)idIn).size();
                        } else {
                            int n = capacity = config.getCount() <= 0 ? AbstractParser.MAX_QUERY_COUNT : config.getCount();
                            if (capacity > 100) {
                                Map<String, Object> having;
                                int groupCount;
                                List<String> andList;
                                Map<String, List<String>> combine = config.getCombineMap();
                                List<String> list = andList = combine == null ? null : combine.get("&");
                                int andCondCount = andList == null ? (config.getWhere() == null ? 0 : config.getWhere().size()) : andList.size();
                                List<String> orList = combine == null ? null : combine.get("|");
                                int orCondCount = orList == null ? 0 : orList.size();
                                List<String> notList = combine == null ? null : combine.get("!");
                                int notCondCount = notList == null ? 0 : notList.size();
                                String[] group = StringUtil.split(config.getGroup());
                                int n2 = groupCount = group == null ? 0 : group.length;
                                if (groupCount > 0 && Arrays.asList(group).contains(config.getIdKey())) {
                                    groupCount = 0;
                                }
                                int havingCount = (having = config.getHaving()) == null ? 0 : having.size();
                                capacity = (int)((double)capacity / Math.pow(1.5, Math.log10(capacity) + (double)andCondCount + ((orCondCount <= 0 ? 0.0 : 2.0 / (double)orCondCount) + (double)notCondCount / 5.0 + (groupCount <= 0 ? 0.0 : 10.0 / (double)groupCount)) + (double)havingCount));
                                ++capacity;
                            }
                        }
                    }
                    resultList = new ArrayList(capacity);
                }
                int index = -1;
                long startTime2 = System.currentTimeMillis();
                ResultSetMetaData rsmd = rs.getMetaData();
                int length = rsmd.getColumnCount();
                this.sqlResultDuration += System.currentTimeMillis() - startTime2;
                childMap = new HashMap<String, JSONObject>();
                String lastTableName = null;
                String lastAliasName = null;
                int lastViceTableStart = 0;
                int lastViceColumnStart = 0;
                Join lastJoin = null;
                List<Join> joinList = config.getJoinList();
                boolean hasJoin = config.hasJoin() && joinList != null && !joinList.isEmpty();
                Join[] columnIndexAndJoinMap = isExplain || !hasJoin ? null : new Join[length];
                long lastCursorTime = System.currentTimeMillis();
                while (rs.next()) {
                    JSONObject item2;
                    this.sqlResultDuration += System.currentTimeMillis() - lastCursorTime;
                    lastCursorTime = System.currentTimeMillis();
                    Log.d(TAG, "\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n execute while (rs.next()){  index = " + ++index + "\n\n");
                    JSONObject curItem = item2 = new JSONObject(true);
                    boolean isMain = true;
                    for (int i = 1; i <= length; ++i) {
                        Join prevJoin;
                        Join curJoin;
                        Join join = curJoin = columnIndexAndJoinMap == null ? null : columnIndexAndJoinMap[i - 1];
                        if (index <= 0 && columnIndexAndJoinMap != null) {
                            boolean toFindJoin;
                            SQLConfig curConfig = curJoin == null || !curJoin.isSQLJoin() ? null : curJoin.getCacheConfig();
                            List<String> curColumn = curConfig == null ? null : curConfig.getColumn();
                            String sqlTable = curConfig == null ? null : curConfig.getSQLTable();
                            String sqlAlias = curConfig == null ? null : curConfig.getAlias();
                            List<String> column = config.getColumn();
                            int mainColumnSize = column == null ? 0 : column.size();
                            boolean bl = toFindJoin = mainColumnSize <= 0 || i > mainColumnSize;
                            if (StringUtil.isEmpty(sqlTable, true)) {
                                if (toFindJoin) {
                                    long startTime3 = System.currentTimeMillis();
                                    sqlTable = rsmd.getTableName(i);
                                    this.sqlResultDuration += System.currentTimeMillis() - startTime3;
                                    if (StringUtil.isEmpty(sqlTable, true)) {
                                        String label;
                                        boolean isEmpty = curItem == null || curItem.isEmpty();
                                        String string = label = isEmpty ? null : this.getKey(config, rs, rsmd, index, curItem, i, childMap);
                                        if (isEmpty || !curItem.containsKey(label)) {
                                            String string2 = sqlTable = i <= 1 ? config.getSQLTable() : lastTableName;
                                        }
                                    }
                                    if (StringUtil.isEmpty(sqlTable, true)) {
                                        int nextViceColumnStart = lastViceColumnStart;
                                        for (int j = lastViceTableStart; j < joinList.size(); ++j) {
                                            List<String> c;
                                            Join join2 = joinList.get(j);
                                            SQLConfig cfg = join2 == null || !join2.isSQLJoin() ? null : join2.getJoinConfig();
                                            List<String> list = c = cfg == null ? null : cfg.getColumn();
                                            if (i >= (nextViceColumnStart += c != null && !c.isEmpty() ? c.size() : (StringUtil.equalsIgnoreCase(sqlTable, lastTableName) && StringUtil.equals(sqlAlias, lastAliasName) ? 1 : 0))) continue;
                                            sqlTable = cfg.getSQLTable();
                                            sqlAlias = cfg.getAlias();
                                            lastViceTableStart = j;
                                            curJoin = join2;
                                            curConfig = cfg;
                                            curColumn = c;
                                            toFindJoin = false;
                                            isMain = false;
                                            break;
                                        }
                                    }
                                    if (StringUtil.isEmpty(sqlTable, true)) {
                                        sqlTable = lastTableName;
                                        sqlAlias = lastAliasName;
                                        toFindJoin = false;
                                    }
                                }
                            } else if (config.isClickHouse() && (sqlTable.startsWith("`") || sqlTable.startsWith("\""))) {
                                sqlTable = sqlTable.substring(1, sqlTable.length() - 1);
                            }
                            if (!StringUtil.equalsIgnoreCase(sqlTable, lastTableName) || !StringUtil.equals(sqlAlias, lastAliasName)) {
                                lastTableName = sqlTable;
                                lastAliasName = sqlAlias;
                                lastViceColumnStart = i;
                                if (toFindJoin) {
                                    for (int j = lastViceTableStart; j < joinList.size(); ++j) {
                                        SQLConfig cfg;
                                        Join join3 = joinList.get(j);
                                        SQLConfig sQLConfig = cfg = join3 == null || !join3.isSQLJoin() ? null : join3.getJoinConfig();
                                        if (cfg == null || !StringUtil.equalsIgnoreCase(sqlTable, cfg.getSQLTable())) continue;
                                        lastViceTableStart = j;
                                        curJoin = join3;
                                        curConfig = cfg;
                                        curColumn = curConfig == null ? null : curConfig.getColumn();
                                        isMain = false;
                                        break;
                                    }
                                }
                            }
                            if (isMain) {
                                ++lastViceColumnStart;
                            } else {
                                if (curJoin == null) {
                                    curJoin = lastJoin;
                                } else {
                                    lastJoin = curJoin;
                                }
                                if (curColumn == null) {
                                    curConfig = curJoin == null || !curJoin.isSQLJoin() ? null : curJoin.getJoinConfig();
                                    List<String> list = curColumn = curConfig == null ? null : curConfig.getColumn();
                                }
                                if (curColumn == null || curColumn.isEmpty()) {
                                    ++lastViceColumnStart;
                                }
                            }
                            columnIndexAndJoinMap[i - 1] = curJoin;
                        }
                        Join join4 = prevJoin = columnIndexAndJoinMap == null || i < 2 ? null : columnIndexAndJoinMap[i - 2];
                        if (curJoin != prevJoin) {
                            String viceSql2;
                            SQLConfig viceConfig;
                            SQLConfig sQLConfig = viceConfig = curJoin != null && curJoin.isSQLJoin() ? curJoin.getCacheConfig() : null;
                            if (viceConfig != null) {
                                int size;
                                List<Join.On> onList = curJoin.getOnList();
                                int n = size = onList == null ? 0 : onList.size();
                                if (size > 0) {
                                    for (int j = size - 1; j >= 0; --j) {
                                        String ok;
                                        Join.On on = onList.get(j);
                                        String string = ok = on == null ? null : on.getOriginKey();
                                        if (ok == null) {
                                            throw new NullPointerException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cList<Join> \u4e2d Join.onList[" + j + (on == null ? "] = null\uff01" : ".getOriginKey() = null\uff01"));
                                        }
                                        viceConfig.putWhere(ok.substring(0, ok.length() - 1), item2.get((Object)on.getTargetKey()), true);
                                    }
                                }
                            }
                            String string = viceSql2 = viceConfig == null ? null : viceConfig.getSQL(false);
                            if (StringUtil.isEmpty(viceSql2, true)) {
                                Log.i(TAG, "execute StringUtil.isEmpty(viceSql, true) >> item = null; >> ");
                                curItem = null;
                            } else if (curJoin.isOuterJoin() || curJoin.isAntiJoin()) {
                                Log.i(TAG, "execute curJoin.isOuterJoin() || curJoin.isAntiJoin() >> item = null; >> ");
                                curItem = null;
                            } else {
                                curItem = (JSONObject)childMap.get(viceSql2);
                                if (curItem == null) {
                                    curItem = new JSONObject(true);
                                    childMap.put(viceSql2, curItem);
                                }
                            }
                        }
                        curItem = this.onPutColumn(config, rs, rsmd, index, curItem, i, curJoin, childMap);
                    }
                    resultList = this.onPutTable(config, rs, rsmd, resultList, index, item2);
                    Log.d(TAG, "execute  while (rs.next()) { resultList.put( " + index + ", result); \n >>>>>>>>>>>>>>>>>>>>>>>>>>> \n\n");
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (resultList == null) {
            return null;
        }
        if (unknownType || isExplain) {
            if (isExplain) {
                if (result == null) {
                    result = new JSONObject(true);
                }
                config.setExplain(false);
                result.put("sql", (Object)config.getSQL(false));
                config.setExplain(isExplain);
            }
            result.put("list", resultList);
            if (!unknownType) {
                this.putCache(sql, Arrays.asList(result), config);
            }
            return result;
        }
        if (!isHead) {
            HashMap<String, List<JSONObject>> appJoinChildMap = new HashMap<String, List<JSONObject>>();
            childMap.forEach((viceSql, item) -> appJoinChildMap.put((String)viceSql, Arrays.asList(item)));
            this.executeAppJoin(config, resultList, appJoinChildMap);
            Set set = appJoinChildMap.entrySet();
            for (Map.Entry entry : set) {
                this.putCache((String)entry.getKey(), (List)entry.getValue(), null);
            }
            Log.i(TAG, ">>> execute  putCache('" + sql + "', resultList);  resultList.size() = " + resultList.size());
            JSONObject jSONObject = result = position >= resultList.size() ? new JSONObject() : (JSONObject)resultList.get(position);
            if (position == 0 && resultList.size() > 1 && result != null && !result.isEmpty()) {
                Log.i(TAG, ">>> execute  position == 0 && resultList.size() > 1 && result != null && result.isEmpty() == false >> result = new JSONObject(result); result.put(KEY_RAW_LIST, resultList);");
                result = new JSONObject((Map)result);
                result.put(KEY_RAW_LIST, resultList);
            }
        }
        this.putCache(sql, resultList, config);
        long endTime = System.currentTimeMillis();
        Log.d(TAG, "\n\n execute  endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n return resultList.get(" + position + ");\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAppJoin(SQLConfig config, List<JSONObject> resultList, Map<String, List<JSONObject>> childMap) throws Exception {
        List<Join> joinList = config.getJoinList();
        if (joinList != null) {
            for (Join join : joinList) {
                boolean isExplain;
                String originKey;
                if (!join.isAppJoin()) {
                    Log.i(TAG, "executeAppJoin  for (Join j : joinList) >> j.isAppJoin() == false >>  continue;");
                    continue;
                }
                SQLConfig cc = join.getCacheConfig();
                if (cc == null) {
                    if (!Log.DEBUG) continue;
                    throw new NullPointerException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef, executeAppJoin cc == null ! \u5bfc\u81f4\u4e0d\u80fd\u7f13\u5b58 @ APP JOIN \u7684\u526f\u8868\u6570\u636e\uff01");
                }
                SQLConfig jc = join.getJoinConfig();
                List<Join.On> onList = join.getOnList();
                Join.On on = onList == null || onList.isEmpty() ? null : onList.get(0);
                String string = originKey = on == null ? null : on.getOriginKey();
                if (originKey == null) {
                    throw new NullPointerException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cList<Join> \u4e2d Join.onList[0" + (on == null ? "] = null\uff01" : ".getOriginKey() = null\uff01"));
                }
                String key = on.getKey();
                if (key == null) {
                    throw new NullPointerException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cList<Join> \u4e2d Join.onList[0" + (on == null ? "] = null\uff01" : ".getKey() = null\uff01"));
                }
                ArrayList<Object> targetValueList = new ArrayList<Object>();
                for (int i = 0; i < resultList.size(); ++i) {
                    Object targetValue;
                    JSONObject mainTable = resultList.get(i);
                    Object object = targetValue = mainTable == null ? null : mainTable.get((Object)on.getTargetKey());
                    if (targetValue == null || targetValueList.contains(targetValue)) continue;
                    targetValueList.add(targetValue);
                }
                if (targetValueList.isEmpty() && !config.isExplain()) {
                    throw new NotExistException("targetValueList.isEmpty() && config.isExplain() == false");
                }
                jc.putWhere(originKey, null, false);
                jc.putWhere(key + "{}", targetValueList, true);
                jc.setMain(true).setPreparedValueList(new ArrayList<Object>());
                int childCount = cc.getCount();
                int allChildCount = childCount * config.getCount();
                boolean isOne2Many = childCount != 1 || join.isOne2Many();
                boolean prepared = jc.isPrepared();
                String sql = jc.getSQL(false);
                if (StringUtil.isEmpty(sql, true)) {
                    throw new NullPointerException("AbstractSQLExecutor.executeAppJoin  StringUtil.isEmpty(sql, true) >> return null;");
                }
                String sql2 = null;
                if (childCount > 0 && isOne2Many && (!jc.isMySQL() || jc.getDBVersionNums()[0] >= 8)) {
                    String q = jc.getQuote();
                    sql2 = prepared && !jc.isTDengine() ? jc.getSQL(true) : sql;
                    String prefix = "SELECT * FROM(";
                    String rnStr = ", row_number() OVER (PARTITION BY " + q + key + q + ((AbstractSQLConfig)jc).getOrderString(true) + ") _row_num_ FROM ";
                    String suffix = ") _t WHERE ( (_row_num_ <= " + childCount + ") )" + (allChildCount > 0 ? " LIMIT " + allChildCount : "");
                    sql2 = prefix + sql2.replaceFirst(" FROM ", rnStr) + suffix;
                    String string2 = sql = prepared ? prefix + sql.replaceFirst(" FROM ", rnStr) + suffix : sql2;
                }
                if (!(isExplain = jc.isExplain())) {
                    ++this.generatedSQLCount;
                }
                long startTime = System.currentTimeMillis();
                Log.d(TAG, "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n executeAppJoin  startTime = " + startTime + "\n sql = \n " + sql + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
                ResultSet rs = null;
                try {
                    long executedSQLStartTime = 0L;
                    if (!isExplain) {
                        ++this.executedSQLCount;
                        executedSQLStartTime = System.currentTimeMillis();
                    }
                    rs = this.executeQuery(jc, sql2);
                    if (!isExplain) {
                        this.executedSQLDuration += System.currentTimeMillis() - executedSQLStartTime;
                    }
                    int count = 0;
                    int index = -1;
                    long startTime2 = System.currentTimeMillis();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int length = rsmd.getColumnCount();
                    this.sqlResultDuration += System.currentTimeMillis() - startTime2;
                    HashMap<String, Boolean> skipMap = new HashMap<String, Boolean>();
                    long lastCursorTime = System.currentTimeMillis();
                    while ((allChildCount <= 0 || count < allChildCount) && rs.next()) {
                        this.sqlResultDuration += System.currentTimeMillis() - lastCursorTime;
                        lastCursorTime = System.currentTimeMillis();
                        Log.d(TAG, "\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n executeAppJoin while (rs.next()){  index = " + ++index + "\n\n");
                        JSONObject result = new JSONObject(true);
                        for (int i = 1; i <= length; ++i) {
                            result = this.onPutColumn(jc, rs, rsmd, index, result, i, null, null);
                        }
                        Log.d(TAG, "\n executeAppJoin  while (rs.next()) { resultList.put(" + index + ", result); \n >>>>>>>>>>>>>>>>>>>>>>>>>>> \n\n");
                        cc.putWhere(key, result.get((Object)key), true);
                        String cacheSql = cc.getSQL(false);
                        List<JSONObject> results = childMap.get(cacheSql);
                        if (results == null || skipMap.get(cacheSql) == null) {
                            results = new ArrayList<JSONObject>(childCount);
                            childMap.put(cacheSql, results);
                            skipMap.put(cacheSql, Boolean.TRUE);
                        }
                        if (childCount > 0 && results.size() >= childCount) continue;
                        results.add(result);
                        ++count;
                        Log.d(TAG, ">>> executeAppJoin childMap.put('" + cacheSql + "', result);  childMap.size() = " + childMap.size());
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                Log.d(TAG, "\n\n executeAppJoin  endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
            }
        }
    }

    protected JSONObject onPutColumn(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, Join join, Map<String, JSONObject> childMap) throws Exception {
        if (table == null) {
            Log.i(TAG, "onPutColumn table == null >> return table;");
            return table;
        }
        if (this.isHideColumn(config, rs, rsmd, tablePosition, table, columnIndex, childMap)) {
            Log.i(TAG, "onPutColumn isHideColumn(config, rs, rsmd, tablePosition, table, columnIndex, childMap) >> return table;");
            return table;
        }
        String label = this.getKey(config, rs, rsmd, tablePosition, table, columnIndex, childMap);
        Object value = this.getValue(config, rs, rsmd, tablePosition, table, columnIndex, label, childMap);
        if (value != null || join == null && table.isEmpty()) {
            table.put(label, value);
        }
        return table;
    }

    protected boolean isHideColumn(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, Map<String, JSONObject> childMap) throws SQLException {
        return rsmd.getColumnName(columnIndex).startsWith("_");
    }

    protected List<JSONObject> onPutTable(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, @NotNull List<JSONObject> resultList, int position, @NotNull JSONObject table) {
        resultList.add(table);
        return resultList;
    }

    protected String getKey(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, Map<String, JSONObject> childMap) throws Exception {
        long startTime = System.currentTimeMillis();
        String key = rsmd.getColumnLabel(columnIndex);
        this.sqlResultDuration += System.currentTimeMillis() - startTime;
        if (config.isHive()) {
            String tableName = config.getTable();
            String realTableName = AbstractSQLConfig.TABLE_KEY_MAP.get(tableName);
            String pattern = "^" + (StringUtil.isEmpty(realTableName, true) ? tableName : realTableName) + "\\.[a-zA-Z]+$";
            boolean isMatch = Pattern.matches(pattern, key);
            if (isMatch) {
                key = key.split("\\.")[1];
            }
        }
        return key;
    }

    protected Object getValue(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, String lable, Map<String, JSONObject> childMap) throws Exception {
        long startTime = System.currentTimeMillis();
        Object value = rs.getObject(columnIndex);
        this.sqlResultDuration += System.currentTimeMillis() - startTime;
        boolean castToJson = false;
        if (!(value instanceof Boolean) && !(value instanceof Number)) {
            if (value instanceof Timestamp) {
                value = ((Timestamp)value).toString();
            } else if (value instanceof Date) {
                value = ((Date)value).toString();
            } else if (value instanceof LocalDateTime) {
                value = ((LocalDateTime)value).toString();
            } else if (value instanceof Year) {
                value = ((Year)value).getValue();
            } else if (value instanceof Month) {
                value = ((Month)value).getValue();
            } else if (value instanceof DayOfWeek) {
                value = ((DayOfWeek)value).getValue();
            } else if (value instanceof String && this.isJSONType(config, rsmd, columnIndex, lable)) {
                castToJson = true;
            } else if (value instanceof Blob) {
                castToJson = true;
                value = new String(((Blob)value).getBytes(1L, (int)((Blob)value).length()), "UTF-8");
            } else if (value instanceof Clob) {
                castToJson = true;
                StringBuffer sb = new StringBuffer();
                BufferedReader br = new BufferedReader(((Clob)value).getCharacterStream());
                String s = br.readLine();
                while (s != null) {
                    sb.append(s);
                    s = br.readLine();
                }
                value = sb.toString();
                try {
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!castToJson) {
            List<String> json = config.getJson();
            boolean bl = castToJson = json != null && json.contains(lable);
        }
        if (castToJson) {
            try {
                value = com.alibaba.fastjson.JSON.parse((String)((String)value));
            }
            catch (Exception e) {
                Log.e(TAG, "getValue  try { value = JSON.parse((String) value); } catch (Exception e) { \n" + e.getMessage());
            }
        }
        return value;
    }

    @Override
    public boolean isJSONType(@NotNull SQLConfig config, ResultSetMetaData rsmd, int position, String lable) {
        try {
            long startTime = System.currentTimeMillis();
            String column = rsmd.getColumnTypeName(position);
            this.sqlResultDuration += System.currentTimeMillis() - startTime;
            if (StringUtil.isEmpty(column)) {
                return false;
            }
            if (column.toLowerCase().contains("json")) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public PreparedStatement getStatement(@NotNull SQLConfig config) throws Exception {
        return this.getStatement(config, null);
    }

    @Override
    public PreparedStatement getStatement(@NotNull SQLConfig config, String sql) throws Exception {
        List<Object> valueList;
        PreparedStatement statement;
        if (StringUtil.isEmpty(sql)) {
            sql = config.getSQL(config.isPrepared());
        }
        if (config.getMethod() == RequestMethod.POST && config.getId() == null) {
            if (config.isOracle()) {
                String[] generatedColumns = new String[]{config.getIdKey()};
                statement = this.getConnection(config).prepareStatement(sql, generatedColumns);
            } else {
                statement = this.getConnection(config).prepareStatement(sql, 1);
            }
        } else {
            statement = RequestMethod.isGetMethod(config.getMethod(), true) ? (config.isMySQL() || config.isPostgreSQL() || config.isOracle() || config.isSQLServer() || config.isDb2() ? this.getConnection(config).prepareStatement(sql, 1005, 1008) : this.getConnection(config).prepareStatement(sql)) : this.getConnection(config).prepareStatement(sql);
        }
        List<Object> list = valueList = config.isPrepared() ? config.getPreparedValueList() : null;
        if (valueList != null && !valueList.isEmpty()) {
            for (int i = 0; i < valueList.size(); ++i) {
                statement = this.setArgument(config, statement, i, valueList.get(i));
            }
        }
        return statement;
    }

    public PreparedStatement setArgument(@NotNull SQLConfig config, @NotNull PreparedStatement statement, int index, Object value) throws SQLException {
        if (JSON.isBooleanOrNumberOrString(value)) {
            statement.setObject(index + 1, value);
        } else {
            statement.setString(index + 1, value == null ? null : value.toString());
        }
        return statement;
    }

    @Override
    @NotNull
    public Connection getConnection(@NotNull SQLConfig config) throws Exception {
        int ti;
        String connectionKey = config.getDatasource() + "-" + config.getDatabase();
        this.connection = this.connectionMap.get(connectionKey);
        if (this.connection == null || this.connection.isClosed()) {
            Log.i(TAG, "select  connection " + (this.connection == null ? " = null" : "isClosed = " + this.connection.isClosed()));
            this.connection = DriverManager.getConnection(config.getDBUri(), config.getDBAccount(), config.getDBPassword());
            this.connectionMap.put(connectionKey, this.connection);
        }
        int n = ti = config.isTDengine() ? 0 : this.getTransactionIsolation();
        if (ti != 0) {
            this.begin(ti);
        }
        return this.connection;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public void begin(int transactionIsolation) throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION begin transactionIsolation = " + transactionIsolation + " >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (!this.isIsolationStatusSet) {
            this.isIsolationStatusSet = true;
            this.connection.setTransactionIsolation(transactionIsolation);
        }
        this.connection.setAutoCommit(false);
    }

    @Override
    public void rollback() throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION rollback >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (this.connection == null) {
            return;
        }
        Collection<Connection> connections = this.connectionMap.values();
        if (connections != null) {
            for (Connection connection : connections) {
                try {
                    if (connection == null || connection.isClosed()) continue;
                    connection.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION rollback savepoint " + (savepoint == null ? "" : "!") + "= null >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (this.connection == null) {
            return;
        }
        if (StringUtil.isEmpty(savepoint)) {
            Collection<Connection> connections = this.connectionMap.values();
            if (connections != null) {
                for (Connection connection : connections) {
                    try {
                        if (connection == null || connection.isClosed()) continue;
                        connection.rollback();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.connection.rollback(savepoint);
        }
    }

    @Override
    public void commit() throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION commit >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (this.connection == null) {
            return;
        }
        Collection<Connection> connections = this.connectionMap.values();
        if (connections != null) {
            for (Connection connection : connections) {
                try {
                    if (connection == null || connection.isClosed()) continue;
                    connection.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() {
        this.cacheMap.clear();
        this.cacheMap = null;
        this.generatedSQLCount = 0;
        this.cachedSQLCount = 0;
        this.executedSQLCount = 0;
        if (this.connectionMap == null) {
            return;
        }
        Collection<Connection> connections = this.connectionMap.values();
        if (connections != null) {
            for (Connection connection : connections) {
                try {
                    if (connection == null || connection.isClosed()) continue;
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.connectionMap.clear();
        this.connectionMap = null;
    }

    @Override
    public ResultSet executeQuery(@NotNull SQLConfig config, String sql) throws Exception {
        if (!config.isPrepared() || config.isTDengine() || config.isExplain() && (config.isPresto() || config.isTrino())) {
            Connection conn = this.getConnection(config);
            Statement stt = conn.createStatement();
            return this.executeQuery(stt, StringUtil.isEmpty(sql) ? config.getSQL(false) : sql);
        }
        PreparedStatement stt = this.getStatement(config, sql);
        ResultSet rs = stt.executeQuery();
        return rs;
    }

    @Override
    public int executeUpdate(@NotNull SQLConfig config, String sql) throws Exception {
        ResultSet rs;
        int count;
        Statement stt;
        if (config.isTDengine()) {
            Connection conn = this.getConnection(config);
            stt = conn.createStatement();
            count = stt.executeUpdate(StringUtil.isEmpty(sql) ? config.getSQL(false) : sql);
        } else {
            stt = this.getStatement(config);
            count = stt.executeUpdate();
        }
        if (count <= 0 && config.isHive()) {
            count = 1;
        }
        if (config.getId() == null && config.getMethod() == RequestMethod.POST && (rs = stt.getGeneratedKeys()) != null && rs.next()) {
            config.setId(rs.getLong(1));
        }
        return count;
    }
}

