/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import apijson.Log;
import apijson.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;

public class JSON {
    private static final String TAG = "JSON";
    private static final Feature[] DEFAULT_FASTJSON_FEATURES = new Feature[]{Feature.OrderedField, Feature.UseBigDecimal};

    public static boolean isJsonCorrect(String s) {
        return s != null && !s.equals("") && !s.equals("[null]") && !s.equals("{null}") && !s.equals("null");
    }

    public static String getCorrectJson(String s) {
        return JSON.getCorrectJson(s, false);
    }

    public static String getCorrectJson(String s, boolean isArray) {
        s = StringUtil.getTrimedString(s);
        return s;
    }

    public static Object parse(Object obj) {
        try {
            return com.alibaba.fastjson.JSON.parse((String)(obj instanceof String ? (String)obj : JSON.toJSONString(obj)), (Feature[])DEFAULT_FASTJSON_FEATURES);
        }
        catch (Exception e) {
            Log.i(TAG, "parse  catch \n" + e.getMessage());
            return null;
        }
    }

    public static JSONObject parseObject(Object obj) {
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        return JSON.parseObject(JSON.toJSONString(obj));
    }

    public static JSONObject parseObject(String json) {
        return JSON.parseObject(json, JSONObject.class);
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (clazz == null) {
            Log.e(TAG, "parseObject  clazz == null >> return null;");
        } else {
            try {
                return (T)com.alibaba.fastjson.JSON.parseObject((String)JSON.getCorrectJson(json), clazz, (Feature[])DEFAULT_FASTJSON_FEATURES);
            }
            catch (Exception e) {
                Log.i(TAG, "parseObject  catch \n" + e.getMessage());
            }
        }
        return null;
    }

    public static JSONArray parseArray(List<Object> list) {
        return new JSONArray(list);
    }

    public static JSONArray parseArray(Object obj) {
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        return JSON.parseArray(JSON.toJSONString(obj));
    }

    public static JSONArray parseArray(String json) {
        try {
            return com.alibaba.fastjson.JSON.parseArray((String)JSON.getCorrectJson(json, true));
        }
        catch (Exception e) {
            Log.i(TAG, "parseArray  catch \n" + e.getMessage());
            return null;
        }
    }

    public static <T> List<T> parseArray(JSONArray array, Class<T> clazz) {
        return JSON.parseArray(JSON.toJSONString(array), clazz);
    }

    public static <T> List<T> parseArray(String json, Class<T> clazz) {
        if (clazz == null) {
            Log.e(TAG, "parseArray  clazz == null >> return null;");
        } else {
            try {
                return com.alibaba.fastjson.JSON.parseArray((String)JSON.getCorrectJson(json, true), clazz);
            }
            catch (Exception e) {
                Log.i(TAG, "parseArray  catch \n" + e.getMessage());
            }
        }
        return null;
    }

    public static String toJSONString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return com.alibaba.fastjson.JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            Log.e(TAG, "toJSONString  catch \n" + e.getMessage());
            return null;
        }
    }

    public static String toJSONString(Object obj, SerializerFeature ... features) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return com.alibaba.fastjson.JSON.toJSONString((Object)obj, (SerializerFeature[])features);
        }
        catch (Exception e) {
            Log.e(TAG, "parseArray  catch \n" + e.getMessage());
            return null;
        }
    }

    public static String format(String json) {
        return JSON.format(JSON.parse(json));
    }

    public static String format(Object object) {
        return JSON.toJSONString(object, SerializerFeature.PrettyFormat);
    }

    public static boolean isJSONObject(Object obj) {
        if (obj instanceof JSONObject) {
            return true;
        }
        if (obj instanceof String) {
            try {
                JSONObject json = JSON.parseObject((String)obj);
                return json != null && !json.isEmpty();
            }
            catch (Exception e) {
                Log.e(TAG, "isJSONObject  catch \n" + e.getMessage());
            }
        }
        return false;
    }

    public static boolean isJSONArray(Object obj) {
        if (obj instanceof JSONArray) {
            return true;
        }
        if (obj instanceof String) {
            try {
                JSONArray json = JSON.parseArray((String)obj);
                return json != null && !json.isEmpty();
            }
            catch (Exception e) {
                Log.e(TAG, "isJSONArray  catch \n" + e.getMessage());
            }
        }
        return false;
    }

    public static boolean isBooleanOrNumberOrString(Object obj) {
        return obj instanceof Boolean || obj instanceof Number || obj instanceof String;
    }
}

