/*
 * Decompiled with CFR 0.152.
 */
package apijson;

public enum RequestMethod {
    GET,
    HEAD,
    GETS,
    HEADS,
    POST,
    PUT,
    DELETE;

    public static final RequestMethod[] ALL;

    public static boolean isGetMethod(RequestMethod method, boolean containPrivate) {
        return method == null || method == GET || containPrivate && method == GETS;
    }

    public static boolean isHeadMethod(RequestMethod method, boolean containPrivate) {
        return method == HEAD || containPrivate && method == HEADS;
    }

    public static boolean isQueryMethod(RequestMethod method) {
        return RequestMethod.isGetMethod(method, true) || RequestMethod.isHeadMethod(method, true);
    }

    public static boolean isPublicMethod(RequestMethod method) {
        return method == null || method == GET || method == HEAD;
    }

    public static String getName(RequestMethod method) {
        return method == null ? GET.name() : method.name();
    }

    static {
        ALL = new RequestMethod[]{GET, HEAD, GETS, HEADS, POST, PUT, DELETE};
    }
}

