/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.JSONObject;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.SQL;
import apijson.StringUtil;
import apijson.orm.AbstractVerifier;
import apijson.orm.Join;
import apijson.orm.Logic;
import apijson.orm.Pair;
import apijson.orm.SQLConfig;
import apijson.orm.Subquery;
import apijson.orm.exception.NotExistException;
import apijson.orm.model.Access;
import apijson.orm.model.Column;
import apijson.orm.model.Document;
import apijson.orm.model.ExtendedProperty;
import apijson.orm.model.Function;
import apijson.orm.model.PgAttribute;
import apijson.orm.model.PgClass;
import apijson.orm.model.Request;
import apijson.orm.model.SysColumn;
import apijson.orm.model.SysTable;
import apijson.orm.model.Table;
import apijson.orm.model.TestRecord;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.UnsupportedDataTypeException;

public abstract class AbstractSQLConfig
implements SQLConfig {
    private static final String TAG = "AbstractSQLConfig";
    public static String DEFAULT_DATABASE = "MYSQL";
    public static String DEFAULT_SCHEMA = "sys";
    public static String PREFFIX_DISTINCT = "DISTINCT ";
    private static final Pattern PATTERN_RANGE = Pattern.compile("^[0-9%,!=\\<\\>/\\.\\+\\-\\*\\^]+$");
    private static final Pattern PATTERN_FUNCTION = Pattern.compile("^[A-Za-z0-9%,:_@&~`!=\\<\\>\\|\\[\\]\\{\\} /\\.\\+\\-\\*\\^\\?\\(\\)\\$]+$");
    private static final Pattern PATTERN_STRING = Pattern.compile("^[,#;\"`]+$");
    public static final Map<String, String> TABLE_KEY_MAP = new HashMap<String, String>();
    public static final List<String> CONFIG_TABLE_LIST;
    public static final List<String> DATABASE_LIST;
    public static final Map<String, String> RAW_MAP;
    public static final Map<String, String> SQL_FUNCTION_MAP;
    private Object id;
    private RequestMethod method;
    private boolean prepared = true;
    private boolean main = true;
    private String role;
    private boolean distinct = false;
    private String database;
    private String schema;
    private String datasource;
    private String table;
    private String alias;
    private String group;
    private String having;
    private String order;
    private List<String> raw;
    private List<String> json;
    private Subquery from;
    private List<String> column;
    private List<List<Object>> values;
    private Map<String, Object> content;
    private Map<String, Object> where;
    private Map<String, List<String>> combine;
    private int count;
    private int page;
    private int position;
    private int query;
    private int type;
    private int cache;
    private boolean explain;
    private List<Join> joinList;
    private boolean test;
    private String procedure;
    protected List<Object> preparedValueList = new ArrayList<Object>();
    private boolean keyPrefix;

    @Override
    public boolean limitSQLCount() {
        return !Log.DEBUG || !AbstractVerifier.SYSTEM_ACCESS_MAP.containsKey(this.getTable());
    }

    @Override
    @NotNull
    public String getIdKey() {
        return JSONObject.KEY_ID;
    }

    @Override
    @NotNull
    public String getUserIdKey() {
        return JSONObject.KEY_USER_ID;
    }

    @Override
    public SQLConfig setProcedure(String procedure) {
        this.procedure = procedure;
        return this;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public AbstractSQLConfig(RequestMethod method) {
        this.setMethod(method);
    }

    public AbstractSQLConfig(RequestMethod method, String table) {
        this(method);
        this.setTable(table);
    }

    public AbstractSQLConfig(RequestMethod method, int count, int page) {
        this(method);
        this.setCount(count);
        this.setPage(page);
    }

    @Override
    @NotNull
    public RequestMethod getMethod() {
        if (this.method == null) {
            this.method = RequestMethod.GET;
        }
        return this.method;
    }

    @Override
    public AbstractSQLConfig setMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public AbstractSQLConfig setPrepared(boolean prepared) {
        this.prepared = prepared;
        return this;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public AbstractSQLConfig setMain(boolean main) {
        this.main = main;
        return this;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public AbstractSQLConfig setId(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public AbstractSQLConfig setRole(String role) {
        this.role = role;
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public SQLConfig setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public SQLConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    @NotNull
    public String getSQLDatabase() {
        String db = this.getDatabase();
        return db == null ? DEFAULT_DATABASE : db;
    }

    @Override
    public boolean isMySQL() {
        return AbstractSQLConfig.isMySQL(this.getSQLDatabase());
    }

    public static boolean isMySQL(String db) {
        return "MYSQL".equals(db);
    }

    @Override
    public boolean isPostgreSQL() {
        return AbstractSQLConfig.isPostgreSQL(this.getSQLDatabase());
    }

    public static boolean isPostgreSQL(String db) {
        return "POSTGRESQL".equals(db);
    }

    @Override
    public boolean isSQLServer() {
        return AbstractSQLConfig.isSQLServer(this.getSQLDatabase());
    }

    public static boolean isSQLServer(String db) {
        return "SQLSERVER".equals(db);
    }

    @Override
    public boolean isOracle() {
        return AbstractSQLConfig.isOracle(this.getSQLDatabase());
    }

    public static boolean isOracle(String db) {
        return "ORACLE".equals(db);
    }

    @Override
    public boolean isDb2() {
        return AbstractSQLConfig.isDb2(this.getSQLDatabase());
    }

    public static boolean isDb2(String db) {
        return "DB2".equals(db);
    }

    @Override
    public boolean isClickHouse() {
        return AbstractSQLConfig.isClickHouse(this.getSQLDatabase());
    }

    public static boolean isClickHouse(String db) {
        return "CLICKHOUSE".equals(db);
    }

    @Override
    public boolean isHive() {
        return AbstractSQLConfig.isHive(this.getSQLDatabase());
    }

    public static boolean isHive(String db) {
        return "HIVE".equals(db);
    }

    @Override
    public String getQuote() {
        return this.isMySQL() || this.isClickHouse() ? "`" : "\"";
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @NotNull
    public String getSQLSchema() {
        String table = this.getTable();
        if ("Table".equals(table) || "Column".equals(table)) {
            return "information_schema";
        }
        if ("PgClass".equals(table) || "PgAttribute".equals(table)) {
            return "";
        }
        if ("SysTable".equals(table) || "SysColumn".equals(table) || "ExtendedProperty".equals(table)) {
            return "sys";
        }
        String sch = this.getSchema();
        return sch == null ? DEFAULT_SCHEMA : sch;
    }

    @Override
    public AbstractSQLConfig setSchema(String schema) {
        if (schema != null) {
            String s;
            String quote = this.getQuote();
            String string = s = schema.startsWith(quote) && schema.endsWith(quote) ? schema.substring(1, schema.length() - 1) : schema;
            if (!StringUtil.isEmpty(s, true) && !StringUtil.isName(s)) {
                throw new IllegalArgumentException("@schema:value \u4e2dvalue\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01");
            }
        }
        this.schema = schema;
        return this;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    @Override
    public SQLConfig setDatasource(String datasource) {
        this.datasource = datasource;
        return this;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    @JSONField(serialize=false)
    public String getSQLTable() {
        return TABLE_KEY_MAP.containsKey(this.table) ? TABLE_KEY_MAP.get(this.table) : this.table;
    }

    @Override
    @JSONField(serialize=false)
    public String getTablePath() {
        String q = this.getQuote();
        String sch = this.getSQLSchema();
        String sqlTable = this.getSQLTable();
        return (StringUtil.isEmpty(sch, true) ? "" : q + sch + q + ".") + q + sqlTable + q + (this.isKeyPrefix() ? " AS " + this.getAliasWithQuote() : "");
    }

    @Override
    public AbstractSQLConfig setTable(String table) {
        this.table = table;
        return this;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public AbstractSQLConfig setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getAliasWithQuote() {
        String a = this.getAlias();
        if (StringUtil.isEmpty(a, true)) {
            a = this.getTable();
        }
        String q = this.getQuote();
        return q + a + q;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public AbstractSQLConfig setGroup(String ... keys) {
        return this.setGroup(StringUtil.getString(keys));
    }

    @Override
    public AbstractSQLConfig setGroup(String group) {
        this.group = group;
        return this;
    }

    @JSONField(serialize=false)
    public String getGroupString(boolean hasPrefix) {
        String joinGroup = "";
        if (this.joinList != null) {
            boolean first = true;
            for (Join j : this.joinList) {
                String c;
                SQLConfig cfg;
                if (j.isAppJoin()) continue;
                SQLConfig sQLConfig = cfg = j.isLeftOrRightJoin() ? j.getOuterConfig() : j.getJoinConfig();
                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                    cfg.setAlias(cfg.getTable());
                }
                if (StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getGroupString(false), true)) continue;
                joinGroup = joinGroup + (first ? "" : ", ") + c;
                first = false;
            }
        }
        this.group = StringUtil.getTrimedString(this.group);
        Object[] keys = StringUtil.split(this.group);
        if (keys == null || keys.length <= 0) {
            return StringUtil.isEmpty(joinGroup, true) ? "" : (hasPrefix ? " GROUP BY " : "") + joinGroup;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.isPrepared() && !StringUtil.isName(keys[i])) {
                throw new IllegalArgumentException("@group:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u7a7a\u683c\uff01");
            }
            keys[i] = this.getKey(keys[i]);
        }
        return (hasPrefix ? " GROUP BY " : "") + StringUtil.concat(StringUtil.getString(keys), joinGroup, ", ");
    }

    @Override
    public String getHaving() {
        return this.having;
    }

    public AbstractSQLConfig setHaving(String ... conditions) {
        return this.setHaving(StringUtil.getString(conditions));
    }

    @Override
    public AbstractSQLConfig setHaving(String having) {
        this.having = having;
        return this;
    }

    @JSONField(serialize=false)
    public String getHavingString(boolean hasPrefix) {
        Object[] keys;
        String joinHaving = "";
        if (this.joinList != null) {
            boolean first = true;
            for (Join j : this.joinList) {
                String c;
                SQLConfig cfg;
                if (j.isAppJoin()) continue;
                SQLConfig sQLConfig = cfg = j.isLeftOrRightJoin() ? j.getOuterConfig() : j.getJoinConfig();
                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                    cfg.setAlias(cfg.getTable());
                }
                if (StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getHavingString(false), true)) continue;
                joinHaving = joinHaving + (first ? "" : ", ") + c;
                first = false;
            }
        }
        if ((keys = StringUtil.split(this.getHaving(), ";")) == null || keys.length <= 0) {
            return StringUtil.isEmpty(joinHaving, true) ? "" : (hasPrefix ? " HAVING " : "") + joinHaving;
        }
        String quote = this.getQuote();
        String tableAlias = this.getAliasWithQuote();
        List<String> raw = this.getRaw();
        boolean containRaw = raw != null && raw.contains("@having");
        for (int i = 0; i < keys.length; ++i) {
            String expression = keys[i];
            if (containRaw) {
                try {
                    String rawSQL = this.getRawSQL("@having", expression);
                    if (rawSQL != null) {
                        keys[i] = rawSQL;
                        continue;
                    }
                }
                catch (Exception e) {
                    Log.e(TAG, "newSQLConfig  rawColumnSQL == null >> try {    String rawSQL = ((AbstractSQLConfig) config).getRawSQL(KEY_COLUMN, fk); ... } catch (Exception e) = " + e.getMessage());
                }
            }
            if (expression.length() > 50) {
                throw new UnsupportedOperationException("@having:value \u7684 value \u4e2d\u5b57\u7b26\u4e32 " + expression + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u8d85\u8fc7 50 \u4e2a\u5b57\u7b26\u7684\u51fd\u6570\u6216\u8868\u8fbe\u5f0f\uff01\u8bf7\u7528 @raw \u7b80\u5316\u4f20\u53c2\uff01");
            }
            int start = expression.indexOf("(");
            if (start < 0) {
                if (!this.isPrepared() || PATTERN_FUNCTION.matcher(expression).matches()) continue;
                throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + expression + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d column?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
            }
            int end = expression.lastIndexOf(")");
            if (start >= end) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01@having:value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
            }
            String method = expression.substring(0, start);
            if (!method.isEmpty()) {
                if (SQL_FUNCTION_MAP == null || SQL_FUNCTION_MAP.isEmpty()) {
                    if (!StringUtil.isName(method)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01");
                    }
                } else if (!SQL_FUNCTION_MAP.containsKey(method)) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e14\u5fc5\u987b\u662f\u540e\u7aef\u5141\u8bb8\u8c03\u7528\u7684 SQL \u51fd\u6570!");
                }
            }
            String suffix = expression.substring(end + 1, expression.length());
            if (this.isPrepared() && (suffix.contains("--") || suffix.contains("/*") || !PATTERN_RANGE.matcher(suffix).matches())) {
                throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + suffix + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d ?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_RANGE + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \u6216\u6ce8\u91ca\u7b26 /* \uff01\u4e0d\u5141\u8bb8\u591a\u4f59\u7684\u7a7a\u683c\uff01");
            }
            Object[] ckeys = StringUtil.split(expression.substring(start + 1, end));
            if (ckeys != null) {
                for (int j = 0; j < ckeys.length; ++j) {
                    String origin = ckeys[j];
                    if (this.isPrepared() && (origin.startsWith("_") || origin.contains("--") || !PATTERN_FUNCTION.matcher(origin).matches())) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + (String)ckeys[j] + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d\u6240\u6709 column, arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd \u6216\u8005 \u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01\u4e0d\u5141\u8bb8\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                    }
                    boolean isName = false;
                    if (!StringUtil.isNumer(origin)) {
                        if (StringUtil.isName(origin)) {
                            origin = quote + origin + quote;
                            isName = true;
                        } else {
                            origin = this.getValue(origin).toString();
                        }
                    }
                    ckeys[j] = (isName && this.isKeyPrefix() ? tableAlias + "." : "") + origin;
                }
            }
            keys[i] = method + "(" + StringUtil.getString(ckeys) + ")" + suffix;
        }
        return (hasPrefix ? " HAVING " : "") + StringUtil.concat(StringUtil.getString(keys, " AND "), joinHaving, " AND ");
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    public AbstractSQLConfig setOrder(String ... conditions) {
        return this.setOrder(StringUtil.getString(conditions));
    }

    @Override
    public AbstractSQLConfig setOrder(String order) {
        this.order = order;
        return this;
    }

    @JSONField(serialize=false)
    public String getOrderString(boolean hasPrefix) {
        Object[] keys;
        String joinOrder = "";
        if (this.joinList != null) {
            boolean first = true;
            for (Join j : this.joinList) {
                String c;
                SQLConfig cfg;
                if (j.isAppJoin()) continue;
                SQLConfig sQLConfig = cfg = j.isLeftOrRightJoin() ? j.getOuterConfig() : j.getJoinConfig();
                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                    cfg.setAlias(cfg.getTable());
                }
                if (StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getOrderString(false), true)) continue;
                joinOrder = joinOrder + (first ? "" : ", ") + c;
                first = false;
            }
        }
        String order = StringUtil.getTrimedString(this.getOrder());
        if (this.getCount() > 0 && (this.isSQLServer() || this.isDb2()) && StringUtil.isEmpty(order, true)) {
            String idKey = this.getIdKey();
            if (StringUtil.isEmpty(idKey, true)) {
                idKey = "id";
            }
            order = idKey;
        }
        if ((keys = StringUtil.split(order)) == null || keys.length <= 0) {
            return StringUtil.isEmpty(joinOrder, true) ? "" : (hasPrefix ? " ORDER BY " : "") + joinOrder;
        }
        for (int i = 0; i < keys.length; ++i) {
            String origin;
            String sort;
            int index;
            String item = keys[i];
            if ("rand()".equals(item)) continue;
            int n = index = item.endsWith("+") ? item.length() - 1 : -1;
            if (index < 0) {
                index = item.endsWith("-") ? item.length() - 1 : -1;
                sort = index <= 0 ? "" : " DESC ";
            } else {
                sort = " ASC ";
            }
            String string = origin = index < 0 ? item : item.substring(0, index);
            if (this.isPrepared() && !StringUtil.isName(origin)) {
                throw new IllegalArgumentException("\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @order:value \u4e2d " + item + " \u4e0d\u5408\u6cd5! value \u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879\u5fc5\u987b\u662f \u968f\u673a\u51fd\u6570 rand() \u6216 column+ / column- \u4e14\u5176\u4e2d column \u5fc5\u987b\u662f 1 \u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
            }
            keys[i] = this.getKey(origin) + sort;
        }
        return (hasPrefix ? " ORDER BY " : "") + StringUtil.concat(StringUtil.getString(keys), joinOrder, ", ");
    }

    @Override
    public List<String> getRaw() {
        return this.raw;
    }

    @Override
    public SQLConfig setRaw(List<String> raw) {
        this.raw = raw;
        return this;
    }

    @Override
    public String getRawSQL(String key, Object value) throws Exception {
        String rawSQL;
        boolean containRaw;
        List<String> rawList = this.getRaw();
        boolean bl = containRaw = rawList != null && rawList.contains(key);
        if (containRaw && !(value instanceof String)) {
            throw new UnsupportedOperationException("@raw:value \u7684 value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01\u5bf9\u5e94\u7684 " + key + ":value \u4e2d value \u7c7b\u578b\u53ea\u80fd\u4e3a String\uff01");
        }
        String string = rawSQL = containRaw ? RAW_MAP.get(value) : null;
        if (containRaw) {
            if (rawSQL == null) {
                throw new UnsupportedOperationException("@raw:value \u7684 value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01\u5bf9\u5e94\u7684 " + key + ":value \u4e2d value \u503c " + value + " \u672a\u5728\u540e\u7aef RAW_MAP \u4e2d\u914d\u7f6e \uff01");
            }
            if (rawSQL.isEmpty()) {
                return (String)value;
            }
        }
        return rawSQL;
    }

    @Override
    public List<String> getJson() {
        return this.json;
    }

    @Override
    public AbstractSQLConfig setJson(List<String> json) {
        this.json = json;
        return this;
    }

    @Override
    public Subquery getFrom() {
        return this.from;
    }

    @Override
    public AbstractSQLConfig setFrom(Subquery from) {
        this.from = from;
        return this;
    }

    @Override
    public List<String> getColumn() {
        return this.column;
    }

    @Override
    public AbstractSQLConfig setColumn(List<String> column) {
        this.column = column;
        return this;
    }

    @JSONField(serialize=false)
    public String getColumnString() throws Exception {
        return this.getColumnString(false);
    }

    @JSONField(serialize=false)
    public String getColumnString(boolean inSQLJoin) throws Exception {
        List<String> column = this.getColumn();
        switch (this.getMethod()) {
            case HEAD: 
            case HEADS: {
                if (this.isPrepared() && column != null) {
                    List<String> raw = this.getRaw();
                    boolean containRaw = raw != null && raw.contains("@column");
                    for (String c : column) {
                        String alias;
                        if (containRaw && ("".equals(RAW_MAP.get(c)) || RAW_MAP.containsValue(c))) continue;
                        int index = c.lastIndexOf(":");
                        String origin = index < 0 ? c : c.substring(0, index);
                        String string = alias = index < 0 ? null : c.substring(index + 1);
                        if (alias != null && !StringUtil.isName(alias)) {
                            throw new IllegalArgumentException("HEAD\u8bf7\u6c42: \u5b57\u7b26 " + alias + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                        }
                        if (StringUtil.isName(origin)) continue;
                        int start = origin.indexOf("(");
                        if (start < 0 || origin.lastIndexOf(")") <= start) {
                            throw new IllegalArgumentException("HEAD\u8bf7\u6c42: \u5b57\u7b26" + origin + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                        }
                        if (start <= 0 || StringUtil.isName(origin.substring(0, start))) continue;
                        throw new IllegalArgumentException("HEAD\u8bf7\u6c42: \u5b57\u7b26 " + origin.substring(0, start) + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                    }
                }
                return SQL.count(column != null && column.size() == 1 && StringUtil.isName(column.get(0)) ? this.getKey(column.get(0)) : "*");
            }
            case POST: {
                if (column == null || column.isEmpty()) {
                    throw new IllegalArgumentException("POST \u8bf7\u6c42\u5fc5\u987b\u5728Table\u5185\u8bbe\u7f6e\u8981\u4fdd\u5b58\u7684 key:value \uff01");
                }
                String s = "";
                boolean pfirst = true;
                for (String c : column) {
                    if (this.isPrepared() && !StringUtil.isName(c)) {
                        throw new IllegalArgumentException("POST\u8bf7\u6c42: \u6bcf\u4e00\u4e2a key:value \u4e2d\u7684key\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01");
                    }
                    s = s + (pfirst ? "" : ",") + this.getKey(c);
                    pfirst = false;
                }
                return "(" + s + ")";
            }
            case GET: 
            case GETS: {
                Object[] keys;
                String joinColumn = "";
                if (this.joinList != null) {
                    boolean first = true;
                    for (Join j : this.joinList) {
                        if (j.isAppJoin()) continue;
                        if (j.isLeftOrRightJoin()) {
                            String quote = this.getQuote();
                            joinColumn = joinColumn + (first ? "" : ", ") + quote + (StringUtil.isEmpty(j.getAlias(), true) ? j.getTable() : j.getAlias()) + quote + ".*";
                            first = false;
                        } else {
                            String c;
                            SQLConfig ecfg = j.getOuterConfig();
                            SQLConfig cfg = ecfg != null && ecfg.getColumn() != null ? ecfg : j.getJoinConfig();
                            if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                                cfg.setAlias(cfg.getTable());
                            }
                            if (!StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getColumnString(true), true)) {
                                joinColumn = joinColumn + (first ? "" : ", ") + c;
                                first = false;
                            }
                        }
                        inSQLJoin = true;
                    }
                }
                String tableAlias = this.getAliasWithQuote();
                Object[] objectArray = keys = column == null ? null : column.toArray(new String[0]);
                if (keys == null || keys.length <= 0) {
                    boolean noColumn;
                    boolean bl = noColumn = column != null && inSQLJoin;
                    String mc = !this.isKeyPrefix() ? (noColumn ? "" : "*") : (noColumn ? "" : tableAlias + ".*");
                    return StringUtil.concat(mc, joinColumn, ", ", true);
                }
                List<String> raw = this.getRaw();
                boolean containRaw = raw != null && raw.contains("@column");
                for (int i = 0; i < keys.length; ++i) {
                    Object expression = keys[i];
                    if (containRaw && ("".equals(RAW_MAP.get(expression)) || RAW_MAP.containsValue(expression))) continue;
                    if (((String)expression).length() > 100) {
                        throw new UnsupportedOperationException("@column:value \u7684 value \u4e2d\u5b57\u7b26\u4e32 " + (String)expression + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26\u7684\u51fd\u6570\u6216\u8868\u8fbe\u5f0f\uff01\u8bf7\u7528 @raw \u7b80\u5316\u4f20\u53c2\uff01");
                    }
                    keys[i] = this.getColumnPrase((String)expression, containRaw);
                }
                String c = StringUtil.getString(keys);
                c = c + (StringUtil.isEmpty(joinColumn, true) ? "" : ", " + joinColumn);
                return this.isMain() && this.isDistinct() ? PREFFIX_DISTINCT + c : c;
            }
        }
        throw new UnsupportedOperationException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1agetColumnString \u4e0d\u652f\u6301 " + RequestMethod.getName(this.getMethod()) + " \u7b49 [GET,GETS,HEAD,HEADS,POST] \u5916\u7684ReuqestMethod\uff01");
    }

    public String getColumnPrase(String expression, boolean containRaw) {
        String quote = this.getQuote();
        int start = expression.indexOf(40);
        if (start < 0) {
            Object[] cks = this.parseArgsSplitWithComma(expression, true, containRaw);
            expression = StringUtil.getString(cks);
        } else {
            boolean containAgainst;
            int overIndex = expression.indexOf(")OVER(");
            int againstIndex = expression.indexOf(")AGAINST(");
            boolean containOver = overIndex > 0 && overIndex < expression.length() - ")OVER(".length();
            boolean bl = containAgainst = againstIndex > 0 && againstIndex < expression.length() - ")AGAINST(".length();
            if (containOver && containAgainst) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u7a97\u53e3\u51fd\u6570\u5173\u952e\u8bcd OVER \u548c\u5168\u6587\u7d22\u5f15\u5173\u952e\u8bcd AGAINST\uff01");
            }
            if (!containOver && !containAgainst) {
                String s;
                boolean distinct;
                int end = expression.lastIndexOf(")");
                if (start >= end) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01@column:value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
                }
                String fun = expression.substring(0, start);
                if (!fun.isEmpty()) {
                    if (SQL_FUNCTION_MAP == null || SQL_FUNCTION_MAP.isEmpty()) {
                        if (!StringUtil.isName(fun)) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01");
                        }
                    } else if (!SQL_FUNCTION_MAP.containsKey(fun)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e14\u5fc5\u987b\u662f\u540e\u7aef\u5141\u8bb8\u8c03\u7528\u7684 SQL \u51fd\u6570!");
                    }
                }
                if (distinct = (s = expression.substring(start + 1, end)).startsWith(PREFFIX_DISTINCT)) {
                    s = s.substring(PREFFIX_DISTINCT.length());
                }
                Object[] ckeys = this.parseArgsSplitWithComma(s, false, containRaw);
                String suffix = expression.substring(end + 1, expression.length());
                int index = suffix.lastIndexOf(":");
                String alias = index < 0 ? "" : suffix.substring(index + 1);
                String string = suffix = index < 0 ? suffix : suffix.substring(0, index);
                if (!alias.isEmpty() && !StringUtil.isName(alias)) {
                    throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + alias + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 ; \u5206\u5272\u7684\u6bcf\u4e00\u9879 function(arg0,arg1,...):alias \u4e2d alias \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                }
                if (!suffix.isEmpty() && (suffix.contains("--") || suffix.contains("/*") || !PATTERN_RANGE.matcher(suffix).matches())) {
                    throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + suffix + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d ?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_RANGE + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \u6216\u6ce8\u91ca\u7b26 /* \uff01\u4e0d\u5141\u8bb8\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                }
                String origin = fun + "(" + (distinct ? PREFFIX_DISTINCT : "") + StringUtil.getString(ckeys) + ")" + suffix;
                expression = origin + (StringUtil.isEmpty(alias, true) ? "" : " AS " + quote + alias + quote);
            } else {
                int keyIndex = containOver ? overIndex : againstIndex;
                String s1 = expression.substring(0, keyIndex + 1);
                String s2 = expression.substring(keyIndex + 1);
                int index1 = s1.indexOf("(");
                String fun = s1.substring(0, index1);
                int end = s2.lastIndexOf(")");
                if (index1 >= end) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01@column:value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
                }
                if (!fun.isEmpty()) {
                    if (SQL_FUNCTION_MAP == null || SQL_FUNCTION_MAP.isEmpty()) {
                        if (!StringUtil.isName(fun)) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01");
                        }
                    } else if (!SQL_FUNCTION_MAP.containsKey(fun)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e14\u5fc5\u987b\u662f\u540e\u7aef\u5141\u8bb8\u8c03\u7528\u7684 SQL \u51fd\u6570!");
                    }
                }
                Object[] agrsString1 = this.parseArgsSplitWithComma(s1.substring(index1 + 1, s1.lastIndexOf(")")), false, containRaw);
                int index2 = s2.indexOf("(");
                String argString2 = s2.substring(index2 + 1, end);
                String alias = s2.lastIndexOf(":") < s2.lastIndexOf(")") ? null : s2.substring(s2.lastIndexOf(":") + 1);
                Object[] argsString2 = this.parseArgsSplitWithComma(argString2, false, containRaw);
                expression = fun + "(" + StringUtil.getString(agrsString1) + (containOver ? ") OVER (" : ") AGAINST (") + StringUtil.getString(argsString2) + ")" + (StringUtil.isEmpty(alias, true) ? "" : " AS " + quote + alias + quote);
            }
        }
        return expression;
    }

    private String[] parseArgsSplitWithComma(String param, boolean isColumn, boolean containRaw) {
        String quote = this.getQuote();
        String tableAlias = this.getAliasWithQuote();
        String[] ckeys = StringUtil.split(param);
        if (ckeys != null && ckeys.length > 0) {
            for (int i = 0; i < ckeys.length; ++i) {
                String[] stringArray;
                String alias;
                String origin;
                String ck = ckeys[i];
                if (ck.startsWith("`") && ck.endsWith("`")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.startsWith("_") || !StringUtil.isName(origin)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"`column0`,`column1`:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709\u5b57\u7b26\u4e32 column \u90fd\u5fc5\u987b\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd \uff01");
                    }
                    ckeys[i] = this.getKey(origin).toString();
                    continue;
                }
                if (ck.startsWith("'") && ck.endsWith("'")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.contains("'")) {
                        throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u5b57\u7b26\u4e32\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4ee5 ' \u5f00\u5934, ' \u7ed3\u5c3e,\u5b57\u7b26\u4e32\u4e2d\u4e0d\u80fd\u5305\u542b ' ");
                    }
                    ckeys[i] = this.getValue(origin).toString();
                    continue;
                }
                int index = isColumn ? ck.lastIndexOf(":") : -1;
                origin = index < 0 ? ck : ck.substring(0, index);
                String string = alias = index < 0 ? null : ck.substring(index + 1);
                if (this.isPrepared()) {
                    if (isColumn) {
                        if (!StringUtil.isName(origin) || alias != null && !StringUtil.isName(alias)) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5173\u952e\u5b57\u5fc5\u987b\u5168\u5927\u5199\uff0c\u4e14\u4ee5\u7a7a\u683c\u5206\u9694\u7684\u53c2\u6570\uff0c\u7a7a\u683c\u5fc5\u987b\u53ea\u6709 1 \u4e2a\uff01\u5176\u5b83\u60c5\u51b5\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                        }
                    } else if (origin.startsWith("_") || origin.contains("--")) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709 arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd \u6216\u8005\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01DISTINCT \u5fc5\u987b\u5168\u5927\u5199\uff0c\u4e14\u540e\u9762\u5fc5\u987b\u6709\u4e14\u53ea\u6709 1 \u4e2a\u7a7a\u683c\uff01\u5176\u5b83\u60c5\u51b5\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                    }
                }
                if (containRaw) {
                    stringArray = StringUtil.split(ck, " ", true);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ck;
                }
                String[] mkes = stringArray;
                if (mkes != null && mkes.length >= 2) {
                    ckeys[i] = this.praseArgsSplitWithSpace(mkes);
                    continue;
                }
                boolean isName = false;
                String mk = RAW_MAP.get(origin);
                if (mk != null) {
                    if (mk.length() > 0) {
                        origin = mk;
                    }
                } else if (!StringUtil.isNumer(origin)) {
                    if (StringUtil.isName(origin)) {
                        origin = quote + origin + quote;
                        isName = true;
                    } else {
                        origin = this.getValue(origin).toString();
                    }
                }
                if (isName && this.isKeyPrefix()) {
                    origin = tableAlias + "." + origin;
                }
                if (isColumn && !StringUtil.isEmpty(alias, true)) {
                    origin = origin + " AS " + quote + alias + quote;
                }
                ckeys[i] = origin;
            }
        }
        return ckeys;
    }

    private String praseArgsSplitWithSpace(String[] mkes) {
        String quote = this.getQuote();
        String tableAlias = this.getAliasWithQuote();
        if (mkes != null && mkes.length > 0) {
            for (int j = 0; j < mkes.length; ++j) {
                String origin = mkes[j];
                String mk = RAW_MAP.get(origin);
                if (mk != null) {
                    if (mk.length() <= 0) continue;
                    mkes[j] = mk;
                    continue;
                }
                String ck = origin;
                if (ck.startsWith("`") && ck.endsWith("`")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.startsWith("_") || !StringUtil.isName(origin)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"`column0`,`column1`:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709\u5b57\u7b26\u4e32 column \u90fd\u5fc5\u987b\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd \uff01");
                    }
                    mkes[j] = this.getKey(origin).toString();
                    continue;
                }
                if (ck.startsWith("'") && ck.endsWith("'")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.contains("'")) {
                        throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u5b57\u7b26\u4e32\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4ee5 ' \u5f00\u5934, ' \u7ed3\u5c3e,\u5b57\u7b26\u4e32\u4e2d\u4e0d\u80fd\u5305\u542b ' ");
                    }
                    mkes[j] = this.getValue(origin).toString();
                    continue;
                }
                if (ck.contains("`") || ck.contains("'") || origin.startsWith("_") || origin.contains("--")) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + origin + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709 arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd \u6216\u8005\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01DISTINCT \u5fc5\u987b\u5168\u5927\u5199\uff0c\u4e14\u540e\u9762\u5fc5\u987b\u6709\u4e14\u53ea\u6709 1 \u4e2a\u7a7a\u683c\uff01\u5176\u5b83\u60c5\u51b5\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                }
                boolean isName = false;
                if (!StringUtil.isNumer(origin)) {
                    if (StringUtil.isName(origin)) {
                        origin = quote + origin + quote;
                        isName = true;
                    } else {
                        origin = this.getValue(origin).toString();
                    }
                }
                if (isName && this.isKeyPrefix()) {
                    origin = tableAlias + "." + origin;
                }
                mkes[j] = origin;
            }
        }
        return StringUtil.join(mkes, " ");
    }

    @Override
    public List<List<Object>> getValues() {
        return this.values;
    }

    @JSONField(serialize=false)
    public String getValuesString() {
        String s = "";
        if (this.values != null && this.values.size() > 0) {
            Object[] items = new Object[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                List<Object> vs = this.values.get(i);
                if (vs == null) continue;
                items[i] = "(";
                for (int j = 0; j < vs.size(); ++j) {
                    int n = i;
                    items[n] = items[n] + (j <= 0 ? "" : ",") + this.getValue(vs.get(j));
                }
                int n = i;
                items[n] = items[n] + ")";
            }
            s = StringUtil.getString(items);
        }
        return s;
    }

    @Override
    public AbstractSQLConfig setValues(List<List<Object>> valuess) {
        this.values = valuess;
        return this;
    }

    @Override
    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    public AbstractSQLConfig setContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public AbstractSQLConfig setCount(int count) {
        this.count = count;
        return this;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public AbstractSQLConfig setPage(int page) {
        this.page = page;
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public AbstractSQLConfig setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getQuery() {
        return this.query;
    }

    @Override
    public AbstractSQLConfig setQuery(int query) {
        this.query = query;
        return this;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public AbstractSQLConfig setType(int type) {
        this.type = type;
        return this;
    }

    @Override
    public int getCache() {
        return this.cache;
    }

    @Override
    public AbstractSQLConfig setCache(int cache) {
        this.cache = cache;
        return this;
    }

    public AbstractSQLConfig setCache(String cache) {
        return this.setCache(AbstractSQLConfig.getCache(cache));
    }

    public static int getCache(String cache) {
        int cache2;
        if (cache == null) {
            cache2 = 0;
        } else {
            switch (cache) {
                case "0": 
                case "ALL": {
                    cache2 = 0;
                    break;
                }
                case "1": 
                case "ROM": {
                    cache2 = 1;
                    break;
                }
                case "2": 
                case "RAM": {
                    cache2 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("@cache:value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 [0,1,2] \u6216 [ALL, ROM, RAM] \u5185 !");
                }
            }
        }
        return cache2;
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public AbstractSQLConfig setExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    @Override
    public List<Join> getJoinList() {
        return this.joinList;
    }

    @Override
    public SQLConfig setJoinList(List<Join> joinList) {
        this.joinList = joinList;
        return this;
    }

    @Override
    public boolean hasJoin() {
        return this.joinList != null && !this.joinList.isEmpty();
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    @Override
    public AbstractSQLConfig setTest(boolean test) {
        this.test = test;
        return this;
    }

    @JSONField(serialize=false)
    public int getOffset() {
        return AbstractSQLConfig.getOffset(this.getPage(), this.getCount());
    }

    public static int getOffset(int page, int count) {
        return page * count;
    }

    @JSONField(serialize=false)
    public String getLimitString() {
        if (this.count <= 0 || RequestMethod.isHeadMethod(this.getMethod(), true)) {
            return "";
        }
        return AbstractSQLConfig.getLimitString(this.getPage(), this.getCount(), this.isOracle() || this.isSQLServer() || this.isDb2(), this.isOracle());
    }

    public static String getLimitString(int page, int count, boolean isTSQL, boolean isOracle) {
        int offset = AbstractSQLConfig.getOffset(page, count);
        if (isTSQL) {
            return isOracle ? " WHERE ROWNUM BETWEEN " + offset + " AND " + (offset + count) : " OFFSET " + offset + " ROWS FETCH FIRST " + count + " ROWS ONLY";
        }
        return " LIMIT " + count + (offset <= 0 ? "" : " OFFSET " + offset);
    }

    @Override
    public Map<String, Object> getWhere() {
        return this.where;
    }

    @Override
    public AbstractSQLConfig setWhere(Map<String, Object> where) {
        this.where = where;
        return this;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getCombine() {
        List<String> andList;
        List<String> list = andList = this.combine == null ? null : this.combine.get("&");
        if (andList == null) {
            List<String> list2 = andList = this.where == null ? new ArrayList<String>() : new ArrayList<String>(this.where.keySet());
            if (this.combine == null) {
                this.combine = new HashMap<String, List<String>>();
            }
            this.combine.put("&", andList);
        }
        return this.combine;
    }

    @Override
    public AbstractSQLConfig setCombine(Map<String, List<String>> combine) {
        this.combine = combine;
        return this;
    }

    @Override
    @JSONField(serialize=false)
    public Object getWhere(String key) {
        return this.getWhere(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JSONField(serialize=false)
    public Object getWhere(String key, boolean exactMatch) {
        if (exactMatch) {
            return this.where == null ? null : this.where.get(key);
        }
        if (key == null || this.where == null) {
            return null;
        }
        Map<String, Object> map = this.where;
        synchronized (map) {
            if (this.where != null) {
                for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                    String k = entry.getKey();
                    int index = k.indexOf(key);
                    if (index < 0 || StringUtil.isName(k.substring(index))) continue;
                    return entry.getValue();
                }
            }
        }
        return null;
    }

    @Override
    public AbstractSQLConfig putWhere(String key, Object value, boolean prior) {
        if (key != null) {
            if (this.where == null) {
                this.where = new LinkedHashMap<String, Object>();
            }
            if (value == null) {
                this.where.remove(key);
            } else {
                this.where.put(key, value);
            }
            this.combine = this.getCombine();
            List<String> andList = this.combine.get("&");
            if (value == null) {
                if (andList != null) {
                    andList.remove(key);
                }
            } else if (andList == null || !andList.contains(key)) {
                int i = 0;
                if (andList == null) {
                    andList = new ArrayList<String>();
                } else if (prior && !andList.isEmpty()) {
                    int lastIndex;
                    String idKey = this.getIdKey();
                    String idInKey = idKey + "{}";
                    String userIdKey = this.getUserIdKey();
                    String userIdInKey = userIdKey + "{}";
                    if (key.equals(idKey)) {
                        lastIndex = -1;
                    } else if (key.equals(idInKey)) {
                        lastIndex = andList.lastIndexOf(idKey);
                    } else if (key.equals(userIdKey)) {
                        lastIndex = andList.lastIndexOf(idInKey);
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idKey);
                        }
                    } else if (key.equals(userIdInKey)) {
                        lastIndex = andList.lastIndexOf(userIdKey);
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idInKey);
                        }
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idKey);
                        }
                    } else {
                        lastIndex = andList.lastIndexOf(userIdInKey);
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(userIdKey);
                        }
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idInKey);
                        }
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idKey);
                        }
                    }
                    i = lastIndex + 1;
                }
                if (prior) {
                    andList.add(i, key);
                } else {
                    andList.add(key);
                }
            }
            this.combine.put("&", andList);
        }
        return this;
    }

    @Override
    @JSONField(serialize=false)
    public String getWhereString(boolean hasPrefix) throws Exception {
        return this.getWhereString(hasPrefix, this.getMethod(), this.getWhere(), this.getCombine(), this.getJoinList(), !this.isTest());
    }

    @JSONField(serialize=false)
    public String getWhereString(boolean hasPrefix, RequestMethod method, Map<String, Object> where, Map<String, List<String>> combine, List<Join> joinList, boolean verifyName) throws Exception {
        String s;
        int logic;
        Set<Map.Entry<String, List<String>>> combineSet;
        Set<Map.Entry<String, List<String>>> set = combineSet = combine == null ? null : combine.entrySet();
        if (combineSet == null || combineSet.isEmpty()) {
            Log.w(TAG, "getWhereString  combineSet == null || combineSet.isEmpty() >> return \"\";");
            return "";
        }
        String whereString = "";
        boolean isCombineFirst = true;
        for (Map.Entry<String, List<String>> ce : combineSet) {
            List<String> keyList = ce == null ? null : ce.getValue();
            if (keyList == null || keyList.isEmpty()) continue;
            logic = "|".equals(ce.getKey()) ? 0 : ("!".equals(ce.getKey()) ? 2 : 1);
            boolean isItemFirst = true;
            String cs = "";
            for (String key : keyList) {
                String c = this.getWhereItem(key, where.get(key), method, verifyName);
                if (StringUtil.isEmpty(c, true)) continue;
                cs = cs + (isItemFirst ? "" : (Logic.isAnd(logic) ? " AND " : " OR ")) + "(" + c + ")";
                isItemFirst = false;
            }
            if (StringUtil.isEmpty(cs, true)) continue;
            whereString = whereString + (isCombineFirst ? "" : " AND ") + (Logic.isNot(logic) ? " NOT " : "") + " (  " + cs + "  ) ";
            isCombineFirst = false;
        }
        if (joinList != null) {
            String newWs = "";
            String ws = whereString;
            ArrayList<Object> newPvl = new ArrayList<Object>();
            ArrayList<Object> pvl = new ArrayList<Object>(this.preparedValueList);
            boolean changed = false;
            block19: for (Join j : joinList) {
                String jt;
                switch (jt = j.getJoinType()) {
                    case "*": 
                    case "@": 
                    case "<": 
                    case ">": {
                        continue block19;
                    }
                    case "&": 
                    case "": 
                    case "|": 
                    case "!": 
                    case "^": 
                    case "(": 
                    case ")": {
                        SQLConfig jc = j.getJoinConfig();
                        boolean isMain = jc.isMain();
                        jc.setMain(false).setPrepared(this.isPrepared()).setPreparedValueList(new ArrayList<Object>());
                        String js = jc.getWhereString(false);
                        jc.setMain(isMain);
                        boolean isOuterJoin = "!".equals(jt);
                        boolean isSideJoin = "^".equals(jt);
                        boolean isAntiJoin = "(".equals(jt);
                        boolean isForeignJoin = ")".equals(jt);
                        boolean isWsEmpty = StringUtil.isEmpty(ws, true);
                        if (isWsEmpty) {
                            if (isOuterJoin) {
                                throw new NotExistException("no result for ! OUTER JOIN( ! (A | B) ) when A or B is empty!");
                            }
                            if (isForeignJoin) {
                                throw new NotExistException("no result for ) FOREIGN JOIN( B & ! A ) when A is empty!");
                            }
                        }
                        if (StringUtil.isEmpty(js, true)) {
                            if (isOuterJoin) {
                                throw new NotExistException("no result for ! OUTER JOIN( ! (A | B) ) when A or B is empty!");
                            }
                            if (isAntiJoin) {
                                throw new NotExistException("no result for ( ANTI JOIN( A & ! B ) when B is empty!");
                            }
                            if (isWsEmpty) {
                                if (!isSideJoin) continue block19;
                                throw new NotExistException("no result for ^ SIDE JOIN( ! (A & B) ) when both A and B are empty!");
                            }
                            if (!isSideJoin && !isForeignJoin) continue block19;
                            newWs = newWs + " ( " + AbstractSQLConfig.getCondition(true, ws) + " ) ";
                            newPvl.addAll(pvl);
                            newPvl.addAll(jc.getPreparedValueList());
                            changed = true;
                            continue block19;
                        }
                        if (!StringUtil.isEmpty(newWs, true)) {
                            newWs = newWs + " AND ";
                        }
                        if (isAntiJoin) {
                            newWs = newWs + " ( " + (isWsEmpty ? "" : ws + " AND ") + " NOT " + " ( " + js + " )  ) ";
                        } else if (isForeignJoin) {
                            newWs = newWs + " (  NOT  ( " + ws + " ) ) " + " AND " + " ( " + js + " ) ";
                        } else if (isSideJoin) {
                            newWs = newWs + " ( " + AbstractSQLConfig.getCondition(true, (isWsEmpty ? "" : ws + " AND ") + " ( " + js + " ) ") + " ) ";
                        } else {
                            logic = Logic.getType(jt);
                            newWs = newWs + " ( " + AbstractSQLConfig.getCondition(Logic.isNot(logic), ws + (isWsEmpty ? "" : (Logic.isAnd(logic) ? " AND " : " OR ")) + " ( " + js + " ) ") + " ) ";
                        }
                        newPvl.addAll(pvl);
                        newPvl.addAll(jc.getPreparedValueList());
                        changed = true;
                        continue block19;
                    }
                }
                throw new UnsupportedOperationException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + "\u9519\u8bef\uff01\u4e0d\u652f\u6301 " + jt + " \u7b49 [ @ APP, < LEFT, > RIGHT, * CROSS, & INNER, | FULL, ! OUTER, ^ SIDE, ( ANTI, ) FOREIGN ] \u4e4b\u5916\u7684 JOIN \u7c7b\u578b !");
            }
            if (changed) {
                whereString = newWs;
                this.preparedValueList = newPvl;
            }
        }
        String string = StringUtil.isEmpty(whereString, true) ? "" : (s = (hasPrefix ? " WHERE " : "") + whereString);
        if (s.isEmpty() && !RequestMethod.isQueryMethod(method)) {
            throw new UnsupportedOperationException("\u5199\u64cd\u4f5c\u8bf7\u6c42\u5fc5\u987b\u5e26\u6761\u4ef6\uff01\uff01\uff01");
        }
        return s;
    }

    protected String getWhereItem(String key, Object value, RequestMethod method, boolean verifyName) throws Exception {
        Log.d(TAG, "getWhereItem  key = " + key);
        if (key == null || value == null || key.endsWith("()") || key.startsWith("@")) {
            Log.d(TAG, "getWhereItem  key == null || value == null || key.startsWith(@) || key.endsWith(()) >> continue;");
            return null;
        }
        if (key.endsWith("@")) {
            throw new IllegalArgumentException("AbstractSQLConfig.getWhereItem: \u5b57\u7b26 " + key + " \u4e0d\u5408\u6cd5\uff01");
        }
        String rawSQL = this.getRawSQL(key, value);
        int keyType = key.endsWith("$") ? 1 : (key.endsWith("~") ? (key.charAt(key.length() - 2) == '*' ? -2 : 2) : (key.endsWith("%") ? 3 : (key.endsWith("{}") ? 4 : (key.endsWith("}{") ? 5 : (key.endsWith("<>") ? 6 : (key.endsWith(">=") ? 7 : (key.endsWith("<=") ? 8 : (key.endsWith(">") ? 9 : (key.endsWith("<") ? 10 : 0)))))))));
        key = AbstractSQLConfig.getRealKey(method, key, false, true, verifyName);
        switch (keyType) {
            case 1: {
                return this.getSearchString(key, value, rawSQL);
            }
            case -2: 
            case 2: {
                return this.getRegExpString(key, value, keyType < 0, rawSQL);
            }
            case 3: {
                return this.getBetweenString(key, value, rawSQL);
            }
            case 4: {
                return this.getRangeString(key, value, rawSQL);
            }
            case 5: {
                return this.getExistsString(key, value, rawSQL);
            }
            case 6: {
                return this.getContainString(key, value, rawSQL);
            }
            case 7: {
                return this.getCompareString(key, value, ">=", rawSQL);
            }
            case 8: {
                return this.getCompareString(key, value, "<=", rawSQL);
            }
            case 9: {
                return this.getCompareString(key, value, ">", rawSQL);
            }
            case 10: {
                return this.getCompareString(key, value, "<", rawSQL);
            }
        }
        return this.getEqualString(key, value, rawSQL);
    }

    @JSONField(serialize=false)
    public String getEqualString(String key, Object value, String rawSQL) throws Exception {
        if (!JSON.isBooleanOrNumberOrString(value) && !(value instanceof Subquery)) {
            throw new IllegalArgumentException(key + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u975ePUT\u8bf7\u6c42\u53ea\u652f\u6301 [Boolean, Number, String] \u5185\u7684\u7c7b\u578b \uff01");
        }
        boolean not = key.endsWith("!");
        if (not) {
            key = key.substring(0, key.length() - 1);
        }
        if (!StringUtil.isName(key)) {
            throw new IllegalArgumentException(key + ":value \u4e2dkey\u4e0d\u5408\u6cd5\uff01\u4e0d\u652f\u6301 ! \u4ee5\u5916\u7684\u903b\u8f91\u7b26 \uff01");
        }
        return this.getKey(key) + (not ? " != " : " = ") + (value instanceof Subquery ? this.getSubqueryString((Subquery)value) : (rawSQL != null ? rawSQL : this.getValue(value)));
    }

    @JSONField(serialize=false)
    public String getCompareString(String key, Object value, String type, String rawSQL) throws Exception {
        if (!JSON.isBooleanOrNumberOrString(value) && !(value instanceof Subquery)) {
            throw new IllegalArgumentException(key + type + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u6bd4\u8f83\u8fd0\u7b97 [>, <, >=, <=] \u53ea\u652f\u6301 [Boolean, Number, String] \u5185\u7684\u7c7b\u578b \uff01");
        }
        if (!StringUtil.isName(key)) {
            throw new IllegalArgumentException(key + type + ":value \u4e2dkey\u4e0d\u5408\u6cd5\uff01\u6bd4\u8f83\u8fd0\u7b97 [>, <, >=, <=] \u4e0d\u652f\u6301 [&, !, |] \u4e2d\u4efb\u4f55\u903b\u8f91\u8fd0\u7b97\u7b26 \uff01");
        }
        return this.getKey(key) + " " + type + " " + (value instanceof Subquery ? this.getSubqueryString((Subquery)value) : (rawSQL != null ? rawSQL : this.getValue(value)));
    }

    public String getKey(String key) {
        if (this.isTest()) {
            if (key.contains("'")) {
                throw new IllegalArgumentException("\u53c2\u6570 " + key + " \u4e0d\u5408\u6cd5\uff01key \u4e2d\u4e0d\u5141\u8bb8\u6709\u5355\u5f15\u53f7 ' \uff01");
            }
            return this.getSQLValue(key).toString();
        }
        return this.getSQLKey(key);
    }

    public String getSQLKey(String key) {
        String q = this.getQuote();
        return (this.isKeyPrefix() ? this.getAliasWithQuote() + "." : "") + q + key + q;
    }

    protected Object getValue(@NotNull Object value) {
        if (this.isPrepared()) {
            this.preparedValueList.add(value);
            return "?";
        }
        return this.getSQLValue(value);
    }

    public Object getSQLValue(@NotNull Object value) {
        return value instanceof Number || value instanceof Boolean ? value : "'" + value + "'";
    }

    @Override
    public List<Object> getPreparedValueList() {
        return this.preparedValueList;
    }

    @Override
    public AbstractSQLConfig setPreparedValueList(List<Object> preparedValueList) {
        this.preparedValueList = preparedValueList;
        return this;
    }

    @JSONField(serialize=false)
    public String getSearchString(String key, Object value, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key$ \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getSearchString key = " + key);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getSearchString(key, arr.toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getSearchString(String key, Object[] values, int type) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (!(v instanceof String)) {
                throw new IllegalArgumentException(key + "$:value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u4e3a String \u6216 String[]\uff01");
            }
            if (((String)v).isEmpty()) {
                throw new IllegalArgumentException(key + "$:value \u4e2d value \u503c " + v + "\u662f\u7a7a\u5b57\u7b26\u4e32\uff0c\u6ca1\u6709\u610f\u4e49\uff0c\u4e0d\u5141\u8bb8\u8fd9\u6837\u4f20\uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + this.getLikeString(key, v);
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getLikeString(String key, Object value) {
        return this.getKey(key) + " LIKE " + this.getValue(value);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, Object value, boolean ignoreCase, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key~ \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getRegExpString key = " + key);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getRegExpString(key, arr.toArray(), logic.getType(), ignoreCase);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, Object[] values, int type, boolean ignoreCase) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof String)) {
                throw new IllegalArgumentException(key + "$:value \u4e2dvalue\u7684\u7c7b\u578b\u53ea\u80fd\u4e3aString\u6216String[]\uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + this.getRegExpString(key, (String)values[i], ignoreCase);
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, String value, boolean ignoreCase) {
        if (this.isPostgreSQL()) {
            return this.getKey(key) + " ~" + (ignoreCase ? "* " : " ") + this.getValue(value);
        }
        if (this.isOracle()) {
            return "regexp_like(" + this.getKey(key) + ", " + this.getValue(value) + (ignoreCase ? ", 'i'" : ", 'c'") + ")";
        }
        if (this.isClickHouse()) {
            return "match(" + (ignoreCase ? "lower(" : "") + this.getKey(key) + (ignoreCase ? ")" : "") + ", " + (ignoreCase ? "lower(" : "") + this.getValue(value) + (ignoreCase ? ")" : "") + ")";
        }
        if (this.isHive()) {
            return (ignoreCase ? "lower(" : "") + this.getKey(key) + (ignoreCase ? ")" : "") + " REGEXP " + (ignoreCase ? "lower(" : "") + this.getValue(value) + (ignoreCase ? ")" : "");
        }
        return this.getKey(key) + " REGEXP " + (ignoreCase ? "" : "BINARY ") + this.getValue(value);
    }

    @JSONField(serialize=false)
    public String getBetweenString(String key, Object value, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key% \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getBetweenString key = " + key);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getBetweenString(key, arr.toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getBetweenString(String key, Object[] values, int type) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof String)) {
                throw new IllegalArgumentException(key + "%:value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u4e3a String \u6216 String[] \uff01");
            }
            String[] vs = StringUtil.split((String)values[i]);
            if (vs == null || vs.length != 2) {
                throw new IllegalArgumentException(key + "%:value \u4e2d value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u4e3a String \u65f6\u5fc5\u987b\u5305\u62ec1\u4e2a\u9017\u53f7 , \u4e14\u5de6\u53f3\u4e24\u4fa7\u90fd\u6709\u503c\uff01\u7c7b\u578b\u4e3a String[] \u91cc\u9762\u6bcf\u4e2a\u5143\u7d20\u8981\u7b26\u5408\u524d\u9762\u7c7b\u578b\u4e3a String \u7684\u89c4\u5219 \uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + "(" + this.getBetweenString(key, (Object)vs[0], (Object)vs[1]) + ")";
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getBetweenString(String key, Object start, Object end) throws IllegalArgumentException {
        if (!JSON.isBooleanOrNumberOrString(start) || !JSON.isBooleanOrNumberOrString(end)) {
            throw new IllegalArgumentException(key + "%:value \u4e2d value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u4e3a String \u65f6\u5fc5\u987b\u5305\u62ec1\u4e2a\u9017\u53f7 , \u4e14\u5de6\u53f3\u4e24\u4fa7\u90fd\u6709\u503c\uff01\u7c7b\u578b\u4e3a String[] \u91cc\u9762\u6bcf\u4e2a\u5143\u7d20\u8981\u7b26\u5408\u524d\u9762\u7c7b\u578b\u4e3a String \u7684\u89c4\u5219 \uff01");
        }
        return this.getKey(key) + " BETWEEN " + this.getValue(start) + " AND " + this.getValue(end);
    }

    @JSONField(serialize=false)
    public String getRangeString(String key, Object range, String rawSQL) throws Exception {
        Log.i(TAG, "getRangeString key = " + key);
        if (range == null) {
            throw new NotExistException("AbstractSQLConfiggetRangeString(" + key + ", " + range + ") range == null");
        }
        Logic logic = new Logic(key);
        String k = logic.getKey();
        Log.i(TAG, "getRangeString k = " + k);
        if (range instanceof List) {
            if (rawSQL != null) {
                throw new UnsupportedOperationException("@raw:value \u7684 value \u4e2d " + key + "{} \u4e0d\u5408\u6cd5\uff01Raw SQL \u4e0d\u652f\u6301 key{}:[] \u8fd9\u79cd\u952e\u503c\u5bf9\uff01");
            }
            if (logic.isOr() || logic.isNot()) {
                List l = (List)range;
                if (logic.isNot() && l.isEmpty()) {
                    return "";
                }
                return this.getKey(k) + this.getInString(k, l.toArray(), logic.isNot());
            }
            throw new IllegalArgumentException(key + "{}\":[] \u4e2d {} \u524d\u9762\u7684\u903b\u8f91\u8fd0\u7b97\u7b26\u9519\u8bef\uff01\u53ea\u80fd\u7528'|','!'\u4e2d\u7684\u4e00\u79cd \uff01");
        }
        if (range instanceof String) {
            String[] cs;
            String condition = "";
            String[] stringArray = cs = rawSQL != null ? null : StringUtil.split((String)range, false);
            if (rawSQL != null) {
                int index = rawSQL == null ? -1 : rawSQL.indexOf("(");
                condition = (index >= 0 && index < rawSQL.lastIndexOf(")") ? "" : this.getKey(k) + " ") + rawSQL;
            }
            if (cs != null) {
                for (int i = 0; i < cs.length; ++i) {
                    String c = cs[i];
                    if ("=null".equals(c)) {
                        c = SQL.isNull();
                    } else if ("!=null".equals(c)) {
                        c = SQL.isNull(false);
                    } else if (this.isPrepared() && (c.contains("--") || !PATTERN_RANGE.matcher(c).matches())) {
                        throw new UnsupportedOperationException(key + "{}:value \u7684 value \u4e2d " + c + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b key{}:\"condition\" \u4e2d condition \u5fc5\u987b \u4e3a =null \u6216 !=null \u6216 \u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_RANGE + " \uff01\u4e0d\u5141\u8bb8\u8fde\u7eed\u51cf\u53f7 -- \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                    }
                    int index = c == null ? -1 : c.indexOf("(");
                    condition = condition + (i <= 0 ? "" : (logic.isAnd() ? " AND " : " OR ")) + (index >= 0 && index < c.lastIndexOf(")") ? "" : this.getKey(k) + " ") + c;
                }
            }
            if (condition.isEmpty()) {
                return "";
            }
            return AbstractSQLConfig.getCondition(logic.isNot(), condition);
        }
        if (range instanceof Subquery) {
            return this.getKey(k) + (logic.isNot() ? " NOT " : "") + " IN " + this.getSubqueryString((Subquery)range);
        }
        throw new IllegalArgumentException(key + "{}:range \u7c7b\u578b\u4e3a" + range.getClass().getSimpleName() + "\uff01range \u53ea\u80fd\u662f \u7528','\u5206\u9694\u6761\u4ef6\u7684\u5b57\u7b26\u4e32 \u6216\u8005 \u53ef\u53d6\u9009\u9879JSONArray\uff01");
    }

    @JSONField(serialize=false)
    public String getInString(String key, Object[] in, boolean not) throws NotExistException {
        String condition = "";
        if (in != null) {
            for (int i = 0; i < in.length; ++i) {
                condition = condition + (i > 0 ? "," : "") + this.getValue(in[i]);
            }
        }
        if (condition.isEmpty()) {
            throw new NotExistException("AbstractSQLConfig.getInString(" + key + ", [], " + not + ") >> condition.isEmpty() >> IN()");
        }
        return (not ? " NOT " : "") + " IN (" + condition + ")";
    }

    @JSONField(serialize=false)
    public String getExistsString(String key, Object value, String rawSQL) throws Exception {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key}{ \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        if (!(value instanceof Subquery)) {
            throw new IllegalArgumentException(key + "}{:subquery \u7c7b\u578b\u4e3a" + value.getClass().getSimpleName() + "\uff01subquery \u53ea\u80fd\u662f \u5b50\u67e5\u8be2JSONObejct\uff01");
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getExistsString key = " + key);
        return (logic.isNot() ? " NOT " : "") + " EXISTS " + this.getSubqueryString((Subquery)value);
    }

    @JSONField(serialize=false)
    public String getContainString(String key, Object value, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key<> \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getContainString key = " + key);
        return this.getContainString(key, AbstractSQLConfig.newJSONArray(value).toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getContainString(String key, Object[] childs, int type) throws IllegalArgumentException {
        boolean not = Logic.isNot(type);
        String condition = "";
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                Object c = childs[i];
                if (c == null) continue;
                if (c instanceof JSON) {
                    throw new IllegalArgumentException(key + "<>:value \u4e2dvalue\u7c7b\u578b\u4e0d\u80fd\u4e3aJSON\uff01");
                }
                condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR "));
                if (this.isPostgreSQL()) {
                    condition = condition + this.getKey(key) + " @> " + this.getValue(AbstractSQLConfig.newJSONArray(c));
                    continue;
                }
                if (this.isOracle()) {
                    condition = condition + "json_textcontains(" + this.getKey(key) + ", '$', " + this.getValue(c.toString()) + ")";
                    continue;
                }
                boolean isNum = c instanceof Number;
                String v = (isNum ? "" : "\"") + childs[i] + (isNum ? "" : "\"");
                condition = this.isClickHouse() ? condition + condition + "has(JSONExtractArrayRaw(assumeNotNull(" + this.getKey(key) + ")), " + this.getValue(v) + ")" : condition + "json_contains(" + this.getKey(key) + ", " + this.getValue(v) + ")";
            }
            condition = condition.isEmpty() ? this.getKey(key) + SQL.isNull(true) + " OR " + this.getLikeString(key, "[]") : this.getKey(key) + SQL.isNull(false) + " AND " + "(" + condition + ")";
        }
        if (condition.isEmpty()) {
            return "";
        }
        return AbstractSQLConfig.getCondition(not, condition);
    }

    @Override
    public String getSubqueryString(Subquery subquery) throws Exception {
        String range = subquery.getRange();
        SQLConfig cfg = subquery.getConfig();
        cfg.setPreparedValueList(new ArrayList<Object>());
        String sql = (range == null || range.isEmpty() ? "" : range) + "(" + cfg.getSQL(this.isPrepared()) + ") ";
        this.preparedValueList.addAll(cfg.getPreparedValueList());
        return sql;
    }

    private static String getCondition(boolean not, String condition) {
        return not ? " NOT (" + condition + ")" : condition;
    }

    @NotNull
    public static JSONArray newJSONArray(Object obj) {
        JSONArray array = new JSONArray();
        if (obj != null) {
            if (obj instanceof Collection) {
                array.addAll((Collection)obj);
            } else {
                array.add(obj);
            }
        }
        return array;
    }

    @JSONField(serialize=false)
    public String getSetString() throws Exception {
        return this.getSetString(this.getMethod(), this.getContent(), !this.isTest());
    }

    @JSONField(serialize=false)
    public String getSetString(RequestMethod method, Map<String, Object> content, boolean verifyName) throws Exception {
        Set<String> set = content == null ? null : content.keySet();
        String setString = "";
        if (set != null && set.size() > 0) {
            boolean isFirst = true;
            String idKey = this.getIdKey();
            for (Map.Entry<String, Object> entry : content.entrySet()) {
                String key = entry.getKey();
                if (key == null || idKey.equals(key)) continue;
                int keyType = key.endsWith("+") ? 1 : (key.endsWith("-") ? 2 : 0);
                Object value = entry.getValue();
                key = AbstractSQLConfig.getRealKey(method, key, false, true, verifyName);
                setString = setString + (isFirst ? "" : ", ") + this.getKey(key) + " = " + (keyType == 1 ? this.getAddString(key, value) : (keyType == 2 ? this.getRemoveString(key, value) : this.getValue(value)));
                isFirst = false;
            }
        }
        if (setString.isEmpty()) {
            throw new IllegalArgumentException("PUT \u8bf7\u6c42\u5fc5\u987b\u5728Table\u5185\u8bbe\u7f6e\u8981\u4fee\u6539\u7684 key:value \uff01");
        }
        return (this.isClickHouse() ? " " : " SET ") + setString;
    }

    @JSONField(serialize=false)
    public String getAddString(String key, Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return this.getKey(key) + " + " + value;
        }
        if (value instanceof String) {
            return SQL.concat(this.getKey(key), (String)this.getValue(value));
        }
        throw new IllegalArgumentException(key + "+ \u5bf9\u5e94\u7684\u503c " + value + " \u4e0d\u662fNumber,String,Array\u4e2d\u7684\u4efb\u4f55\u4e00\u79cd\uff01");
    }

    @JSONField(serialize=false)
    public String getRemoveString(String key, Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return this.getKey(key) + " - " + value;
        }
        if (value instanceof String) {
            return SQL.replace(this.getKey(key), (String)this.getValue(value), "''");
        }
        throw new IllegalArgumentException(key + "- \u5bf9\u5e94\u7684\u503c " + value + " \u4e0d\u662fNumber,String,Array\u4e2d\u7684\u4efb\u4f55\u4e00\u79cd\uff01");
    }

    @Override
    @JSONField(serialize=false)
    public String getSQL(boolean prepared) throws Exception {
        return AbstractSQLConfig.getSQL(this.setPrepared(prepared));
    }

    public static String getSQL(AbstractSQLConfig config) throws Exception {
        String explain;
        if (config == null) {
            Log.i(TAG, "getSQL  config == null >> return null;");
            return null;
        }
        String sch = config.getSQLSchema();
        if (StringUtil.isNotEmpty(config.getProcedure(), true)) {
            String q = config.getQuote();
            return "CALL " + q + sch + q + "." + config.getProcedure();
        }
        String tablePath = config.getTablePath();
        if (!StringUtil.isNotEmpty(tablePath, true)) {
            Log.i(TAG, "getSQL  StringUtil.isNotEmpty(tablePath, true) == false >> return null;");
            return null;
        }
        switch (config.getMethod()) {
            case POST: {
                return "INSERT INTO " + tablePath + config.getColumnString() + " VALUES" + config.getValuesString();
            }
            case PUT: {
                if (config.isClickHouse()) {
                    return "ALTER TABLE " + tablePath + " UPDATE" + config.getSetString() + config.getWhereString(true);
                }
                return "UPDATE " + tablePath + config.getSetString() + config.getWhereString(true) + (config.isMySQL() ? config.getLimitString() : "");
            }
            case DELETE: {
                if (config.isClickHouse()) {
                    return "ALTER TABLE " + tablePath + " DELETE" + config.getWhereString(true);
                }
                return "DELETE FROM " + tablePath + config.getWhereString(true) + (config.isMySQL() ? config.getLimitString() : "");
            }
        }
        String string = config.isExplain() ? (config.isSQLServer() || config.isOracle() ? "SET STATISTICS PROFILE ON  " : "EXPLAIN ") : (explain = "");
        if (config.isTest() && RequestMethod.isGetMethod(config.getMethod(), true)) {
            String q = config.getQuote();
            return explain + "SELECT " + config.getWhereString(false) + " AS " + q + "count" + q + config.getLimitString();
        }
        config.setPreparedValueList((List)new ArrayList());
        String column = config.getColumnString();
        if (config.isOracle()) {
            if ((config.getMethod() == RequestMethod.HEAD || config.getMethod() == RequestMethod.HEADS) && StringUtil.isNotEmpty(config.getGroup(), true)) {
                return explain + "SELECT count(*) FROM (SELECT " + (config.getCache() == 2 ? "SQL_NO_CACHE " : "") + column + " FROM " + AbstractSQLConfig.getConditionString(column, tablePath, config) + ") " + config.getLimitString();
            }
            return explain + "SELECT * FROM (SELECT " + (config.getCache() == 2 ? "SQL_NO_CACHE " : "") + column + " FROM " + AbstractSQLConfig.getConditionString(column, tablePath, config) + ") " + config.getLimitString();
        }
        return explain + "SELECT " + (config.getCache() == 2 ? "SQL_NO_CACHE " : "") + column + " FROM " + AbstractSQLConfig.getConditionString(column, tablePath, config) + config.getLimitString();
    }

    private static String getConditionString(String column, String table, AbstractSQLConfig config) throws Exception {
        String where = config.getWhereString(true);
        Subquery from = config.getFrom();
        if (from != null) {
            table = config.getSubqueryString(from) + " AS " + config.getAliasWithQuote() + " ";
        }
        String aggregation = "";
        if (RequestMethod.isGetMethod(config.getMethod(), true)) {
            aggregation = config.getGroupString(true) + config.getHavingString(true) + config.getOrderString(true);
        }
        if (RequestMethod.isHeadMethod(config.getMethod(), true)) {
            aggregation = config.getGroupString(true) + config.getHavingString(true);
        }
        if (config.getMethod() == RequestMethod.PUT || config.getMethod() == RequestMethod.DELETE) {
            aggregation = config.getHavingString(true);
        }
        String condition = table + config.getJoinString() + where + aggregation;
        return condition;
    }

    @Override
    public boolean isKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public AbstractSQLConfig setKeyPrefix(boolean keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public String getJoinString() throws Exception {
        String joinOns = "";
        if (this.joinList != null) {
            String quote = this.getQuote();
            ArrayList<Object> pvl = new ArrayList<Object>();
            boolean changed = false;
            String sql = null;
            for (Join j : this.joinList) {
                if (j.isAppJoin()) continue;
                String type = j.getJoinType();
                SQLConfig jc = j.getJoinConfig();
                jc.setPrepared(this.isPrepared());
                String jt = StringUtil.isEmpty(jc.getAlias(), true) ? jc.getTable() : jc.getAlias();
                String tt = j.getTargetTable();
                switch (type) {
                    case "*": {
                        this.onGetCrossJoinString(j);
                    }
                    case "<": 
                    case ">": {
                        jc.setMain(true).setKeyPrefix(false);
                        sql = ("<".equals(type) ? " LEFT" : (">".equals(type) ? " RIGHT" : " CROSS")) + " JOIN ( " + jc.getSQL(this.isPrepared()) + " ) AS " + quote + jt + quote + " ON " + quote + jt + quote + "." + quote + j.getKey() + quote + " = " + quote + tt + quote + "." + quote + j.getTargetKey() + quote;
                        jc.setMain(false).setKeyPrefix(true);
                        pvl.addAll(jc.getPreparedValueList());
                        changed = true;
                        break;
                    }
                    case "&": 
                    case "": 
                    case "|": 
                    case "!": 
                    case "^": 
                    case "(": 
                    case ")": {
                        sql = " INNER JOIN " + jc.getTablePath() + " ON " + quote + jt + quote + "." + quote + j.getKey() + quote + " = " + quote + tt + quote + "." + quote + j.getTargetKey() + quote;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + "\u9519\u8bef\uff01\u4e0d\u652f\u6301 " + jt + " \u7b49 [ @ APP, < LEFT, > RIGHT, * CROSS, & INNER, | FULL, ! OUTER, ^ SIDE, ( ANTI, ) FOREIGN ] \u4e4b\u5916\u7684 JOIN \u7c7b\u578b !");
                    }
                }
                joinOns = joinOns + "  \n  " + sql;
            }
            if (changed) {
                pvl.addAll(this.preparedValueList);
                this.preparedValueList = pvl;
            }
        }
        return joinOns;
    }

    protected void onGetCrossJoinString(Join j) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("\u5df2\u7981\u7528 * CROSS JOIN \uff01\u6027\u80fd\u5f88\u5dee\u3001\u9700\u6c42\u6781\u5c11\uff0c\u5982\u8981\u53d6\u6d88\u7981\u7528\u53ef\u5728\u540e\u7aef\u91cd\u5199\u76f8\u5173\u65b9\u6cd5\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLConfig newSQLConfig(RequestMethod method, String table, String alias, com.alibaba.fastjson.JSONObject request, List<Join> joinList, boolean isProcedure, Callback callback) throws Exception {
        Object id;
        boolean hasId;
        if (request == null) {
            throw new NullPointerException("AbstractSQLConfig: newSQLConfig  request == null!");
        }
        boolean explain = request.getBooleanValue("@explain");
        if (explain && !Log.DEBUG) {
            throw new UnsupportedOperationException("DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4f20 @explain \uff01");
        }
        String database = request.getString("@database");
        if (!StringUtil.isEmpty(database, false) && !DATABASE_LIST.contains(database)) {
            throw new UnsupportedDataTypeException("@database:value \u4e2d value \u9519\u8bef\uff0c\u53ea\u80fd\u662f [" + StringUtil.getString(DATABASE_LIST.toArray()) + "] \u4e2d\u7684\u4e00\u79cd\uff01");
        }
        String schema = request.getString("@schema");
        String datasource = request.getString("@datasource");
        SQLConfig config = callback.getSQLConfig(method, database, schema, table);
        config.setAlias(alias);
        config.setDatabase(database);
        config.setSchema(schema);
        config.setDatasource(datasource);
        if (isProcedure) {
            return config;
        }
        config = AbstractSQLConfig.parseJoin(method, config, joinList, callback);
        if (request.isEmpty()) {
            return config;
        }
        String idKey = callback.getIdKey(datasource, database, schema, table);
        String idInKey = idKey + "{}";
        String userIdKey = callback.getUserIdKey(datasource, database, schema, table);
        String userIdInKey = userIdKey + "{}";
        ArrayList idIn = request.get((Object)idInKey);
        if (idIn instanceof List) {
            List ids = idIn;
            ArrayList newIdIn = new ArrayList();
            for (int i = 0; i < ids.size(); ++i) {
                Object d = ids.get(i);
                if ((!(d instanceof Number) || ((Number)d).longValue() <= 0L) && (!(d instanceof String) || !StringUtil.isNotEmpty(d, true))) continue;
                newIdIn.add(d);
            }
            if (newIdIn.isEmpty()) {
                throw new NotExistException("AbstractSQLConfig: newSQLConfig idIn instanceof List >> \u53bb\u6389\u65e0\u6548 id \u540e newIdIn.isEmpty()");
            }
            idIn = newIdIn;
            if (method == RequestMethod.DELETE || method == RequestMethod.PUT) {
                config.setCount(newIdIn.size());
            }
        }
        boolean bl = hasId = (id = request.get((Object)idKey)) != null;
        if (method == RequestMethod.POST && !hasId) {
            id = callback.newId(method, database, schema, table);
        }
        if (id != null) {
            if (id instanceof Number) {
                if (((Number)id).longValue() <= 0L) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig " + table + ".id <= 0");
                }
            } else if (id instanceof String) {
                if (StringUtil.isEmpty(id, true)) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig StringUtil.isEmpty(" + table + ".id, true)");
                }
            } else if (!(id instanceof Subquery)) {
                throw new IllegalArgumentException(idKey + ":value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u662f Long\u00a0, String \u6216 Subquery \uff01");
            }
            if (idIn instanceof List) {
                boolean contains = false;
                List ids = idIn;
                for (int i = 0; i < ids.size(); ++i) {
                    Object d = ids.get(i);
                    if (d == null || !id.toString().equals(d.toString())) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig  idIn != null && (((List<?>) idIn).contains(id) == false");
                }
            }
            if (method == RequestMethod.DELETE || method == RequestMethod.PUT) {
                config.setCount(1);
            }
        }
        String role = request.getString("@role");
        String cache = request.getString("@cache");
        String combine = request.getString("@combine");
        Subquery from = (Subquery)request.get((Object)"@from");
        String column = request.getString("@column");
        String group = request.getString("@group");
        String having = request.getString("@having");
        String order = request.getString("@order");
        String raw = request.getString("@raw");
        String json = request.getString("@json");
        try {
            String[] fks;
            boolean distinct;
            request.remove((Object)idKey);
            request.remove((Object)idInKey);
            request.remove((Object)"@role");
            request.remove((Object)"@explain");
            request.remove((Object)"@cache");
            request.remove((Object)"@datasource");
            request.remove((Object)"@database");
            request.remove((Object)"@schema");
            request.remove((Object)"@combine");
            request.remove((Object)"@from");
            request.remove((Object)"@column");
            request.remove((Object)"@group");
            request.remove((Object)"@having");
            request.remove((Object)"@order");
            request.remove((Object)"@raw");
            request.remove((Object)"@json");
            String[] rawArr = StringUtil.split(raw);
            config.setRaw(rawArr == null || rawArr.length <= 0 ? null : new ArrayList<String>(Arrays.asList(rawArr)));
            LinkedHashMap<String, Object> tableWhere = new LinkedHashMap<String, Object>();
            Set set = request.keySet();
            if (method == RequestMethod.POST) {
                if (idIn != null) {
                    throw new IllegalArgumentException("POST \u8bf7\u6c42\u4e2d\u4e0d\u5141\u8bb8\u4f20 " + idInKey + " !");
                }
                if (set != null && !set.isEmpty()) {
                    List<Object> items;
                    Object[] values;
                    Object[] columns = set.toArray(new String[0]);
                    Collection valueCollection = request.values();
                    Object[] objectArray = values = valueCollection == null ? null : valueCollection.toArray();
                    if (values == null || values.length != columns.length) {
                        throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef:\nAbstractSQLConfig newSQLConfig  values == null || values.length != columns.length !");
                    }
                    column = (id == null ? "" : idKey + ",") + StringUtil.getString(columns);
                    ArrayList<List<Object>> valuess = new ArrayList<List<Object>>(1);
                    if (id == null) {
                        items = Arrays.asList(values);
                    } else {
                        int size = columns.length + (id == null ? 0 : 1);
                        items = new ArrayList<Object>(size);
                        items.add(id);
                        for (int j = 1; j < size; ++j) {
                            items.add(values[j - 1]);
                        }
                    }
                    valuess.add(items);
                    config.setValues(valuess);
                }
            } else {
                String[] ws;
                boolean isWhere = method != RequestMethod.PUT;
                ArrayList<String> whereList = null;
                LinkedHashMap<String, List<String>> combineMap = new LinkedHashMap<String, List<String>>();
                ArrayList<String> andList = new ArrayList<String>();
                ArrayList<String> orList = new ArrayList<String>();
                ArrayList<String> notList = new ArrayList<String>();
                if (id != null) {
                    tableWhere.put(idKey, id);
                    andList.add(idKey);
                }
                if (idIn != null) {
                    tableWhere.put(idInKey, idIn);
                    andList.add(idInKey);
                }
                if ((ws = StringUtil.split(combine)) != null) {
                    if (method == RequestMethod.DELETE || method == RequestMethod.GETS || method == RequestMethod.HEADS) {
                        throw new IllegalArgumentException("DELETE,GETS,HEADS \u8bf7\u6c42\u4e0d\u5141\u8bb8\u4f20 @combine:value !");
                    }
                    whereList = new ArrayList<String>();
                    for (int i = 0; i < ws.length; ++i) {
                        String w = ws[i];
                        if (w != null) {
                            if (w.startsWith("&")) {
                                w = w.substring(1);
                                andList.add(w);
                            } else if (w.startsWith("|")) {
                                if (method == RequestMethod.PUT) {
                                    throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01PUT\u8bf7\u6c42\u7684 @combine:\"key0,key1,...\" \u4e0d\u5141\u8bb8\u4f20 |key \u6216 !key !");
                                }
                                w = w.substring(1);
                                orList.add(w);
                            } else if (w.startsWith("!")) {
                                if (method == RequestMethod.PUT) {
                                    throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01PUT\u8bf7\u6c42\u7684 @combine:\"key0,key1,...\" \u4e0d\u5141\u8bb8\u4f20 |key \u6216 !key !");
                                }
                                w = w.substring(1);
                                notList.add(w);
                            } else {
                                orList.add(w);
                            }
                            if (w.isEmpty()) {
                                throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u503c\uff01");
                            }
                            if (idKey.equals(w) || idInKey.equals(w) || userIdKey.equals(w) || userIdInKey.equals(w)) {
                                throw new UnsupportedOperationException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc " + ws[i] + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20 [" + idKey + ", " + idInKey + ", " + userIdKey + ", " + userIdInKey + "] \u5176\u4e2d\u4efb\u4f55\u4e00\u4e2a\uff01");
                            }
                            whereList.add(w);
                        }
                        if (request.containsKey((Object)w)) continue;
                        callback.onMissingKey4Combine(table, request, combine, ws[i], w);
                    }
                }
                LinkedHashMap<String, Object> tableContent = new LinkedHashMap<String, Object>();
                for (String key : set) {
                    Object value = request.get((Object)key);
                    if (value instanceof Map) {
                        throw new IllegalArgumentException("\u4e0d\u5141\u8bb8 " + key + " \u7b49\u4efb\u4f55key\u7684value\u7c7b\u578b\u4e3a {JSONObject} !");
                    }
                    if (isWhere || !StringUtil.isName(key.replaceFirst("[+-]$", ""))) {
                        tableWhere.put(key, value);
                        if (whereList != null && whereList.contains(key)) continue;
                        andList.add(key);
                        continue;
                    }
                    if (whereList != null && whereList.contains(key)) {
                        tableWhere.put(key, value);
                        continue;
                    }
                    tableContent.put(key, value);
                }
                combineMap.put("&", andList);
                combineMap.put("|", orList);
                combineMap.put("!", notList);
                config.setCombine(combineMap);
                config.setContent(tableContent);
            }
            ArrayList<String> cs = new ArrayList<String>();
            List<String> rawList = config.getRaw();
            boolean containColumnRaw = rawList != null && rawList.contains("@column");
            String rawColumnSQL = null;
            if (containColumnRaw) {
                try {
                    rawColumnSQL = config.getRawSQL("@column", column);
                    if (rawColumnSQL != null) {
                        cs.add(rawColumnSQL);
                    }
                }
                catch (Exception e) {
                    Log.e(TAG, "newSQLConfig  config instanceof AbstractSQLConfig >> try {    rawColumnSQL = ((AbstractSQLConfig) config).getRawSQL(KEY_COLUMN, column); } catch (Exception e) = " + e.getMessage());
                }
            }
            boolean bl2 = distinct = column == null || rawColumnSQL != null ? false : column.startsWith(PREFFIX_DISTINCT);
            if (rawColumnSQL == null && (fks = StringUtil.split(distinct ? column.substring(PREFFIX_DISTINCT.length()) : column, ";")) != null) {
                for (String fk : fks) {
                    if (containColumnRaw) {
                        try {
                            String rawSQL = config.getRawSQL("@column", fk);
                            if (rawSQL != null) {
                                cs.add(rawSQL);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            Log.e(TAG, "newSQLConfig  rawColumnSQL == null >> try {    String rawSQL = ((AbstractSQLConfig) config).getRawSQL(KEY_COLUMN, fk); ... } catch (Exception e) = " + e.getMessage());
                        }
                    }
                    if (fk.contains("(")) {
                        cs.add(fk);
                        continue;
                    }
                    String[] ks = StringUtil.split(fk);
                    if (ks == null || ks.length <= 0) continue;
                    cs.addAll(Arrays.asList(ks));
                }
            }
            config.setExplain(explain);
            config.setCache(AbstractSQLConfig.getCache(cache));
            config.setFrom(from);
            config.setDistinct(distinct);
            config.setColumn(column == null ? null : cs);
            config.setWhere(tableWhere);
            config.setId(id);
            config.setRole(role);
            config.setGroup(group);
            config.setHaving(having);
            config.setOrder(order);
            String[] jsonArr = StringUtil.split(json);
            config.setJson(jsonArr == null || jsonArr.length <= 0 ? null : new ArrayList<String>(Arrays.asList(jsonArr)));
        }
        finally {
            if (hasId) {
                request.put(idKey, id);
            }
            request.put(idInKey, idIn);
            request.put("@database", (Object)database);
            request.put("@role", (Object)role);
            request.put("@explain", (Object)explain);
            request.put("@cache", (Object)cache);
            request.put("@datasource", (Object)datasource);
            request.put("@schema", (Object)schema);
            request.put("@combine", (Object)combine);
            request.put("@from", (Object)from);
            request.put("@column", (Object)column);
            request.put("@group", (Object)group);
            request.put("@having", (Object)having);
            request.put("@order", (Object)order);
            request.put("@raw", (Object)raw);
            request.put("@json", (Object)json);
        }
        return config;
    }

    public static SQLConfig parseJoin(RequestMethod method, SQLConfig config, List<Join> joinList, Callback callback) throws Exception {
        boolean isQuery = RequestMethod.isQueryMethod(method);
        config.setKeyPrefix(isQuery && !config.isMain());
        if (joinList == null || joinList.isEmpty() || !RequestMethod.isQueryMethod(method)) {
            return config;
        }
        for (Join j : joinList) {
            SQLConfig cacheConfig;
            String table = j.getTable();
            String alias = j.getAlias();
            SQLConfig joinConfig = AbstractSQLConfig.newSQLConfig(method, table, alias, j.getRequest(), null, false, callback);
            SQLConfig sQLConfig = cacheConfig = !j.canCacheViceTable() ? null : AbstractSQLConfig.newSQLConfig(method, table, alias, j.getRequest(), null, false, callback).setCount(1);
            if (!j.isAppJoin()) {
                if (joinConfig.getDatabase() == null) {
                    joinConfig.setDatabase(config.getDatabase());
                } else if (!joinConfig.getDatabase().equals(config.getDatabase())) {
                    throw new IllegalArgumentException("\u4e3b\u8868 " + config.getTable() + " \u7684 @database:" + config.getDatabase() + " \u548c\u5b83 SQL JOIN \u7684\u526f\u8868 " + table + " \u7684 @database:" + joinConfig.getDatabase() + " \u4e0d\u4e00\u81f4\uff01");
                }
                if (joinConfig.getSchema() == null) {
                    joinConfig.setSchema(config.getSchema());
                }
                if (cacheConfig != null) {
                    cacheConfig.setDatabase(joinConfig.getDatabase()).setSchema(joinConfig.getSchema());
                }
                if (isQuery) {
                    config.setKeyPrefix(true);
                }
                joinConfig.setMain(false).setKeyPrefix(true);
                if (j.isLeftOrRightJoin()) {
                    SQLConfig outterConfig = AbstractSQLConfig.newSQLConfig(method, table, alias, j.getOuter(), null, false, callback);
                    outterConfig.setMain(false).setKeyPrefix(true).setDatabase(joinConfig.getDatabase()).setSchema(joinConfig.getSchema());
                    j.setOuterConfig(outterConfig);
                }
            }
            if (RequestMethod.isHeadMethod(method, true)) {
                joinConfig.setMethod(RequestMethod.GET);
                joinConfig.setColumn(Arrays.asList(j.getKey()));
                if (cacheConfig != null) {
                    cacheConfig.setMethod(RequestMethod.GET);
                    cacheConfig.setColumn(Arrays.asList(j.getKey()));
                }
            }
            j.setJoinConfig(joinConfig);
            j.setCacheConfig(cacheConfig);
        }
        config.setJoinList(joinList);
        return config;
    }

    public static String getRealKey(RequestMethod method, String originKey, boolean isTableKey, boolean saveLogic) throws Exception {
        return AbstractSQLConfig.getRealKey(method, originKey, isTableKey, saveLogic, true);
    }

    public static String getRealKey(RequestMethod method, String originKey, boolean isTableKey, boolean saveLogic, boolean verifyName) throws Exception {
        Log.i(TAG, "getRealKey  saveLogic = " + saveLogic + "; originKey = " + originKey);
        if (originKey == null || JSONObject.isArrayKey(originKey)) {
            Log.w(TAG, "getRealKey  originKey == null || apijson.JSONObject.isArrayKey(originKey) >>  return originKey;");
            return originKey;
        }
        String key = new String(originKey);
        if (key.endsWith("$")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("~")) {
            if ((key = key.substring(0, key.length() - 1)).endsWith("*")) {
                key = key.substring(0, key.length() - 1);
            }
        } else if (key.endsWith("%")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("{}")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("}{")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("<>")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("()")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("@")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith(">=")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("<=")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith(">")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("<")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("+")) {
            if (method == RequestMethod.PUT) {
                key = key.substring(0, key.length() - 1);
            }
        } else if (key.endsWith("-") && method == RequestMethod.PUT) {
            key = key.substring(0, key.length() - 1);
        }
        String last = null;
        if (RequestMethod.isQueryMethod(method)) {
            String string = last = key.isEmpty() ? "" : key.substring(key.length() - 1);
            if ("&".equals(last) || "|".equals(last) || "!".equals(last)) {
                key = key.substring(0, key.length() - 1);
            } else {
                last = null;
            }
        }
        key = isTableKey ? Pair.parseEntry(key, true).getKey() : Pair.parseEntry(key).getValue();
        if (verifyName && !StringUtil.isName(key.startsWith("@") ? key.substring(1) : key)) {
            throw new IllegalArgumentException((Object)((Object)method) + "\u8bf7\u6c42\uff0c\u5b57\u7b26 " + originKey + " \u4e0d\u5408\u6cd5\uff01 key:value \u4e2d\u7684key\u53ea\u80fd\u5173\u952e\u8bcd '@key' \u6216 'key[\u903b\u8f91\u7b26][\u6761\u4ef6\u7b26]' \u6216 PUT\u8bf7\u6c42\u4e0b\u7684 'key+' / 'key-' \uff01");
        }
        if (saveLogic && last != null) {
            key = key + last;
        }
        Log.i(TAG, "getRealKey  return key = " + key);
        return key;
    }

    static {
        TABLE_KEY_MAP.put(Table.class.getSimpleName(), "tables");
        TABLE_KEY_MAP.put(Column.class.getSimpleName(), "columns");
        TABLE_KEY_MAP.put(PgClass.class.getSimpleName(), "pg_class");
        TABLE_KEY_MAP.put(PgAttribute.class.getSimpleName(), "pg_attribute");
        TABLE_KEY_MAP.put(SysTable.class.getSimpleName(), "tables");
        TABLE_KEY_MAP.put(SysColumn.class.getSimpleName(), "columns");
        TABLE_KEY_MAP.put(ExtendedProperty.class.getSimpleName(), "extended_properties");
        CONFIG_TABLE_LIST = new ArrayList<String>();
        CONFIG_TABLE_LIST.add(Function.class.getSimpleName());
        CONFIG_TABLE_LIST.add(Request.class.getSimpleName());
        CONFIG_TABLE_LIST.add(Access.class.getSimpleName());
        CONFIG_TABLE_LIST.add(Document.class.getSimpleName());
        CONFIG_TABLE_LIST.add(TestRecord.class.getSimpleName());
        DATABASE_LIST = new ArrayList<String>();
        DATABASE_LIST.add("MYSQL");
        DATABASE_LIST.add("POSTGRESQL");
        DATABASE_LIST.add("SQLSERVER");
        DATABASE_LIST.add("ORACLE");
        DATABASE_LIST.add("DB2");
        DATABASE_LIST.add("CLICKHOUSE");
        DATABASE_LIST.add("HIVE");
        RAW_MAP = new LinkedHashMap<String, String>();
        RAW_MAP.put("+", "");
        RAW_MAP.put("-", "");
        RAW_MAP.put("*", "");
        RAW_MAP.put("/", "");
        RAW_MAP.put("=", "");
        RAW_MAP.put("!=", "");
        RAW_MAP.put(">", "");
        RAW_MAP.put(">=", "");
        RAW_MAP.put("<", "");
        RAW_MAP.put("<=", "");
        RAW_MAP.put("%", "");
        RAW_MAP.put("(", "");
        RAW_MAP.put(")", "");
        RAW_MAP.put("AS", "");
        RAW_MAP.put("IS NOT NULL", "");
        RAW_MAP.put("IS NULL", "");
        RAW_MAP.put("IS", "");
        RAW_MAP.put("NULL", "");
        RAW_MAP.put("AND", "");
        RAW_MAP.put("OR", "");
        RAW_MAP.put("NOT", "");
        RAW_MAP.put("VALUE", "");
        RAW_MAP.put("DISTINCT", "");
        RAW_MAP.put("CASE", "");
        RAW_MAP.put("WHEN", "");
        RAW_MAP.put("THEN", "");
        RAW_MAP.put("ELSE", "");
        RAW_MAP.put("END", "");
        RAW_MAP.put("now()", "");
        RAW_MAP.put("DATE", "");
        RAW_MAP.put("TIME", "");
        RAW_MAP.put("DATETIME", "");
        RAW_MAP.put("TIMESTAMP", "");
        RAW_MAP.put("DateTime", "");
        RAW_MAP.put("SECOND", "");
        RAW_MAP.put("MINUTE", "");
        RAW_MAP.put("HOUR", "");
        RAW_MAP.put("DAY", "");
        RAW_MAP.put("WEEK", "");
        RAW_MAP.put("MONTH", "");
        RAW_MAP.put("QUARTER", "");
        RAW_MAP.put("YEAR", "");
        RAW_MAP.put("BINARY", "");
        RAW_MAP.put("SIGNED", "");
        RAW_MAP.put("DECIMAL", "");
        RAW_MAP.put("DOUBLE", "");
        RAW_MAP.put("FLOAT", "");
        RAW_MAP.put("BOOLEAN", "");
        RAW_MAP.put("ENUM", "");
        RAW_MAP.put("SET", "");
        RAW_MAP.put("POINT", "");
        RAW_MAP.put("BLOB", "");
        RAW_MAP.put("LONGBLOB", "");
        RAW_MAP.put("BINARY", "");
        RAW_MAP.put("UNSIGNED", "");
        RAW_MAP.put("BIT", "");
        RAW_MAP.put("TINYINT", "");
        RAW_MAP.put("SMALLINT", "");
        RAW_MAP.put("INT", "");
        RAW_MAP.put("BIGINT", "");
        RAW_MAP.put("CHAR", "");
        RAW_MAP.put("VARCHAR", "");
        RAW_MAP.put("TEXT", "");
        RAW_MAP.put("LONGTEXT", "");
        RAW_MAP.put("JSON", "");
        RAW_MAP.put("OVER", "");
        RAW_MAP.put("INTERVAL", "");
        RAW_MAP.put("GROUP BY", "");
        RAW_MAP.put("GROUP", "");
        RAW_MAP.put("ORDER BY", "");
        RAW_MAP.put("ORDER", "");
        RAW_MAP.put("PARTITION BY", "");
        RAW_MAP.put("PARTITION", "");
        RAW_MAP.put("BY", "");
        RAW_MAP.put("DESC", "");
        RAW_MAP.put("ASC", "");
        RAW_MAP.put("FOLLOWING", "");
        RAW_MAP.put("BETWEEN", "");
        RAW_MAP.put("AND", "");
        RAW_MAP.put("ROWS", "");
        RAW_MAP.put("AGAINST", "");
        RAW_MAP.put("IN NATURAL LANGUAGE MODE", "");
        RAW_MAP.put("IN BOOLEAN MODE", "");
        RAW_MAP.put("IN", "");
        RAW_MAP.put("BOOLEAN", "");
        RAW_MAP.put("NATURAL", "");
        RAW_MAP.put("LANGUAGE", "");
        RAW_MAP.put("MODE", "");
        SQL_FUNCTION_MAP = new LinkedHashMap<String, String>();
        SQL_FUNCTION_MAP.put("rank", "");
        SQL_FUNCTION_MAP.put("dense_rank", "");
        SQL_FUNCTION_MAP.put("row_number", "");
        SQL_FUNCTION_MAP.put("ntile", "");
        SQL_FUNCTION_MAP.put("first_value", "");
        SQL_FUNCTION_MAP.put("last_value", "");
        SQL_FUNCTION_MAP.put("lag", "");
        SQL_FUNCTION_MAP.put("lead", "");
        SQL_FUNCTION_MAP.put("cume_dist", "");
        SQL_FUNCTION_MAP.put("percent_rank", "");
        SQL_FUNCTION_MAP.put("ascii", "");
        SQL_FUNCTION_MAP.put("char_length", "");
        SQL_FUNCTION_MAP.put("character_length", "");
        SQL_FUNCTION_MAP.put("concat", "");
        SQL_FUNCTION_MAP.put("concat_ws", "");
        SQL_FUNCTION_MAP.put("field", "");
        SQL_FUNCTION_MAP.put("find_in_set", "");
        SQL_FUNCTION_MAP.put("format", "");
        SQL_FUNCTION_MAP.put("insert", "");
        SQL_FUNCTION_MAP.put("locate", "");
        SQL_FUNCTION_MAP.put("lcase", "");
        SQL_FUNCTION_MAP.put("left", "");
        SQL_FUNCTION_MAP.put("length", "");
        SQL_FUNCTION_MAP.put("lower", "");
        SQL_FUNCTION_MAP.put("lpad", "");
        SQL_FUNCTION_MAP.put("ltrim", "");
        SQL_FUNCTION_MAP.put("mid", "");
        SQL_FUNCTION_MAP.put("position", "");
        SQL_FUNCTION_MAP.put("repeat", "");
        SQL_FUNCTION_MAP.put("replace", "");
        SQL_FUNCTION_MAP.put("reverse", "");
        SQL_FUNCTION_MAP.put("right", "");
        SQL_FUNCTION_MAP.put("rpad", "");
        SQL_FUNCTION_MAP.put("rtrim", "");
        SQL_FUNCTION_MAP.put("space", "");
        SQL_FUNCTION_MAP.put("strcmp", "");
        SQL_FUNCTION_MAP.put("substr", "");
        SQL_FUNCTION_MAP.put("substring", "");
        SQL_FUNCTION_MAP.put("substring_index", "");
        SQL_FUNCTION_MAP.put("trim", "");
        SQL_FUNCTION_MAP.put("ucase", "");
        SQL_FUNCTION_MAP.put("upper", "");
        SQL_FUNCTION_MAP.put("abs", "");
        SQL_FUNCTION_MAP.put("acos", "");
        SQL_FUNCTION_MAP.put("asin", "");
        SQL_FUNCTION_MAP.put("atan", "");
        SQL_FUNCTION_MAP.put("atan2", "");
        SQL_FUNCTION_MAP.put("avg", "");
        SQL_FUNCTION_MAP.put("ceil", "");
        SQL_FUNCTION_MAP.put("ceiling", "");
        SQL_FUNCTION_MAP.put("cos", "");
        SQL_FUNCTION_MAP.put("cot", "");
        SQL_FUNCTION_MAP.put("count", "");
        SQL_FUNCTION_MAP.put("degrees", "");
        SQL_FUNCTION_MAP.put("div", "");
        SQL_FUNCTION_MAP.put("exp", "");
        SQL_FUNCTION_MAP.put("floor", "");
        SQL_FUNCTION_MAP.put("greatest", "");
        SQL_FUNCTION_MAP.put("least", "");
        SQL_FUNCTION_MAP.put("ln", "");
        SQL_FUNCTION_MAP.put("log", "");
        SQL_FUNCTION_MAP.put("log10", "");
        SQL_FUNCTION_MAP.put("log2", "");
        SQL_FUNCTION_MAP.put("max", "");
        SQL_FUNCTION_MAP.put("min", "");
        SQL_FUNCTION_MAP.put("mod", "");
        SQL_FUNCTION_MAP.put("pi", "");
        SQL_FUNCTION_MAP.put("pow", "");
        SQL_FUNCTION_MAP.put("power", "");
        SQL_FUNCTION_MAP.put("radians", "");
        SQL_FUNCTION_MAP.put("rand", "");
        SQL_FUNCTION_MAP.put("round", "");
        SQL_FUNCTION_MAP.put("sign", "");
        SQL_FUNCTION_MAP.put("sin", "");
        SQL_FUNCTION_MAP.put("sqrt", "");
        SQL_FUNCTION_MAP.put("sum", "");
        SQL_FUNCTION_MAP.put("tan", "");
        SQL_FUNCTION_MAP.put("truncate", "");
        SQL_FUNCTION_MAP.put("adddate", "");
        SQL_FUNCTION_MAP.put("addtime", "");
        SQL_FUNCTION_MAP.put("curdate", "");
        SQL_FUNCTION_MAP.put("current_date", "");
        SQL_FUNCTION_MAP.put("current_time", "");
        SQL_FUNCTION_MAP.put("current_timestamp", "");
        SQL_FUNCTION_MAP.put("curtime", "");
        SQL_FUNCTION_MAP.put("date", "");
        SQL_FUNCTION_MAP.put("datediff", "");
        SQL_FUNCTION_MAP.put("date_add", "");
        SQL_FUNCTION_MAP.put("date_format", "");
        SQL_FUNCTION_MAP.put("date_sub", "");
        SQL_FUNCTION_MAP.put("day", "");
        SQL_FUNCTION_MAP.put("dayname", "");
        SQL_FUNCTION_MAP.put("dayofmonth", "");
        SQL_FUNCTION_MAP.put("dayofweek", "");
        SQL_FUNCTION_MAP.put("dayofyear", "");
        SQL_FUNCTION_MAP.put("extract", "");
        SQL_FUNCTION_MAP.put("from_days", "");
        SQL_FUNCTION_MAP.put("hour", "");
        SQL_FUNCTION_MAP.put("last_day", "");
        SQL_FUNCTION_MAP.put("localtime", "");
        SQL_FUNCTION_MAP.put("localtimestamp", "");
        SQL_FUNCTION_MAP.put("makedate", "");
        SQL_FUNCTION_MAP.put("maketime", "");
        SQL_FUNCTION_MAP.put("microsecond", "");
        SQL_FUNCTION_MAP.put("minute", "");
        SQL_FUNCTION_MAP.put("monthname", "");
        SQL_FUNCTION_MAP.put("month", "");
        SQL_FUNCTION_MAP.put("now", "");
        SQL_FUNCTION_MAP.put("period_add", "");
        SQL_FUNCTION_MAP.put("period_diff", "");
        SQL_FUNCTION_MAP.put("quarter", "");
        SQL_FUNCTION_MAP.put("second", "");
        SQL_FUNCTION_MAP.put("sec_to_time", "");
        SQL_FUNCTION_MAP.put("str_to_date", "");
        SQL_FUNCTION_MAP.put("subdate", "");
        SQL_FUNCTION_MAP.put("subtime", "");
        SQL_FUNCTION_MAP.put("sysdate", "");
        SQL_FUNCTION_MAP.put("time", "");
        SQL_FUNCTION_MAP.put("time_format", "");
        SQL_FUNCTION_MAP.put("time_to_sec", "");
        SQL_FUNCTION_MAP.put("timediff", "");
        SQL_FUNCTION_MAP.put("timestamp", "");
        SQL_FUNCTION_MAP.put("to_days", "");
        SQL_FUNCTION_MAP.put("week", "");
        SQL_FUNCTION_MAP.put("weekday", "");
        SQL_FUNCTION_MAP.put("weekofyear", "");
        SQL_FUNCTION_MAP.put("year", "");
        SQL_FUNCTION_MAP.put("yearweek", "");
        SQL_FUNCTION_MAP.put("unix_timestamp", "");
        SQL_FUNCTION_MAP.put("from_unixtime", "");
        SQL_FUNCTION_MAP.put("json_append", "");
        SQL_FUNCTION_MAP.put("json_array", "");
        SQL_FUNCTION_MAP.put("json_array_append", "");
        SQL_FUNCTION_MAP.put("json_array_insert", "");
        SQL_FUNCTION_MAP.put("json_contains", "");
        SQL_FUNCTION_MAP.put("json_contains_path", "");
        SQL_FUNCTION_MAP.put("json_depth", "");
        SQL_FUNCTION_MAP.put("json_extract", "");
        SQL_FUNCTION_MAP.put("json_insert", "");
        SQL_FUNCTION_MAP.put("json_keys", "");
        SQL_FUNCTION_MAP.put("json_length", "");
        SQL_FUNCTION_MAP.put("json_merge", "");
        SQL_FUNCTION_MAP.put("json_merge_patch", "");
        SQL_FUNCTION_MAP.put("json_merge_preserve", "");
        SQL_FUNCTION_MAP.put("json_object", "");
        SQL_FUNCTION_MAP.put("json_overlaps", "");
        SQL_FUNCTION_MAP.put("json_pretty", "");
        SQL_FUNCTION_MAP.put("json_quote", "");
        SQL_FUNCTION_MAP.put("json_remove", "");
        SQL_FUNCTION_MAP.put("json_replace", "");
        SQL_FUNCTION_MAP.put("json_schema_valid", "");
        SQL_FUNCTION_MAP.put("json_schema_validation_report", "");
        SQL_FUNCTION_MAP.put("json_search", "");
        SQL_FUNCTION_MAP.put("json_set", "");
        SQL_FUNCTION_MAP.put("json_table", "");
        SQL_FUNCTION_MAP.put("json_type", "");
        SQL_FUNCTION_MAP.put("json_unquote", "");
        SQL_FUNCTION_MAP.put("json_valid", "");
        SQL_FUNCTION_MAP.put("json_arrayagg", "");
        SQL_FUNCTION_MAP.put("json_objectagg", "");
        SQL_FUNCTION_MAP.put("case", "");
        SQL_FUNCTION_MAP.put("cast", "");
        SQL_FUNCTION_MAP.put("coalesce", "");
        SQL_FUNCTION_MAP.put("if", "");
        SQL_FUNCTION_MAP.put("ifnull", "");
        SQL_FUNCTION_MAP.put("isnull", "");
        SQL_FUNCTION_MAP.put("nullif", "");
        SQL_FUNCTION_MAP.put("group_concat", "");
        SQL_FUNCTION_MAP.put("match", "");
        SQL_FUNCTION_MAP.put("empty", "");
        SQL_FUNCTION_MAP.put("notEmpty", "");
        SQL_FUNCTION_MAP.put("lengthUTF8", "");
        SQL_FUNCTION_MAP.put("lcase", "");
        SQL_FUNCTION_MAP.put("ucase", "");
        SQL_FUNCTION_MAP.put("lowerUTF8", "");
        SQL_FUNCTION_MAP.put("upperUTF8", "");
        SQL_FUNCTION_MAP.put("isValidUTF8", "");
        SQL_FUNCTION_MAP.put("toValidUTF8", "");
        SQL_FUNCTION_MAP.put("reverseUTF8", "");
        SQL_FUNCTION_MAP.put("concatAssumeInjective", "");
        SQL_FUNCTION_MAP.put("substringUTF8", "");
        SQL_FUNCTION_MAP.put("appendTrailingCharIfAbsent", "");
        SQL_FUNCTION_MAP.put("convertCharset", "");
        SQL_FUNCTION_MAP.put("base64Encode", "");
        SQL_FUNCTION_MAP.put("base64Decode", "");
        SQL_FUNCTION_MAP.put("tryBase64Decode", "");
        SQL_FUNCTION_MAP.put("endsWith", "");
        SQL_FUNCTION_MAP.put("startsWith", "");
        SQL_FUNCTION_MAP.put("trimLeft", "");
        SQL_FUNCTION_MAP.put("trimRight", "");
        SQL_FUNCTION_MAP.put("trimBoth", "");
        SQL_FUNCTION_MAP.put("extractAllGroups", "");
        SQL_FUNCTION_MAP.put("normalizeQuery", "");
        SQL_FUNCTION_MAP.put("normalizedQueryHash", "");
        SQL_FUNCTION_MAP.put("positionUTF8", "");
        SQL_FUNCTION_MAP.put("multiSearchFirstIndex", "");
        SQL_FUNCTION_MAP.put("multiSearchAny", "");
        SQL_FUNCTION_MAP.put("match", "");
        SQL_FUNCTION_MAP.put("multiMatchAny", "");
        SQL_FUNCTION_MAP.put("multiMatchAnyIndex", "");
        SQL_FUNCTION_MAP.put("extract", "");
        SQL_FUNCTION_MAP.put("extractAll", "");
        SQL_FUNCTION_MAP.put("like", "");
        SQL_FUNCTION_MAP.put("notLike", "");
        SQL_FUNCTION_MAP.put("countSubstrings", "");
        SQL_FUNCTION_MAP.put("countMatches", "");
        SQL_FUNCTION_MAP.put("replaceOne", "");
        SQL_FUNCTION_MAP.put("replaceAll", "");
        SQL_FUNCTION_MAP.put("replaceRegexpOne", "");
        SQL_FUNCTION_MAP.put("replaceRegexpAll", "");
        SQL_FUNCTION_MAP.put("regexpQuoteMeta", "");
        SQL_FUNCTION_MAP.put("toYear", "");
        SQL_FUNCTION_MAP.put("toQuarter", "");
        SQL_FUNCTION_MAP.put("toMonth", "");
        SQL_FUNCTION_MAP.put("toDayOfYear", "");
        SQL_FUNCTION_MAP.put("toDayOfMonth", "");
        SQL_FUNCTION_MAP.put("toDayOfWeek", "");
        SQL_FUNCTION_MAP.put("toHour", "");
        SQL_FUNCTION_MAP.put("toMinute", "");
        SQL_FUNCTION_MAP.put("toSecond", "");
        SQL_FUNCTION_MAP.put("toUnixTimestamp", "");
        SQL_FUNCTION_MAP.put("toStartOfYear", "");
        SQL_FUNCTION_MAP.put("toStartOfISOYear", "");
        SQL_FUNCTION_MAP.put("toStartOfQuarter", "");
        SQL_FUNCTION_MAP.put("toStartOfMonth", "");
        SQL_FUNCTION_MAP.put("toMonday", "");
        SQL_FUNCTION_MAP.put("toStartOfWeek", "");
        SQL_FUNCTION_MAP.put("toStartOfDay", "");
        SQL_FUNCTION_MAP.put("toStartOfHour", "");
        SQL_FUNCTION_MAP.put("toStartOfMinute", "");
        SQL_FUNCTION_MAP.put("toStartOfSecond", "");
        SQL_FUNCTION_MAP.put("toStartOfFiveMinute", "");
        SQL_FUNCTION_MAP.put("toStartOfTenMinutes", "");
        SQL_FUNCTION_MAP.put("toStartOfFifteenMinutes", "");
        SQL_FUNCTION_MAP.put("toStartOfInterval", "");
        SQL_FUNCTION_MAP.put("toTime", "");
        SQL_FUNCTION_MAP.put("toISOYear", "");
        SQL_FUNCTION_MAP.put("toISOWeek", "");
        SQL_FUNCTION_MAP.put("toWeek", "");
        SQL_FUNCTION_MAP.put("toYearWeek", "");
        SQL_FUNCTION_MAP.put("date_trunc", "");
        SQL_FUNCTION_MAP.put("date_diff", "");
        SQL_FUNCTION_MAP.put("yesterday", "");
        SQL_FUNCTION_MAP.put("today", "");
        SQL_FUNCTION_MAP.put("timeSlot", "");
        SQL_FUNCTION_MAP.put("toYYYYMM", "");
        SQL_FUNCTION_MAP.put("toYYYYMMDD", "");
        SQL_FUNCTION_MAP.put("toYYYYMMDDhhmmss", "");
        SQL_FUNCTION_MAP.put("addYears", "");
        SQL_FUNCTION_MAP.put("addMonths", "");
        SQL_FUNCTION_MAP.put("addWeeks", "");
        SQL_FUNCTION_MAP.put("addDays", "");
        SQL_FUNCTION_MAP.put("addHours", "");
        SQL_FUNCTION_MAP.put("addMinutes", "");
        SQL_FUNCTION_MAP.put("addSeconds", "");
        SQL_FUNCTION_MAP.put("addQuarters", "");
        SQL_FUNCTION_MAP.put("subtractYears", "");
        SQL_FUNCTION_MAP.put("subtractMonths", "");
        SQL_FUNCTION_MAP.put("subtractWeeks", "");
        SQL_FUNCTION_MAP.put("subtractDays", "");
        SQL_FUNCTION_MAP.put("subtractours", "");
        SQL_FUNCTION_MAP.put("subtractMinutes", "");
        SQL_FUNCTION_MAP.put("subtractSeconds", "");
        SQL_FUNCTION_MAP.put("subtractQuarters", "");
        SQL_FUNCTION_MAP.put("formatDateTime", "");
        SQL_FUNCTION_MAP.put("timestamp_add", "");
        SQL_FUNCTION_MAP.put("timestamp_sub", "");
        SQL_FUNCTION_MAP.put("visitParamHas", "");
        SQL_FUNCTION_MAP.put("visitParamExtractUInt", "");
        SQL_FUNCTION_MAP.put("visitParamExtractInt", "");
        SQL_FUNCTION_MAP.put("visitParamExtractFloat", "");
        SQL_FUNCTION_MAP.put("visitParamExtractBool", "");
        SQL_FUNCTION_MAP.put("visitParamExtractRaw", "");
        SQL_FUNCTION_MAP.put("visitParamExtractString", "");
        SQL_FUNCTION_MAP.put("JSONHas", "");
        SQL_FUNCTION_MAP.put("JSONLength", "");
        SQL_FUNCTION_MAP.put("JSONType", "");
        SQL_FUNCTION_MAP.put("JSONExtractUInt", "");
        SQL_FUNCTION_MAP.put("JSONExtractInt", "");
        SQL_FUNCTION_MAP.put("JSONExtractFloat", "");
        SQL_FUNCTION_MAP.put("JSONExtractBool", "");
        SQL_FUNCTION_MAP.put("JSONExtractString", "");
        SQL_FUNCTION_MAP.put("JSONExtract", "");
        SQL_FUNCTION_MAP.put("JSONExtractKeysAndValues", "");
        SQL_FUNCTION_MAP.put("JSONExtractRaw", "");
        SQL_FUNCTION_MAP.put("toJSONString", "");
        SQL_FUNCTION_MAP.put("toInt8", "");
        SQL_FUNCTION_MAP.put("toInt16", "");
        SQL_FUNCTION_MAP.put("toInt32", "");
        SQL_FUNCTION_MAP.put("toInt64", "");
        SQL_FUNCTION_MAP.put("toInt8OrZero", "");
        SQL_FUNCTION_MAP.put("toInt16OrZero", "");
        SQL_FUNCTION_MAP.put("toInt32OrZero", "");
        SQL_FUNCTION_MAP.put("toInt64OrZero", "");
        SQL_FUNCTION_MAP.put("toInt8OrNull", "");
        SQL_FUNCTION_MAP.put("toInt16OrNull", "");
        SQL_FUNCTION_MAP.put("toInt32OrNull", "");
        SQL_FUNCTION_MAP.put("toInt64OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt8", "");
        SQL_FUNCTION_MAP.put("toUInt16", "");
        SQL_FUNCTION_MAP.put("toUInt32", "");
        SQL_FUNCTION_MAP.put("toUInt64", "");
        SQL_FUNCTION_MAP.put("toUInt8OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt16OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt32OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt64OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt8OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt16OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt32OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt64OrNull", "");
        SQL_FUNCTION_MAP.put("toFloat32", "");
        SQL_FUNCTION_MAP.put("toFloat64", "");
        SQL_FUNCTION_MAP.put("toFloat32OrZero", "");
        SQL_FUNCTION_MAP.put("toFloat64OrZero", "");
        SQL_FUNCTION_MAP.put("toFloat32OrNull", "");
        SQL_FUNCTION_MAP.put("toFloat64OrNull", "");
        SQL_FUNCTION_MAP.put("toDate", "");
        SQL_FUNCTION_MAP.put("toDateOrZero", "");
        SQL_FUNCTION_MAP.put("toDateOrNull", "");
        SQL_FUNCTION_MAP.put("toDateTimeOrZero", "");
        SQL_FUNCTION_MAP.put("toDateTimeOrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal32", "");
        SQL_FUNCTION_MAP.put("toFixedString", "");
        SQL_FUNCTION_MAP.put("toStringCutToZero", "");
        SQL_FUNCTION_MAP.put("toDecimal256", "");
        SQL_FUNCTION_MAP.put("toDecimal32OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal64OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal128OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal256OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal32OrZero", "");
        SQL_FUNCTION_MAP.put("toDecimal64OrZero", "");
        SQL_FUNCTION_MAP.put("toDecimal128OrZero", "");
        SQL_FUNCTION_MAP.put("toDecimal256OrZero", "");
        SQL_FUNCTION_MAP.put("toIntervalSecond", "");
        SQL_FUNCTION_MAP.put("toIntervalMinute", "");
        SQL_FUNCTION_MAP.put("toIntervalHour", "");
        SQL_FUNCTION_MAP.put("toIntervalDay", "");
        SQL_FUNCTION_MAP.put("toIntervalWeek", "");
        SQL_FUNCTION_MAP.put("toIntervalMonth", "");
        SQL_FUNCTION_MAP.put("toIntervalQuarter", "");
        SQL_FUNCTION_MAP.put("toIntervalYear", "");
        SQL_FUNCTION_MAP.put("parseDateTimeBestEffort", "");
        SQL_FUNCTION_MAP.put("parseDateTimeBestEffortOrNull", "");
        SQL_FUNCTION_MAP.put("parseDateTimeBestEffortOrZero", "");
        SQL_FUNCTION_MAP.put("toLowCardinality", "");
        SQL_FUNCTION_MAP.put("halfMD5", "");
        SQL_FUNCTION_MAP.put("MD5", "");
        SQL_FUNCTION_MAP.put("IPv4NumToString", "");
        SQL_FUNCTION_MAP.put("IPv4StringToNum", "");
        SQL_FUNCTION_MAP.put("IPv6NumToString", "");
        SQL_FUNCTION_MAP.put("IPv6StringToNum", "");
        SQL_FUNCTION_MAP.put("IPv4ToIPv6", "");
        SQL_FUNCTION_MAP.put("cutIPv6", "");
        SQL_FUNCTION_MAP.put("toIPv4", "");
        SQL_FUNCTION_MAP.put("toIPv6", "");
        SQL_FUNCTION_MAP.put("isIPAddressInRange", "");
        SQL_FUNCTION_MAP.put("isNull", "");
        SQL_FUNCTION_MAP.put("isNotNull", "");
        SQL_FUNCTION_MAP.put("ifNull", "");
        SQL_FUNCTION_MAP.put("assumeNotNull", "");
        SQL_FUNCTION_MAP.put("toNullable", "");
        SQL_FUNCTION_MAP.put("generateUUIDv4", "");
        SQL_FUNCTION_MAP.put("toUUID", "");
        SQL_FUNCTION_MAP.put("hostName", "");
        SQL_FUNCTION_MAP.put("getMacro", "");
        SQL_FUNCTION_MAP.put("FQDN", "");
        SQL_FUNCTION_MAP.put("basename", "");
        SQL_FUNCTION_MAP.put("currentUser", "");
        SQL_FUNCTION_MAP.put("version", "");
        SQL_FUNCTION_MAP.put("uptime", "");
        SQL_FUNCTION_MAP.put("least", "");
        SQL_FUNCTION_MAP.put("greatest", "");
        SQL_FUNCTION_MAP.put("plus", "");
        SQL_FUNCTION_MAP.put("minus", "");
        SQL_FUNCTION_MAP.put("multiply", "");
        SQL_FUNCTION_MAP.put("divide", "");
        SQL_FUNCTION_MAP.put("intDiv", "");
        SQL_FUNCTION_MAP.put("intDivOrZero", "");
        SQL_FUNCTION_MAP.put("modulo", "");
        SQL_FUNCTION_MAP.put("moduloOrZero", "");
        SQL_FUNCTION_MAP.put("negate", "");
        SQL_FUNCTION_MAP.put("gcd", "");
        SQL_FUNCTION_MAP.put("lcm", "");
        SQL_FUNCTION_MAP.put("e", "");
        SQL_FUNCTION_MAP.put("pi", "");
        SQL_FUNCTION_MAP.put("exp2", "");
        SQL_FUNCTION_MAP.put("exp10", "");
        SQL_FUNCTION_MAP.put("cbrt", "");
        SQL_FUNCTION_MAP.put("lgamma", "");
        SQL_FUNCTION_MAP.put("tgamma", "");
        SQL_FUNCTION_MAP.put("intExp2", "");
        SQL_FUNCTION_MAP.put("intExp10", "");
        SQL_FUNCTION_MAP.put("cosh", "");
        SQL_FUNCTION_MAP.put("cosh", "");
        SQL_FUNCTION_MAP.put("sinh", "");
        SQL_FUNCTION_MAP.put("asinh", "");
        SQL_FUNCTION_MAP.put("atanh", "");
        SQL_FUNCTION_MAP.put("atan2", "");
        SQL_FUNCTION_MAP.put("hypot", "");
        SQL_FUNCTION_MAP.put("log1p", "");
        SQL_FUNCTION_MAP.put("trunc", "");
        SQL_FUNCTION_MAP.put("roundToExp2", "");
        SQL_FUNCTION_MAP.put("roundDuration", "");
        SQL_FUNCTION_MAP.put("roundAge", "");
        SQL_FUNCTION_MAP.put("roundDown", "");
        SQL_FUNCTION_MAP.put("bitAnd", "");
        SQL_FUNCTION_MAP.put("bitOr", "");
    }

    public static abstract class SimpleCallback
    implements Callback {
        @Override
        public Object newId(RequestMethod method, String database, String schema, String table) {
            return System.currentTimeMillis();
        }

        @Override
        public String getIdKey(String database, String schema, String datasource, String table) {
            return JSONObject.KEY_ID;
        }

        @Override
        public String getUserIdKey(String database, String schema, String datasource, String table) {
            return JSONObject.KEY_USER_ID;
        }

        @Override
        public void onMissingKey4Combine(String name, com.alibaba.fastjson.JSONObject request, String combine, String item, String key) throws Exception {
            throw new IllegalArgumentException(name + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc " + item + " \u5bf9\u5e94\u7684\u6761\u4ef6 " + key + ":value \u4e2d value \u4e0d\u80fd\u4e3a null\uff01");
        }
    }

    public static interface Callback
    extends IdCallback {
        public SQLConfig getSQLConfig(RequestMethod var1, String var2, String var3, String var4);

        public void onMissingKey4Combine(String var1, com.alibaba.fastjson.JSONObject var2, String var3, String var4, String var5) throws Exception;
    }

    public static interface IdCallback {
        public Object newId(RequestMethod var1, String var2, String var3, String var4);

        public String getIdKey(String var1, String var2, String var3, String var4);

        public String getUserIdKey(String var1, String var2, String var3, String var4);
    }
}

