/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.NotNull;
import apijson.RequestMethod;
import apijson.orm.ObjectParser;
import apijson.orm.SQLConfig;
import apijson.orm.SQLCreator;
import apijson.orm.SQLExecutor;
import apijson.orm.Verifier;
import apijson.orm.Visitor;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.sql.Savepoint;

public interface Parser<T> {
    public static final int DEFAULT_QUERY_COUNT = 10;
    public static final int MAX_QUERY_PAGE = 100;
    public static final int MAX_QUERY_COUNT = 100;
    public static final int MAX_UPDATE_COUNT = 10;
    public static final int MAX_SQL_COUNT = 200;
    public static final int MAX_OBJECT_COUNT = 5;
    public static final int MAX_ARRAY_COUNT = 5;
    public static final int MAX_QUERY_DEPTH = 5;

    @NotNull
    public Visitor<T> getVisitor();

    public Parser<T> setVisitor(@NotNull Visitor<T> var1);

    @NotNull
    public RequestMethod getMethod();

    public Parser<T> setMethod(@NotNull RequestMethod var1);

    public int getVersion();

    public Parser<T> setVersion(int var1);

    public String getTag();

    public Parser<T> setTag(String var1);

    public JSONObject getRequest();

    public Parser<T> setRequest(JSONObject var1);

    public Parser<T> setNeedVerify(boolean var1);

    public boolean isNeedVerifyLogin();

    public Parser<T> setNeedVerifyLogin(boolean var1);

    public boolean isNeedVerifyRole();

    public Parser<T> setNeedVerifyRole(boolean var1);

    public boolean isNeedVerifyContent();

    public Parser<T> setNeedVerifyContent(boolean var1);

    public String parse(String var1);

    public String parse(JSONObject var1);

    public JSONObject parseResponse(String var1);

    public JSONObject parseResponse(JSONObject var1);

    public JSONObject parseCorrectRequest() throws Exception;

    public JSONObject parseCorrectRequest(RequestMethod var1, String var2, int var3, String var4, JSONObject var5, int var6, SQLCreator var7) throws Exception;

    public JSONObject getStructure(String var1, String var2, String var3, int var4) throws Exception;

    public JSONObject onObjectParse(JSONObject var1, String var2, String var3, SQLConfig var4, boolean var5) throws Exception;

    public JSONArray onArrayParse(JSONObject var1, String var2, String var3, boolean var4) throws Exception;

    public Object onFunctionParse(String var1, String var2, String var3, String var4, JSONObject var5) throws Exception;

    public ObjectParser createObjectParser(JSONObject var1, String var2, SQLConfig var3, boolean var4, boolean var5, boolean var6) throws Exception;

    public int getDefaultQueryCount();

    public int getMaxQueryPage();

    public int getMaxQueryCount();

    public int getMaxUpdateCount();

    public int getMaxSQLCount();

    public int getMaxObjectCount();

    public int getMaxArrayCount();

    public int getMaxQueryDepth();

    public void putQueryResult(String var1, Object var2);

    public Object getValueByPath(String var1);

    public void onVerifyLogin() throws Exception;

    public void onVerifyContent() throws Exception;

    public void onVerifyRole(SQLConfig var1) throws Exception;

    public JSONObject executeSQL(SQLConfig var1, boolean var2) throws Exception;

    public SQLExecutor getSQLExecutor();

    public Verifier<T> getVerifier();

    public Boolean getGlobleFormat();

    public String getGlobleRole();

    public String getGlobleDatabase();

    public String getGlobleSchema();

    public String getGlobleDatasource();

    public Boolean getGlobleExplain();

    public String getGlobleCache();

    public int getTransactionIsolation();

    public void setTransactionIsolation(int var1);

    public void begin(int var1);

    public void rollback() throws SQLException;

    public void rollback(Savepoint var1) throws SQLException;

    public void commit() throws SQLException;

    public void close();
}

