/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.JSONObject;
import apijson.JSONRequest;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractVerifier;
import apijson.orm.Entry;
import apijson.orm.Join;
import apijson.orm.ObjectParser;
import apijson.orm.Operation;
import apijson.orm.Pair;
import apijson.orm.Parser;
import apijson.orm.ParserCreator;
import apijson.orm.SQLConfig;
import apijson.orm.SQLCreator;
import apijson.orm.SQLExecutor;
import apijson.orm.Verifier;
import apijson.orm.VerifierCreator;
import apijson.orm.Visitor;
import apijson.orm.exception.ConditionErrorException;
import apijson.orm.exception.ConflictException;
import apijson.orm.exception.NotExistException;
import apijson.orm.exception.NotLoggedInException;
import apijson.orm.exception.OutOfRangeException;
import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import javax.activation.UnsupportedDataTypeException;

public abstract class AbstractParser<T>
implements Parser<T>,
ParserCreator<T>,
VerifierCreator<T>,
SQLCreator {
    protected static final String TAG = "AbstractParser";
    public static boolean IS_PRINT_REQUEST_STRING_LOG = false;
    public static boolean IS_PRINT_BIG_LOG = false;
    public static boolean IS_PRINT_REQUEST_ENDTIME_LOG = false;
    @NotNull
    protected Visitor<T> visitor;
    protected RequestMethod requestMethod;
    protected int version;
    protected String tag;
    protected com.alibaba.fastjson.JSONObject requestObject;
    protected Boolean globleFormat;
    protected String globleRole;
    protected String globleDatabase;
    protected String globleSchema;
    protected String globleDatasource;
    protected Boolean globleExplain;
    protected String globleCache;
    protected boolean needVerifyLogin;
    protected boolean needVerifyRole;
    protected boolean needVerifyContent;
    protected SQLExecutor sqlExecutor;
    protected Verifier<T> verifier;
    protected Map<String, Object> queryResultMap;
    private int queryDepth;
    protected Map<String, ObjectParser> arrayObjectParserCacheMap = new HashMap<String, ObjectParser>();
    private static final List<String> JOIN_COPY_KEY_LIST = new ArrayList<String>();
    public static final String KEY_CONFIG = "config";
    public static final String KEY_SQL = "sql";
    protected Map<String, List<com.alibaba.fastjson.JSONObject>> arrayMainCacheMap = new HashMap<String, List<com.alibaba.fastjson.JSONObject>>();
    private int transactionIsolation = 0;

    public AbstractParser() {
        this(null);
    }

    public AbstractParser(RequestMethod method) {
        this(method, true);
    }

    public AbstractParser(RequestMethod method, boolean needVerify) {
        this.setMethod(method);
        this.setNeedVerify(needVerify);
    }

    @Override
    @NotNull
    public Visitor<T> getVisitor() {
        if (this.visitor == null) {
            this.visitor = new Visitor<T>(){

                @Override
                public T getId() {
                    return null;
                }

                @Override
                public List<T> getContactIdList() {
                    return null;
                }
            };
        }
        return this.visitor;
    }

    @Override
    public AbstractParser<T> setVisitor(@NotNull Visitor<T> visitor) {
        this.visitor = visitor;
        return this;
    }

    @Override
    @NotNull
    public RequestMethod getMethod() {
        return this.requestMethod;
    }

    @Override
    @NotNull
    public AbstractParser<T> setMethod(RequestMethod method) {
        this.requestMethod = method == null ? RequestMethod.GET : method;
        this.transactionIsolation = RequestMethod.isQueryMethod(method) ? 0 : 4;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public AbstractParser<T> setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public AbstractParser<T> setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getRequest() {
        return this.requestObject;
    }

    @Override
    public AbstractParser<T> setRequest(com.alibaba.fastjson.JSONObject request) {
        this.requestObject = request;
        return this;
    }

    public AbstractParser<T> setGlobleFormat(Boolean globleFormat) {
        this.globleFormat = globleFormat;
        return this;
    }

    @Override
    public Boolean getGlobleFormat() {
        return this.globleFormat;
    }

    public AbstractParser<T> setGlobleRole(String globleRole) {
        this.globleRole = globleRole;
        return this;
    }

    @Override
    public String getGlobleRole() {
        return this.globleRole;
    }

    public AbstractParser<T> setGlobleDatabase(String globleDatabase) {
        this.globleDatabase = globleDatabase;
        return this;
    }

    @Override
    public String getGlobleDatabase() {
        return this.globleDatabase;
    }

    public AbstractParser<T> setGlobleSchema(String globleSchema) {
        this.globleSchema = globleSchema;
        return this;
    }

    @Override
    public String getGlobleSchema() {
        return this.globleSchema;
    }

    @Override
    public String getGlobleDatasource() {
        return this.globleDatasource;
    }

    public AbstractParser<T> setGlobleDatasource(String globleDatasource) {
        this.globleDatasource = globleDatasource;
        return this;
    }

    public AbstractParser<T> setGlobleExplain(Boolean globleExplain) {
        this.globleExplain = globleExplain;
        return this;
    }

    @Override
    public Boolean getGlobleExplain() {
        return this.globleExplain;
    }

    public AbstractParser<T> setGlobleCache(String globleCache) {
        this.globleCache = globleCache;
        return this;
    }

    @Override
    public String getGlobleCache() {
        return this.globleCache;
    }

    @Override
    public AbstractParser<T> setNeedVerify(boolean needVerify) {
        this.setNeedVerifyLogin(needVerify);
        this.setNeedVerifyRole(needVerify);
        this.setNeedVerifyContent(needVerify);
        return this;
    }

    @Override
    public boolean isNeedVerifyLogin() {
        return this.needVerifyLogin;
    }

    @Override
    public AbstractParser<T> setNeedVerifyLogin(boolean needVerifyLogin) {
        this.needVerifyLogin = needVerifyLogin;
        return this;
    }

    @Override
    public boolean isNeedVerifyRole() {
        return this.needVerifyRole;
    }

    @Override
    public AbstractParser<T> setNeedVerifyRole(boolean needVerifyRole) {
        this.needVerifyRole = needVerifyRole;
        return this;
    }

    @Override
    public boolean isNeedVerifyContent() {
        return this.needVerifyContent;
    }

    @Override
    public AbstractParser<T> setNeedVerifyContent(boolean needVerifyContent) {
        this.needVerifyContent = needVerifyContent;
        return this;
    }

    @Override
    public SQLExecutor getSQLExecutor() {
        if (this.sqlExecutor == null) {
            this.sqlExecutor = this.createSQLExecutor();
        }
        return this.sqlExecutor;
    }

    @Override
    public Verifier<T> getVerifier() {
        if (this.verifier == null) {
            this.verifier = this.createVerifier().setVisitor(this.getVisitor());
        }
        return this.verifier;
    }

    @Override
    public String parse(String request) {
        return JSON.toJSONString(this.parseResponse(request));
    }

    @Override
    @NotNull
    public String parse(com.alibaba.fastjson.JSONObject request) {
        return JSON.toJSONString(this.parseResponse(request));
    }

    @Override
    @NotNull
    public com.alibaba.fastjson.JSONObject parseResponse(String request) {
        Log.d(TAG, "\n\n\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" + (Object)((Object)this.requestMethod) + "/parseResponse  request = \n" + request + "\n\n");
        try {
            this.requestObject = AbstractParser.parseRequest(request);
        }
        catch (Exception e) {
            return AbstractParser.newErrorResult(e);
        }
        return this.parseResponse(this.requestObject);
    }

    @Override
    @NotNull
    public com.alibaba.fastjson.JSONObject parseResponse(com.alibaba.fastjson.JSONObject request) {
        long startTime = System.currentTimeMillis();
        Log.d(TAG, "parseResponse  startTime = " + startTime + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\n\n ");
        this.requestObject = request;
        this.verifier = this.createVerifier().setVisitor(this.getVisitor());
        if (!RequestMethod.isPublicMethod(this.requestMethod)) {
            try {
                if (this.isNeedVerifyLogin()) {
                    this.onVerifyLogin();
                }
                if (this.isNeedVerifyContent()) {
                    this.onVerifyContent();
                }
            }
            catch (Exception e) {
                return AbstractParser.extendErrorResult(this.requestObject, e);
            }
        }
        if (this.isNeedVerifyRole() && this.globleRole == null) {
            try {
                this.setGlobleRole(this.requestObject.getString("@role"));
                this.requestObject.remove((Object)"@role");
            }
            catch (Exception e) {
                return AbstractParser.extendErrorResult(this.requestObject, e);
            }
        }
        try {
            this.setGlobleFormat(this.requestObject.getBoolean("format"));
            this.setGlobleDatabase(this.requestObject.getString("@database"));
            this.setGlobleSchema(this.requestObject.getString("@schema"));
            this.setGlobleDatasource(this.requestObject.getString("@datasource"));
            this.setGlobleExplain(this.requestObject.getBoolean("@explain"));
            this.setGlobleCache(this.requestObject.getString("@cache"));
            this.requestObject.remove((Object)"format");
            this.requestObject.remove((Object)"@database");
            this.requestObject.remove((Object)"@schema");
            this.requestObject.remove((Object)"@datasource");
            this.requestObject.remove((Object)"@explain");
            this.requestObject.remove((Object)"@cache");
        }
        catch (Exception e) {
            return AbstractParser.extendErrorResult(this.requestObject, e);
        }
        String requestString = JSON.toJSONString(request);
        this.queryResultMap = new HashMap<String, Object>();
        Exception error = null;
        this.sqlExecutor = this.createSQLExecutor();
        this.onBegin();
        try {
            this.queryDepth = 0;
            this.requestObject = this.onObjectParse(request, null, null, null, false);
            this.onCommit();
        }
        catch (Exception e) {
            e.printStackTrace();
            error = e;
            this.onRollback();
        }
        this.requestObject = error == null ? AbstractParser.extendSuccessResult(this.requestObject) : AbstractParser.extendErrorResult(this.requestObject, error);
        com.alibaba.fastjson.JSONObject res = this.globleFormat != null && this.globleFormat != false && JSONResponse.isSuccess(this.requestObject) ? new JSONResponse(this.requestObject) : this.requestObject;
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        if (Log.DEBUG) {
            this.requestObject.put("sql:generate|cache|execute|maxExecute", (Object)(this.getSQLExecutor().getGeneratedSQLCount() + "|" + this.getSQLExecutor().getCachedSQLCount() + "|" + this.getSQLExecutor().getExecutedSQLCount() + "|" + this.getMaxSQLCount()));
            this.requestObject.put("depth:count|max", (Object)(this.queryDepth + "|" + this.getMaxQueryDepth()));
            this.requestObject.put("time:start|duration|end", (Object)(startTime + "|" + duration + "|" + endTime));
            if (error != null) {
                this.requestObject.put("throw", (Object)error.getClass().getName());
                this.requestObject.put("trace", (Object)error.getStackTrace());
            }
        }
        this.onClose();
        if (IS_PRINT_REQUEST_STRING_LOG || Log.DEBUG || error != null) {
            Log.sl("\n\n\n", '<', "");
            Log.fd(TAG, (Object)((Object)this.requestMethod) + "/parseResponse  request = \n" + requestString + "\n\n");
        }
        if (IS_PRINT_BIG_LOG || Log.DEBUG || error != null) {
            Log.fd(TAG, (Object)((Object)this.requestMethod) + "/parseResponse return response = \n" + JSON.toJSONString(this.requestObject) + "\n\n");
        }
        if (IS_PRINT_REQUEST_ENDTIME_LOG || Log.DEBUG || error != null) {
            Log.fd(TAG, (Object)((Object)this.requestMethod) + "/parseResponse  endTime = " + endTime + ";  duration = " + duration);
            Log.sl("", '>', "\n\n\n");
        }
        return res;
    }

    @Override
    public void onVerifyLogin() throws Exception {
        this.getVerifier().verifyLogin();
    }

    @Override
    public void onVerifyContent() throws Exception {
        this.requestObject = this.parseCorrectRequest();
    }

    @Override
    public void onVerifyRole(@NotNull SQLConfig config) throws Exception {
        if (Log.DEBUG) {
            Log.i(TAG, "onVerifyRole  config = " + JSON.toJSONString(config));
        }
        if (this.isNeedVerifyRole()) {
            if (config.getRole() == null) {
                if (this.globleRole != null) {
                    config.setRole(this.globleRole);
                } else {
                    config.setRole(this.getVisitor().getId() == null ? "UNKNOWN" : "LOGIN");
                }
            }
            this.getVerifier().verifyAccess(config);
        }
    }

    @NotNull
    public static com.alibaba.fastjson.JSONObject parseRequest(String request) throws Exception {
        com.alibaba.fastjson.JSONObject obj = JSON.parseObject(request);
        if (obj == null) {
            throw new UnsupportedEncodingException("JSON\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        return obj;
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseCorrectRequest(RequestMethod method, String tag, int version, String name, @NotNull com.alibaba.fastjson.JSONObject request, int maxUpdateCount, SQLCreator creator) throws Exception {
        if (RequestMethod.isPublicMethod(method)) {
            return request;
        }
        if (StringUtil.isEmpty(tag, true)) {
            throw new IllegalArgumentException("\u8bf7\u5728\u6700\u5916\u5c42\u4f20 tag \uff01\u4e00\u822c\u662f Table \u540d\uff0c\u4f8b\u5982 \"tag\": \"User\" ");
        }
        com.alibaba.fastjson.JSONObject object = null;
        String error = "";
        try {
            object = this.getStructure("Request", method.name(), tag, version);
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (object == null) {
            throw new UnsupportedOperationException("\u627e\u4e0d\u5230 version: " + version + ", method: " + method.name() + ", tag: " + tag + " \u5bf9\u5e94\u7684 structure \uff01\u975e\u5f00\u653e\u8bf7\u6c42\u5fc5\u987b\u662f\u540e\u7aef Request \u8868\u4e2d\u6821\u9a8c\u89c4\u5219\u5141\u8bb8\u7684\u64cd\u4f5c\uff01\n " + error + "\n\u5982\u679c\u9700\u8981\u5219\u5728 Request \u8868\u4e2d\u65b0\u589e\u914d\u7f6e\uff01");
        }
        com.alibaba.fastjson.JSONObject target = AbstractParser.wrapRequest(method, tag, object, true);
        return this.getVerifier().verifyRequest(method, name, target, request, maxUpdateCount, this.getGlobleDatabase(), this.getGlobleSchema(), creator);
    }

    public static com.alibaba.fastjson.JSONObject wrapRequest(RequestMethod method, String tag, com.alibaba.fastjson.JSONObject object, boolean isStructure) {
        boolean isArrayKey;
        boolean putTag;
        boolean bl = putTag = !isStructure;
        if (object == null || object.containsKey((Object)tag)) {
            if (putTag) {
                if (object == null) {
                    object = new com.alibaba.fastjson.JSONObject(true);
                }
                object.put("tag", (Object)tag);
            }
            return object;
        }
        boolean isDiffArrayKey = tag.endsWith(":[]");
        boolean bl2 = isArrayKey = isDiffArrayKey || JSONRequest.isArrayKey(tag);
        String key = isArrayKey ? tag.substring(0, tag.length() - (isDiffArrayKey ? 3 : 2)) : tag;
        com.alibaba.fastjson.JSONObject target = object;
        if (JSONObject.isTableKey(key)) {
            if (isDiffArrayKey) {
                if (isStructure && (method == RequestMethod.POST || method == RequestMethod.PUT)) {
                    String arrKey = key + "[]";
                    if (!target.containsKey((Object)arrKey)) {
                        target.put(arrKey, (Object)new JSONArray());
                    }
                    try {
                        com.alibaba.fastjson.JSONObject type = target.getJSONObject(Operation.TYPE.name());
                        if (type == null || !type.containsKey((Object)arrKey)) {
                            if (type == null) {
                                type = new com.alibaba.fastjson.JSONObject(true);
                            }
                            type.put(arrKey, (Object)"OBJECT[]");
                            target.put(Operation.TYPE.name(), (Object)type);
                        }
                    }
                    catch (Throwable e) {
                        Log.w(TAG, "wrapRequest try { JSONObject type = target.getJSONObject(Operation.TYPE.name()); } catch (Exception e) = " + e.getMessage());
                    }
                }
            } else if (!isArrayKey || RequestMethod.isGetMethod(method, true)) {
                target = new com.alibaba.fastjson.JSONObject(true);
                target.put(tag, (Object)object);
            } else if (!target.containsKey((Object)key)) {
                target = new com.alibaba.fastjson.JSONObject(true);
                target.put(key, (Object)object);
            }
        }
        if (putTag) {
            target.put("tag", (Object)tag);
        }
        return target;
    }

    public static com.alibaba.fastjson.JSONObject newResult(int code, String msg) {
        return AbstractParser.extendResult(null, code, msg);
    }

    public static com.alibaba.fastjson.JSONObject extendResult(com.alibaba.fastjson.JSONObject object, int code, String msg) {
        String m;
        if (object == null) {
            object = new com.alibaba.fastjson.JSONObject(true);
        }
        if (!object.containsKey((Object)JSONResponse.KEY_OK)) {
            object.put(JSONResponse.KEY_OK, (Object)JSONResponse.isSuccess(code));
        }
        if (!object.containsKey((Object)JSONResponse.KEY_CODE)) {
            object.put(JSONResponse.KEY_CODE, (Object)code);
        }
        if (!(m = StringUtil.getString(object.getString(JSONResponse.KEY_MSG))).isEmpty()) {
            msg = m + " ;\n " + StringUtil.getString(msg);
        }
        object.put(JSONResponse.KEY_MSG, (Object)msg);
        return object;
    }

    public static com.alibaba.fastjson.JSONObject extendSuccessResult(com.alibaba.fastjson.JSONObject object) {
        return AbstractParser.extendResult(object, 200, "success");
    }

    public static com.alibaba.fastjson.JSONObject newSuccessResult() {
        return AbstractParser.newResult(200, "success");
    }

    public static com.alibaba.fastjson.JSONObject extendErrorResult(com.alibaba.fastjson.JSONObject object, Exception e) {
        com.alibaba.fastjson.JSONObject error = AbstractParser.newErrorResult(e);
        return AbstractParser.extendResult(object, error.getIntValue(JSONResponse.KEY_CODE), error.getString(JSONResponse.KEY_MSG));
    }

    public static com.alibaba.fastjson.JSONObject newErrorResult(Exception e) {
        if (e != null) {
            e.printStackTrace();
            int code = e instanceof UnsupportedEncodingException ? 400 : (e instanceof IllegalAccessException ? 401 : (e instanceof UnsupportedOperationException ? 403 : (e instanceof NotExistException ? 404 : (e instanceof IllegalArgumentException ? 406 : (e instanceof NotLoggedInException ? 407 : (e instanceof TimeoutException ? 408 : (e instanceof ConflictException ? 409 : (e instanceof ConditionErrorException ? 412 : (e instanceof UnsupportedDataTypeException ? 415 : (e instanceof OutOfRangeException ? 416 : (e instanceof NullPointerException ? 417 : 500)))))))))));
            return AbstractParser.newResult(code, e.getMessage());
        }
        return AbstractParser.newResult(500, "Internal Server Error!");
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseCorrectRequest() throws Exception {
        this.setTag(this.requestObject.getString("tag"));
        this.setVersion(this.requestObject.getIntValue("version"));
        this.requestObject.remove((Object)"tag");
        this.requestObject.remove((Object)"version");
        return this.parseCorrectRequest(this.requestMethod, this.tag, this.version, "", this.requestObject, this.getMaxUpdateCount(), this);
    }

    @Override
    public com.alibaba.fastjson.JSONObject getStructure(@NotNull String table, String method, String tag, int version) throws Exception {
        com.alibaba.fastjson.JSONObject result;
        String cacheKey = AbstractVerifier.getCacheKeyForRequest(method, tag);
        SortedMap<Integer, com.alibaba.fastjson.JSONObject> versionedMap = AbstractVerifier.REQUEST_MAP.get(cacheKey);
        com.alibaba.fastjson.JSONObject jSONObject = result = versionedMap == null ? null : (com.alibaba.fastjson.JSONObject)versionedMap.get(version);
        if (result == null) {
            Set<Map.Entry<Integer, com.alibaba.fastjson.JSONObject>> set;
            Set<Map.Entry<Integer, com.alibaba.fastjson.JSONObject>> set2 = set = versionedMap == null ? null : versionedMap.entrySet();
            if (set != null && !set.isEmpty()) {
                Map.Entry<Integer, com.alibaba.fastjson.JSONObject> maxEntry = null;
                for (Map.Entry<Integer, com.alibaba.fastjson.JSONObject> entry : set) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                    if (version <= 0 || version == entry.getKey()) {
                        maxEntry = entry;
                        break;
                    }
                    if (entry.getKey() < version) break;
                    maxEntry = entry;
                }
                com.alibaba.fastjson.JSONObject jSONObject2 = result = maxEntry == null ? null : (com.alibaba.fastjson.JSONObject)maxEntry.getValue();
            }
            if (result != null) {
                if (versionedMap == null) {
                    versionedMap = new TreeMap<Integer, com.alibaba.fastjson.JSONObject>((o1, o2) -> o2 == null ? -1 : o2.compareTo((Integer)o1));
                }
                versionedMap.put(version, result);
                AbstractVerifier.REQUEST_MAP.put(cacheKey, versionedMap);
            }
        }
        if (result == null) {
            if (!AbstractVerifier.REQUEST_MAP.isEmpty()) {
                return null;
            }
            SQLConfig config = this.createSQLConfig().setMethod(RequestMethod.GET).setTable(table);
            config.setPrepared(false);
            config.setColumn(Arrays.asList("structure"));
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("method", method);
            where.put("tag", tag);
            if (version > 0) {
                where.put("version{}", ">=" + version);
            }
            config.setWhere(where);
            config.setOrder("version" + (version > 0 ? "+" : "-"));
            config.setCount(1);
            result = this.getSQLExecutor().execute(config, false);
        }
        return AbstractParser.getJSONObject(result, "structure");
    }

    @Override
    public com.alibaba.fastjson.JSONObject onObjectParse(com.alibaba.fastjson.JSONObject request, String parentPath, String name, SQLConfig arrayConfig, boolean isSubquery) throws Exception {
        if (Log.DEBUG) {
            Log.i(TAG, "\ngetObject:  parentPath = " + parentPath + ";\n name = " + name + "; request = " + JSON.toJSONString(request));
        }
        if (request == null) {
            return null;
        }
        int type = arrayConfig == null ? 0 : arrayConfig.getType();
        int position = arrayConfig == null ? 0 : arrayConfig.getPosition();
        String[] arr = StringUtil.split(parentPath, "/");
        if (position == 0) {
            int d;
            int n = d = arr == null ? 1 : arr.length + 1;
            if (this.queryDepth < d) {
                this.queryDepth = d;
                int maxQueryDepth = this.getMaxQueryDepth();
                if (this.queryDepth > maxQueryDepth) {
                    throw new IllegalArgumentException(parentPath + "/" + name + ":{} \u7684\u6df1\u5ea6(\u6216\u8005\u8bf4\u5c42\u7ea7) \u4e3a " + this.queryDepth + " \u5df2\u8d85\u9650\uff0c\u5fc5\u987b\u5728 1-" + maxQueryDepth + " \u5185 !");
                }
            }
        }
        Entry<String, String> entry = Pair.parseEntry(name, true);
        String table = entry.getKey();
        boolean isTable = JSONObject.isTableKey(table);
        boolean isArrayMainTable = !isSubquery && isTable && type == 2 && arrayConfig != null && RequestMethod.isGetMethod(arrayConfig.getMethod(), true);
        boolean isReuse = isArrayMainTable && position > 0;
        ObjectParser op = null;
        if (isReuse) {
            op = this.arrayObjectParserCacheMap.get(parentPath.substring(0, parentPath.lastIndexOf("[]") + 2));
            op.setParentPath(parentPath);
        }
        if (op == null) {
            op = this.createObjectParser(request, parentPath, arrayConfig, isSubquery, isTable, isArrayMainTable);
        }
        op = op.parse(name, isReuse);
        Object response = null;
        if (op != null) {
            if (arrayConfig == null) {
                response = op.setSQLConfig().executeSQL().response();
            } else {
                int query = arrayConfig.getQuery();
                if (type == 2 && query != 0 && position == 0) {
                    int index;
                    RequestMethod method = op.getMethod();
                    com.alibaba.fastjson.JSONObject rp = op.setMethod(RequestMethod.HEAD).setSQLConfig().executeSQL().getSqlReponse();
                    op.setMethod(method);
                    if (rp != null && (index = parentPath.lastIndexOf("]/")) >= 0) {
                        int total = rp.getIntValue("count");
                        String pathPrefix = parentPath.substring(0, index) + "]/";
                        this.putQueryResult(pathPrefix + "total", total);
                        int count = arrayConfig.getCount();
                        int page = arrayConfig.getPage();
                        int max = (total - 1) / count;
                        if (max < 0) {
                            max = 0;
                        }
                        com.alibaba.fastjson.JSONObject pagination = new com.alibaba.fastjson.JSONObject(true);
                        Object explain = rp.get((Object)"@explain");
                        if (explain instanceof com.alibaba.fastjson.JSONObject) {
                            pagination.put("@explain", explain);
                        }
                        pagination.put("total", (Object)total);
                        pagination.put("count", (Object)count);
                        pagination.put("page", (Object)page);
                        pagination.put("max", (Object)max);
                        pagination.put("more", (Object)(page < max ? 1 : 0));
                        pagination.put("first", (Object)(page == 0 ? 1 : 0));
                        pagination.put("last", (Object)(page == max ? 1 : 0));
                        this.putQueryResult(pathPrefix + "info", pagination);
                        if (total <= count * page) {
                            query = 1;
                        }
                    }
                    op.setMethod(this.requestMethod);
                }
                response = query == 1 ? null : op.setSQLConfig(arrayConfig.getCount(), arrayConfig.getPage(), position).executeSQL().response();
            }
            if (isArrayMainTable && position == 0) {
                this.arrayObjectParserCacheMap.put(parentPath.substring(0, parentPath.lastIndexOf("[]") + 2), op);
            }
            op = null;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONArray onArrayParse(com.alibaba.fastjson.JSONObject request, String parentPath, String name, boolean isSubquery) throws Exception {
        int max;
        int query2;
        if (Log.DEBUG) {
            Log.i(TAG, "\n\n\n onArrayParse parentPath = " + parentPath + "; name = " + name + "; request = " + JSON.toJSONString(request));
        }
        if (!isSubquery && !RequestMethod.isGetMethod(this.requestMethod, true)) {
            throw new UnsupportedOperationException("key[]:{} \u53ea\u652f\u6301 GET, GETS \u65b9\u6cd5\uff01\u5176\u5b83\u65b9\u6cd5\u4e0d\u5141\u8bb8\u4f20 " + name + ":{} \u7b49\u8fd9\u79cd key[]:{} \u683c\u5f0f\uff01");
        }
        if (request == null || request.isEmpty()) {
            return null;
        }
        String path = AbstractParser.getAbsPath(parentPath, name);
        String query = request.getString("query");
        Integer count = request.getInteger("count");
        int page = request.getIntValue("page");
        Object join = request.get((Object)"join");
        if (query == null) {
            query2 = 0;
        } else {
            switch (query) {
                case "0": 
                case "TABLE": {
                    query2 = 0;
                    break;
                }
                case "1": 
                case "TOTAL": {
                    query2 = 1;
                    break;
                }
                case "2": 
                case "ALL": {
                    query2 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(path + "/" + "query" + ":value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 [0,1,2] \u6216 [TABLE, TOTAL, ALL] \u5185 !");
                }
            }
        }
        int maxPage = this.getMaxQueryPage();
        if (page < 0 || page > maxPage) {
            throw new IllegalArgumentException(path + "/" + "page" + ":value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 0-" + maxPage + " \u5185 !");
        }
        int count2 = isSubquery || count != null ? (count == null ? 0 : count) : this.getDefaultQueryCount();
        int n = max = isSubquery ? count2 : this.getMaxQueryCount();
        if (count2 < 0 || count2 > max) {
            throw new IllegalArgumentException(path + "/" + "count" + ":value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 0-" + max + " \u5185 !");
        }
        request.remove((Object)"query");
        request.remove((Object)"count");
        request.remove((Object)"page");
        request.remove((Object)"join");
        Log.d(TAG, "onArrayParse  query = " + query + "; count = " + count + "; page = " + page + "; join = " + join);
        if (request.isEmpty()) {
            Log.e(TAG, "onArrayParse  request.isEmpty() >> return null;");
            return null;
        }
        JSONArray response = null;
        try {
            com.alibaba.fastjson.JSONObject parent;
            int size = count2 == 0 ? max : count2;
            Log.d(TAG, "onArrayParse  size = " + size + "; page = " + page);
            int index = isSubquery || name == null ? -1 : name.lastIndexOf("[]");
            String childPath = index <= 0 ? null : Pair.parseEntry(name.substring(0, index), true).getKey();
            String arrTableKey = null;
            String[] childKeys = StringUtil.split(childPath, "-", false);
            if (childKeys == null || childKeys.length <= 0 || !request.containsKey((Object)childKeys[0])) {
                childKeys = null;
            } else if (childKeys.length == 1 && JSONRequest.isTableKey(childKeys[0])) {
                arrTableKey = childKeys[0];
            }
            response = new JSONArray();
            SQLConfig config = this.createSQLConfig().setMethod(this.requestMethod).setCount(size).setPage(page).setQuery(query2).setTable(arrTableKey).setJoinList(this.onJoinParse(join, request));
            boolean isExtract = true;
            for (int i = 0; i < (isSubquery ? 1 : size) && (parent = this.onObjectParse(request, isSubquery ? parentPath : path, isSubquery ? name : "" + i, config.setType(1).setPosition(i), isSubquery)) != null && !parent.isEmpty(); ++i) {
                List list;
                long startTime = System.currentTimeMillis();
                com.alibaba.fastjson.JSONObject fo = i != 0 || arrTableKey == null ? null : parent.getJSONObject(arrTableKey);
                List list2 = list = fo == null ? null : (List)fo.remove((Object)"@RAW@LIST");
                if (list != null && !list.isEmpty()) {
                    isExtract = false;
                    list.set(0, fo);
                    response.addAll((Collection)list);
                    long endTime = System.currentTimeMillis();
                    Log.d(TAG, "\n onArrayParse <<<<<<<<<<<<<<<<<<<<<<<<<<<<\n for (int i = 0; i < (isSubquery ? 1 : size); i++)  startTime = " + startTime + "; endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
                    break;
                }
                response.add(AbstractParser.getValue(parent, childKeys));
            }
            if (isExtract) {
                Object fo;
                long startTime = System.currentTimeMillis();
                Object object = fo = childKeys == null || response.isEmpty() ? null : response.get(0);
                if (fo instanceof Boolean || fo instanceof Number || fo instanceof String) {
                    this.putQueryResult(path, response);
                }
                long endTime = System.currentTimeMillis();
                Log.d(TAG, "\n onArrayParse <<<<<<<<<<<<<<<<<<<<<<<<<<<<\n isExtract >> putQueryResult  startTime = " + startTime + "; endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
            }
        }
        finally {
            request.put("query", (Object)query);
            request.put("count", (Object)count);
            request.put("page", (Object)page);
            request.put("join", join);
        }
        if (Log.DEBUG) {
            Log.i(TAG, "onArrayParse  return response = \n" + JSON.toJSONString(response) + "\n>>>>>>>>>>>>>>>\n\n\n");
        }
        return response;
    }

    private List<Join> onJoinParse(Object join, com.alibaba.fastjson.JSONObject request) throws Exception {
        Set set;
        com.alibaba.fastjson.JSONObject joinMap = null;
        if (join instanceof com.alibaba.fastjson.JSONObject) {
            joinMap = (com.alibaba.fastjson.JSONObject)join;
        } else if (join instanceof String) {
            String[] sArr;
            String[] stringArray = sArr = request == null || request.isEmpty() ? null : StringUtil.split((String)join);
            if (sArr != null && sArr.length > 0) {
                joinMap = new com.alibaba.fastjson.JSONObject(true);
                for (int i = 0; i < sArr.length; ++i) {
                    joinMap.put(sArr[i], (Object)new com.alibaba.fastjson.JSONObject());
                }
            }
        } else if (join != null) {
            throw new UnsupportedDataTypeException("AbstractParser.onJoinParse  join \u53ea\u80fd\u662f String \u6216 JSONObject \u7c7b\u578b\uff01");
        }
        Set set2 = set = joinMap == null ? null : joinMap.entrySet();
        if (set == null || set.isEmpty()) {
            Log.e(TAG, "onJoinParse  set == null || set.isEmpty() >> return null;");
            return null;
        }
        ArrayList<Join> joinList = new ArrayList<Join>();
        for (Map.Entry e : set) {
            com.alibaba.fastjson.JSONObject targetObj;
            String targetKey;
            String targetPath;
            com.alibaba.fastjson.JSONObject tableObj;
            if (!(e.getValue() instanceof com.alibaba.fastjson.JSONObject)) {
                throw new IllegalArgumentException("join:value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1/key1,... \u6216 { '&/Table0/key0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u5f62\u5f0f\uff01");
            }
            String path = "" + (String)e.getKey();
            int index = path.indexOf("/");
            if (index < 0) {
                throw new IllegalArgumentException("join:value \u4e2d value \u503c " + path + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1/key1,... \u6216 { '&/Table0/key0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u5f62\u5f0f\uff01");
            }
            String joinType = path.substring(0, index);
            String tableKey = (index = (path = path.substring(index + 1)).indexOf("/")) < 0 ? null : path.substring(0, index);
            Entry<String, String> entry = Pair.parseEntry(tableKey, true);
            String table = entry.getKey();
            if (!StringUtil.isName(table)) {
                throw new IllegalArgumentException("join:value \u4e2d value \u7684 Table \u503c " + table + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1:alias1/key1,... \u8fd9\u79cd\u5f62\u5f0f\uff01\u4e14 Table0 \u5fc5\u987b\u6ee1\u8db3\u5927\u5199\u5b57\u6bcd\u5f00\u5934\u7684\u8868\u5bf9\u8c61\u82f1\u6587\u5355\u8bcd key \u683c\u5f0f\uff01");
            }
            String alias = entry.getValue();
            if (StringUtil.isNotEmpty(alias, true) && !StringUtil.isName(alias)) {
                throw new IllegalArgumentException("join:value \u4e2d value \u7684 alias \u503c " + alias + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1:alias1/key1,... \u8fd9\u79cd\u5f62\u5f0f\uff01\u4e14 Table:alias \u7684 alias \u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
            }
            String key = StringUtil.isEmpty(table, true) ? null : path.substring(index + 1);
            try {
                tableObj = request.getJSONObject(tableKey);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("join:'" + path + "' \u5bf9\u5e94\u7684 " + tableKey + ":value \u4e2d value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u662f {} \u8fd9\u79cd JSONObject \u683c\u5f0f\uff01" + e2.getMessage());
            }
            String string = targetPath = tableObj == null ? null : tableObj.getString(key);
            if (StringUtil.isEmpty(targetPath, true)) {
                throw new IllegalArgumentException("/" + path + ":value \u4e2d value \u503c " + targetPath + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a\u5f15\u7528\u8d4b\u503c\u7684\u8def\u5f84 '/targetTable/targetKey' \uff01");
            }
            index = targetPath.lastIndexOf("/");
            String string2 = targetKey = index < 0 ? null : targetPath.substring(index + 1);
            if (!StringUtil.isName(targetKey)) {
                throw new IllegalArgumentException("/" + path + ":'/targetTable/targetKey' \u4e2d targetKey \u503c " + targetKey + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
            }
            String targetTableKey = (index = (targetPath = targetPath.substring(0, index)).lastIndexOf("/")) < 0 ? targetPath : targetPath.substring(index + 1);
            String targetTable = targetTableKey;
            if (!StringUtil.isName(targetTable)) {
                throw new IllegalArgumentException("/" + path + ":'/targetTable/targetKey' \u4e2d targetTable \u503c " + targetTable + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u5927\u5199\u5b57\u6bcd\u5f00\u5934\u7684\u8868\u5bf9\u8c61\u82f1\u6587\u5355\u8bcd key \u683c\u5f0f\uff01");
            }
            try {
                targetObj = request.getJSONObject(targetTableKey);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("/" + path + ":'/targetTable/targetKey' \u4e2d\u8def\u5f84\u5bf9\u5e94\u7684 '" + targetTableKey + "':value \u4e2d value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u662f {} \u8fd9\u79cd JSONObject \u683c\u5f0f\uff01" + e2.getMessage());
            }
            if (targetObj == null) {
                throw new IllegalArgumentException("/" + path + ":'/targetTable/targetKey' \u4e2d\u8def\u5f84\u5bf9\u5e94\u7684\u5bf9\u8c61 '" + targetTableKey + "':{} \u4e0d\u5b58\u5728\u6216\u503c\u4e3a null \uff01\u5fc5\u987b\u662f {} \u8fd9\u79cd JSONObject \u683c\u5f0f\uff01");
            }
            if (tableObj.size() > 1) {
                com.alibaba.fastjson.JSONObject newTableObj = new com.alibaba.fastjson.JSONObject(tableObj.size(), true);
                newTableObj.put(key, tableObj.remove((Object)key));
                newTableObj.putAll((Map)tableObj);
                tableObj = newTableObj;
                request.put(tableKey, (Object)tableObj);
            }
            Join j = new Join();
            j.setPath(path);
            j.setOriginKey(key);
            j.setOriginValue(targetPath);
            j.setJoinType(joinType);
            j.setTable(table);
            j.setAlias(alias);
            j.setTargetTable(targetTable);
            j.setTargetKey(targetKey);
            j.setKeyAndType(key);
            j.setRequest(this.getJoinObject(table, tableObj, key));
            j.setOuter((com.alibaba.fastjson.JSONObject)e.getValue());
            if (!StringUtil.isName(j.getKey())) {
                throw new IllegalArgumentException("join:value \u4e2d value \u7684 key@ \u4e2d key \u503c " + j.getKey() + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
            }
            joinList.add(j);
        }
        return joinList;
    }

    private com.alibaba.fastjson.JSONObject getJoinObject(String table, com.alibaba.fastjson.JSONObject obj, String key) {
        if (obj == null || obj.isEmpty()) {
            Log.e(TAG, "getIdList  obj == null || obj.isEmpty() >> return null;");
            return null;
        }
        if (StringUtil.isEmpty(key, true)) {
            Log.e(TAG, "getIdList  StringUtil.isEmpty(key, true) >> return null;");
            return null;
        }
        com.alibaba.fastjson.JSONObject requestObj = new com.alibaba.fastjson.JSONObject(true);
        LinkedHashSet set = new LinkedHashSet(obj.keySet());
        for (String k : set) {
            if (StringUtil.isEmpty(k, true)) continue;
            if (k.startsWith("@")) {
                if (!JOIN_COPY_KEY_LIST.contains(k)) continue;
                requestObj.put(k, obj.get((Object)k));
                continue;
            }
            if (k.endsWith("@")) {
                if (k.equals(key)) continue;
                throw new UnsupportedOperationException(table + "." + k + " \u4e0d\u5408\u6cd5\uff01" + "join" + " \u5173\u8054\u7684Table\u4e2d\u53ea\u80fd\u67091\u4e2a key@:value \uff01");
            }
            if (k.contains("()")) continue;
            requestObj.put(k, obj.get((Object)k));
        }
        return requestObj;
    }

    @Override
    public int getDefaultQueryCount() {
        return 10;
    }

    @Override
    public int getMaxQueryPage() {
        return 100;
    }

    @Override
    public int getMaxQueryCount() {
        return 100;
    }

    @Override
    public int getMaxUpdateCount() {
        return 10;
    }

    @Override
    public int getMaxSQLCount() {
        return 200;
    }

    @Override
    public int getMaxObjectCount() {
        return 5;
    }

    @Override
    public int getMaxArrayCount() {
        return 5;
    }

    @Override
    public int getMaxQueryDepth() {
        return 5;
    }

    protected static Object getValue(com.alibaba.fastjson.JSONObject parent, String[] pathKeys) {
        if (parent == null || pathKeys == null || pathKeys.length <= 0) {
            Log.w(TAG, "getChild  parent == null || pathKeys == null || pathKeys.length <= 0 >> return parent;");
            return parent;
        }
        int last = pathKeys.length - 1;
        for (int i = 0; i < last && parent != null; ++i) {
            parent = AbstractParser.getJSONObject(parent, pathKeys[i]);
        }
        return parent == null ? null : parent.get((Object)pathKeys[last]);
    }

    public static String getValuePath(String parentPath, String valuePath) {
        valuePath = valuePath.startsWith("/") ? AbstractParser.getAbsPath(parentPath, valuePath) : AbstractParser.replaceArrayChildPath(parentPath, valuePath);
        return valuePath;
    }

    public static String getAbsPath(String path, String name) {
        Log.i(TAG, "getPath  path = " + path + "; name = " + name + " <<<<<<<<<<<<<");
        path = StringUtil.getString(path);
        name = StringUtil.getString(name);
        if (StringUtil.isNotEmpty(path, false)) {
            if (StringUtil.isNotEmpty(name, false)) {
                path = path + (name.startsWith("/") ? "" : "/") + name;
            }
        } else {
            path = name;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Log.i(TAG, "getPath  return " + path + " >>>>>>>>>>>>>>>>");
        return path;
    }

    public static String replaceArrayChildPath(String parentPath, String valuePath) {
        Object[] vs;
        String[] ps = StringUtil.split(parentPath, "]/");
        if (ps != null && ps.length > 1 && (vs = StringUtil.split(valuePath, "]/")) != null && vs.length > 0) {
            for (int i = 0; i < ps.length - 1 && ps[i] != null && ps[i].equals(vs[i]); ++i) {
                String pos;
                String string = pos = !ps[i + 1].contains("/") ? ps[i + 1] : ps[i + 1].substring(0, ps[i + 1].indexOf("/"));
                if (((String)vs[i + 1]).startsWith(pos + "/")) continue;
                vs[i + 1] = pos + "/" + (String)vs[i + 1];
            }
            return StringUtil.getString(vs, "]/");
        }
        return valuePath;
    }

    @Override
    public synchronized void putQueryResult(String path, Object result) {
        Log.i(TAG, "\n putQueryResult  valuePath = " + path + "; result = " + result + "\n <<<<<<<<<<<<<<<<<<<<<<<");
        Log.d(TAG, "putQueryResult  queryResultMap.containsKey(valuePath) >> queryResultMap.put(path, result);");
        this.queryResultMap.put(path, result);
    }

    @Override
    public Object getValueByPath(String valuePath) {
        Log.i(TAG, "<<<<<<<<<<<<<<< \n getValueByPath  valuePath = " + valuePath + "\n <<<<<<<<<<<<<<<<<<");
        if (StringUtil.isEmpty(valuePath, true)) {
            Log.e(TAG, "getValueByPath  StringUtil.isNotEmpty(valuePath, true) == false >> return null;");
            return null;
        }
        Object target = this.queryResultMap.get(valuePath);
        if (target != null) {
            return target;
        }
        Object parent = null;
        String[] keys = null;
        for (Map.Entry<String, Object> entry : this.queryResultMap.entrySet()) {
            String path = entry.getKey();
            if (!valuePath.startsWith(path + "/")) continue;
            try {
                parent = (com.alibaba.fastjson.JSONObject)entry.getValue();
            }
            catch (Exception e) {
                Log.e(TAG, "getValueByPath  try { parent = (JSONObject) queryResultMap.get(path); } catch { \n parent not instanceof JSONObject!");
                parent = null;
            }
            if (parent == null) break;
            keys = StringUtil.splitPath(valuePath.substring(path.length()));
            break;
        }
        if (keys != null && keys.length > 1) {
            for (int i = 0; i < keys.length - 1 && parent != null; ++i) {
                parent = AbstractParser.getJSONObject((com.alibaba.fastjson.JSONObject)parent, (String)keys[i]);
            }
        }
        if (parent != null) {
            Log.i(TAG, "getValueByPath >> get from queryResultMap >> return  parent.get(keys[keys.length - 1]);");
            Object object = target = keys == null || keys.length <= 0 ? parent : parent.get((Object)keys[keys.length - 1]);
            if (target != null) {
                Log.i(TAG, "getValueByPath >> getValue >> return target = " + target);
                return target;
            }
        }
        if ((target = AbstractParser.getValue(this.requestObject, StringUtil.splitPath(valuePath))) != null) {
            Log.i(TAG, "getValueByPath >> getValue >> return target = " + target);
            return target;
        }
        Log.i(TAG, "getValueByPath  return valuePath;");
        return valuePath;
    }

    public static com.alibaba.fastjson.JSONObject getJSONObject(com.alibaba.fastjson.JSONObject object, String key) {
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            Log.i(TAG, "getJSONObject  try { return object.getJSONObject(key); } catch (Exception e) { \n" + e.getMessage());
            return null;
        }
    }

    public void putArrayMainCache(String arrayPath, List<com.alibaba.fastjson.JSONObject> mainTableDataList) {
        this.arrayMainCacheMap.put(arrayPath, mainTableDataList);
    }

    public List<com.alibaba.fastjson.JSONObject> getArrayMainCache(String arrayPath) {
        return this.arrayMainCacheMap.get(arrayPath);
    }

    public com.alibaba.fastjson.JSONObject getArrayMainCacheItem(String arrayPath, int position) {
        List<com.alibaba.fastjson.JSONObject> list = this.getArrayMainCache(arrayPath);
        return list == null || position >= list.size() ? null : list.get(position);
    }

    @Override
    public com.alibaba.fastjson.JSONObject executeSQL(SQLConfig config, boolean isSubquery) throws Exception {
        if (config == null) {
            Log.d(TAG, "executeSQL  config == null >> return null;");
            return null;
        }
        if (isSubquery) {
            com.alibaba.fastjson.JSONObject sqlObj = new com.alibaba.fastjson.JSONObject(true);
            sqlObj.put(KEY_CONFIG, (Object)config);
            return sqlObj;
        }
        try {
            com.alibaba.fastjson.JSONObject result;
            boolean explain = config.isExplain();
            if (explain) {
                config.setExplain(false);
                com.alibaba.fastjson.JSONObject res = this.getSQLExecutor().execute(config, false);
                if (RequestMethod.isQueryMethod(config.getMethod())) {
                    com.alibaba.fastjson.JSONObject explainResult;
                    config.setExplain(explain);
                    com.alibaba.fastjson.JSONObject jSONObject = explainResult = config.isMain() && config.getPosition() != 0 ? null : this.getSQLExecutor().execute(config, false);
                    if (explainResult == null) {
                        result = res;
                    } else {
                        result = new com.alibaba.fastjson.JSONObject(true);
                        result.put("@explain", (Object)explainResult);
                        result.putAll((Map)res);
                    }
                } else {
                    result = new com.alibaba.fastjson.JSONObject(true);
                    result.put(KEY_SQL, (Object)config.getSQL(false));
                    result.putAll((Map)res);
                }
            } else {
                result = this.getSQLExecutor().execute(config, false);
            }
            com.alibaba.fastjson.JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            if (!Log.DEBUG && e instanceof SQLException) {
                throw new SQLException("\u6570\u636e\u5e93\u9a71\u52a8\u6267\u884c\u5f02\u5e38SQLException\uff0c\u975e Log.DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u663e\u793a\u8be6\u60c5\uff0c\u907f\u514d\u6cc4\u6f0f\u771f\u5b9e\u6a21\u5f0f\u540d\u3001\u8868\u540d\u7b49\u9690\u79c1\u4fe1\u606f", e);
            }
            throw e;
        }
        finally {
            if (config.getPosition() == 0 && config.limitSQLCount()) {
                int maxSQLCount = this.getMaxSQLCount();
                int sqlCount = this.getSQLExecutor().getExecutedSQLCount();
                Log.d(TAG, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< \n\n\n \u5df2\u6267\u884c " + sqlCount + "/" + maxSQLCount + " \u6761 SQL \n\n\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                if (sqlCount > maxSQLCount) {
                    throw new IllegalArgumentException("\u622a\u81f3 " + config.getTable() + " \u5df2\u6267\u884c " + sqlCount + " \u6761 SQL\uff0c\u6570\u91cf\u5df2\u8d85\u9650\uff0c\u5fc5\u987b\u5728 0-" + maxSQLCount + " \u5185 !");
                }
            }
        }
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public void begin(int transactionIsolation) {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< begin transactionIsolation = " + transactionIsolation + " >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().setTransactionIsolation(transactionIsolation);
    }

    @Override
    public void rollback() throws SQLException {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< rollback >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< rollback savepoint " + (savepoint == null ? "" : "!") + "= null >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().rollback(savepoint);
    }

    @Override
    public void commit() throws SQLException {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< commit >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().commit();
    }

    @Override
    public void close() {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< close >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().close();
    }

    protected void onBegin() {
        if (RequestMethod.isQueryMethod(this.requestMethod)) {
            return;
        }
        this.begin(this.getTransactionIsolation());
    }

    protected void onCommit() {
        if (RequestMethod.isQueryMethod(this.requestMethod)) {
            return;
        }
        try {
            this.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void onRollback() {
        if (RequestMethod.isQueryMethod(this.requestMethod)) {
            return;
        }
        try {
            this.rollback();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            try {
                this.rollback(null);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void onClose() {
        this.close();
        this.verifier = null;
        this.sqlExecutor = null;
        this.queryResultMap.clear();
        this.queryResultMap = null;
    }

    static {
        JOIN_COPY_KEY_LIST.add("@role");
        JOIN_COPY_KEY_LIST.add("@database");
        JOIN_COPY_KEY_LIST.add("@schema");
        JOIN_COPY_KEY_LIST.add("@datasource");
        JOIN_COPY_KEY_LIST.add("@column");
        JOIN_COPY_KEY_LIST.add("@combine");
        JOIN_COPY_KEY_LIST.add("@group");
        JOIN_COPY_KEY_LIST.add("@having");
        JOIN_COPY_KEY_LIST.add("@order");
        JOIN_COPY_KEY_LIST.add("@raw");
    }
}

