/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import apijson.Log;
import apijson.MethodAccess;
import apijson.SQL;
import apijson.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JSONObject
extends com.alibaba.fastjson.JSONObject {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "JSONObject";
    public static final String KEY_ARRAY = "[]";
    public static String KEY_ID = "id";
    public static String KEY_ID_IN = KEY_ID + "{}";
    public static String KEY_USER_ID = "userId";
    public static String KEY_USER_ID_IN = KEY_USER_ID + "{}";
    public static final int CACHE_ALL = 0;
    public static final int CACHE_ROM = 1;
    public static final int CACHE_RAM = 2;
    public static final String CACHE_ALL_STRING = "ALL";
    public static final String CACHE_ROM_STRING = "ROM";
    public static final String CACHE_RAM_STRING = "RAM";
    public static final String KEY_TRY = "@try";
    public static final String KEY_CATCH = "@catch";
    public static final String KEY_DROP = "@drop";
    public static final String KEY_DEFULT = "@default";
    public static final String KEY_NULL = "@null";
    public static final String KEY_ROLE = "@role";
    public static final String KEY_DATABASE = "@database";
    public static final String KEY_SCHEMA = "@schema";
    public static final String KEY_DATASOURCE = "@datasource";
    public static final String KEY_EXPLAIN = "@explain";
    public static final String KEY_CACHE = "@cache";
    public static final String KEY_COLUMN = "@column";
    public static final String KEY_FROM = "@from";
    public static final String KEY_COMBINE = "@combine";
    public static final String KEY_GROUP = "@group";
    public static final String KEY_HAVING = "@having";
    public static final String KEY_ORDER = "@order";
    public static final String KEY_RAW = "@raw";
    public static final String KEY_JSON = "@json";
    public static final List<String> TABLE_KEY_LIST = new ArrayList<String>();

    public JSONObject() {
        super(true);
    }

    public JSONObject(Object object) {
        this(JSONObject.toJSONString((Object)object));
    }

    public JSONObject(String json) {
        this(JSONObject.parseObject((String)json));
    }

    public JSONObject(com.alibaba.fastjson.JSONObject object) {
        this();
        this.putsAll((Map<? extends String, ? extends Object>)object);
    }

    public static boolean isArrayKey(String key) {
        return key != null && key.endsWith(KEY_ARRAY);
    }

    public static boolean isTableKey(String key) {
        return StringUtil.isBigName(key);
    }

    public static boolean isTableArray(String key) {
        return JSONObject.isArrayKey(key) && JSONObject.isTableKey(key.substring(0, key.length() - KEY_ARRAY.length()));
    }

    public JSONObject setId(Long id) {
        return this.puts(KEY_ID, id);
    }

    public JSONObject setIdIn(List<Object> list) {
        return this.puts(KEY_ID_IN, list);
    }

    public JSONObject setUserId(Long id) {
        return this.puts(KEY_USER_ID, id);
    }

    public JSONObject setUserIdIn(List<Object> list) {
        return this.puts(KEY_USER_ID_IN, list);
    }

    public JSONObject setTry(Boolean tri) {
        return this.puts(KEY_TRY, tri);
    }

    public JSONObject setCatch(String isCatch) {
        return this.puts(KEY_CATCH, isCatch);
    }

    public JSONObject setDrop(Boolean drop) {
        return this.puts(KEY_DROP, drop);
    }

    public JSONObject setDefault(Boolean hasDefault) {
        return this.puts(KEY_DEFULT, hasDefault);
    }

    public JSONObject setRole(String role) {
        return this.puts(KEY_ROLE, role);
    }

    public JSONObject setDatabase(String database) {
        return this.puts(KEY_DATABASE, database);
    }

    public JSONObject setSchema(String schema) {
        return this.puts(KEY_SCHEMA, schema);
    }

    public JSONObject setDatasource(String datasource) {
        return this.puts(KEY_DATASOURCE, datasource);
    }

    public JSONObject setExplain(Boolean explain) {
        return this.puts(KEY_EXPLAIN, explain);
    }

    public JSONObject setCache(Integer cache) {
        return this.puts(KEY_CACHE, cache);
    }

    public JSONObject setCache(String cache) {
        return this.puts(KEY_CACHE, cache);
    }

    public JSONObject setColumn(String ... keys) {
        return this.setColumn(StringUtil.getString((Object[])keys, true));
    }

    public JSONObject setColumn(String keys) {
        return this.puts(KEY_COLUMN, keys);
    }

    public JSONObject setCombine(String ... keys) {
        return this.setCombine(StringUtil.getString((Object[])keys, true));
    }

    public JSONObject setCombine(String keys) {
        return this.puts(KEY_COMBINE, keys);
    }

    public JSONObject setGroup(String ... keys) {
        return this.setGroup(StringUtil.getString((Object[])keys, true));
    }

    public JSONObject setGroup(String keys) {
        return this.puts(KEY_GROUP, keys);
    }

    public JSONObject setHaving(String ... keys) {
        return this.setHaving(StringUtil.getString((Object[])keys, true));
    }

    public JSONObject setHaving(String keys) {
        return this.puts(KEY_HAVING, keys);
    }

    public JSONObject setOrder(String ... keys) {
        return this.setOrder(StringUtil.getString((Object[])keys, true));
    }

    public JSONObject setOrder(String keys) {
        return this.puts(KEY_ORDER, keys);
    }

    public JSONObject setRaw(String keys) {
        return this.puts(KEY_RAW, keys);
    }

    public JSONObject setJson(String keys) {
        return this.puts(KEY_JSON, keys);
    }

    @Deprecated
    public JSONObject setJSON(String keys) {
        return this.puts(KEY_JSON, keys);
    }

    public JSONObject putsPath(String key, String ... keys) {
        return this.puts(key + "@", StringUtil.getString((Object[])keys, "/"));
    }

    public JSONObject putsNull(String key, boolean isNull) {
        return this.puts(key + "{}", SQL.isNull(isNull));
    }

    public JSONObject putsEmpty(String key, boolean isEmpty) {
        return this.putsEmpty(key, isEmpty, false);
    }

    public JSONObject putsEmpty(String key, boolean isEmpty, boolean trim) {
        return this.puts(key + "{}", SQL.isEmpty(key, isEmpty, trim));
    }

    public JSONObject putsLength(String key, String compare) {
        return this.puts(key + "{}", SQL.length(key) + compare);
    }

    public JSONObject putsSearch(String key, String value) {
        return this.putsSearch(key, value, 0);
    }

    public JSONObject putsSearch(String key, String value, int type) {
        return this.puts(key + "$", SQL.search(value, type));
    }

    public JSONObject putsAll(Map<? extends String, ? extends Object> map) {
        this.putAll(map);
        return this;
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map != null && !map.isEmpty()) {
            super.putAll(map);
        }
    }

    public JSONObject puts(Object value) {
        return this.puts(null, value);
    }

    public JSONObject puts(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public Object put(Object value) {
        return this.put(null, value);
    }

    public Object put(String key, Object value) {
        if (value == null) {
            Log.e(TAG, "put  value == null >> return null;");
            return null;
        }
        if (StringUtil.isEmpty(key, true)) {
            Class<?> clazz = value.getClass();
            if (clazz.getAnnotation(MethodAccess.class) == null) {
                throw new IllegalArgumentException("puts  StringUtil.isEmpty(key, true) clazz.getAnnotation(MethodAccess.class) == null \n key\u4e3a\u7a7a\u65f6\u4ec5\u652f\u6301 \u7c7b\u578b\u88ab@MethodAccess\u6ce8\u89e3 \u7684value !!! \n \u5982\u679c\u4e00\u5b9a\u8981\u8fd9\u4e48\u7528\uff0c\u8bf7\u5bf9 " + clazz.getName() + " \u6ce8\u89e3\uff01 \n \u5982\u679c\u662f\u7c7b\u4f3c key[]:{} \u7ed3\u6784\u7684\u8bf7\u6c42\uff0c\u5efa\u8bae\u7528 putsAll(...) \uff01");
            }
            key = value.getClass().getSimpleName();
        }
        return super.put(key, value);
    }

    static {
        TABLE_KEY_LIST.add(KEY_ROLE);
        TABLE_KEY_LIST.add(KEY_DATABASE);
        TABLE_KEY_LIST.add(KEY_SCHEMA);
        TABLE_KEY_LIST.add(KEY_DATASOURCE);
        TABLE_KEY_LIST.add(KEY_EXPLAIN);
        TABLE_KEY_LIST.add(KEY_CACHE);
        TABLE_KEY_LIST.add(KEY_COLUMN);
        TABLE_KEY_LIST.add(KEY_FROM);
        TABLE_KEY_LIST.add(KEY_COMBINE);
        TABLE_KEY_LIST.add(KEY_GROUP);
        TABLE_KEY_LIST.add(KEY_HAVING);
        TABLE_KEY_LIST.add(KEY_ORDER);
        TABLE_KEY_LIST.add(KEY_RAW);
        TABLE_KEY_LIST.add(KEY_JSON);
    }
}

