/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.FunctionParser;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;

public class AbstractFunctionParser
implements FunctionParser {
    public static final Map<String, JSONObject> FUNCTION_MAP = new HashMap<String, JSONObject>();
    private RequestMethod method;
    private String tag;
    private int version;
    private JSONObject request;
    private String key;
    private String parentPath;
    private String currentName;
    private JSONObject currentObject;

    public AbstractFunctionParser() {
        this(null, null, 0, null);
    }

    public AbstractFunctionParser(RequestMethod method, String tag, int version, @NotNull JSONObject request) {
        this.setMethod(method == null ? RequestMethod.GET : method);
        this.setTag(tag);
        this.setVersion(version);
        this.setRequest(request);
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public AbstractFunctionParser setMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public AbstractFunctionParser setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public AbstractFunctionParser setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public AbstractFunctionParser setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public AbstractFunctionParser setParentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @Override
    public String getCurrentName() {
        return this.currentName;
    }

    @Override
    public AbstractFunctionParser setCurrentName(String currentName) {
        this.currentName = currentName;
        return this;
    }

    @Override
    @NotNull
    public JSONObject getRequest() {
        return this.request;
    }

    @Override
    public AbstractFunctionParser setRequest(@NotNull JSONObject request) {
        this.request = request;
        return this;
    }

    @Override
    @NotNull
    public JSONObject getCurrentObject() {
        return this.currentObject;
    }

    @Override
    public AbstractFunctionParser setCurrentObject(@NotNull JSONObject currentObject) {
        this.currentObject = currentObject;
        return this;
    }

    @Override
    public Object invoke(@NotNull String function, @NotNull JSONObject currentObject) throws Exception {
        return AbstractFunctionParser.invoke(this, function, currentObject);
    }

    public static Object invoke(@NotNull AbstractFunctionParser parser, @NotNull String function, @NotNull JSONObject currentObject) throws Exception {
        List<String> ml;
        FunctionBean fb = AbstractFunctionParser.parseFunction(function, currentObject, false);
        JSONObject row = FUNCTION_MAP.get(fb.getMethod());
        if (row == null) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " !");
        }
        int v = row.getIntValue("version");
        if (parser.getVersion() < v) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8 version = " + parser.getVersion() + " \u7684\u8bf7\u6c42\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " ! \u5fc5\u987b\u6ee1\u8db3 version >= " + v + " !");
        }
        String t = row.getString("tag");
        if (t != null && !t.equals(parser.getTag())) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8 tag = " + parser.getTag() + " \u7684\u8bf7\u6c42\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " ! \u5fc5\u987b\u6ee1\u8db3 tag = " + t + " !");
        }
        String[] methods = StringUtil.split(row.getString("methods"));
        List<String> list = ml = methods == null || methods.length <= 0 ? null : Arrays.asList(methods);
        if (ml != null && !ml.contains(parser.getMethod().toString())) {
            throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8 method = " + (Object)((Object)parser.getMethod()) + " \u7684\u8bf7\u6c42\u8c03\u7528\u8fdc\u7a0b\u51fd\u6570 " + fb.getMethod() + " ! \u5fc5\u987b\u6ee1\u8db3 method \u5728 " + methods + "\u5185 !");
        }
        try {
            return AbstractFunctionParser.invoke(parser, fb.getMethod(), fb.getTypes(), fb.getValues());
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + function + " \u5bf9\u5e94\u7684\u8fdc\u7a0b\u51fd\u6570 " + AbstractFunctionParser.getFunction(fb.getMethod(), fb.getKeys()) + " \u4e0d\u5728\u540e\u7aef\u5de5\u7a0b\u7684DemoFunction\u5185\uff01\n\u8bf7\u68c0\u67e5\u51fd\u6570\u540d\u548c\u53c2\u6570\u6570\u91cf\u662f\u5426\u4e0e\u5df2\u5b9a\u4e49\u7684\u51fd\u6570\u4e00\u81f4\uff01\n\u4e14\u5fc5\u987b\u4e3a function(key0,key1,...) \u8fd9\u79cd\u5355\u51fd\u6570\u683c\u5f0f\uff01\nfunction\u5fc5\u987b\u7b26\u5408Java\u51fd\u6570\u547d\u540d\uff0ckey\u662f\u7528\u4e8e\u5728request\u5185\u53d6\u503c\u7684\u952e\uff01\n\u8c03\u7528\u65f6\u4e0d\u8981\u6709\u7a7a\u683c\uff01");
            }
            if (e instanceof InvocationTargetException) {
                Throwable te = ((InvocationTargetException)e).getTargetException();
                if (!StringUtil.isEmpty(te.getMessage(), true)) {
                    throw te instanceof Exception ? (Exception)te : new Exception(te.getMessage());
                }
                throw new IllegalArgumentException("\u5b57\u7b26 " + function + " \u5bf9\u5e94\u7684\u8fdc\u7a0b\u51fd\u6570\u4f20\u53c2\u7c7b\u578b\u9519\u8bef\uff01\n\u8bf7\u68c0\u67e5 key:value \u4e2dvalue\u7684\u7c7b\u578b\u662f\u5426\u6ee1\u8db3\u5df2\u5b9a\u4e49\u7684\u51fd\u6570 " + AbstractFunctionParser.getFunction(fb.getMethod(), fb.getKeys()) + " \u7684\u8981\u6c42\uff01");
            }
            throw e;
        }
    }

    public static Object invoke(@NotNull AbstractFunctionParser parser, @NotNull String methodName, @NotNull Class<?>[] parameterTypes, @NotNull Object[] args) throws Exception {
        return parser.getClass().getMethod(methodName, parameterTypes).invoke((Object)parser, args);
    }

    @NotNull
    public static FunctionBean parseFunction(@NotNull String function, @NotNull JSONObject request, boolean isSQLFunction) throws Exception {
        Object[] values;
        Class[] types;
        int length;
        String method;
        int start = function.indexOf("(");
        int end = function.lastIndexOf(")");
        String string = method = start <= 0 || end != function.length() - 1 ? null : function.substring(0, start);
        if (StringUtil.isEmpty(method, true)) {
            throw new IllegalArgumentException("\u5b57\u7b26 " + function + " \u4e0d\u5408\u6cd5\uff01\u51fd\u6570\u7684\u540d\u79f0 function \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u4e3a function(key0,key1,...) \u8fd9\u79cd\u5355\u51fd\u6570\u683c\u5f0f\uff01\nfunction\u5fc5\u987b\u7b26\u5408 " + (isSQLFunction ? "SQL \u51fd\u6570/SQL \u5b58\u50a8\u8fc7\u7a0b" : "Java \u51fd\u6570") + " \u547d\u540d\uff0ckey \u662f\u7528\u4e8e\u5728 request \u5185\u53d6\u503c\u7684\u952e\uff01");
        }
        String[] keys = StringUtil.split(function.substring(start + 1, end));
        int n = length = keys == null ? 0 : keys.length;
        if (isSQLFunction) {
            types = new Class[length];
            values = new Object[length];
            for (int i = 0; i < length; ++i) {
                values[i] = request.get((Object)keys[i]);
                Object v = values[i];
                if (v == null) {
                    types[i] = Object.class;
                    values[i] = null;
                    break;
                }
                if (v instanceof Boolean) {
                    types[i] = Boolean.class;
                    continue;
                }
                if (v instanceof Number) {
                    types[i] = Number.class;
                    continue;
                }
                if (v instanceof String) {
                    types[i] = String.class;
                    continue;
                }
                if (v instanceof JSONObject) {
                    types[i] = JSONObject.class;
                    continue;
                }
                if (v instanceof JSONArray) {
                    types[i] = JSONArray.class;
                    continue;
                }
                throw new UnsupportedDataTypeException(keys[i] + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u8fdc\u7a0b\u51fd\u6570 key():" + function + " \u4e2d\u7684arg\u5bf9\u5e94\u7684\u503c\u7c7b\u578b\u53ea\u80fd\u662f [Boolean, Number, String, JSONObject, JSONArray] \u4e2d\u7684\u4e00\u79cd\uff01");
            }
        } else {
            types = new Class[length + 1];
            types[0] = JSONObject.class;
            values = new Object[length + 1];
            values[0] = request;
            for (int i = 0; i < length; ++i) {
                types[i + 1] = String.class;
                values[i + 1] = keys[i];
            }
        }
        FunctionBean fb = new FunctionBean();
        fb.setFunction(function);
        fb.setMethod(method);
        fb.setKeys(keys);
        fb.setTypes(types);
        fb.setValues(values);
        return fb;
    }

    public static String getFunction(String method, String[] keys) {
        String f = method + "(JSONObject request";
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                f = f + ", String " + keys[i];
            }
        }
        f = f + ")";
        return f;
    }

    public static class FunctionBean {
        private String function;
        private String method;
        private String[] keys;
        private Class<?>[] types;
        private Object[] values;

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public void setKeys(String[] keys) {
            this.keys = keys;
        }

        public Class<?>[] getTypes() {
            return this.types;
        }

        public void setTypes(Class<?>[] types) {
            this.types = types;
        }

        public Object[] getValues() {
            return this.values;
        }

        public void setValues(Object[] values) {
            this.values = values;
        }

        public String toFunctionCallString(boolean useValue) {
            return this.toFunctionCallString(useValue, null);
        }

        public String toFunctionCallString(boolean useValue, String quote) {
            Object[] args;
            String s = this.getMethod() + "(";
            Object[] objectArray = args = useValue ? this.getValues() : this.getKeys();
            if (args != null && args.length > 0) {
                if (quote == null) {
                    quote = "'";
                }
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    s = s + (i <= 0 ? "" : ",") + (arg instanceof Boolean || arg instanceof Number ? arg : quote + arg + quote);
                }
            }
            return s + ")";
        }
    }
}

