/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import apijson.JSON;
import apijson.JSONObject;
import apijson.Log;
import apijson.NotNull;
import apijson.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Set;

public class JSONResponse
extends JSONObject {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "JSONResponse";
    public static final int CODE_SUCCESS = 200;
    public static final int CODE_UNSUPPORTED_ENCODING = 400;
    public static final int CODE_ILLEGAL_ACCESS = 401;
    public static final int CODE_UNSUPPORTED_OPERATION = 403;
    public static final int CODE_NOT_FOUND = 404;
    public static final int CODE_ILLEGAL_ARGUMENT = 406;
    public static final int CODE_NOT_LOGGED_IN = 407;
    public static final int CODE_TIME_OUT = 408;
    public static final int CODE_CONFLICT = 409;
    public static final int CODE_CONDITION_ERROR = 412;
    public static final int CODE_UNSUPPORTED_TYPE = 415;
    public static final int CODE_OUT_OF_RANGE = 416;
    public static final int CODE_NULL_POINTER = 417;
    public static final int CODE_SERVER_ERROR = 500;
    public static final String MSG_SUCCEED = "success";
    public static final String MSG_SERVER_ERROR = "Internal Server Error!";
    public static final String KEY_OK = "ok";
    public static final String KEY_CODE = "code";
    public static final String KEY_MSG = "msg";
    public static final String KEY_COUNT = "count";
    public static final String KEY_TOTAL = "total";
    public static final String KEY_INFO = "info";
    public static final String KEY_FIRST = "first";
    public static final String KEY_LAST = "last";
    public static final String KEY_MAX = "max";
    public static final String KEY_MORE = "more";

    public JSONResponse() {
    }

    public JSONResponse(String json) {
        this(JSONResponse.parseObject((String)json));
    }

    public JSONResponse(com.alibaba.fastjson.JSONObject object) {
        super(JSONResponse.format(object));
    }

    public int getCode() {
        try {
            return this.getIntValue(KEY_CODE);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getCode(com.alibaba.fastjson.JSONObject reponse) {
        try {
            return reponse.getIntValue(KEY_CODE);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getMsg() {
        return this.getString(KEY_MSG);
    }

    public static String getMsg(com.alibaba.fastjson.JSONObject reponse) {
        return reponse == null ? null : reponse.getString(KEY_MSG);
    }

    public long getId() {
        try {
            return this.getLongValue(KEY_ID);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public int getCount() {
        try {
            return this.getIntValue(KEY_COUNT);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getTotal() {
        try {
            return this.getIntValue(KEY_TOTAL);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isSuccess() {
        return JSONResponse.isSuccess(this.getCode());
    }

    public static boolean isSuccess(int code) {
        return code == 200;
    }

    public static boolean isSuccess(JSONResponse response) {
        return response != null && response.isSuccess();
    }

    public static boolean isSuccess(com.alibaba.fastjson.JSONObject response) {
        return response != null && JSONResponse.isSuccess(response.getIntValue(KEY_CODE));
    }

    public boolean isExist() {
        return JSONResponse.isExist(this.getCount());
    }

    public static boolean isExist(int count) {
        return count > 0;
    }

    public static boolean isExist(JSONResponse response) {
        return response != null && response.isExist();
    }

    public JSONResponse getJSONResponse(String key) {
        return this.getObject(key, JSONResponse.class);
    }

    public <T> T getObject(Class<T> clazz) {
        return this.getObject(clazz == null ? "" : clazz.getSimpleName(), clazz);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        return JSONResponse.getObject(this, key, clazz);
    }

    public static <T> T getObject(com.alibaba.fastjson.JSONObject object, String key, Class<T> clazz) {
        return JSONResponse.toObject(object == null ? null : object.getJSONObject(JSONResponse.formatObjectKey(key)), clazz);
    }

    public <T> T toObject(Class<T> clazz) {
        return JSONResponse.toObject(this, clazz);
    }

    public static <T> T toObject(com.alibaba.fastjson.JSONObject object, Class<T> clazz) {
        return JSON.parseObject(JSON.toJSONString(object), clazz);
    }

    public <T> List<T> getList(Class<T> clazz) {
        return this.getList("[]", clazz);
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        return JSONResponse.getList(this, key, clazz);
    }

    public static <T> List<T> getList(com.alibaba.fastjson.JSONObject object, Class<T> clazz) {
        return JSONResponse.getList(object, "[]", clazz);
    }

    public static <T> List<T> getList(com.alibaba.fastjson.JSONObject object, String key, Class<T> clazz) {
        return object == null ? null : JSON.parseArray(object.getString(JSONResponse.formatArrayKey(key)), clazz);
    }

    public JSONArray getArray() {
        return this.getArray("[]");
    }

    public JSONArray getArray(String key) {
        return JSONResponse.getArray(this, key);
    }

    public static JSONArray getArray(com.alibaba.fastjson.JSONObject object) {
        return JSONResponse.getArray(object, "[]");
    }

    public static JSONArray getArray(com.alibaba.fastjson.JSONObject object, String key) {
        return object == null ? null : object.getJSONArray(JSONResponse.formatArrayKey(key));
    }

    public static com.alibaba.fastjson.JSONObject format(com.alibaba.fastjson.JSONObject object) {
        if (object == null || object.isEmpty()) {
            Log.i(TAG, "format  object == null || object.isEmpty() >> return object;");
            return object;
        }
        com.alibaba.fastjson.JSONObject formatedObject = new com.alibaba.fastjson.JSONObject(true);
        Set set = object.keySet();
        if (set != null) {
            for (String key : set) {
                Object value = object.get((Object)key);
                if (value instanceof JSONArray) {
                    formatedObject.put(JSONResponse.formatArrayKey(key), (Object)JSONResponse.format((JSONArray)value));
                    continue;
                }
                if (value instanceof com.alibaba.fastjson.JSONObject) {
                    formatedObject.put(JSONResponse.formatObjectKey(key), (Object)JSONResponse.format((com.alibaba.fastjson.JSONObject)value));
                    continue;
                }
                formatedObject.put(JSONResponse.formatOtherKey(key), value);
            }
        }
        return formatedObject;
    }

    public static JSONArray format(JSONArray array) {
        if (array == null || array.isEmpty()) {
            Log.i(TAG, "format  array == null || array.isEmpty() >> return array;");
            return array;
        }
        JSONArray formatedArray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            if (value instanceof JSONArray) {
                formatedArray.add((Object)JSONResponse.format((JSONArray)value));
                continue;
            }
            if (value instanceof com.alibaba.fastjson.JSONObject) {
                formatedArray.add((Object)JSONResponse.format((com.alibaba.fastjson.JSONObject)value));
                continue;
            }
            formatedArray.add(value);
        }
        return formatedArray;
    }

    public static String getTableName(String fullName) {
        int index = fullName == null ? -1 : fullName.indexOf(":");
        return index < 0 ? fullName : fullName.substring(0, index);
    }

    public static String getVariableName(String fullName) {
        if (JSONResponse.isArrayKey(fullName)) {
            fullName = StringUtil.addSuffix(fullName.substring(0, fullName.length() - 2), "list");
        }
        return JSONResponse.formatKey(fullName, true, true, true, true);
    }

    public static String formatArrayKey(String key) {
        int index;
        if (JSONResponse.isArrayKey(key)) {
            key = StringUtil.addSuffix(key.substring(0, key.length() - 2), "list");
        }
        int n = index = key == null ? -1 : key.indexOf(":");
        if (index >= 0) {
            return key.substring(index + 1);
        }
        return JSONResponse.formatKey(key, false, true, true, true);
    }

    public static String formatObjectKey(String key) {
        int index;
        int n = index = key == null ? -1 : key.indexOf(":");
        if (index >= 0) {
            return key.substring(index + 1);
        }
        return JSONResponse.formatKey(key, false, true, false, true);
    }

    public static String formatOtherKey(String fullName) {
        return JSONResponse.formatKey(fullName, false, true, false, false);
    }

    public static String formatKey(String fullName, boolean formatColon, boolean formatAt, boolean formatHyphen, boolean firstCase) {
        if (fullName == null) {
            Log.w(TAG, "formatKey  fullName == null >> return null;");
            return null;
        }
        if (formatColon) {
            fullName = JSONResponse.formatColon(fullName);
        }
        if (formatAt) {
            fullName = JSONResponse.formatAt(fullName);
        }
        if (formatHyphen) {
            fullName = JSONResponse.formatHyphen(fullName, firstCase);
        }
        return firstCase ? StringUtil.firstCase(fullName) : fullName;
    }

    public static String formatAt(@NotNull String key) {
        return key.startsWith("@") ? key.substring(1) : key;
    }

    public static String formatColon(@NotNull String key) {
        int index = key.indexOf(":");
        return index < 0 ? key : key.substring(index + 1);
    }

    public static String formatHyphen(@NotNull String key, boolean firstCase) {
        int index;
        boolean first = true;
        String name = "";
        do {
            String part = (index = key.indexOf("-")) < 0 ? key : key.substring(0, index);
            name = name + (firstCase && !first ? StringUtil.firstCase(part, true) : part);
            key = key.substring(index + 1);
            first = false;
        } while (index >= 0);
        return name;
    }
}

