/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.BlockEventHandler;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import me.ryanhamshire.GriefPrevention.SiegeData;
import me.ryanhamshire.GriefPrevention.events.ClaimPermissionCheckEvent;
import me.ryanhamshire.GriefPrevention.util.BoundingBox;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Claim {
    Location lesserBoundaryCorner;
    Location greaterBoundaryCorner;
    public Date modifiedDate;
    Long id = null;
    public UUID ownerID;
    public ArrayList<String> managers = new ArrayList();
    private HashMap<String, ClaimPermission> playerIDToClaimPermissionMap = new HashMap();
    public boolean inDataStore = false;
    public boolean areExplosivesAllowed = false;
    public Claim parent = null;
    private boolean inheritNothing = false;
    public ArrayList<Claim> children = new ArrayList();
    public SiegeData siegeData = null;
    public boolean doorsOpen = false;
    private static final Set<Material> PLACEABLE_FARMING_BLOCKS = EnumSet.of(Material.PUMPKIN_STEM, new Material[]{Material.WHEAT, Material.MELON_STEM, Material.CARROTS, Material.POTATOES, Material.NETHER_WART, Material.BEETROOTS, Material.COCOA, Material.GLOW_BERRIES, Material.CAVE_VINES, Material.CAVE_VINES_PLANT});

    public boolean isAdminClaim() {
        return this.getOwnerID() == null;
    }

    public Long getID() {
        return this.id;
    }

    Claim() {
        this.modifiedDate = Calendar.getInstance().getTime();
    }

    public boolean canSiege(Player defender) {
        if (this.isAdminClaim()) {
            return false;
        }
        return this.checkPermission(defender, ClaimPermission.Access, null) == null;
    }

    public void removeSurfaceFluids(Claim exclusionClaim) {
        if (this.isAdminClaim()) {
            return;
        }
        if (this.getArea() > 10000) {
            return;
        }
        if (!GriefPrevention.instance.creativeRulesApply(this.lesserBoundaryCorner)) {
            return;
        }
        Location lesser = this.getLesserBoundaryCorner();
        Location greater = this.getGreaterBoundaryCorner();
        if (lesser.getWorld().getEnvironment() == World.Environment.NETHER) {
            return;
        }
        int seaLevel = 0;
        if (lesser.getWorld().getEnvironment() == World.Environment.NORMAL) {
            seaLevel = GriefPrevention.instance.getSeaLevel(lesser.getWorld());
        }
        for (int x = lesser.getBlockX(); x <= greater.getBlockX(); ++x) {
            for (int z = lesser.getBlockZ(); z <= greater.getBlockZ(); ++z) {
                for (int y = seaLevel - 1; y <= lesser.getWorld().getMaxHeight(); ++y) {
                    Block block = lesser.getWorld().getBlockAt(x, y, z);
                    if (exclusionClaim != null && exclusionClaim.contains(block.getLocation(), true, false) || block.getType() != Material.LAVA && block.getType() != Material.WATER) continue;
                    block.setType(Material.AIR);
                }
            }
        }
    }

    boolean hasSurfaceFluids() {
        Location lesser = this.getLesserBoundaryCorner();
        Location greater = this.getGreaterBoundaryCorner();
        if (this.getArea() > 10000) {
            return false;
        }
        int seaLevel = 0;
        if (lesser.getWorld().getEnvironment() == World.Environment.NORMAL) {
            seaLevel = GriefPrevention.instance.getSeaLevel(lesser.getWorld());
        }
        for (int x = lesser.getBlockX(); x <= greater.getBlockX(); ++x) {
            for (int z = lesser.getBlockZ(); z <= greater.getBlockZ(); ++z) {
                for (int y = seaLevel - 1; y <= lesser.getWorld().getMaxHeight(); ++y) {
                    Block block = lesser.getWorld().getBlockAt(x, y, z);
                    if (block.getType() != Material.WATER && block.getType() != Material.LAVA) continue;
                    return true;
                }
            }
        }
        return false;
    }

    Claim(Location lesserBoundaryCorner, Location greaterBoundaryCorner, UUID ownerID, List<String> builderIDs, List<String> containerIDs, List<String> accessorIDs, List<String> managerIDs, boolean inheritNothing, Long id) {
        this.modifiedDate = Calendar.getInstance().getTime();
        this.id = id;
        this.lesserBoundaryCorner = lesserBoundaryCorner;
        this.greaterBoundaryCorner = greaterBoundaryCorner;
        this.ownerID = ownerID;
        for (String builderID : builderIDs) {
            this.setPermission(builderID, ClaimPermission.Build);
        }
        for (String containerID : containerIDs) {
            this.setPermission(containerID, ClaimPermission.Inventory);
        }
        for (String accessorID : accessorIDs) {
            this.setPermission(accessorID, ClaimPermission.Access);
        }
        for (String managerID : managerIDs) {
            if (managerID == null || managerID.isEmpty()) continue;
            this.managers.add(managerID);
        }
        this.inheritNothing = inheritNothing;
    }

    Claim(Location lesserBoundaryCorner, Location greaterBoundaryCorner, UUID ownerID, List<String> builderIDs, List<String> containerIDs, List<String> accessorIDs, List<String> managerIDs, Long id) {
        this(lesserBoundaryCorner, greaterBoundaryCorner, ownerID, builderIDs, containerIDs, accessorIDs, managerIDs, false, id);
    }

    public Claim(Claim claim) {
        this.modifiedDate = claim.modifiedDate;
        this.lesserBoundaryCorner = claim.greaterBoundaryCorner.clone();
        this.greaterBoundaryCorner = claim.greaterBoundaryCorner.clone();
        this.id = claim.id;
        this.ownerID = claim.ownerID;
        this.managers = new ArrayList<String>(claim.managers);
        this.playerIDToClaimPermissionMap = new HashMap<String, ClaimPermission>(claim.playerIDToClaimPermissionMap);
        this.inDataStore = false;
        this.areExplosivesAllowed = claim.areExplosivesAllowed;
        this.parent = claim.parent;
        this.inheritNothing = claim.inheritNothing;
        this.children = new ArrayList<Claim>(claim.children);
        this.siegeData = claim.siegeData;
        this.doorsOpen = claim.doorsOpen;
    }

    public int getArea() {
        int claimWidth = this.greaterBoundaryCorner.getBlockX() - this.lesserBoundaryCorner.getBlockX() + 1;
        int claimHeight = this.greaterBoundaryCorner.getBlockZ() - this.lesserBoundaryCorner.getBlockZ() + 1;
        return claimWidth * claimHeight;
    }

    public int getWidth() {
        return this.greaterBoundaryCorner.getBlockX() - this.lesserBoundaryCorner.getBlockX() + 1;
    }

    public int getHeight() {
        return this.greaterBoundaryCorner.getBlockZ() - this.lesserBoundaryCorner.getBlockZ() + 1;
    }

    public boolean getSubclaimRestrictions() {
        return this.inheritNothing;
    }

    public void setSubclaimRestrictions(boolean inheritNothing) {
        this.inheritNothing = inheritNothing;
    }

    public boolean isNear(Location location, int howNear) {
        Claim claim = new Claim(new Location(this.lesserBoundaryCorner.getWorld(), (double)(this.lesserBoundaryCorner.getBlockX() - howNear), (double)this.lesserBoundaryCorner.getBlockY(), (double)(this.lesserBoundaryCorner.getBlockZ() - howNear)), new Location(this.greaterBoundaryCorner.getWorld(), (double)(this.greaterBoundaryCorner.getBlockX() + howNear), (double)this.greaterBoundaryCorner.getBlockY(), (double)(this.greaterBoundaryCorner.getBlockZ() + howNear)), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
        return claim.contains(location, false, true);
    }

    @Deprecated
    @Nullable
    public String allowEdit(@NotNull Player player) {
        Supplier<String> supplier = this.checkPermission(player, ClaimPermission.Edit, null);
        return supplier != null ? supplier.get() : null;
    }

    private static boolean placeableForFarming(Material material) {
        return PLACEABLE_FARMING_BLOCKS.contains(material);
    }

    @Deprecated
    @Nullable
    public String allowBuild(@NotNull Player player, @NotNull Material material) {
        Supplier<String> supplier = this.checkPermission(player, ClaimPermission.Build, (Event)new CompatBuildBreakEvent(material, false));
        return supplier != null ? supplier.get() : null;
    }

    public boolean hasExplicitPermission(@NotNull UUID uuid, @NotNull ClaimPermission level) {
        if (uuid.equals(this.getOwnerID())) {
            return true;
        }
        if (level == ClaimPermission.Manage) {
            return this.managers.contains(uuid.toString());
        }
        return level.isGrantedBy(this.playerIDToClaimPermissionMap.get(uuid.toString()));
    }

    public boolean hasExplicitPermission(@NotNull Player player, @NotNull ClaimPermission level) {
        if (this.hasExplicitPermission(player.getUniqueId(), level)) {
            return true;
        }
        if (level == ClaimPermission.Manage) {
            for (String node : this.managers) {
                if (node.length() < 3 || node.charAt(0) != '[' || node.charAt(node.length() - 1) != ']' || !player.hasPermission(node.substring(1, node.length() - 1))) continue;
                return true;
            }
            return false;
        }
        for (Map.Entry<String, ClaimPermission> stringToPermission : this.playerIDToClaimPermissionMap.entrySet()) {
            String node = stringToPermission.getKey();
            if (node.length() < 3 || node.charAt(0) != '[' || node.charAt(node.length() - 1) != ']' || !level.isGrantedBy(stringToPermission.getValue()) || !player.hasPermission(node.substring(1, node.length() - 1))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Supplier<String> checkPermission(@NotNull Player player, @NotNull ClaimPermission permission, @Nullable Event event) {
        return this.checkPermission(player, permission, event, null);
    }

    @Nullable
    Supplier<String> checkPermission(@NotNull Player player, @NotNull ClaimPermission permission, @Nullable Event event, @Nullable Supplier<String> denialOverride) {
        return this.callPermissionCheck(new ClaimPermissionCheckEvent(player, this, permission, event), denialOverride);
    }

    @Nullable
    public Supplier<String> checkPermission(@NotNull UUID uuid, @NotNull ClaimPermission permission, @Nullable Event event) {
        return this.callPermissionCheck(new ClaimPermissionCheckEvent(uuid, this, permission, event), null);
    }

    @Nullable
    private Supplier<String> callPermissionCheck(@NotNull ClaimPermissionCheckEvent event, @Nullable Supplier<String> denialOverride) {
        Supplier<String> defaultDenial = this.getDefaultDenial(event.getCheckedPlayer(), event.getCheckedUUID(), event.getRequiredPermission(), event.getTriggeringEvent());
        if (defaultDenial != null && denialOverride != null) {
            defaultDenial = denialOverride;
        }
        event.setDenialReason(defaultDenial);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getDenialReason();
    }

    @Nullable
    private Supplier<String> getDefaultDenial(@Nullable Player player, @NotNull UUID uuid, @NotNull ClaimPermission permission, @Nullable Event event) {
        if (player != null && (this.isAdminClaim() ? player.hasPermission("griefprevention.adminclaims") : permission == ClaimPermission.Edit && player.hasPermission("griefprevention.deleteclaims"))) {
            return null;
        }
        if (uuid.equals(this.getOwnerID()) || GriefPrevention.instance.dataStore.getPlayerData((UUID)uuid).ignoreClaims && this.hasBypassPermission(player, permission)) {
            return null;
        }
        if (player != null ? this.hasExplicitPermission(player, permission) : this.hasExplicitPermission(uuid, permission)) {
            return null;
        }
        if (permission.isGrantedBy(this.playerIDToClaimPermissionMap.get("public"))) {
            return null;
        }
        if (permission == ClaimPermission.Build) {
            PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(uuid);
            if (playerData.inPvpCombat()) {
                return () -> GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildPvP, new String[0]);
            }
            Material material = null;
            if (event instanceof BlockBreakEvent || event instanceof BlockPlaceEvent) {
                material = ((BlockEvent)event).getBlock().getType();
            }
            if (material != null && Claim.placeableForFarming(material) && this.getDefaultDenial(player, uuid, ClaimPermission.Inventory, event) == null) {
                return null;
            }
        }
        if (this.parent != null && !this.inheritNothing) {
            return this.parent.getDefaultDenial(player, uuid, permission, event);
        }
        return () -> {
            Object reason = GriefPrevention.instance.dataStore.getMessage(permission.getDenialMessage(), this.getOwnerName());
            if (this.hasBypassPermission(player, permission)) {
                reason = (String)reason + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
            }
            return reason;
        };
    }

    @Contract(value="null, _ -> false")
    private boolean hasBypassPermission(@Nullable Player player, @NotNull ClaimPermission permission) {
        if (player == null) {
            return false;
        }
        if (permission == ClaimPermission.Edit) {
            return player.hasPermission("griefprevention.deleteclaims");
        }
        return player.hasPermission("griefprevention.ignoreclaims");
    }

    @Deprecated
    @Nullable
    public String allowBreak(@NotNull Player player, @NotNull Material material) {
        Supplier<String> supplier = this.checkPermission(player, ClaimPermission.Build, (Event)new CompatBuildBreakEvent(material, true));
        return supplier != null ? supplier.get() : null;
    }

    @Deprecated
    @Nullable
    public String allowAccess(@NotNull Player player) {
        Supplier<String> supplier = this.checkPermission(player, ClaimPermission.Access, null);
        return supplier != null ? supplier.get() : null;
    }

    @Deprecated
    @Nullable
    public String allowContainers(@NotNull Player player) {
        Supplier<String> supplier = this.checkPermission(player, ClaimPermission.Inventory, null);
        return supplier != null ? supplier.get() : null;
    }

    @Deprecated
    @Nullable
    public String allowGrantPermission(@NotNull Player player) {
        Supplier<String> supplier = this.checkPermission(player, ClaimPermission.Manage, null);
        return supplier != null ? supplier.get() : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public ClaimPermission getPermission(@Nullable String playerID) {
        if (playerID == null || playerID.isEmpty()) {
            return null;
        }
        return this.playerIDToClaimPermissionMap.get(playerID.toLowerCase());
    }

    public void setPermission(@Nullable String playerID, @Nullable ClaimPermission permissionLevel) {
        if (permissionLevel == ClaimPermission.Edit) {
            throw new IllegalArgumentException("Cannot add editors!");
        }
        if (playerID == null || playerID.isEmpty()) {
            return;
        }
        if (permissionLevel == null) {
            this.dropPermission(playerID);
        } else if (permissionLevel == ClaimPermission.Manage) {
            this.managers.add(playerID.toLowerCase());
        } else {
            this.playerIDToClaimPermissionMap.put(playerID.toLowerCase(), permissionLevel);
        }
    }

    public void dropPermission(@NotNull String playerID) {
        playerID = playerID.toLowerCase();
        this.playerIDToClaimPermissionMap.remove(playerID);
        this.managers.remove(playerID);
        for (Claim child : this.children) {
            child.dropPermission(playerID);
        }
    }

    public void clearPermissions() {
        this.playerIDToClaimPermissionMap.clear();
        this.managers.clear();
        for (Claim child : this.children) {
            child.clearPermissions();
        }
    }

    public void getPermissions(ArrayList<String> builders, ArrayList<String> containers, ArrayList<String> accessors, ArrayList<String> managers) {
        for (Map.Entry<String, ClaimPermission> entry : this.playerIDToClaimPermissionMap.entrySet()) {
            if (entry.getValue() == ClaimPermission.Build) {
                builders.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == ClaimPermission.Inventory) {
                containers.add(entry.getKey());
                continue;
            }
            accessors.add(entry.getKey());
        }
        managers.addAll(this.managers);
    }

    public Location getLesserBoundaryCorner() {
        return this.lesserBoundaryCorner.clone();
    }

    public Location getGreaterBoundaryCorner() {
        return this.greaterBoundaryCorner.clone();
    }

    public String getOwnerName() {
        if (this.parent != null) {
            return this.parent.getOwnerName();
        }
        if (this.ownerID == null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.OwnerNameForAdminClaims, new String[0]);
        }
        return GriefPrevention.lookupPlayerName(this.ownerID);
    }

    public UUID getOwnerID() {
        if (this.parent != null) {
            return this.parent.ownerID;
        }
        return this.ownerID;
    }

    public boolean contains(Location location, boolean ignoreHeight, boolean excludeSubdivisions) {
        if (!Objects.equals(location.getWorld(), this.lesserBoundaryCorner.getWorld())) {
            return false;
        }
        BoundingBox boundingBox = new BoundingBox(this);
        int x = location.getBlockX();
        int z = location.getBlockZ();
        if (ignoreHeight && !boundingBox.contains2d(x, z)) {
            return false;
        }
        if (!ignoreHeight && !boundingBox.contains(x, location.getBlockY(), z)) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.contains(location, ignoreHeight, false);
        }
        if (excludeSubdivisions) {
            for (Claim child : this.children) {
                if (!child.contains(location, ignoreHeight, true)) continue;
                return false;
            }
        }
        return true;
    }

    boolean overlaps(Claim otherClaim) {
        if (!Objects.equals(this.lesserBoundaryCorner.getWorld(), otherClaim.getLesserBoundaryCorner().getWorld())) {
            return false;
        }
        return new BoundingBox(this).intersects(new BoundingBox(otherClaim));
    }

    public String allowMoreEntities(boolean remove) {
        if (this.parent != null) {
            return this.parent.allowMoreEntities(remove);
        }
        if (!GriefPrevention.instance.creativeRulesApply(this.getLesserBoundaryCorner())) {
            return null;
        }
        if (this.isAdminClaim()) {
            return null;
        }
        if (this.getArea() > 10000) {
            return null;
        }
        int maxEntities = this.getArea() / 50;
        if (maxEntities == 0) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.ClaimTooSmallForEntities, new String[0]);
        }
        int totalEntities = 0;
        ArrayList<Chunk> chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            Entity[] entities;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity instanceof Player || !this.contains(entity.getLocation(), false, false) || !remove || ++totalEntities <= maxEntities) continue;
                entity.remove();
            }
        }
        if (totalEntities >= maxEntities) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.TooManyEntitiesInClaim, new String[0]);
        }
        return null;
    }

    public String allowMoreActiveBlocks() {
        if (this.parent != null) {
            return this.parent.allowMoreActiveBlocks();
        }
        int maxActives = this.getArea() / 100;
        if (maxActives == 0) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.ClaimTooSmallForActiveBlocks, new String[0]);
        }
        int totalActives = 0;
        ArrayList<Chunk> chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            BlockState[] actives;
            for (BlockState active : actives = chunk.getTileEntities()) {
                if (!BlockEventHandler.isActiveBlock(active) || !this.contains(active.getLocation(), false, false)) continue;
                ++totalActives;
            }
        }
        if (totalActives >= maxActives) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.TooManyActiveBlocksInClaim, new String[0]);
        }
        return null;
    }

    boolean greaterThan(Claim otherClaim) {
        Location thisCorner = this.getLesserBoundaryCorner();
        Location otherCorner = otherClaim.getLesserBoundaryCorner();
        if (thisCorner.getBlockX() > otherCorner.getBlockX()) {
            return true;
        }
        if (thisCorner.getBlockX() < otherCorner.getBlockX()) {
            return false;
        }
        if (thisCorner.getBlockZ() > otherCorner.getBlockZ()) {
            return true;
        }
        if (thisCorner.getBlockZ() < otherCorner.getBlockZ()) {
            return false;
        }
        return thisCorner.getWorld().getName().compareTo(otherCorner.getWorld().getName()) < 0;
    }

    long getPlayerInvestmentScore() {
        Location lesserBoundaryCorner = this.getLesserBoundaryCorner();
        Set<Material> playerBlocks = RestoreNatureProcessingTask.getPlayerBlocks(lesserBoundaryCorner.getWorld().getEnvironment(), lesserBoundaryCorner.getBlock().getBiome());
        double score = 0.0;
        boolean creativeMode = GriefPrevention.instance.creativeRulesApply(lesserBoundaryCorner);
        for (int x = this.lesserBoundaryCorner.getBlockX(); x <= this.greaterBoundaryCorner.getBlockX(); ++x) {
            for (int z = this.lesserBoundaryCorner.getBlockZ(); z <= this.greaterBoundaryCorner.getBlockZ(); ++z) {
                Block block;
                int y;
                for (y = this.lesserBoundaryCorner.getBlockY(); y < GriefPrevention.instance.getSeaLevel(this.lesserBoundaryCorner.getWorld()) - 5; ++y) {
                    block = this.lesserBoundaryCorner.getWorld().getBlockAt(x, y, z);
                    if (!playerBlocks.contains(block.getType())) continue;
                    if (block.getType() == Material.CHEST && !creativeMode) {
                        score += 10.0;
                        continue;
                    }
                    score += 0.5;
                }
                while (y < this.lesserBoundaryCorner.getWorld().getMaxHeight()) {
                    block = this.lesserBoundaryCorner.getWorld().getBlockAt(x, y, z);
                    if (playerBlocks.contains(block.getType())) {
                        score = block.getType() == Material.CHEST && !creativeMode ? (score += 10.0) : (creativeMode && block.getType() == Material.LAVA ? (score -= 10.0) : (score += 1.0));
                    }
                    ++y;
                }
            }
        }
        return (long)score;
    }

    public ArrayList<Chunk> getChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        World world = this.getLesserBoundaryCorner().getWorld();
        Chunk lesserChunk = this.getLesserBoundaryCorner().getChunk();
        Chunk greaterChunk = this.getGreaterBoundaryCorner().getChunk();
        for (int x = lesserChunk.getX(); x <= greaterChunk.getX(); ++x) {
            for (int z = lesserChunk.getZ(); z <= greaterChunk.getZ(); ++z) {
                chunks.add(world.getChunkAt(x, z));
            }
        }
        return chunks;
    }

    ArrayList<Long> getChunkHashes() {
        return DataStore.getChunkHashes(this);
    }

    public static class CompatBuildBreakEvent
    extends Event {
        private final Material material;
        private final boolean isBreak;

        private CompatBuildBreakEvent(Material material, boolean isBreak) {
            this.material = material;
            this.isBreak = isBreak;
        }

        public Material getMaterial() {
            return this.material;
        }

        public boolean isBreak() {
            return this.isBreak;
        }

        @NotNull
        public HandlerList getHandlers() {
            return new HandlerList();
        }
    }
}

