/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.concurrent.ConcurrentLinkedQueue;
import me.ryanhamshire.GriefPrevention.LengthTimestampPair;

class ChatterData {
    public String lastMessage = "";
    public long lastMessageTimestamp;
    public int spamLevel = 0;
    public boolean spamWarned = false;
    private final ConcurrentLinkedQueue<LengthTimestampPair> recentMessageLengths = new ConcurrentLinkedQueue();
    private int recentTotalLength = 0;

    ChatterData() {
    }

    public void AddMessage(String message, long timestamp) {
        int length = message.length();
        this.recentMessageLengths.add(new LengthTimestampPair(length, timestamp));
        this.recentTotalLength += length;
        this.lastMessage = message;
        this.lastMessageTimestamp = timestamp;
    }

    public int getTotalRecentLength(long timestamp) {
        LengthTimestampPair oldestPair = this.recentMessageLengths.peek();
        while (oldestPair != null && timestamp - oldestPair.timestamp > 10000L) {
            this.recentMessageLengths.poll();
            this.recentTotalLength -= oldestPair.length;
            oldestPair = this.recentMessageLengths.peek();
        }
        return this.recentTotalLength;
    }
}

