/*
 * Decompiled with CFR 0.152.
 */
package com.griefprevention.visualization;

import com.griefprevention.util.IntVector;
import com.griefprevention.visualization.BlockElement;
import com.griefprevention.visualization.Boundary;
import com.griefprevention.visualization.BoundaryVisualization;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import me.ryanhamshire.GriefPrevention.util.BoundingBox;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockBoundaryVisualization
extends BoundaryVisualization {
    private final int step;
    private final BoundingBox displayZoneArea;
    protected final Collection<BlockElement> elements = new HashSet<BlockElement>();

    protected BlockBoundaryVisualization(@NotNull World world, @NotNull IntVector visualizeFrom, int height) {
        this(world, visualizeFrom, height, 10, 75);
    }

    protected BlockBoundaryVisualization(@NotNull World world, @NotNull IntVector visualizeFrom, int height, int step, int displayZoneRadius) {
        super(world, visualizeFrom, height);
        this.step = step;
        this.displayZoneArea = new BoundingBox(visualizeFrom.add(-displayZoneRadius, -displayZoneRadius, -displayZoneRadius), visualizeFrom.add(displayZoneRadius, displayZoneRadius, displayZoneRadius));
    }

    @Override
    protected void draw(@NotNull Player player, @NotNull Boundary boundary) {
        BoundingBox area = boundary.bounds();
        BoundingBox displayZone = this.displayZoneArea.intersection(area);
        if (displayZone == null) {
            return;
        }
        Consumer<@NotNull IntVector> addCorner = this.addCornerElements(boundary);
        Consumer<@NotNull IntVector> addSide = this.addSideElements(boundary);
        for (int x = Math.max(area.getMinX() + this.step, displayZone.getMinX()); x < area.getMaxX() - this.step / 2 && x < displayZone.getMaxX(); x += this.step) {
            this.addDisplayed(displayZone, new IntVector(x, this.height, area.getMaxZ()), addSide);
            this.addDisplayed(displayZone, new IntVector(x, this.height, area.getMinZ()), addSide);
        }
        if (area.getLength() > 2) {
            this.addDisplayed(displayZone, new IntVector(area.getMinX() + 1, this.height, area.getMaxZ()), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMinX() + 1, this.height, area.getMinZ()), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMaxX() - 1, this.height, area.getMaxZ()), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMaxX() - 1, this.height, area.getMinZ()), addSide);
        }
        for (int z = Math.max(area.getMinZ() + this.step, displayZone.getMinZ()); z < area.getMaxZ() - this.step / 2 && z < displayZone.getMaxZ(); z += this.step) {
            this.addDisplayed(displayZone, new IntVector(area.getMinX(), this.height, z), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMaxX(), this.height, z), addSide);
        }
        if (area.getWidth() > 2) {
            this.addDisplayed(displayZone, new IntVector(area.getMinX(), this.height, area.getMinZ() + 1), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMaxX(), this.height, area.getMinZ() + 1), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMinX(), this.height, area.getMaxZ() - 1), addSide);
            this.addDisplayed(displayZone, new IntVector(area.getMaxX(), this.height, area.getMaxZ() - 1), addSide);
        }
        this.addDisplayed(displayZone, new IntVector(area.getMinX(), this.height, area.getMaxZ()), addCorner);
        this.addDisplayed(displayZone, new IntVector(area.getMaxX(), this.height, area.getMaxZ()), addCorner);
        this.addDisplayed(displayZone, new IntVector(area.getMinX(), this.height, area.getMinZ()), addCorner);
        this.addDisplayed(displayZone, new IntVector(area.getMaxX(), this.height, area.getMinZ()), addCorner);
        this.elements.forEach(element -> element.draw(player, this.world));
    }

    @NotNull
    protected abstract @NotNull Consumer<@NotNull IntVector> addCornerElements(@NotNull Boundary var1);

    @NotNull
    protected abstract @NotNull Consumer<@NotNull IntVector> addSideElements(@NotNull Boundary var1);

    protected boolean isAccessible(@NotNull BoundingBox displayZone, @NotNull IntVector coordinate) {
        return displayZone.contains2d(coordinate) && coordinate.isChunkLoaded(this.world);
    }

    protected void addDisplayed(@NotNull BoundingBox displayZone, @NotNull IntVector coordinate, @NotNull @NotNull Consumer<@NotNull IntVector> addElement) {
        if (this.isAccessible(displayZone, coordinate)) {
            addElement.accept(coordinate);
        }
    }

    @Override
    public void revert(@Nullable Player player) {
        if (!this.canVisualize(player)) {
            return;
        }
        this.elements.forEach(element -> element.erase(player, this.world));
    }

    @Override
    protected void erase(@NotNull Player player, @NotNull Boundary boundary) {
        this.elements.forEach(element -> element.erase(player, this.world));
    }
}

