/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.events.ClaimPermissionCheckEvent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SiegeEventHandler
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onClaimPermissionCheck(ClaimPermissionCheckEvent event) {
        PlayerInteractEvent triggeringEvent;
        if (event.getRequiredPermission() == ClaimPermission.Manage) {
            return;
        }
        Player player = event.getCheckedPlayer();
        if (player == null) {
            return;
        }
        Claim claim = event.getClaim();
        if (claim.isAdminClaim()) {
            return;
        }
        if (event.getRequiredPermission() == ClaimPermission.Edit) {
            if (claim.siegeData != null) {
                event.setDenialReason(() -> GriefPrevention.instance.dataStore.getMessage(Messages.NoModifyDuringSiege, new String[0]));
            }
            return;
        }
        if (event.getRequiredPermission() == ClaimPermission.Access) {
            if (claim.doorsOpen) {
                event.setDenialReason(null);
            }
            return;
        }
        if (event.getRequiredPermission() == ClaimPermission.Inventory) {
            GriefPrevention.instance.dataStore.tryExtendSiege(player, claim);
            if (claim.siegeData != null) {
                event.setDenialReason(() -> GriefPrevention.instance.dataStore.getMessage(Messages.NoContainersSiege, claim.siegeData.attacker.getName()));
            }
            return;
        }
        GriefPrevention.instance.dataStore.tryExtendSiege(player, claim);
        if (claim.siegeData == null && !claim.doorsOpen) {
            return;
        }
        Material broken = null;
        if (event.getTriggeringEvent() instanceof BlockBreakEvent) {
            broken = ((BlockBreakEvent)event.getTriggeringEvent()).getBlock().getType();
        } else if (event.getTriggeringEvent() instanceof Claim.CompatBuildBreakEvent) {
            Claim.CompatBuildBreakEvent triggeringEvent2 = (Claim.CompatBuildBreakEvent)event.getTriggeringEvent();
            if (triggeringEvent2.isBreak()) {
                broken = triggeringEvent2.getMaterial();
            }
        } else if (event.getTriggeringEvent() instanceof PlayerInteractEvent && (triggeringEvent = (PlayerInteractEvent)event.getTriggeringEvent()).getAction() == Action.PHYSICAL && triggeringEvent.getClickedBlock() != null && triggeringEvent.getClickedBlock().getType() == Material.TURTLE_EGG) {
            broken = Material.TURTLE_EGG;
        }
        if (broken != null) {
            if (!GriefPrevention.instance.config_siege_blocks.contains(broken)) {
                event.setDenialReason(() -> GriefPrevention.instance.dataStore.getMessage(Messages.NonSiegeMaterial, new String[0]));
            } else if (player.getUniqueId().equals(claim.ownerID)) {
                event.setDenialReason(() -> GriefPrevention.instance.dataStore.getMessage(Messages.NoOwnerBuildUnderSiege, new String[0]));
            }
            return;
        }
        if (claim.siegeData != null) {
            event.setDenialReason(() -> GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildUnderSiege, claim.siegeData.attacker.getName()));
        }
    }
}

