/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CleanupUnusedClaimTask;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

class CleanupUnusedClaimPreTask
implements Runnable {
    private UUID ownerID = null;

    CleanupUnusedClaimPreTask(UUID uuid) {
        this.ownerID = uuid;
    }

    @Override
    public void run() {
        PlayerData ownerData = GriefPrevention.instance.dataStore.getPlayerDataFromStorage(this.ownerID);
        OfflinePlayer ownerInfo = Bukkit.getServer().getOfflinePlayer(this.ownerID);
        GriefPrevention.AddLogEntry("Looking for expired claims.  Checking data for " + this.ownerID.toString(), CustomLogEntryTypes.Debug, true);
        if (ownerInfo.isOnline()) {
            GriefPrevention.AddLogEntry("Player is online. Ignoring.", CustomLogEntryTypes.Debug, true);
            return;
        }
        if (ownerInfo.getLastPlayed() <= 0L) {
            GriefPrevention.AddLogEntry("Player is new or not in the server's cached userdata. Ignoring. getLastPlayed = " + ownerInfo.getLastPlayed(), CustomLogEntryTypes.Debug, true);
            return;
        }
        int bonusBlocks = ownerData.getBonusClaimBlocks();
        if (bonusBlocks >= GriefPrevention.instance.config_claims_expirationExemptionBonusBlocks || bonusBlocks + ownerData.getAccruedClaimBlocks() >= GriefPrevention.instance.config_claims_expirationExemptionTotalBlocks) {
            GriefPrevention.AddLogEntry("Player exempt from claim expiration based on claim block counts vs. config file settings.", CustomLogEntryTypes.Debug, true);
            return;
        }
        Claim claimToExpire = null;
        for (Claim claim : GriefPrevention.instance.dataStore.getClaims()) {
            if (!this.ownerID.equals(claim.ownerID)) continue;
            claimToExpire = claim;
            break;
        }
        if (claimToExpire == null) {
            GriefPrevention.AddLogEntry("Unable to find a claim to expire for " + this.ownerID.toString(), CustomLogEntryTypes.Debug, false);
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)new CleanupUnusedClaimTask(claimToExpire, ownerData, ownerInfo), 1L);
    }
}

