/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

class CheckForPortalTrapTask
extends BukkitRunnable {
    GriefPrevention instance;
    private final Player player;
    private final Location returnLocation;

    public CheckForPortalTrapTask(Player player, GriefPrevention plugin, Location locationToReturn) {
        this.player = player;
        this.instance = plugin;
        this.returnLocation = locationToReturn;
        player.setMetadata("GP_PORTALRESCUE", (MetadataValue)new FixedMetadataValue((Plugin)this.instance, (Object)locationToReturn));
    }

    public void run() {
        if (this.player.isOnline() && this.player.getPortalCooldown() >= 10 && this.player.hasMetadata("GP_PORTALRESCUE")) {
            GriefPrevention.AddLogEntry("Rescued " + this.player.getName() + " from a nether portal.\nTeleported from " + this.player.getLocation().toString() + " to " + this.returnLocation.toString(), CustomLogEntryTypes.Debug);
            this.player.teleport(this.returnLocation);
            this.player.removeMetadata("GP_PORTALRESCUE", (Plugin)this.instance);
        }
        this.instance.portalReturnTaskMap.remove(this.player.getUniqueId());
    }
}

