/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.loot.Lootable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class AutoExtendClaimTask
implements Runnable {
    private final Claim claim;
    private final ArrayList<ChunkSnapshot> chunks;
    private final World.Environment worldType;
    private final Map<Biome, Set<Material>> biomePlayerMaterials = new HashMap<Biome, Set<Material>>();
    private final int minY;
    private final int lowestExistingY;

    static void scheduleAsync(Claim claim) {
        Location lesserCorner = claim.getLesserBoundaryCorner();
        Location greaterCorner = claim.getGreaterBoundaryCorner();
        World world = lesserCorner.getWorld();
        if (world == null) {
            return;
        }
        int lowestLootableTile = lesserCorner.getBlockY();
        ArrayList<ChunkSnapshot> snapshots = new ArrayList<ChunkSnapshot>();
        for (int chunkX = lesserCorner.getBlockX() / 16; chunkX <= greaterCorner.getBlockX() / 16; ++chunkX) {
            for (int chunkZ = lesserCorner.getBlockZ() / 16; chunkZ <= greaterCorner.getBlockZ() / 16; ++chunkZ) {
                if (!world.isChunkLoaded(chunkX, chunkZ)) continue;
                Chunk chunk = world.getChunkAt(chunkX, chunkZ);
                if (Bukkit.isPrimaryThread()) {
                    lowestLootableTile = Math.min(lowestLootableTile, Arrays.stream(chunk.getTileEntities()).filter(tile -> {
                        Lootable lootable;
                        return tile instanceof Lootable && (lootable = (Lootable)tile).getLootTable() == null;
                    }).mapToInt(BlockState::getY).min().orElse(lowestLootableTile));
                }
                snapshots.add(chunk.getChunkSnapshot(false, true, false));
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GriefPrevention.instance, (Runnable)new AutoExtendClaimTask(claim, snapshots, world.getEnvironment(), lowestLootableTile));
    }

    private AutoExtendClaimTask(@NotNull Claim claim, @NotNull @NotNull ArrayList<@NotNull ChunkSnapshot> chunks, @NotNull World.Environment worldType, int lowestExistingY) {
        this.claim = claim;
        this.chunks = chunks;
        this.worldType = worldType;
        this.lowestExistingY = Math.min(lowestExistingY, claim.getLesserBoundaryCorner().getBlockY());
        this.minY = Math.max(Objects.requireNonNull(claim.getLesserBoundaryCorner().getWorld()).getMinHeight(), GriefPrevention.instance.config_claims_maxDepth);
    }

    @Override
    public void run() {
        int newY = this.getLowestBuiltY();
        if (newY < this.claim.getLesserBoundaryCorner().getBlockY()) {
            Bukkit.getScheduler().runTask((Plugin)GriefPrevention.instance, (Runnable)new ExecuteExtendClaimTask(this.claim, newY));
        }
    }

    private int getLowestBuiltY() {
        int y = this.lowestExistingY;
        if (this.yTooSmall(y)) {
            return this.minY;
        }
        for (ChunkSnapshot chunk : this.chunks) {
            y = this.findLowerBuiltY(chunk, y);
            if (!this.yTooSmall(y)) continue;
            return this.minY;
        }
        return y;
    }

    private int findLowerBuiltY(ChunkSnapshot chunkSnapshot, int y) {
        block0: for (int newY = y - 1; newY >= this.minY; --newY) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (!this.isPlayerBlock(chunkSnapshot, x, newY, z)) continue;
                    if (this.yTooSmall(y)) {
                        return this.minY;
                    }
                    while (this.isPlayerBlock(chunkSnapshot, x, newY--, z)) {
                        if (!this.yTooSmall(y)) continue;
                        return this.minY;
                    }
                    y = ++newY;
                    continue block0;
                }
            }
        }
        return y;
    }

    private boolean yTooSmall(int y) {
        return y <= this.minY;
    }

    private boolean isPlayerBlock(ChunkSnapshot chunkSnapshot, int x, int y, int z) {
        Material blockType = chunkSnapshot.getBlockType(x, y, z);
        Biome biome = chunkSnapshot.getBiome(x, y, z);
        return this.getBiomePlayerBlocks(biome).contains(blockType);
    }

    private Set<Material> getBiomePlayerBlocks(Biome biome) {
        return this.biomePlayerMaterials.computeIfAbsent(biome, newBiome -> RestoreNatureProcessingTask.getPlayerBlocks(this.worldType, newBiome));
    }

    private record ExecuteExtendClaimTask(Claim claim, int newY) implements Runnable
    {
        @Override
        public void run() {
            GriefPrevention.instance.dataStore.extendClaim(this.claim, this.newY);
        }
    }
}

