/*
 * Decompiled with CFR 0.152.
 */
package com.griefprevention.visualization;

import com.griefprevention.events.BoundaryVisualizationEvent;
import com.griefprevention.util.IntVector;
import com.griefprevention.visualization.Boundary;
import com.griefprevention.visualization.VisualizationType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.util.BoundingBox;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BoundaryVisualization {
    private final Collection<Boundary> elements = new HashSet<Boundary>();
    @NotNull
    protected final World world;
    @NotNull
    protected final IntVector visualizeFrom;
    protected final int height;

    protected BoundaryVisualization(@NotNull World world, @NotNull IntVector visualizeFrom, int height) {
        this.world = world;
        this.visualizeFrom = visualizeFrom;
        this.height = height;
    }

    @Contract(value="null -> false")
    protected boolean canVisualize(@Nullable Player player) {
        return player != null && player.isOnline() && !this.elements.isEmpty() && Objects.equals(this.world, player.getWorld());
    }

    protected void apply(@NotNull Player player, @NotNull PlayerData playerData) {
        playerData.setVisibleBoundaries(this);
        this.elements.forEach(element -> this.draw(player, (Boundary)element));
        this.scheduleRevert(player, playerData);
    }

    protected abstract void draw(@NotNull Player var1, @NotNull Boundary var2);

    protected void scheduleRevert(@NotNull Player player, @NotNull PlayerData playerData) {
        GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, () -> {
            if (playerData.getVisibleBoundaries() == this) {
                playerData.setVisibleBoundaries(null);
            }
        }, 1200L);
    }

    public void revert(@Nullable Player player) {
        if (!this.canVisualize(player)) {
            return;
        }
        this.elements.forEach(element -> this.erase(player, (Boundary)element));
    }

    protected abstract void erase(@NotNull Player var1, @NotNull Boundary var2);

    public static void visualizeArea(@NotNull Player player, @NotNull BoundingBox boundingBox, @NotNull VisualizationType type) {
        BoundaryVisualizationEvent event = new BoundaryVisualizationEvent(player, Set.of(new Boundary(boundingBox, type)), player.getEyeLocation().getBlockY());
        BoundaryVisualization.callAndVisualize(event);
    }

    public static void visualizeClaim(@NotNull Player player, @NotNull Claim claim, @NotNull VisualizationType type) {
        BoundaryVisualization.visualizeClaim(player, claim, type, player.getEyeLocation().getBlockY());
    }

    public static void visualizeClaim(@NotNull Player player, @NotNull Claim claim, @NotNull VisualizationType type, @NotNull Block block) {
        BoundaryVisualization.visualizeClaim(player, claim, type, block.getY());
    }

    private static void visualizeClaim(@NotNull Player player, @NotNull Claim claim, @NotNull VisualizationType type, int height) {
        BoundaryVisualizationEvent event = new BoundaryVisualizationEvent(player, BoundaryVisualization.defineBoundaries(claim, type), height);
        BoundaryVisualization.callAndVisualize(event);
    }

    private static Collection<Boundary> defineBoundaries(Claim claim, VisualizationType type) {
        if (claim == null) {
            return Set.of();
        }
        if (claim.parent != null) {
            claim = claim.parent;
        }
        if (type == VisualizationType.CLAIM && claim.isAdminClaim()) {
            type = VisualizationType.ADMIN_CLAIM;
        }
        return Stream.concat(Stream.of(new Boundary(claim, type)), claim.children.stream().map(child -> new Boundary((Claim)child, VisualizationType.SUBDIVISION))).collect(Collectors.toSet());
    }

    public static void visualizeNearbyClaims(@NotNull Player player, @NotNull Collection<Claim> claims, int height) {
        BoundaryVisualizationEvent event = new BoundaryVisualizationEvent(player, claims.stream().map(claim -> new Boundary((Claim)claim, claim.isAdminClaim() ? VisualizationType.ADMIN_CLAIM : VisualizationType.CLAIM)).collect(Collectors.toSet()), height);
        BoundaryVisualization.callAndVisualize(event);
    }

    public static void callAndVisualize(@NotNull BoundaryVisualizationEvent event) {
        Bukkit.getPluginManager().callEvent((Event)event);
        Player player = event.getPlayer();
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        BoundaryVisualization currentVisualization = playerData.getVisibleBoundaries();
        Collection<Boundary> boundaries = event.getBoundaries();
        boundaries.removeIf(Objects::isNull);
        if (currentVisualization != null && currentVisualization.elements.equals(boundaries) && currentVisualization.visualizeFrom.distanceSquared(event.getCenter()) < 165) {
            return;
        }
        BoundaryVisualization visualization = event.getProvider().create(player.getWorld(), event.getCenter(), event.getHeight());
        visualization.elements.addAll(boundaries);
        playerData.setVisibleBoundaries(null);
        if (visualization.canVisualize(player)) {
            GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)new DelayedVisualizationTask(visualization, playerData, event), 1L);
        }
    }

    private record DelayedVisualizationTask(@NotNull BoundaryVisualization visualization, @NotNull PlayerData playerData, @NotNull BoundaryVisualizationEvent event) implements Runnable
    {
        @Override
        public void run() {
            try {
                this.visualization.apply(this.event.getPlayer(), this.playerData);
            }
            catch (Exception exception) {
                if (this.event.getProvider() == BoundaryVisualizationEvent.DEFAULT_PROVIDER) {
                    GriefPrevention.instance.getLogger().log(Level.WARNING, "Exception visualizing claim", exception);
                    return;
                }
                GriefPrevention.AddLogEntry(String.format("External visualization provider %s caused %s: %s", this.event.getProvider().getClass().getName(), exception.getClass().getName(), exception.getCause()), CustomLogEntryTypes.Exception);
                GriefPrevention.instance.getLogger().log(Level.WARNING, "Exception visualizing claim using external provider", exception);
                BoundaryVisualization fallback = BoundaryVisualizationEvent.DEFAULT_PROVIDER.create(this.event.getPlayer().getWorld(), this.event.getCenter(), this.event.getHeight());
                this.event.getBoundaries().stream().filter(Objects::nonNull).forEach(fallback.elements::add);
                fallback.apply(this.event.getPlayer(), this.playerData);
            }
        }
    }
}

