/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import me.ryanhamshire.GriefPrevention.CleanupUnusedClaimPreTask;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.plugin.Plugin;

class FindUnusedClaimsTask
implements Runnable {
    private List<UUID> claimOwnerUUIDs;
    private Iterator<UUID> claimOwnerIterator;

    FindUnusedClaimsTask() {
        this.refreshUUIDs();
    }

    @Override
    public void run() {
        if (this.claimOwnerUUIDs.isEmpty()) {
            return;
        }
        if (!this.claimOwnerIterator.hasNext()) {
            this.refreshUUIDs();
            return;
        }
        GriefPrevention.instance.getServer().getScheduler().runTaskAsynchronously((Plugin)GriefPrevention.instance, (Runnable)new CleanupUnusedClaimPreTask(this.claimOwnerIterator.next()));
    }

    public void refreshUUIDs() {
        this.claimOwnerUUIDs = GriefPrevention.instance.dataStore.claims.stream().map(claim -> claim.ownerID).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (!this.claimOwnerUUIDs.isEmpty()) {
            Collections.shuffle(this.claimOwnerUUIDs);
        }
        GriefPrevention.AddLogEntry("The following UUIDs own a claim and will be checked for inactivity in the following order:", CustomLogEntryTypes.Debug, true);
        for (UUID uuid : this.claimOwnerUUIDs) {
            GriefPrevention.AddLogEntry(uuid.toString(), CustomLogEntryTypes.Debug, true);
        }
        this.claimOwnerIterator = this.claimOwnerUUIDs.iterator();
    }
}

