/*
 * Decompiled with CFR 0.152.
 */
package com.amaze.trashbin;

import android.os.Build;
import com.amaze.trashbin.TrashBinConfig;
import com.amaze.trashbin.TrashBinFile;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\t\u0010 \u001a\u00020\u001eH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/amaze/trashbin/TrashBinMetadata;", "", "config", "Lcom/amaze/trashbin/TrashBinConfig;", "totalSize", "", "files", "", "Lcom/amaze/trashbin/TrashBinFile;", "(Lcom/amaze/trashbin/TrashBinConfig;JLjava/util/List;)V", "getConfig", "()Lcom/amaze/trashbin/TrashBinConfig;", "setConfig", "(Lcom/amaze/trashbin/TrashBinConfig;)V", "getFiles", "()Ljava/util/List;", "setFiles", "(Ljava/util/List;)V", "getTotalSize", "()J", "setTotalSize", "(J)V", "component1", "component2", "component3", "copy", "equals", "", "other", "getCapacity", "", "getFilesWithDeletionCriteria", "hashCode", "toString", "", "trashbin_release"})
public final class TrashBinMetadata {
    @NotNull
    private TrashBinConfig config;
    private long totalSize;
    @NotNull
    private List<TrashBinFile> files;

    public TrashBinMetadata(@NotNull TrashBinConfig config, long totalSize, @NotNull List<TrashBinFile> files) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.config = config;
        this.totalSize = totalSize;
        this.files = files;
    }

    @NotNull
    public final TrashBinConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull TrashBinConfig trashBinConfig) {
        Intrinsics.checkNotNullParameter((Object)trashBinConfig, (String)"<set-?>");
        this.config = trashBinConfig;
    }

    public final long getTotalSize() {
        return this.totalSize;
    }

    public final void setTotalSize(long l) {
        this.totalSize = l;
    }

    @NotNull
    public final List<TrashBinFile> getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull List<TrashBinFile> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.files = list;
    }

    public final int getCapacity() {
        int numOfFiles = this.files.size();
        long totalBytes = this.totalSize;
        int capacityNumOfFiles = 0;
        int capacityBytes = 0;
        if (this.config.getRetentionNumOfFiles() != -1) {
            capacityNumOfFiles = numOfFiles / this.config.getRetentionNumOfFiles() * 100;
        }
        if (this.config.getRetentionBytes() != -1L) {
            capacityBytes = (int)(totalBytes / this.config.getRetentionBytes() * (long)100);
        }
        return capacityBytes > capacityNumOfFiles ? capacityBytes : (capacityNumOfFiles > capacityBytes ? capacityBytes : -1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TrashBinFile> getFilesWithDeletionCriteria() {
        void $this$filterTo$iv$iv;
        long totalBytes = 0L;
        totalBytes = this.totalSize;
        int numOfFiles = 0;
        numOfFiles = this.files.size();
        Iterable $this$sortedBy$iv = this.files;
        boolean $i$f$sortedBy = false;
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TrashBinFile it = (TrashBinFile)a;
                boolean bl = false;
                Comparable comparable = it.getDeleteTime();
                it = (TrashBinFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getDeleteTime());
            }
        });
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            TrashBinFile file = (TrashBinFile)element$iv$iv;
            boolean bl2 = false;
            if (this.config.getRetentionNumOfFiles() != -1 && numOfFiles > this.config.getRetentionNumOfFiles()) {
                numOfFiles += -1;
                bl = true;
            } else if (this.config.getRetentionBytes() != -1L && totalBytes > this.config.getRetentionBytes()) {
                totalBytes -= file.getSizeBytes();
                bl = true;
            } else if (this.config.getRetentionDays() != -1) {
                if (Build.VERSION.SDK_INT >= 26) {
                    Long l = file.getDeleteTime();
                    bl = LocalDateTime.ofEpochSecond(l != null ? l : System.currentTimeMillis() / (long)1000, 0, ZoneOffset.UTC).plusDays(this.config.getRetentionDays()).isBefore(LocalDateTime.now());
                } else {
                    long secondsToAdd = this.config.getRetentionDays() * 24 * 60 * 60;
                    Long l = file.getDeleteTime();
                    long newEpochSeconds = (l != null ? l : System.currentTimeMillis() / (long)1000) + secondsToAdd;
                    bl = newEpochSeconds < System.currentTimeMillis() / (long)1000;
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TrashBinConfig component1() {
        return this.config;
    }

    public final long component2() {
        return this.totalSize;
    }

    @NotNull
    public final List<TrashBinFile> component3() {
        return this.files;
    }

    @NotNull
    public final TrashBinMetadata copy(@NotNull TrashBinConfig config, long totalSize, @NotNull List<TrashBinFile> files) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return new TrashBinMetadata(config, totalSize, files);
    }

    public static /* synthetic */ TrashBinMetadata copy$default(TrashBinMetadata trashBinMetadata, TrashBinConfig trashBinConfig, long l, List list, int n, Object object) {
        if ((n & 1) != 0) {
            trashBinConfig = trashBinMetadata.config;
        }
        if ((n & 2) != 0) {
            l = trashBinMetadata.totalSize;
        }
        if ((n & 4) != 0) {
            list = trashBinMetadata.files;
        }
        return trashBinMetadata.copy(trashBinConfig, l, list);
    }

    @NotNull
    public String toString() {
        return "TrashBinMetadata(config=" + this.config + ", totalSize=" + this.totalSize + ", files=" + this.files + ')';
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = result * 31 + Long.hashCode(this.totalSize);
        result = result * 31 + ((Object)this.files).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrashBinMetadata)) {
            return false;
        }
        TrashBinMetadata trashBinMetadata = (TrashBinMetadata)other;
        if (!Intrinsics.areEqual((Object)this.config, (Object)trashBinMetadata.config)) {
            return false;
        }
        if (this.totalSize != trashBinMetadata.totalSize) {
            return false;
        }
        return Intrinsics.areEqual(this.files, trashBinMetadata.files);
    }
}

