/*
 * Decompiled with CFR 0.152.
 */
package com.amaze.trashbin;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001e\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003JO\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0003J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/amaze/trashbin/TrashBinConfig;", "", "basePath", "", "retentionDays", "", "retentionBytes", "", "retentionNumOfFiles", "cleanupHours", "deleteRogueFiles", "", "triggerCleanupAutomatically", "(Ljava/lang/String;IJIIZZ)V", "getBasePath", "()Ljava/lang/String;", "getCleanupHours", "()I", "getDeleteRogueFiles", "()Z", "getRetentionBytes", "()J", "getRetentionDays", "getRetentionNumOfFiles", "getTriggerCleanupAutomatically", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "getCleanupIntervalHours", "getMetaDataFilePath", "getTrashBinFilesDirectory", "hashCode", "toString", "Companion", "trashbin_release"})
public final class TrashBinConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String basePath;
    private final int retentionDays;
    private final long retentionBytes;
    private final int retentionNumOfFiles;
    private final int cleanupHours;
    private final boolean deleteRogueFiles;
    private final boolean triggerCleanupAutomatically;
    public static final int RETENTION_DAYS_INFINITE = -1;
    public static final long RETENTION_BYTES_INFINITE = -1L;
    public static final int RETENTION_NUM_OF_FILES = -1;
    public static final int INTERVAL_CLEANUP_HOURS = 1;
    public static final int TRASH_BIN_CAPACITY_INVALID = -1;
    @NotNull
    public static final String TRASH_BIN_DIR = "TrashBinFiles";
    @NotNull
    public static final String TRASH_BIN_META_FILE = "metadata.json";

    public TrashBinConfig(@NotNull String basePath, int retentionDays, long retentionBytes, int retentionNumOfFiles, int cleanupHours, boolean deleteRogueFiles, boolean triggerCleanupAutomatically) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
        this.retentionDays = retentionDays;
        this.retentionBytes = retentionBytes;
        this.retentionNumOfFiles = retentionNumOfFiles;
        this.cleanupHours = cleanupHours;
        this.deleteRogueFiles = deleteRogueFiles;
        this.triggerCleanupAutomatically = triggerCleanupAutomatically;
    }

    public /* synthetic */ TrashBinConfig(String string, int n, long l, int n2, int n3, boolean bl, boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = -1;
        }
        this(string, n, l, n2, n3, bl, bl2);
    }

    @NotNull
    public final String getBasePath() {
        return this.basePath;
    }

    public final int getRetentionDays() {
        return this.retentionDays;
    }

    public final long getRetentionBytes() {
        return this.retentionBytes;
    }

    public final int getRetentionNumOfFiles() {
        return this.retentionNumOfFiles;
    }

    public final int getCleanupHours() {
        return this.cleanupHours;
    }

    public final boolean getDeleteRogueFiles() {
        return this.deleteRogueFiles;
    }

    public final boolean getTriggerCleanupAutomatically() {
        return this.triggerCleanupAutomatically;
    }

    @NotNull
    public final String getTrashBinFilesDirectory() {
        File directory;
        File baseDir = new File(this.basePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        if (!(directory = new File(this.basePath, TRASH_BIN_DIR)).exists()) {
            directory.mkdirs();
        }
        return this.basePath + File.separator + TRASH_BIN_DIR;
    }

    @NotNull
    public final String getMetaDataFilePath() {
        File file;
        File baseDir = new File(this.basePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        if (!(file = new File(this.basePath, TRASH_BIN_META_FILE)).exists()) {
            file.createNewFile();
        }
        return this.basePath + File.separator + TRASH_BIN_META_FILE;
    }

    public final int getCleanupIntervalHours() {
        return this.cleanupHours;
    }

    @NotNull
    public final String component1() {
        return this.basePath;
    }

    public final int component2() {
        return this.retentionDays;
    }

    public final long component3() {
        return this.retentionBytes;
    }

    public final int component4() {
        return this.retentionNumOfFiles;
    }

    public final int component5() {
        return this.cleanupHours;
    }

    public final boolean component6() {
        return this.deleteRogueFiles;
    }

    public final boolean component7() {
        return this.triggerCleanupAutomatically;
    }

    @NotNull
    public final TrashBinConfig copy(@NotNull String basePath, int retentionDays, long retentionBytes, int retentionNumOfFiles, int cleanupHours, boolean deleteRogueFiles, boolean triggerCleanupAutomatically) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return new TrashBinConfig(basePath, retentionDays, retentionBytes, retentionNumOfFiles, cleanupHours, deleteRogueFiles, triggerCleanupAutomatically);
    }

    public static /* synthetic */ TrashBinConfig copy$default(TrashBinConfig trashBinConfig, String string, int n, long l, int n2, int n3, boolean bl, boolean bl2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = trashBinConfig.basePath;
        }
        if ((n4 & 2) != 0) {
            n = trashBinConfig.retentionDays;
        }
        if ((n4 & 4) != 0) {
            l = trashBinConfig.retentionBytes;
        }
        if ((n4 & 8) != 0) {
            n2 = trashBinConfig.retentionNumOfFiles;
        }
        if ((n4 & 0x10) != 0) {
            n3 = trashBinConfig.cleanupHours;
        }
        if ((n4 & 0x20) != 0) {
            bl = trashBinConfig.deleteRogueFiles;
        }
        if ((n4 & 0x40) != 0) {
            bl2 = trashBinConfig.triggerCleanupAutomatically;
        }
        return trashBinConfig.copy(string, n, l, n2, n3, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "TrashBinConfig(basePath=" + this.basePath + ", retentionDays=" + this.retentionDays + ", retentionBytes=" + this.retentionBytes + ", retentionNumOfFiles=" + this.retentionNumOfFiles + ", cleanupHours=" + this.cleanupHours + ", deleteRogueFiles=" + this.deleteRogueFiles + ", triggerCleanupAutomatically=" + this.triggerCleanupAutomatically + ')';
    }

    public int hashCode() {
        int result = this.basePath.hashCode();
        result = result * 31 + Integer.hashCode(this.retentionDays);
        result = result * 31 + Long.hashCode(this.retentionBytes);
        result = result * 31 + Integer.hashCode(this.retentionNumOfFiles);
        result = result * 31 + Integer.hashCode(this.cleanupHours);
        int n = this.deleteRogueFiles ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.triggerCleanupAutomatically ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrashBinConfig)) {
            return false;
        }
        TrashBinConfig trashBinConfig = (TrashBinConfig)other;
        if (!Intrinsics.areEqual((Object)this.basePath, (Object)trashBinConfig.basePath)) {
            return false;
        }
        if (this.retentionDays != trashBinConfig.retentionDays) {
            return false;
        }
        if (this.retentionBytes != trashBinConfig.retentionBytes) {
            return false;
        }
        if (this.retentionNumOfFiles != trashBinConfig.retentionNumOfFiles) {
            return false;
        }
        if (this.cleanupHours != trashBinConfig.cleanupHours) {
            return false;
        }
        if (this.deleteRogueFiles != trashBinConfig.deleteRogueFiles) {
            return false;
        }
        return this.triggerCleanupAutomatically == trashBinConfig.triggerCleanupAutomatically;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amaze/trashbin/TrashBinConfig$Companion;", "", "()V", "INTERVAL_CLEANUP_HOURS", "", "RETENTION_BYTES_INFINITE", "", "RETENTION_DAYS_INFINITE", "RETENTION_NUM_OF_FILES", "TRASH_BIN_CAPACITY_INVALID", "TRASH_BIN_DIR", "", "TRASH_BIN_META_FILE", "trashbin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

