/*
 * Decompiled with CFR 0.152.
 */
package com.amaze.trashbin;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amaze.trashbin.TrashBinConfig;
import com.amaze.trashbin.TrashBinFile;
import com.amaze.trashbin.TrashBinMetadata;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012)\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tj\u0004\u0018\u0001`\u000e\u00121\b\u0002\u0010\u000f\u001a+\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\tj\u0004\u0018\u0001`\u0013\u00a2\u0006\u0002\u0010\u0014JE\u0010!\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112%\u0010#\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00050\tj\u0002`\u000e2\b\b\u0002\u0010$\u001a\u00020\u0005J-\u0010%\u001a\u00020\u00052%\u0010#\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00050\tj\u0002`\u000eJ\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u001cJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010)\u001a\u00020\u001cH\u0002JZ\u0010*\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0002\u0010$\u001a\u00020\u00052:\u0010+\u001a6\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00050,j\u0002`/Jh\u00100\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112+\u00101\u001a'\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\tj\u0002`\u00132%\u0010#\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00050\tj\u0002`\u000eJZ\u00102\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0002\u0010$\u001a\u00020\u00052:\u0010+\u001a6\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00050,j\u0002`/JB\u00103\u001a\u00020\u00052:\u0010+\u001a6\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00050,j\u0002`/J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0007J-\u00107\u001a\u00020\u00052%\u0010#\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00050\tj\u0002`\u000eJ\u0010\u00108\u001a\u0002052\u0006\u00109\u001a\u00020\u001cH\u0002J&\u0010:\u001a\u0002052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010$\u001a\u00020\u0005R=\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tj\u0004\u0018\u0001`\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018RC\u0010\u000f\u001a+\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\tj\u0004\u0018\u0001`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006="}, d2={"Lcom/amaze/trashbin/TrashBin;", "", "context", "Landroid/content/Context;", "doTriggerAutoCleanup", "", "trashConfig", "Lcom/amaze/trashbin/TrashBinConfig;", "deletePermanentlySuperCallback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "deletePath", "Lcom/amaze/trashbin/DeletePermanentlyCallback;", "listTrashBinFilesSuperCallback", "parentTrashBinPath", "", "Lcom/amaze/trashbin/TrashBinFile;", "Lcom/amaze/trashbin/ListTrashBinFilesCallback;", "(Landroid/content/Context;ZLcom/amaze/trashbin/TrashBinConfig;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getDeletePermanentlySuperCallback", "()Lkotlin/jvm/functions/Function1;", "setDeletePermanentlySuperCallback", "(Lkotlin/jvm/functions/Function1;)V", "getListTrashBinFilesSuperCallback", "setListTrashBinFilesSuperCallback", "metadata", "Lcom/amaze/trashbin/TrashBinMetadata;", "getTrashConfig", "()Lcom/amaze/trashbin/TrashBinConfig;", "setTrashConfig", "(Lcom/amaze/trashbin/TrashBinConfig;)V", "deletePermanently", "files", "deletePermanentlyCallback", "doTriggerCleanup", "emptyBin", "getConfig", "getTrashBinMetadata", "listFilesInBin", "loadMetaDataJSONFile", "moveToBin", "moveFilesCallback", "Lkotlin/Function2;", "source", "dest", "Lcom/amaze/trashbin/MoveFilesCallback;", "removeRogueFiles", "listTrashBinFilesCallback", "restore", "restoreBin", "setConfig", "", "trashBinConfig", "triggerCleanup", "writeMetaDataJSONFile", "meta", "writeMetadataAndTriggerCleanup", "totalSize", "", "trashbin_release"})
public final class TrashBin {
    @NotNull
    private TrashBinConfig trashConfig;
    @Nullable
    private Function1<? super String, Boolean> deletePermanentlySuperCallback;
    @Nullable
    private Function1<? super String, ? extends List<TrashBinFile>> listTrashBinFilesSuperCallback;
    @Nullable
    private TrashBinMetadata metadata;

    public TrashBin(@NotNull Context context, boolean doTriggerAutoCleanup, @NotNull TrashBinConfig trashConfig, @Nullable Function1<? super String, Boolean> deletePermanentlySuperCallback, @Nullable Function1<? super String, ? extends List<TrashBinFile>> listTrashBinFilesSuperCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)trashConfig, (String)"trashConfig");
        this.trashConfig = trashConfig;
        this.deletePermanentlySuperCallback = deletePermanentlySuperCallback;
        this.listTrashBinFilesSuperCallback = listTrashBinFilesSuperCallback;
        this.trashConfig.getTrashBinFilesDirectory();
        this.metadata = this.getTrashBinMetadata();
        if (this.deletePermanentlySuperCallback != null && doTriggerAutoCleanup && this.trashConfig.getCleanupIntervalHours() != -1) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(context.getPackageName() + ".com.amaze.trashbin", 0);
            long lastCleanup = sharedPreferences.getLong("com.amaze.trashbin.lastCleanup", 0L);
            long currentTime = System.currentTimeMillis();
            long hours = (currentTime - lastCleanup) / (long)3600000;
            Log.i((String)this.getClass().getSimpleName(), (String)("auto cleanup pending minutes " + hours + " and interval " + this.trashConfig.getCleanupIntervalHours()));
            if (hours >= (long)this.trashConfig.getCleanupIntervalHours()) {
                Log.i((String)this.getClass().getSimpleName(), (String)"triggering auto cleanup for trash bin");
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sharedPreferences, currentTime, null){
                    int label;
                    final /* synthetic */ TrashBin this$0;
                    final /* synthetic */ SharedPreferences $sharedPreferences;
                    final /* synthetic */ long $currentTime;
                    {
                        this.this$0 = $receiver;
                        this.$sharedPreferences = $sharedPreferences;
                        this.$currentTime = $currentTime;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Function1<String, Boolean> function1 = this.this$0.getDeletePermanentlySuperCallback();
                                Intrinsics.checkNotNull(function1);
                                this.this$0.triggerCleanup(function1);
                                this.$sharedPreferences.edit().putLong("com.amaze.trashbin.lastCleanup", this.$currentTime).apply();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }
    }

    public /* synthetic */ TrashBin(Context context, boolean bl, TrashBinConfig trashBinConfig, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function12 = null;
        }
        this(context, bl, trashBinConfig, (Function1<? super String, Boolean>)function1, (Function1<? super String, ? extends List<TrashBinFile>>)function12);
    }

    @NotNull
    public final TrashBinConfig getTrashConfig() {
        return this.trashConfig;
    }

    public final void setTrashConfig(@NotNull TrashBinConfig trashBinConfig) {
        Intrinsics.checkNotNullParameter((Object)trashBinConfig, (String)"<set-?>");
        this.trashConfig = trashBinConfig;
    }

    @Nullable
    public final Function1<String, Boolean> getDeletePermanentlySuperCallback() {
        return this.deletePermanentlySuperCallback;
    }

    public final void setDeletePermanentlySuperCallback(@Nullable Function1<? super String, Boolean> function1) {
        this.deletePermanentlySuperCallback = function1;
    }

    @Nullable
    public final Function1<String, List<TrashBinFile>> getListTrashBinFilesSuperCallback() {
        return this.listTrashBinFilesSuperCallback;
    }

    public final void setListTrashBinFilesSuperCallback(@Nullable Function1<? super String, ? extends List<TrashBinFile>> function1) {
        this.listTrashBinFilesSuperCallback = function1;
    }

    public final boolean deletePermanently(@NotNull List<TrashBinFile> files, @NotNull Function1<? super String, Boolean> deletePermanentlyCallback, boolean doTriggerCleanup) {
        TrashBinFile it;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(deletePermanentlyCallback, (String)"deletePermanentlyCallback");
        if (files.isEmpty()) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Empty files list to delete permanently");
            return true;
        }
        long totalSize = 0L;
        ArrayList filesMetadata = new ArrayList(this.getTrashBinMetadata().getFiles());
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TrashBinFile)element$iv;
            boolean bl = false;
            int indexToRemove = -1;
            int n = filesMetadata.size();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)it.getPath(), (Object)((TrashBinFile)filesMetadata.get(i)).getPath())) continue;
                indexToRemove = i;
                break;
            }
            if (indexToRemove != -1) {
                boolean didDelete = (Boolean)deletePermanentlyCallback.invoke((Object)it.getDeletedPath(this.trashConfig));
                if (!didDelete) continue;
                filesMetadata.remove(indexToRemove);
                Log.w((String)this.getClass().getSimpleName(), (String)("TrashBin: deleting file in trashbin " + it.getPath()));
                continue;
            }
            deletePermanentlyCallback.invoke((Object)it.getPath());
            Log.w((String)this.getClass().getSimpleName(), (String)("TrashBin: deleting original file " + it.getPath()));
        }
        $this$forEach$iv = filesMetadata;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TrashBinFile)element$iv;
            boolean bl = false;
            totalSize += it.getSizeBytes();
        }
        Iterable $this$sortedBy$iv = filesMetadata;
        boolean $i$f$sortedBy = false;
        CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TrashBinFile trashBinFile = (TrashBinFile)a;
                boolean bl = false;
                Long l = trashBinFile.getDeleteTime();
                trashBinFile = (TrashBinFile)b;
                Comparable comparable = l != null ? Long.valueOf(l * (long)-1) : null;
                bl = false;
                Long l2 = trashBinFile.getDeleteTime();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(l2 != null ? Long.valueOf(l2 * (long)-1) : null));
            }
        });
        this.writeMetadataAndTriggerCleanup(filesMetadata, totalSize, doTriggerCleanup);
        return true;
    }

    public static /* synthetic */ boolean deletePermanently$default(TrashBin trashBin, List list, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return trashBin.deletePermanently(list, (Function1<? super String, Boolean>)function1, bl);
    }

    public final boolean moveToBin(@NotNull List<TrashBinFile> files, boolean doTriggerCleanup, @NotNull Function2<? super String, ? super String, Boolean> moveFilesCallback) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(moveFilesCallback, (String)"moveFilesCallback");
        if (files.isEmpty()) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Empty files list to move to bin");
            return true;
        }
        long totalSize = 0L;
        TrashBinMetadata trashBinMetadata = this.metadata;
        totalSize = trashBinMetadata != null ? trashBinMetadata.getTotalSize() : 0L;
        ArrayList<TrashBinFile> filesMetadata = new ArrayList<TrashBinFile>((Collection)this.getTrashBinMetadata().getFiles());
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrashBinFile it = (TrashBinFile)element$iv;
            boolean bl = false;
            boolean didMove = (Boolean)moveFilesCallback.invoke((Object)it.getPath(), (Object)it.getDeletedPath(this.trashConfig));
            if (didMove) {
                filesMetadata.add(it);
                totalSize += it.getSizeBytes();
                continue;
            }
            Log.w((String)this.getClass().getSimpleName(), (String)("Failed to move to bin " + it.getPath()));
        }
        Iterable $this$sortedByDescending$iv = filesMetadata;
        boolean $i$f$sortedByDescending = false;
        CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TrashBinFile trashBinFile = (TrashBinFile)b;
                boolean bl = false;
                Comparable comparable = trashBinFile.getDeleteTime();
                trashBinFile = (TrashBinFile)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)trashBinFile.getDeleteTime());
            }
        });
        this.writeMetadataAndTriggerCleanup((List<TrashBinFile>)filesMetadata, totalSize, doTriggerCleanup);
        return true;
    }

    public static /* synthetic */ boolean moveToBin$default(TrashBin trashBin, List list, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return trashBin.moveToBin(list, bl, (Function2<? super String, ? super String, Boolean>)function2);
    }

    public final boolean restore(@NotNull List<TrashBinFile> files, boolean doTriggerCleanup, @NotNull Function2<? super String, ? super String, Boolean> moveFilesCallback) {
        TrashBinFile it;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(moveFilesCallback, (String)"moveFilesCallback");
        if (files.isEmpty()) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Empty files list to restore");
            return true;
        }
        long totalSize = 0L;
        ArrayList filesMetadata = new ArrayList(this.getTrashBinMetadata().getFiles());
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TrashBinFile)element$iv;
            boolean bl = false;
            boolean didMove = (Boolean)moveFilesCallback.invoke((Object)it.getDeletedPath(this.trashConfig), (Object)it.getPath());
            if (didMove) {
                int indexToRemove = -1;
                int n = filesMetadata.size();
                for (int i = 0; i < n; ++i) {
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)((TrashBinFile)filesMetadata.get(i)).getPath())) continue;
                    indexToRemove = i;
                    break;
                }
                if (indexToRemove == -1) continue;
                filesMetadata.remove(indexToRemove);
                continue;
            }
            Log.w((String)this.getClass().getSimpleName(), (String)("Failed to restore from bin " + it.getPath()));
        }
        $this$forEach$iv = filesMetadata;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TrashBinFile)element$iv;
            boolean bl = false;
            totalSize += it.getSizeBytes();
        }
        Iterable $this$sortedBy$iv = filesMetadata;
        boolean $i$f$sortedBy = false;
        CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TrashBinFile trashBinFile = (TrashBinFile)a;
                boolean bl = false;
                Long l = trashBinFile.getDeleteTime();
                trashBinFile = (TrashBinFile)b;
                Comparable comparable = l != null ? Long.valueOf(l * (long)-1) : null;
                bl = false;
                Long l2 = trashBinFile.getDeleteTime();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(l2 != null ? Long.valueOf(l2 * (long)-1) : null));
            }
        });
        this.writeMetadataAndTriggerCleanup(filesMetadata, totalSize, doTriggerCleanup);
        return true;
    }

    public static /* synthetic */ boolean restore$default(TrashBin trashBin, List list, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return trashBin.restore(list, bl, (Function2<? super String, ? super String, Boolean>)function2);
    }

    public final boolean emptyBin(@NotNull Function1<? super String, Boolean> deletePermanentlyCallback) {
        Intrinsics.checkNotNullParameter(deletePermanentlyCallback, (String)"deletePermanentlyCallback");
        Object object = this.metadata;
        if (object == null || (object = ((TrashBinMetadata)object).getFiles()) == null) {
            object = CollectionsKt.emptyList();
        }
        return this.deletePermanently((List<TrashBinFile>)object, deletePermanentlyCallback, true);
    }

    public final boolean restoreBin(@NotNull Function2<? super String, ? super String, Boolean> moveFilesCallback) {
        Intrinsics.checkNotNullParameter(moveFilesCallback, (String)"moveFilesCallback");
        Object object = this.metadata;
        if (object == null || (object = ((TrashBinMetadata)object).getFiles()) == null) {
            object = CollectionsKt.emptyList();
        }
        return this.restore((List<TrashBinFile>)object, true, moveFilesCallback);
    }

    @NotNull
    public final List<TrashBinFile> listFilesInBin() {
        return this.getTrashBinMetadata().getFiles();
    }

    @NotNull
    public final TrashBinConfig getConfig() {
        return this.trashConfig;
    }

    public final void setConfig(@NotNull TrashBinConfig trashBinConfig) {
        Intrinsics.checkNotNullParameter((Object)trashBinConfig, (String)"trashBinConfig");
        this.trashConfig = trashBinConfig;
    }

    @NotNull
    public final TrashBinMetadata getTrashBinMetadata() {
        TrashBinMetadata trashBinMetadata = this.metadata;
        if (trashBinMetadata == null) {
            trashBinMetadata = this.loadMetaDataJSONFile();
        }
        return trashBinMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrashBinMetadata loadMetaDataJSONFile() {
        Type metadataType2 = new TypeToken<TrashBinMetadata>(){}.getType();
        JsonReader reader = new JsonReader((Reader)new FileReader(this.trashConfig.getMetaDataFilePath()));
        try {
            Gson gson = new Gson();
            Closeable closeable = (Closeable)reader;
            Throwable throwable = null;
            try {
                JsonReader it = (JsonReader)closeable;
                boolean bl = false;
                this.metadata = (TrashBinMetadata)gson.fromJson(reader, metadataType2);
                if (this.metadata == null) {
                    this.metadata = new TrashBinMetadata(this.trashConfig, 0L, CollectionsKt.emptyList());
                } else {
                    TrashBinMetadata trashBinMetadata = this.metadata;
                    if (trashBinMetadata != null) {
                        trashBinMetadata.setConfig(this.trashConfig);
                    }
                }
                TrashBinMetadata trashBinMetadata = this.metadata;
                Intrinsics.checkNotNull((Object)trashBinMetadata);
                this.writeMetaDataJSONFile(trashBinMetadata);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Log.w((String)this.getClass().getSimpleName(), (String)"Failed to load metadata", (Throwable)e);
            this.metadata = new TrashBinMetadata(this.trashConfig, 0L, CollectionsKt.emptyList());
        }
        TrashBinMetadata trashBinMetadata = this.metadata;
        Intrinsics.checkNotNull((Object)trashBinMetadata);
        return trashBinMetadata;
    }

    public final boolean triggerCleanup(@NotNull Function1<? super String, Boolean> deletePermanentlyCallback) {
        Intrinsics.checkNotNullParameter(deletePermanentlyCallback, (String)"deletePermanentlyCallback");
        TrashBinMetadata trashBinMetadata = this.metadata;
        List<TrashBinFile> filesToDelete = trashBinMetadata != null ? trashBinMetadata.getFilesWithDeletionCriteria() : null;
        Collection collection = filesToDelete;
        if (!(collection == null || collection.isEmpty())) {
            this.deletePermanently(filesToDelete, deletePermanentlyCallback, false);
        }
        return true;
    }

    public final boolean removeRogueFiles(@NotNull List<TrashBinFile> files, @NotNull Function1<? super String, ? extends List<TrashBinFile>> listTrashBinFilesCallback, @NotNull Function1<? super String, Boolean> deletePermanentlyCallback) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(listTrashBinFilesCallback, (String)"listTrashBinFilesCallback");
        Intrinsics.checkNotNullParameter(deletePermanentlyCallback, (String)"deletePermanentlyCallback");
        List physicalFilesList = (List)listTrashBinFilesCallback.invoke((Object)this.trashConfig.getTrashBinFilesDirectory());
        if (physicalFilesList.size() > files.size()) {
            int n = physicalFilesList.size();
            for (int i = 0; i < n; ++i) {
                boolean foundPhysicalFile = false;
                int n2 = files.size();
                for (int j = 0; j < n2; ++j) {
                    if (!Intrinsics.areEqual((Object)((TrashBinFile)physicalFilesList.get(i)).getPath(), (Object)files.get(j).getPath())) continue;
                    foundPhysicalFile = true;
                    break;
                }
                if (foundPhysicalFile) continue;
                this.deletePermanently(CollectionsKt.listOf(physicalFilesList.get(i)), deletePermanentlyCallback, false);
            }
        } else {
            ArrayList mutableMetaFiles = new ArrayList(files);
            int n = mutableMetaFiles.size();
            for (int i = 0; i < n; ++i) {
                boolean foundFileMetadata = false;
                int n3 = physicalFilesList.size();
                for (int j = 0; j < n3; ++j) {
                    if (!Intrinsics.areEqual((Object)((TrashBinFile)physicalFilesList.get(i)).getPath(), (Object)((TrashBinFile)mutableMetaFiles.get(j)).getPath())) continue;
                    foundFileMetadata = true;
                    break;
                }
                if (foundFileMetadata) continue;
                mutableMetaFiles.remove(i);
            }
            TrashBinMetadata trashBinMetadata = this.metadata;
            if (trashBinMetadata != null) {
                trashBinMetadata.setFiles(mutableMetaFiles);
            }
            TrashBinMetadata trashBinMetadata2 = this.metadata;
            Intrinsics.checkNotNull((Object)trashBinMetadata2);
            this.writeMetaDataJSONFile(trashBinMetadata2);
        }
        return true;
    }

    public final void writeMetadataAndTriggerCleanup(@NotNull List<TrashBinFile> files, long totalSize, boolean doTriggerCleanup) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        TrashBinMetadata trashBinMetadata = this.metadata;
        if (trashBinMetadata != null) {
            trashBinMetadata.setConfig(this.trashConfig);
        }
        TrashBinMetadata trashBinMetadata2 = this.metadata;
        if (trashBinMetadata2 != null) {
            trashBinMetadata2.setFiles(files);
        }
        TrashBinMetadata trashBinMetadata3 = this.metadata;
        if (trashBinMetadata3 != null) {
            trashBinMetadata3.setTotalSize(totalSize);
        }
        if (this.trashConfig.getDeleteRogueFiles() && this.listTrashBinFilesSuperCallback != null && this.deletePermanentlySuperCallback != null) {
            Function1<? super String, ? extends List<TrashBinFile>> function1 = this.listTrashBinFilesSuperCallback;
            Intrinsics.checkNotNull(function1);
            Function1<? super String, Boolean> function12 = this.deletePermanentlySuperCallback;
            Intrinsics.checkNotNull(function12);
            this.removeRogueFiles(files, function1, function12);
        } else {
            TrashBinMetadata trashBinMetadata4 = this.metadata;
            Intrinsics.checkNotNull((Object)trashBinMetadata4);
            this.writeMetaDataJSONFile(trashBinMetadata4);
        }
        if (doTriggerCleanup && this.deletePermanentlySuperCallback != null) {
            Function1<? super String, Boolean> function1 = this.deletePermanentlySuperCallback;
            Intrinsics.checkNotNull(function1);
            this.triggerCleanup(function1);
        }
    }

    public static /* synthetic */ void writeMetadataAndTriggerCleanup$default(TrashBin trashBin, List list, long l, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        trashBin.writeMetadataAndTriggerCleanup(list, l, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMetaDataJSONFile(TrashBinMetadata meta) {
        Closeable closeable = new FileWriter(this.trashConfig.getMetaDataFilePath());
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            Gson gson = new GsonBuilder().serializeNulls().create();
            gson.toJson((Object)meta, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

