/*
 * Decompiled with CFR 0.152.
 */
package gotap.com.tapglkitandroid.gl.Views;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import gotap.com.tapglkitandroid.gl.Shaders.BaseShader;
import gotap.com.tapglkitandroid.gl.Shaders.TapLoadingShader;
import java.lang.reflect.InvocationTargetException;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class TapRender
implements GLSurfaceView.Renderer {
    private Context context;
    private TapRenderListener listener;
    BaseShader view;
    Class shader;

    public TapRender(Context context, Class shader, TapRenderListener listener) {
        this.context = context;
        this.shader = shader;
        this.listener = listener;
    }

    public void onDrawFrame(GL10 unused) {
        if (this.view != null) {
            this.view.draw();
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        try {
            if (this.shader.getConstructors() != null && this.shader.getConstructors().length > 0) {
                this.view = (BaseShader)this.shader.getConstructors()[0].newInstance(this.context, this.listener);
            }
            if (this.view == null) {
                this.view = new TapLoadingShader(this.context, this.listener);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void onSurfaceChanged(GL10 unused, int width, int height) {
    }

    public static int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)shaderCode);
        GLES20.glCompileShader((int)shader);
        return shader;
    }

    public static interface TapRenderListener {
        public float width();

        public float height();

        public int getColor();

        public boolean isForceStop();

        public float getTimer();

        public boolean useCustomColor();
    }
}

