/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.TriggeringPolicyBase;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.InvocationGate;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeBasedTriggeringPolicy<E>
extends TriggeringPolicyBase<E> {
    public static final String SEE_SIZE_FORMAT = "http://logback.qos.ch/codes.html#sbtp_size_format";
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    String maxFileSizeAsString = Long.toString(0xA00000L);
    FileSize maxFileSize;
    private InvocationGate invocationGate = new InvocationGate();

    public SizeBasedTriggeringPolicy() {
    }

    public SizeBasedTriggeringPolicy(String string) {
        this.setMaxFileSize(string);
    }

    @Override
    public boolean isTriggeringEvent(File file, E e) {
        if (this.invocationGate.skipFurtherWork()) {
            return false;
        }
        long l = System.currentTimeMillis();
        this.invocationGate.updateMaskIfNecessary(l);
        return file.length() >= this.maxFileSize.getSize();
    }

    public String getMaxFileSize() {
        return this.maxFileSizeAsString;
    }

    public void setMaxFileSize(String string) {
        this.maxFileSizeAsString = string;
        this.maxFileSize = FileSize.valueOf(string);
    }

    long toFileSize(String string) {
        if (string == null) {
            return 0xA00000L;
        }
        String string2 = string.trim().toUpperCase();
        long l = 1L;
        int n = string2.indexOf("KB");
        if (n != -1) {
            l = 1024L;
            string2 = string2.substring(0, n);
        } else {
            n = string2.indexOf("MB");
            if (n != -1) {
                l = 0x100000L;
                string2 = string2.substring(0, n);
            } else {
                n = string2.indexOf("GB");
                if (n != -1) {
                    l = 0x40000000L;
                    string2 = string2.substring(0, n);
                }
            }
        }
        if (string2 != null) {
            try {
                return Long.valueOf(string2) * l;
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("[" + string2 + "] is not in proper int format. Please refer to " + SEE_SIZE_FORMAT);
                this.addError("[" + string + "] not in expected format.", numberFormatException);
            }
        }
        return 0xA00000L;
    }
}

