/*
 * Decompiled with CFR 0.152.
 */
package com.thf.logger;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.thf.logger.LogConfig;
import java.io.File;
import org.slf4j.LoggerFactory;

public class AppenderFactory {
    public static RollingFileAppender createRollingFileAppender(LogConfig logConfig) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setAppend(true);
        rollingFileAppender.setContext((Context)context);
        rollingFileAppender.setFile(logConfig.getLogDir() + File.separator + logConfig.getLogName() + "_0.txt");
        FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
        fixedWindowRollingPolicy.setFileNamePattern(logConfig.getLogDir() + File.separator + logConfig.getLogName() + "_%i.txt");
        fixedWindowRollingPolicy.setMinIndex(0);
        fixedWindowRollingPolicy.setMaxIndex(logConfig.getFileCount() - 1);
        fixedWindowRollingPolicy.setParent((FileAppender)rollingFileAppender);
        fixedWindowRollingPolicy.setContext((Context)context);
        fixedWindowRollingPolicy.start();
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
        sizeBasedTriggeringPolicy.setMaxFileSize(FileSize.valueOf((String)logConfig.getMaxSize()));
        sizeBasedTriggeringPolicy.setContext((Context)context);
        sizeBasedTriggeringPolicy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %-5level %logger{36} %msg%n");
        encoder.setContext((Context)context);
        encoder.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)fixedWindowRollingPolicy);
        rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)sizeBasedTriggeringPolicy);
        rollingFileAppender.setEncoder((Encoder)encoder);
        rollingFileAppender.start();
        return rollingFileAppender;
    }

    public static AsyncAppender createAsyncAppender() {
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setDiscardingThreshold(0);
        asyncAppender.setQueueSize(512);
        return asyncAppender;
    }
}

