/*
 * Decompiled with CFR 0.152.
 */
package com.thf.logger;

import android.text.TextUtils;
import android.util.Log;
import ch.qos.logback.classic.Logger;
import com.thf.logger.LogConfig;

public class ThfLogger {
    Logger logger;
    LogConfig logConfig;
    private String logFilePath;

    public ThfLogger(Logger logger, LogConfig logConfig) {
        this.logger = logger;
        this.logConfig = logConfig;
        this.logFilePath = logConfig.getLogDir();
    }

    public String getLogFilePath(int index) {
        return this.logFilePath + "_" + index + ".txt";
    }

    public void i(String tag, String message) {
        if (this.logConfig.isEnableLogcat()) {
            if (TextUtils.isEmpty((CharSequence)tag)) {
                Log.i((String)this.logger.getName(), (String)message);
            } else {
                Log.i((String)tag, (String)message);
            }
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            this.logger.info(message);
        } else {
            this.logger.info("[" + tag + "]  " + message);
        }
    }

    public void i(String message) {
        this.i(null, message);
    }

    public void e(String tag, String message, Exception e) {
        if (this.logConfig.isEnableLogcat()) {
            if (TextUtils.isEmpty((CharSequence)tag)) {
                Log.e((String)this.logger.getName(), (String)message, (Throwable)e);
            } else {
                Log.e((String)tag, (String)message, (Throwable)e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            this.logger.error(message, (Throwable)e);
        } else {
            this.logger.error("[" + tag + "]  " + message, (Throwable)e);
        }
    }

    public void e(String message, Exception e) {
        this.e(null, message, e);
    }
}

