/*
 * Decompiled with CFR 0.152.
 */
package com.thf.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import com.thf.logger.AppenderFactory;
import com.thf.logger.LogConfig;
import com.thf.logger.ThfLogger;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LoggerBuilder {
    private static final Map<String, ThfLogger> container = new HashMap<String, ThfLogger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThfLogger getLogger(LogConfig logConfig) {
        ThfLogger logger = container.get(logConfig.getLoggerRefName());
        if (logger != null) {
            return logger;
        }
        Class<LoggerBuilder> clazz = LoggerBuilder.class;
        synchronized (LoggerBuilder.class) {
            logger = container.get(logConfig.getLoggerRefName());
            if (logger != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return logger;
            }
            logger = LoggerBuilder.build(logConfig);
            container.put(logConfig.getLoggerRefName(), logger);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return logger;
        }
    }

    private static ThfLogger build(LogConfig logConfig) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger(logConfig.getLoggerRefName());
        logger.setAdditive(false);
        logger.addAppender((Appender)AppenderFactory.createRollingFileAppender(logConfig));
        if (logConfig.isEnableAsyncSaveLog()) {
            logger.addAppender((Appender)AppenderFactory.createAsyncAppender());
        }
        logger.setLevel(Level.ALL);
        ThfLogger thfLogger = new ThfLogger(logger, logConfig);
        return thfLogger;
    }
}

