/*
 * Decompiled with CFR 0.152.
 */
package com.thf.logger;

import android.text.TextUtils;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.android.LogcatAppender;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final String TAG = Logger.class.getSimpleName();

    private Logger() {
    }

    public void saveLog(String tag, String message) {
        this.saveLog(tag, message, null);
    }

    public void saveLog(String tag, String message, Throwable throwable) {
        this.error(tag, message, throwable);
    }

    public void error(String tag, String message, Throwable throwable) {
        org.slf4j.Logger logger = TextUtils.isEmpty((CharSequence)tag) ? LoggerFactory.getLogger((String)TAG) : LoggerFactory.getLogger((String)tag);
        if (throwable == null) {
            logger.error(message);
        } else {
            logger.error(message, throwable);
        }
    }

    public void info(String tag, String message, Throwable throwable) {
        org.slf4j.Logger logger = TextUtils.isEmpty((CharSequence)tag) ? LoggerFactory.getLogger((String)TAG) : LoggerFactory.getLogger((String)tag);
        if (throwable == null) {
            logger.info(message);
        } else {
            logger.info(message, throwable);
        }
    }

    public void saveLog(String message) {
        this.saveLog(null, message);
    }

    private void init(String log_dir, String filePrefix, int maxIndex, int minIndex, String maxSize) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setAppend(true);
        rollingFileAppender.setContext((Context)context);
        rollingFileAppender.setFile(log_dir + "/" + filePrefix + "_0.log");
        FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
        fixedWindowRollingPolicy.setFileNamePattern(log_dir + "/" + filePrefix + "_%i.log");
        fixedWindowRollingPolicy.setMinIndex(minIndex);
        fixedWindowRollingPolicy.setMaxIndex(maxIndex);
        fixedWindowRollingPolicy.setParent((FileAppender)rollingFileAppender);
        fixedWindowRollingPolicy.setContext((Context)context);
        fixedWindowRollingPolicy.start();
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
        sizeBasedTriggeringPolicy.setMaxFileSize(maxSize);
        sizeBasedTriggeringPolicy.setContext((Context)context);
        sizeBasedTriggeringPolicy.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)fixedWindowRollingPolicy);
        rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)sizeBasedTriggeringPolicy);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        encoder.setContext((Context)context);
        encoder.start();
        rollingFileAppender.setEncoder((Encoder)encoder);
        rollingFileAppender.start();
        LogcatAppender logcatAppender = new LogcatAppender();
        logcatAppender.setContext((Context)context);
        logcatAppender.setEncoder(encoder);
        logcatAppender.start();
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.ERROR);
        root.addAppender((Appender)rollingFileAppender);
        root.addAppender((Appender)logcatAppender);
    }

    public static class Builder {
        private int minIndex = 0;
        private String logDir = "/sdcard/logback";
        private String filePreFix = "wxb_log";
        private String maxSize = "20MB";
        private int maxFileNumber;

        public Builder setLogDir(String logDir) {
            this.logDir = logDir;
            return this;
        }

        public Builder setMaxFileNumber(int maxFileNumber) {
            this.maxFileNumber = maxFileNumber;
            return this;
        }

        public Builder setFilePreFix(String filePreFix) {
            this.filePreFix = filePreFix;
            return this;
        }

        public Builder setMaxSize(String maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Logger create() {
            Logger Logger2 = new Logger();
            Logger2.init(this.logDir, this.filePreFix, this.maxFileNumber - 1, this.minIndex, this.maxSize);
            return Logger2;
        }
    }
}

