/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String string = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(string)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, string);
        }
    }

    private static void addStatusListener(LoggerContext loggerContext, String string) {
        StatusListener statusListener = StatusListenerConfigHelper.createListenerPerClassName(loggerContext, string);
        StatusListenerConfigHelper.initListener(loggerContext, statusListener);
    }

    private static void initListener(LoggerContext loggerContext, StatusListener statusListener) {
        if (statusListener != null) {
            if (statusListener instanceof ContextAware) {
                ((ContextAware)((Object)statusListener)).setContext(loggerContext);
            }
            if (statusListener instanceof LifeCycle) {
                ((LifeCycle)((Object)statusListener)).start();
            }
            loggerContext.getStatusManager().add(statusListener);
        }
    }

    private static StatusListener createListenerPerClassName(LoggerContext loggerContext, String string) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName(string, StatusListener.class, loggerContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

