/*
 * Decompiled with CFR 0.152.
 */
package com.goodayapps.widget;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.IntRange;
import com.goodayapps.widget.AvatarDrawable;
import com.goodayapps.widget.TextOverDrawableDsl;
import com.goodayapps.widget.utils.DrawingKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u001f !B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/goodayapps/widget/TextOverDrawable;", "Landroid/graphics/drawable/Drawable;", "size", "", "border", "Lcom/goodayapps/widget/TextOverDrawable$Border;", "text", "Lcom/goodayapps/widget/TextOverDrawable$Text;", "(ILcom/goodayapps/widget/TextOverDrawable$Border;Lcom/goodayapps/widget/TextOverDrawable$Text;)V", "backgroundCircleRadius", "", "bufferBitmap", "Landroid/graphics/Bitmap;", "bufferCanvas", "Landroid/graphics/Canvas;", "circleCenter", "circleRadius", "textOverBackgroundPaint", "Landroid/graphics/Paint;", "textOverPaint", "Landroid/text/TextPaint;", "draw", "", "canvas", "drawTextOver", "getOpacity", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "Border", "Builder", "Text", "avatar-view_release"})
public final class TextOverDrawable
extends Drawable {
    private final int size;
    @NotNull
    private final Border border;
    @NotNull
    private final Text text;
    @NotNull
    private TextPaint textOverPaint;
    @NotNull
    private final Paint textOverBackgroundPaint;
    @NotNull
    private Bitmap bufferBitmap;
    @NotNull
    private Canvas bufferCanvas;
    private float circleRadius;
    private float circleCenter;
    private float backgroundCircleRadius;

    /*
     * WARNING - void declaration
     */
    public TextOverDrawable(int size, @NotNull Border border, @NotNull Text text) {
        void $this$textOverBackgroundPaint_u24lambda_u2d1;
        TextPaint $this$textOverPaint_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)border, (String)"border");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.size = size;
        this.border = border;
        this.text = text;
        TextPaint textPaint = new TextPaint(1);
        boolean bl = false;
        boolean bl2 = false;
        TextPaint textPaint2 = textPaint;
        TextOverDrawable textOverDrawable = this;
        boolean bl3 = false;
        $this$textOverPaint_u24lambda_u2d0.setTextSize(this.text.getTextSize());
        $this$textOverPaint_u24lambda_u2d0.setColor(this.text.getTextColor());
        if (this.text.getTypeface() != null) {
            $this$textOverPaint_u24lambda_u2d0.setTypeface(this.text.getTypeface());
        }
        $this$textOverPaint_u24lambda_u2d0.setStyle(Paint.Style.FILL);
        $this$textOverPaint_u24lambda_u2d0.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        Unit unit = Unit.INSTANCE;
        textOverDrawable.textOverPaint = textPaint;
        textPaint = new Paint();
        bl = false;
        bl2 = false;
        $this$textOverPaint_u24lambda_u2d0 = textPaint;
        textOverDrawable = this;
        boolean bl4 = false;
        $this$textOverBackgroundPaint_u24lambda_u2d1.setAntiAlias(true);
        $this$textOverBackgroundPaint_u24lambda_u2d1.setStyle(Paint.Style.STROKE);
        $this$textOverBackgroundPaint_u24lambda_u2d1.setStrokeWidth((float)this.border.getWidth());
        $this$textOverBackgroundPaint_u24lambda_u2d1.setShader((Shader)DrawingKt.getGradientShader(this.border.getColor(), this.border.getColorSecondary(), this.border.getGradientAngle(), this.size));
        unit = Unit.INSTANCE;
        textOverDrawable.textOverBackgroundPaint = textPaint;
        textPaint = Bitmap.createBitmap((int)this.size, (int)this.size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)textPaint, (String)"createBitmap(size, size, Bitmap.Config.ARGB_8888)");
        this.bufferBitmap = textPaint;
        this.bufferCanvas = new Canvas(this.bufferBitmap);
        this.circleCenter = this.circleRadius = (float)this.size / 2.0f;
        this.backgroundCircleRadius = this.circleRadius - (float)this.border.getWidth() * 0.9f;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate((float)this.getBounds().left, (float)this.getBounds().top);
        this.drawTextOver();
        canvas.drawBitmap(this.bufferBitmap, new Matrix(), null);
        canvas.restore();
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    private final void drawTextOver() {
        float radius = this.circleRadius - (float)this.border.getWidth();
        this.bufferCanvas.drawCircle(this.circleCenter, this.circleCenter, radius - (float)this.border.getWidth() / 2.0f, this.textOverBackgroundPaint);
        Path path = new Path();
        this.bufferCanvas.save();
        this.bufferCanvas.rotate((float)this.text.getAngle(), this.circleCenter, this.circleCenter);
        path.addCircle(this.circleCenter, this.circleCenter, radius, Path.Direction.CCW);
        this.bufferCanvas.drawTextOnPath("#OPENTOWORK", path, 0.0f, 0.0f, (Paint)this.textOverPaint);
        this.bufferCanvas.restore();
    }

    @TextOverDrawableDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/goodayapps/widget/TextOverDrawable$Builder;", "", "()V", "border", "Lcom/goodayapps/widget/TextOverDrawable$Border;", "getBorder", "()Lcom/goodayapps/widget/TextOverDrawable$Border;", "setBorder", "(Lcom/goodayapps/widget/TextOverDrawable$Border;)V", "text", "Lcom/goodayapps/widget/TextOverDrawable$Text;", "getText", "()Lcom/goodayapps/widget/TextOverDrawable$Text;", "setText", "(Lcom/goodayapps/widget/TextOverDrawable$Text;)V", "avatar-view_release"})
    public static final class Builder {
        @NotNull
        private Border border = new Border(0, 0, 0, 0, 15, null);
        @NotNull
        private Text text = new Text(null, 0, 0.0f, null, 0, 31, null);

        @NotNull
        public final Border getBorder() {
            return this.border;
        }

        public final void setBorder(@NotNull Border border) {
            Intrinsics.checkNotNullParameter((Object)border, (String)"<set-?>");
            this.border = border;
        }

        @NotNull
        public final Text getText() {
            return this.text;
        }

        public final void setText(@NotNull Text text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"<set-?>");
            this.text = text;
        }
    }

    @TextOverDrawableDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB-\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/goodayapps/widget/TextOverDrawable$Border;", "", "width", "", "color", "colorSecondary", "gradientAngle", "(IIII)V", "getColor", "()I", "getColorSecondary", "getGradientAngle", "getWidth", "Builder", "avatar-view_release"})
    public static final class Border {
        private final int width;
        private final int color;
        private final int colorSecondary;
        private final int gradientAngle;

        public Border(@Dimension(unit=1) int width, @ColorInt int color, @ColorInt int colorSecondary, int gradientAngle) {
            this.width = width;
            this.color = color;
            this.colorSecondary = colorSecondary;
            this.gradientAngle = gradientAngle;
        }

        public /* synthetic */ Border(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = Color.parseColor((String)"#FF51E400");
            }
            if ((n5 & 4) != 0) {
                n3 = n2;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getColor() {
            return this.color;
        }

        public final int getColorSecondary() {
            return this.colorSecondary;
        }

        public final int getGradientAngle() {
            return this.gradientAngle;
        }

        public Border() {
            this(0, 0, 0, 0, 15, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0017\u0010\u0005\u001a\u00020\u00002\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\b\u001a\u00020\u00002\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\f\u001a\u00020\u00002\b\b\u0001\u0010\u0013\u001a\u00020\u0004J\u0017\u0010\u000e\u001a\u00020\u00002\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@BX\u0087\u000e\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/goodayapps/widget/TextOverDrawable$Border$Builder;", "", "()V", "<set-?>", "", "color", "getColor", "()I", "colorSecondary", "getColorSecondary", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "gradientAngle", "getGradientAngle", "width", "getWidth", "build", "Lcom/goodayapps/widget/TextOverDrawable$Border;", "(Ljava/lang/Integer;)Lcom/goodayapps/widget/TextOverDrawable$Border$Builder;", "angle", "avatar-view_release"})
        public static final class Builder {
            @Dimension(unit=1)
            private int width;
            @ColorInt
            private int color = Color.parseColor((String)"#FF51E400");
            @ColorInt
            @Nullable
            private Integer colorSecondary;
            private int gradientAngle;

            public final int getWidth() {
                return this.width;
            }

            public final int getColor() {
                return this.color;
            }

            @Nullable
            public final Integer getColorSecondary() {
                return this.colorSecondary;
            }

            public final int getGradientAngle() {
                return this.gradientAngle;
            }

            @NotNull
            public final Builder color(@ColorInt @Nullable Integer color) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$color_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                Integer n = color;
                $this$color_u24lambda_u2d0.color = n == null ? $this$color_u24lambda_u2d0.getColor() : n.intValue();
                return builder;
            }

            @NotNull
            public final Builder colorSecondary(@ColorInt @Nullable Integer color) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$colorSecondary_u24lambda_u2d1 = builder;
                boolean bl3 = false;
                Integer n = color;
                $this$colorSecondary_u24lambda_u2d1.colorSecondary = n == null ? Integer.valueOf($this$colorSecondary_u24lambda_u2d1.getColor()) : n;
                return builder;
            }

            @NotNull
            public final Builder width(@Dimension(unit=1) @Nullable Integer width) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$width_u24lambda_u2d2 = builder;
                boolean bl3 = false;
                Integer n = width;
                $this$width_u24lambda_u2d2.width = n == null ? 0 : n;
                return builder;
            }

            @NotNull
            public final Builder gradientAngle(@IntRange(from=0L, to=360L) int angle) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$gradientAngle_u24lambda_u2d3 = builder;
                boolean bl3 = false;
                $this$gradientAngle_u24lambda_u2d3.gradientAngle = angle;
                return builder;
            }

            @NotNull
            public final Border build() {
                Integer n = this.colorSecondary;
                return new Border(this.width, this.color, n == null ? this.color : n, this.gradientAngle);
            }
        }
    }

    @TextOverDrawableDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB;\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/goodayapps/widget/TextOverDrawable$Text;", "", "text", "", "textColor", "", "textSize", "", "typeface", "Landroid/graphics/Typeface;", "angle", "(Ljava/lang/CharSequence;IFLandroid/graphics/Typeface;I)V", "getAngle", "()I", "setAngle", "(I)V", "getText", "()Ljava/lang/CharSequence;", "setText", "(Ljava/lang/CharSequence;)V", "getTextColor", "setTextColor", "getTextSize", "()F", "setTextSize", "(F)V", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "Builder", "avatar-view_release"})
    public static final class Text {
        @Nullable
        private CharSequence text;
        private int textColor;
        private float textSize;
        @Nullable
        private Typeface typeface;
        private int angle;

        public Text(@Nullable CharSequence text, @ColorInt int textColor, @Dimension(unit=1) float textSize, @Nullable Typeface typeface, int angle) {
            this.text = text;
            this.textColor = textColor;
            this.textSize = textSize;
            this.typeface = typeface;
            this.angle = angle;
        }

        public /* synthetic */ Text(CharSequence charSequence, int n, float f, Typeface typeface, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                charSequence = "?";
            }
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 4) != 0) {
                f = 0.0f;
            }
            if ((n3 & 8) != 0) {
                typeface = null;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 0;
            }
            this(charSequence, n, f, typeface, n2);
        }

        @Nullable
        public final CharSequence getText() {
            return this.text;
        }

        public final void setText(@Nullable CharSequence charSequence) {
            this.text = charSequence;
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(int n) {
            this.textColor = n;
        }

        public final float getTextSize() {
            return this.textSize;
        }

        public final void setTextSize(float f) {
            this.textSize = f;
        }

        @Nullable
        public final Typeface getTypeface() {
            return this.typeface;
        }

        public final void setTypeface(@Nullable Typeface typeface) {
            this.typeface = typeface;
        }

        public final int getAngle() {
            return this.angle;
        }

        public final void setAngle(int n) {
            this.angle = n;
        }

        public Text() {
            this(null, 0, 0.0f, null, 0, 31, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0017J\u0017\u0010\b\u001a\u00020\u00002\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u000b\u001a\u00020\u00002\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0003\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/goodayapps/widget/TextOverDrawable$Text$Builder;", "", "()V", "<set-?>", "", "angle", "getAngle", "()I", "color", "getColor", "", "size", "getSize", "()F", "", "text", "getText", "()Ljava/lang/CharSequence;", "Landroid/graphics/Typeface;", "typeface", "getTypeface", "()Landroid/graphics/Typeface;", "build", "Lcom/goodayapps/widget/AvatarDrawable$Placeholder;", "(Ljava/lang/Integer;)Lcom/goodayapps/widget/TextOverDrawable$Text$Builder;", "(Ljava/lang/Float;)Lcom/goodayapps/widget/TextOverDrawable$Text$Builder;", "avatar-view_release"})
        public static final class Builder {
            @Nullable
            private CharSequence text = "?";
            @ColorInt
            private int color = -1;
            @Dimension(unit=1)
            private float size;
            @Nullable
            private Typeface typeface;
            private int angle;

            @Nullable
            public final CharSequence getText() {
                return this.text;
            }

            public final int getColor() {
                return this.color;
            }

            public final float getSize() {
                return this.size;
            }

            @Nullable
            public final Typeface getTypeface() {
                return this.typeface;
            }

            public final int getAngle() {
                return this.angle;
            }

            @NotNull
            public final Builder text(@Nullable CharSequence text) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$text_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                CharSequence charSequence = text;
                $this$text_u24lambda_u2d0.text = charSequence == null ? (CharSequence)"?" : charSequence;
                return builder;
            }

            @NotNull
            public final Builder color(@ColorInt @Nullable Integer color) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$color_u24lambda_u2d1 = builder;
                boolean bl3 = false;
                Integer n = color;
                $this$color_u24lambda_u2d1.color = n == null ? $this$color_u24lambda_u2d1.getColor() : n.intValue();
                return builder;
            }

            @NotNull
            public final Builder size(@Dimension(unit=1) @Nullable Float size) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$size_u24lambda_u2d2 = builder;
                boolean bl3 = false;
                Float f = size;
                $this$size_u24lambda_u2d2.size = f == null ? 0.0f : f.floatValue();
                return builder;
            }

            @NotNull
            public final Builder typeface(@Nullable Typeface typeface) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$typeface_u24lambda_u2d3 = builder;
                boolean bl3 = false;
                $this$typeface_u24lambda_u2d3.typeface = typeface;
                return builder;
            }

            @NotNull
            public final Builder angle(@IntRange(from=0L, to=360L) int angle) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$angle_u24lambda_u2d4 = builder;
                boolean bl3 = false;
                $this$angle_u24lambda_u2d4.angle = angle;
                return builder;
            }

            @NotNull
            public final AvatarDrawable.Placeholder build() {
                return new AvatarDrawable.Placeholder(this.text, this.color, this.size, this.typeface);
            }
        }
    }
}

