/*
 * Decompiled with CFR 0.152.
 */
package com.goodayapps.widget;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.goodayapps.widget.AvatarDrawableDsl;
import com.goodayapps.widget.CenterCropDrawable;
import com.goodayapps.widget.utils.DrawingKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AvatarDrawableDsl
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0007\u0018\u00002\u00020\u0001:\u0005TUVWXB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BQ\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u00107\u001a\u00020\nH\u0002J\b\u00108\u001a\u00020\u0018H\u0002J\b\u00109\u001a\u00020\nH\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\b\u001a\u00020\u0001H\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\nH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020!H\u0016J\b\u0010@\u001a\u00020>H\u0002J\u0018\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\nH\u0002J\u0018\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u001fH\u0002J\b\u0010I\u001a\u00020>H\u0002J\b\u0010J\u001a\u00020>H\u0002J\b\u0010K\u001a\u00020>H\u0002J\u0010\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020GH\u0002J\n\u0010N\u001a\u0004\u0018\u00010)H\u0016J\b\u0010O\u001a\u00020\u0006H\u0016J\u0010\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020\u0006H\u0016J\u0012\u0010R\u001a\u00020>2\b\u0010S\u001a\u0004\u0018\u00010)H\u0016R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0016R\u000e\u0010'\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0016R\u000e\u00100\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/goodayapps/widget/AvatarDrawable;", "Landroid/graphics/drawable/Drawable;", "builder", "Lcom/goodayapps/widget/AvatarDrawable$Builder;", "(Lcom/goodayapps/widget/AvatarDrawable$Builder;)V", "size", "", "backgroundColor", "avatarDrawable", "iconDrawableScale", "", "volumetricType", "Lcom/goodayapps/widget/AvatarDrawable$Volumetric;", "avatarMargin", "border", "Lcom/goodayapps/widget/AvatarDrawable$Border;", "placeholder", "Lcom/goodayapps/widget/AvatarDrawable$Placeholder;", "(IILandroid/graphics/drawable/Drawable;FLcom/goodayapps/widget/AvatarDrawable$Volumetric;ILcom/goodayapps/widget/AvatarDrawable$Border;Lcom/goodayapps/widget/AvatarDrawable$Placeholder;)V", "animationArchesSparseness", "animationLoopDegrees", "getAnimationLoopDegrees", "()F", "arcBorderRect", "Landroid/graphics/RectF;", "avatarBackgroundPaint", "Landroid/graphics/Paint;", "backgroundCircleRadius", "borderPaint", "borderRect", "bufferBitmap", "Landroid/graphics/Bitmap;", "bufferCanvas", "Landroid/graphics/Canvas;", "circleCenter", "circleRadius", "clipPaint", "currentAnimationArchesArea", "getCurrentAnimationArchesArea", "gradientPaint", "iconColorFilter", "Landroid/graphics/ColorFilter;", "individualArcDegreeLength", "getIndividualArcDegreeLength", "placeholderPaint", "Landroid/text/TextPaint;", "spaceBetweenArches", "getSpaceBetweenArches", "textHeight", "textLayout", "Landroid/text/StaticLayout;", "textLeft", "textWidth", "totalArchesDegreeArea", "getTotalArchesDegreeArea", "calculateArcDegreeLength", "calculateBounds", "calculateSpaceBetweenArches", "createAnimatableAvatarBitmap", "createAvatarBitmap", "scale", "draw", "", "canvas", "drawArcBorder", "drawArches", "path", "Landroid/graphics/Path;", "totalDegrees", "drawBitmap", "isIconDrawable", "", "avatarBitmap", "drawBorder", "drawCircleBorder", "drawPlaceholder", "drawVolume", "isDrawable", "getColorFilter", "getOpacity", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Border", "Builder", "Placeholder", "Size", "Volumetric", "avatar-view_release"})
public final class AvatarDrawable
extends Drawable {
    private final int size;
    private final int backgroundColor;
    @Nullable
    private final Drawable avatarDrawable;
    private final float iconDrawableScale;
    @NotNull
    private final Volumetric volumetricType;
    private final int avatarMargin;
    @NotNull
    private final Border border;
    @NotNull
    private final Placeholder placeholder;
    @Nullable
    private ColorFilter iconColorFilter;
    @Nullable
    private StaticLayout textLayout;
    @NotNull
    private TextPaint placeholderPaint;
    @NotNull
    private Paint avatarBackgroundPaint;
    @NotNull
    private final Paint gradientPaint;
    @NotNull
    private final Paint borderPaint;
    @NotNull
    private final Paint clipPaint;
    @NotNull
    private Bitmap bufferBitmap;
    @NotNull
    private Canvas bufferCanvas;
    private float textWidth;
    private float textHeight;
    private float textLeft;
    private float circleRadius;
    private float circleCenter;
    private float backgroundCircleRadius;
    @NotNull
    private final RectF arcBorderRect;
    @NotNull
    private final RectF borderRect;
    private float animationArchesSparseness;

    /*
     * WARNING - void declaration
     */
    private AvatarDrawable(int size, int backgroundColor, Drawable avatarDrawable, float iconDrawableScale, Volumetric volumetricType, int avatarMargin, Border border, Placeholder placeholder) {
        Object object;
        void $this$clipPaint_u24lambda_u2d42;
        TextPaint $this$borderPaint_u24lambda_u2d3;
        TextPaint $this$gradientPaint_u24lambda_u2d2;
        TextPaint $this$avatarBackgroundPaint_u24lambda_u2d1;
        TextPaint $this$placeholderPaint_u24lambda_u2d0;
        this.size = size;
        this.backgroundColor = backgroundColor;
        this.avatarDrawable = avatarDrawable;
        this.iconDrawableScale = iconDrawableScale;
        this.volumetricType = volumetricType;
        this.avatarMargin = avatarMargin;
        this.border = border;
        this.placeholder = placeholder;
        Object object2 = new TextPaint(1);
        boolean bl = false;
        boolean bl2 = false;
        TextPaint textPaint = object2;
        AvatarDrawable avatarDrawable2 = this;
        boolean bl3 = false;
        $this$placeholderPaint_u24lambda_u2d0.setTextSize(this.placeholder.getTextSize());
        $this$placeholderPaint_u24lambda_u2d0.setColor(this.placeholder.getTextColor());
        if (this.placeholder.getTypeface() != null) {
            $this$placeholderPaint_u24lambda_u2d0.setTypeface(this.placeholder.getTypeface());
        }
        $this$placeholderPaint_u24lambda_u2d0.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        Unit unit = Unit.INSTANCE;
        avatarDrawable2.placeholderPaint = object2;
        object2 = new Paint(1);
        bl = false;
        bl2 = false;
        $this$placeholderPaint_u24lambda_u2d0 = object2;
        avatarDrawable2 = this;
        boolean bl4 = false;
        $this$avatarBackgroundPaint_u24lambda_u2d1.setColor(this.backgroundColor);
        $this$avatarBackgroundPaint_u24lambda_u2d1.setAntiAlias(true);
        $this$avatarBackgroundPaint_u24lambda_u2d1.setStyle(Paint.Style.FILL);
        unit = Unit.INSTANCE;
        avatarDrawable2.avatarBackgroundPaint = object2;
        object2 = new Paint();
        bl = false;
        bl2 = false;
        $this$avatarBackgroundPaint_u24lambda_u2d1 = object2;
        avatarDrawable2 = this;
        boolean bl5 = false;
        $this$gradientPaint_u24lambda_u2d2.setAntiAlias(true);
        $this$gradientPaint_u24lambda_u2d2.setShader((Shader)new LinearGradient(0.0f, (float)this.size * 0.94f, 0.0f, 0.0f, 0, Color.argb((int)102, (int)255, (int)255, (int)255), Shader.TileMode.CLAMP));
        unit = Unit.INSTANCE;
        avatarDrawable2.gradientPaint = object2;
        object2 = new Paint();
        bl = false;
        bl2 = false;
        $this$gradientPaint_u24lambda_u2d2 = object2;
        avatarDrawable2 = this;
        boolean bl6 = false;
        $this$borderPaint_u24lambda_u2d3.setAntiAlias(true);
        $this$borderPaint_u24lambda_u2d3.setStyle(Paint.Style.STROKE);
        $this$borderPaint_u24lambda_u2d3.setStrokeCap(Paint.Cap.ROUND);
        $this$borderPaint_u24lambda_u2d3.setStrokeWidth((float)this.border.getWidth());
        $this$borderPaint_u24lambda_u2d3.setShader((Shader)DrawingKt.getGradientShader(this.border.getColor(), this.border.getColorSecondary(), this.border.getGradientAngle(), this.size));
        unit = Unit.INSTANCE;
        avatarDrawable2.borderPaint = object2;
        object2 = new Paint();
        bl = false;
        bl2 = false;
        $this$borderPaint_u24lambda_u2d3 = object2;
        avatarDrawable2 = this;
        boolean bl7 = false;
        $this$clipPaint_u24lambda_u2d42.setColor(-1);
        $this$clipPaint_u24lambda_u2d42.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        $this$clipPaint_u24lambda_u2d42.setStyle(Paint.Style.FILL_AND_STROKE);
        unit = Unit.INSTANCE;
        avatarDrawable2.clipPaint = object2;
        object2 = Bitmap.createBitmap((int)this.size, (int)this.size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"createBitmap(size, size, Bitmap.Config.ARGB_8888)");
        this.bufferBitmap = object2;
        this.bufferCanvas = new Canvas(this.bufferBitmap);
        this.arcBorderRect = new RectF();
        this.borderRect = new RectF();
        this.animationArchesSparseness = 1.0f;
        this.circleCenter = this.circleRadius = (float)this.size / 2.0f;
        this.backgroundCircleRadius = this.circleRadius - (float)this.avatarMargin - (float)this.border.getWidth() * 0.9f;
        AvatarDrawable avatarDrawable3 = this;
        object2 = this.placeholder.getText();
        if (object2 == null) {
            object = null;
        } else {
            Object it;
            Object object3 = object2;
            boolean $this$clipPaint_u24lambda_u2d42 = false;
            bl7 = false;
            Object object4 = object3;
            avatarDrawable2 = avatarDrawable3;
            boolean bl8 = false;
            unit = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)it, (int)0, (int)it.length(), (TextPaint)this.placeholderPaint, (int)this.size).setAlignment(Layout.Alignment.ALIGN_CENTER).setLineSpacing(1.0f, 1.0f).setIncludePad(false).build() : new StaticLayout((CharSequence)it, this.placeholderPaint, this.size, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, false);
            avatarDrawable3 = avatarDrawable2;
            Unit unit2 = unit;
            if (unit2 == null) {
                object = null;
            } else {
                object3 = unit2;
                $this$clipPaint_u24lambda_u2d42 = false;
                bl7 = false;
                it = object3;
                avatarDrawable2 = avatarDrawable3;
                boolean bl9 = false;
                if (it.getLineCount() > 0) {
                    this.textLeft = it.getLineLeft(0);
                    this.textWidth = it.getLineWidth(0);
                    this.textHeight = it.getLineBottom(it.getLineCount() - 1);
                }
                unit = Unit.INSTANCE;
                avatarDrawable3 = avatarDrawable2;
                object = object3;
            }
        }
        avatarDrawable3.textLayout = object;
        this.borderRect.set(this.calculateBounds());
        object2 = this.arcBorderRect;
        boolean bl10 = false;
        boolean bl11 = false;
        Object $this$_init__u24lambda_u2d7 = object2;
        boolean bl12 = false;
        $this$_init__u24lambda_u2d7.set(this.borderRect);
        $this$_init__u24lambda_u2d7.inset((float)this.border.getWidth() / 2.0f, (float)this.border.getWidth() / 2.0f);
    }

    /* synthetic */ AvatarDrawable(int n, int n2, Drawable drawable, float f, Volumetric volumetric, int n3, Border border, Placeholder placeholder, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = -16777216;
        }
        if ((n4 & 8) != 0) {
            f = 0.5f;
        }
        if ((n4 & 0x10) != 0) {
            volumetric = Volumetric.ALL;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        this(n, n2, drawable, f, volumetric, n3, border, placeholder);
    }

    private final float getTotalArchesDegreeArea() {
        return this.border.getArchesDegreeArea();
    }

    private final float getAnimationLoopDegrees() {
        return this.border.getArchesAngle();
    }

    private final float getIndividualArcDegreeLength() {
        return this.calculateArcDegreeLength();
    }

    private final float getSpaceBetweenArches() {
        return this.calculateSpaceBetweenArches();
    }

    private final float getCurrentAnimationArchesArea() {
        return this.animationArchesSparseness * this.getTotalArchesDegreeArea();
    }

    public AvatarDrawable(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this(builder.getSize(), builder.getBackgroundColor(), builder.getAvatarDrawable(), builder.getIconDrawableScale(), builder.getVolumetricType(), RangesKt.coerceAtMost((int)builder.getAvatarMargin(), (int)(builder.getSize() / 2)), builder.getBorder(), builder.getPlaceholder());
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.iconColorFilter = colorFilter;
        this.invalidateSelf();
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.iconColorFilter;
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NotNull Canvas canvas) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate((float)this.getBounds().left, (float)this.getBounds().top);
        boolean isIconDrawable = false;
        Drawable drawable = this.avatarDrawable;
        if (drawable instanceof BitmapDrawable) {
            isIconDrawable = false;
            int bitmapSize = this.size - this.avatarMargin;
            bitmap = ThumbnailUtils.extractThumbnail((Bitmap)((BitmapDrawable)this.avatarDrawable).getBitmap(), (int)bitmapSize, (int)bitmapSize);
        } else if (drawable instanceof Animatable) {
            isIconDrawable = false;
            bitmap = this.createAnimatableAvatarBitmap(this.avatarDrawable);
        } else if (drawable != null) {
            isIconDrawable = true;
            bitmap = this.createAvatarBitmap(this.avatarDrawable, this.iconDrawableScale);
        } else {
            bitmap = null;
        }
        Bitmap avatarBitmap = bitmap;
        this.bufferCanvas.drawCircle(this.circleCenter, this.circleCenter, this.backgroundCircleRadius, this.avatarBackgroundPaint);
        if (avatarBitmap == null) {
            this.drawPlaceholder();
        } else {
            this.drawBitmap(isIconDrawable, avatarBitmap);
        }
        this.drawVolume(avatarBitmap != null);
        this.drawBorder();
        canvas.drawBitmap(this.bufferBitmap, new Matrix(), null);
        canvas.restore();
    }

    private final Bitmap createAvatarBitmap(Drawable avatarDrawable, float scale) {
        Bitmap bitmap;
        Size sizeHelper = new Size(avatarDrawable.getIntrinsicWidth(), avatarDrawable.getIntrinsicHeight(), this.size, scale);
        int width = sizeHelper.getWidth();
        int height = sizeHelper.getHeight();
        if (width > 0 && height > 0) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap2;
            boolean bl3 = false;
            avatarDrawable.setBounds(0, 0, width, height);
            ColorFilter colorFilter = this.iconColorFilter;
            if (colorFilter != null) {
                ColorFilter colorFilter2 = colorFilter;
                boolean bl4 = false;
                boolean bl5 = false;
                ColorFilter filter = colorFilter2;
                boolean bl6 = false;
                avatarDrawable.setColorFilter(filter);
            }
            avatarDrawable.draw(new Canvas(it));
            bitmap = bitmap2;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap createAnimatableAvatarBitmap(Drawable avatarDrawable) {
        CenterCropDrawable cropDrawable = new CenterCropDrawable(avatarDrawable);
        Bitmap bitmap = Bitmap.createBitmap((int)this.size, (int)this.size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        boolean bl = false;
        boolean bl2 = false;
        Bitmap it = bitmap;
        boolean bl3 = false;
        cropDrawable.setBounds(0, 0, this.size, this.size);
        ColorFilter colorFilter = this.iconColorFilter;
        if (colorFilter != null) {
            ColorFilter colorFilter2 = colorFilter;
            boolean bl4 = false;
            boolean bl5 = false;
            ColorFilter filter = colorFilter2;
            boolean bl6 = false;
            cropDrawable.setColorFilter(filter);
        }
        cropDrawable.draw(new Canvas(it));
        return bitmap;
    }

    private final RectF calculateBounds() {
        int availableWidth = this.size;
        int availableHeight = this.size;
        int sideLength = RangesKt.coerceAtMost((int)availableWidth, (int)availableHeight);
        float left = (float)(availableWidth - sideLength) / 2.0f;
        float top = (float)(availableHeight - sideLength) / 2.0f;
        return new RectF(left, top, left + (float)sideLength, top + (float)sideLength);
    }

    private final void drawBorder() {
        if (this.border.getWidth() > 0) {
            if ((this.border.getArchesType() == 0 && this.border.getArchesCount() > 1 || this.border.getArchesType() == 1 && this.border.getArchesCount() > 0) && this.getTotalArchesDegreeArea() > 0.0f) {
                this.drawArcBorder();
            } else {
                this.drawCircleBorder();
            }
        }
    }

    private final void drawArcBorder() {
        Path path = new Path();
        float totalDegrees = (270.0f + this.getAnimationLoopDegrees()) % (float)360;
        float startSpace = this.getTotalArchesDegreeArea() == 360.0f || this.border.getArchesType() == 1 ? 0.0f : this.getIndividualArcDegreeLength();
        this.drawArches(path, totalDegrees + startSpace);
        if (this.border.getArchesType() == 1) {
            totalDegrees = (270.0f + (this.getAnimationLoopDegrees() + (float)180)) % (float)360;
            this.drawArches(path, totalDegrees + startSpace);
        } else {
            float startOfMainArch = totalDegrees + this.getCurrentAnimationArchesArea();
            path.addArc(this.arcBorderRect, startOfMainArch, 360.0f - this.getCurrentAnimationArchesArea());
        }
        this.bufferCanvas.drawPath(path, this.borderPaint);
    }

    private final void drawCircleBorder() {
        this.bufferCanvas.drawCircle(this.circleCenter, this.circleCenter, this.circleRadius - (float)this.border.getWidth() / 2.0f, this.borderPaint);
    }

    private final void drawArches(Path path, float totalDegrees) {
        int n = 0;
        int n2 = this.border.getArchesCount();
        if (n < n2) {
            do {
                int i = n++;
                float arcDeg = (this.getIndividualArcDegreeLength() + this.getSpaceBetweenArches()) * (float)i;
                float deg = totalDegrees + arcDeg;
                path.addArc(this.arcBorderRect, deg, this.getIndividualArcDegreeLength());
            } while (n < n2);
        }
    }

    private final void drawBitmap(boolean isIconDrawable, Bitmap avatarBitmap) {
        if (isIconDrawable) {
            float left = (float)(this.size - avatarBitmap.getWidth()) / 2.0f;
            float top = (float)(this.size - avatarBitmap.getHeight()) / 2.0f;
            this.bufferCanvas.drawBitmap(avatarBitmap, left, top, this.clipPaint);
        } else {
            this.bufferCanvas.drawBitmap(avatarBitmap, new Matrix(), this.clipPaint);
        }
    }

    private final void drawPlaceholder() {
        if (this.textLayout != null) {
            this.bufferCanvas.save();
            this.bufferCanvas.translate(((float)this.size - this.textWidth) / (float)2 - this.textLeft, ((float)this.size - this.textHeight) / (float)2);
            StaticLayout staticLayout = this.textLayout;
            if (staticLayout != null) {
                staticLayout.draw(this.bufferCanvas);
            }
            this.bufferCanvas.restore();
        }
    }

    private final void drawVolume(boolean isDrawable) {
        if (this.volumetricType == Volumetric.NONE) {
            return;
        }
        if (this.volumetricType == Volumetric.DRAWABLE && !isDrawable) {
            return;
        }
        if (this.volumetricType == Volumetric.PLACEHOLDER && isDrawable) {
            return;
        }
        this.bufferCanvas.drawCircle(this.circleCenter, this.circleCenter, this.backgroundCircleRadius, this.gradientPaint);
    }

    private final float calculateSpaceBetweenArches() {
        return (this.getTotalArchesDegreeArea() - (float)this.border.getArchesCount() * this.getIndividualArcDegreeLength()) / (float)(this.border.getArchesCount() + (this.getTotalArchesDegreeArea() == 360.0f ? 0 : 1));
    }

    private final float calculateArcDegreeLength() {
        return this.getTotalArchesDegreeArea() / (float)(this.border.getArchesType() == 0 ? this.border.getArchesCount() * 2 + 1 : this.border.getArchesCount());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Size;", "", "intrinsicWidth", "", "intrinsicHeight", "max", "scale", "", "(IIIF)V", "_height", "_width", "height", "getHeight", "()I", "width", "getWidth", "avatar-view_release"})
    public static final class Size {
        private final float scale;
        private final float _width;
        private final float _height;

        public Size(int intrinsicWidth, int intrinsicHeight, int max, float scale) {
            this.scale = scale;
            float maxF = max;
            float intrinsicHeightF = intrinsicHeight;
            float intrinsicWidthF = intrinsicWidth;
            float ratioOfWidth = intrinsicWidthF / maxF;
            float ratioOfHeight = intrinsicHeightF / maxF;
            float ratio = (float)intrinsicWidth / intrinsicHeightF;
            if (ratio > 1.0f) {
                this._width = maxF;
                this._height = (float)intrinsicHeight / ratioOfHeight / ratio;
            } else if (ratio < 1.0f) {
                this._width = (float)intrinsicWidth / ratioOfWidth * ratio;
                this._height = maxF;
            } else if (ratio == 1.0f) {
                this._width = maxF;
                this._height = maxF;
            } else {
                this._width = 0.0f;
                this._height = 0.0f;
            }
        }

        public final int getWidth() {
            return (int)(this._width * this.scale);
        }

        public final int getHeight() {
            return (int)(this._height * this.scale);
        }
    }

    @AvatarDrawableDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010$\u001a\u00020\bJ\u0017\u0010\f\u001a\u00020\u00002\n\b\u0001\u0010%\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010&J%\u0010\u000e\u001a\u00020\u00002\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(\u00a2\u0006\u0002\b+H\u0086\b\u00f8\u0001\u0000J\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0015\u001a\u00020\u00002\b\b\u0001\u0010/\u001a\u00020\u0014J%\u0010\u0018\u001a\u00020\u00002\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020*0(\u00a2\u0006\u0002\b+H\u0086\b\u00f8\u0001\u0000J\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0001\u0010\u001e\u001a\u00020\bJ\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020 R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u001e\u0010!\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00063"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Builder;", "", "()V", "<set-?>", "Landroid/graphics/drawable/Drawable;", "avatarDrawable", "getAvatarDrawable", "()Landroid/graphics/drawable/Drawable;", "", "avatarMargin", "getAvatarMargin", "()I", "backgroundColor", "getBackgroundColor", "border", "Lcom/goodayapps/widget/AvatarDrawable$Border;", "getBorder", "()Lcom/goodayapps/widget/AvatarDrawable$Border;", "setBorder", "(Lcom/goodayapps/widget/AvatarDrawable$Border;)V", "", "iconDrawableScale", "getIconDrawableScale", "()F", "placeholder", "Lcom/goodayapps/widget/AvatarDrawable$Placeholder;", "getPlaceholder", "()Lcom/goodayapps/widget/AvatarDrawable$Placeholder;", "setPlaceholder", "(Lcom/goodayapps/widget/AvatarDrawable$Placeholder;)V", "size", "getSize", "Lcom/goodayapps/widget/AvatarDrawable$Volumetric;", "volumetricType", "getVolumetricType", "()Lcom/goodayapps/widget/AvatarDrawable$Volumetric;", "margin", "color", "(Ljava/lang/Integer;)Lcom/goodayapps/widget/AvatarDrawable$Builder;", "body", "Lkotlin/Function1;", "Lcom/goodayapps/widget/AvatarDrawable$Border$Builder;", "", "Lkotlin/ExtensionFunctionType;", "build", "Lcom/goodayapps/widget/AvatarDrawable;", "drawable", "scale", "Lcom/goodayapps/widget/AvatarDrawable$Placeholder$Builder;", "volumetric", "type", "avatar-view_release"})
    public static final class Builder {
        @Dimension(unit=1)
        private int size;
        @Dimension(unit=1)
        private int avatarMargin;
        @ColorInt
        private int backgroundColor = Color.parseColor((String)"#4D4D7F");
        @Nullable
        private Drawable avatarDrawable;
        private float iconDrawableScale = 0.5f;
        @NotNull
        private Volumetric volumetricType = Volumetric.ALL;
        @NotNull
        private Border border = new Border(0, 0, 0, 0, 0, 0, 0, 0, 255, null);
        @NotNull
        private Placeholder placeholder = new Placeholder(null, 0, 0.0f, null, 15, null);

        public final int getSize() {
            return this.size;
        }

        public final int getAvatarMargin() {
            return this.avatarMargin;
        }

        public final int getBackgroundColor() {
            return this.backgroundColor;
        }

        @Nullable
        public final Drawable getAvatarDrawable() {
            return this.avatarDrawable;
        }

        public final float getIconDrawableScale() {
            return this.iconDrawableScale;
        }

        @NotNull
        public final Volumetric getVolumetricType() {
            return this.volumetricType;
        }

        @NotNull
        public final Border getBorder() {
            return this.border;
        }

        public final void setBorder(@NotNull Border border) {
            Intrinsics.checkNotNullParameter((Object)border, (String)"<set-?>");
            this.border = border;
        }

        @NotNull
        public final Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public final void setPlaceholder(@NotNull Placeholder placeholder) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"<set-?>");
            this.placeholder = placeholder;
        }

        @NotNull
        public final Builder drawable(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$drawable_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$drawable_u24lambda_u2d0.avatarDrawable = drawable;
            return builder;
        }

        @NotNull
        public final Builder iconDrawableScale(@FloatRange(from=0.0) float scale) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$iconDrawableScale_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$iconDrawableScale_u24lambda_u2d1.iconDrawableScale = scale;
            return builder;
        }

        @NotNull
        public final Builder size(@Dimension(unit=1) int size) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$size_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$size_u24lambda_u2d2.size = size;
            return builder;
        }

        @NotNull
        public final Builder avatarMargin(@Dimension(unit=1) int margin) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$avatarMargin_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$avatarMargin_u24lambda_u2d3.avatarMargin = margin;
            return builder;
        }

        @NotNull
        public final Builder volumetric(@NotNull Volumetric type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$volumetric_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            $this$volumetric_u24lambda_u2d4.volumetricType = type;
            return builder;
        }

        @NotNull
        public final Builder backgroundColor(@ColorInt @Nullable Integer color) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$backgroundColor_u24lambda_u2d5 = builder;
            boolean bl3 = false;
            Integer n = color;
            $this$backgroundColor_u24lambda_u2d5.backgroundColor = n == null ? $this$backgroundColor_u24lambda_u2d5.getBackgroundColor() : n.intValue();
            return builder;
        }

        @NotNull
        public final Builder border(@NotNull Function1<? super Border.Builder, Unit> body) {
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean $i$f$border = false;
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$border_u24lambda_u2d6 = builder;
            boolean bl3 = false;
            Border.Builder builder2 = new Border.Builder();
            boolean bl4 = false;
            boolean bl5 = false;
            body.invoke((Object)builder2);
            $this$border_u24lambda_u2d6.setBorder(builder2.build());
            return builder;
        }

        @NotNull
        public final Builder placeholder(@NotNull Function1<? super Placeholder.Builder, Unit> body) {
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean $i$f$placeholder = false;
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$placeholder_u24lambda_u2d7 = builder;
            boolean bl3 = false;
            Placeholder.Builder builder2 = new Placeholder.Builder();
            boolean bl4 = false;
            boolean bl5 = false;
            body.invoke((Object)builder2);
            $this$placeholder_u24lambda_u2d7.setPlaceholder(builder2.build());
            return builder;
        }

        @NotNull
        public final AvatarDrawable build() {
            return new AvatarDrawable(this);
        }
    }

    @AvatarDrawableDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016BU\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Border;", "", "width", "", "color", "colorSecondary", "gradientAngle", "archesCount", "archesDegreeArea", "archesAngle", "archesType", "(IIIIIIII)V", "getArchesAngle", "()I", "getArchesCount", "getArchesDegreeArea", "getArchesType", "getColor", "getColorSecondary", "getGradientAngle", "getWidth", "Builder", "Companion", "avatar-view_release"})
    public static final class Border {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int width;
        private final int color;
        private final int colorSecondary;
        private final int gradientAngle;
        private final int archesCount;
        private final int archesDegreeArea;
        private final int archesAngle;
        private final int archesType;
        public static final int ARCH_TYPE_DEFAULT = 0;
        public static final int ARCH_TYPE_MIRROR = 1;

        public Border(@Dimension(unit=1) int width, @ColorInt int color, @ColorInt int colorSecondary, int gradientAngle, int archesCount, int archesDegreeArea, int archesAngle, int archesType) {
            this.width = width;
            this.color = color;
            this.colorSecondary = colorSecondary;
            this.gradientAngle = gradientAngle;
            this.archesCount = archesCount;
            this.archesDegreeArea = archesDegreeArea;
            this.archesAngle = archesAngle;
            this.archesType = archesType;
        }

        public /* synthetic */ Border(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n9 & 1) != 0) {
                n = 0;
            }
            if ((n9 & 2) != 0) {
                n2 = Color.parseColor((String)"#4D8989A8");
            }
            if ((n9 & 4) != 0) {
                n3 = n2;
            }
            if ((n9 & 8) != 0) {
                n4 = 0;
            }
            if ((n9 & 0x10) != 0) {
                n5 = 0;
            }
            if ((n9 & 0x20) != 0) {
                n6 = 0;
            }
            if ((n9 & 0x40) != 0) {
                n7 = 0;
            }
            if ((n9 & 0x80) != 0) {
                n8 = 0;
            }
            this(n, n2, n3, n4, n5, n6, n7, n8);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getColor() {
            return this.color;
        }

        public final int getColorSecondary() {
            return this.colorSecondary;
        }

        public final int getGradientAngle() {
            return this.gradientAngle;
        }

        public final int getArchesCount() {
            return this.archesCount;
        }

        public final int getArchesDegreeArea() {
            return this.archesDegreeArea;
        }

        public final int getArchesAngle() {
            return this.archesAngle;
        }

        public final int getArchesType() {
            return this.archesType;
        }

        public Border() {
            this(0, 0, 0, 0, 0, 0, 0, 0, 255, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Border$Companion;", "", "()V", "ARCH_TYPE_DEFAULT", "", "ARCH_TYPE_MIRROR", "avatar-view_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @AvatarDrawableDsl
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u00002\b\b\u0001\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\f\u001a\u00020\u00002\b\b\u0001\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0017\u0010\u000e\u001a\u00020\u00002\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u0010\u001a\u00020\u00002\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\u0018\u001a\u00020\u0004J\u0017\u0010\u0016\u001a\u00020\u00002\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001dR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R&\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@BX\u0087\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Border$Builder;", "", "()V", "<set-?>", "", "archesAngle", "getArchesAngle", "()I", "archesCount", "getArchesCount", "archesDegreeArea", "getArchesDegreeArea", "archesType", "getArchesType", "color", "getColor", "colorSecondary", "getColorSecondary", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "gradientAngle", "getGradientAngle", "width", "getWidth", "angle", "count", "type", "build", "Lcom/goodayapps/widget/AvatarDrawable$Border;", "(Ljava/lang/Integer;)Lcom/goodayapps/widget/AvatarDrawable$Border$Builder;", "avatar-view_release"})
        public static final class Builder {
            @Dimension(unit=1)
            private int width;
            @ColorInt
            private int color = Color.parseColor((String)"#4D8989A8");
            @ColorInt
            @Nullable
            private Integer colorSecondary;
            private int gradientAngle;
            private int archesCount;
            private int archesDegreeArea;
            private int archesAngle;
            private int archesType;

            public final int getWidth() {
                return this.width;
            }

            public final int getColor() {
                return this.color;
            }

            @Nullable
            public final Integer getColorSecondary() {
                return this.colorSecondary;
            }

            public final int getGradientAngle() {
                return this.gradientAngle;
            }

            public final int getArchesCount() {
                return this.archesCount;
            }

            public final int getArchesDegreeArea() {
                return this.archesDegreeArea;
            }

            public final int getArchesAngle() {
                return this.archesAngle;
            }

            public final int getArchesType() {
                return this.archesType;
            }

            @NotNull
            public final Builder color(@ColorInt @Nullable Integer color) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$color_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                Integer n = color;
                $this$color_u24lambda_u2d0.color = n == null ? $this$color_u24lambda_u2d0.getColor() : n.intValue();
                return builder;
            }

            @NotNull
            public final Builder colorSecondary(@ColorInt @Nullable Integer color) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$colorSecondary_u24lambda_u2d1 = builder;
                boolean bl3 = false;
                Integer n = color;
                $this$colorSecondary_u24lambda_u2d1.colorSecondary = n == null ? Integer.valueOf($this$colorSecondary_u24lambda_u2d1.getColor()) : n;
                return builder;
            }

            @NotNull
            public final Builder archesCount(int count) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$archesCount_u24lambda_u2d2 = builder;
                boolean bl3 = false;
                $this$archesCount_u24lambda_u2d2.archesCount = count;
                return builder;
            }

            @NotNull
            public final Builder archesDegreeArea(@IntRange(from=0L, to=360L) int angle) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$archesDegreeArea_u24lambda_u2d3 = builder;
                boolean bl3 = false;
                $this$archesDegreeArea_u24lambda_u2d3.archesDegreeArea = angle;
                return builder;
            }

            @NotNull
            public final Builder archesAngle(@IntRange(from=0L, to=360L) int angle) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$archesAngle_u24lambda_u2d4 = builder;
                boolean bl3 = false;
                $this$archesAngle_u24lambda_u2d4.archesAngle = angle;
                return builder;
            }

            @NotNull
            public final Builder archesType(@IntRange(from=0L, to=2L) int type) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$archesType_u24lambda_u2d5 = builder;
                boolean bl3 = false;
                $this$archesType_u24lambda_u2d5.archesType = type;
                return builder;
            }

            @NotNull
            public final Builder width(@Dimension(unit=1) @Nullable Integer width) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$width_u24lambda_u2d6 = builder;
                boolean bl3 = false;
                Integer n = width;
                $this$width_u24lambda_u2d6.width = n == null ? 0 : n;
                return builder;
            }

            @NotNull
            public final Builder gradientAngle(@IntRange(from=0L, to=360L) int angle) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$gradientAngle_u24lambda_u2d7 = builder;
                boolean bl3 = false;
                $this$gradientAngle_u24lambda_u2d7.gradientAngle = angle;
                return builder;
            }

            @NotNull
            public final Border build() {
                Integer n = this.colorSecondary;
                return new Border(this.width, this.color, n == null ? this.color : n, this.gradientAngle, this.archesCount, this.archesDegreeArea, this.archesAngle, this.archesType);
            }
        }
    }

    @AvatarDrawableDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB1\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Placeholder;", "", "text", "", "textColor", "", "textSize", "", "typeface", "Landroid/graphics/Typeface;", "(Ljava/lang/CharSequence;IFLandroid/graphics/Typeface;)V", "getText", "()Ljava/lang/CharSequence;", "setText", "(Ljava/lang/CharSequence;)V", "getTextColor", "()I", "setTextColor", "(I)V", "getTextSize", "()F", "setTextSize", "(F)V", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "Builder", "avatar-view_release"})
    public static final class Placeholder {
        @Nullable
        private CharSequence text;
        private int textColor;
        private float textSize;
        @Nullable
        private Typeface typeface;

        public Placeholder(@Nullable CharSequence text, @ColorInt int textColor, @Dimension(unit=1) float textSize, @Nullable Typeface typeface) {
            this.text = text;
            this.textColor = textColor;
            this.textSize = textSize;
            this.typeface = typeface;
        }

        public /* synthetic */ Placeholder(CharSequence charSequence, int n, float f, Typeface typeface, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                charSequence = "?";
            }
            if ((n2 & 2) != 0) {
                n = -1;
            }
            if ((n2 & 4) != 0) {
                f = 30.0f;
            }
            if ((n2 & 8) != 0) {
                typeface = null;
            }
            this(charSequence, n, f, typeface);
        }

        @Nullable
        public final CharSequence getText() {
            return this.text;
        }

        public final void setText(@Nullable CharSequence charSequence) {
            this.text = charSequence;
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(int n) {
            this.textColor = n;
        }

        public final float getTextSize() {
            return this.textSize;
        }

        public final void setTextSize(float f) {
            this.textSize = f;
        }

        @Nullable
        public final Typeface getTypeface() {
            return this.typeface;
        }

        public final void setTypeface(@Nullable Typeface typeface) {
            this.typeface = typeface;
        }

        public Placeholder() {
            this(null, 0, 0.0f, null, 15, null);
        }

        @AvatarDrawableDsl
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0017\u0010\u0005\u001a\u00020\u00002\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\t\u001a\u00020\u00002\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Placeholder$Builder;", "", "()V", "<set-?>", "", "color", "getColor", "()I", "", "size", "getSize", "()F", "", "text", "getText", "()Ljava/lang/CharSequence;", "Landroid/graphics/Typeface;", "typeface", "getTypeface", "()Landroid/graphics/Typeface;", "build", "Lcom/goodayapps/widget/AvatarDrawable$Placeholder;", "(Ljava/lang/Integer;)Lcom/goodayapps/widget/AvatarDrawable$Placeholder$Builder;", "(Ljava/lang/Float;)Lcom/goodayapps/widget/AvatarDrawable$Placeholder$Builder;", "avatar-view_release"})
        public static final class Builder {
            @Nullable
            private CharSequence text = "?";
            @ColorInt
            private int color = -1;
            @Dimension(unit=1)
            private float size = 30.0f;
            @Nullable
            private Typeface typeface;

            @Nullable
            public final CharSequence getText() {
                return this.text;
            }

            public final int getColor() {
                return this.color;
            }

            public final float getSize() {
                return this.size;
            }

            @Nullable
            public final Typeface getTypeface() {
                return this.typeface;
            }

            @NotNull
            public final Builder text(@Nullable CharSequence text) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$text_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                CharSequence charSequence = text;
                $this$text_u24lambda_u2d0.text = charSequence == null ? (CharSequence)"?" : charSequence;
                return builder;
            }

            @NotNull
            public final Builder color(@ColorInt @Nullable Integer color) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$color_u24lambda_u2d1 = builder;
                boolean bl3 = false;
                Integer n = color;
                $this$color_u24lambda_u2d1.color = n == null ? $this$color_u24lambda_u2d1.getColor() : n.intValue();
                return builder;
            }

            @NotNull
            public final Builder size(@Dimension(unit=1) @Nullable Float size) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$size_u24lambda_u2d2 = builder;
                boolean bl3 = false;
                Float f = size;
                $this$size_u24lambda_u2d2.size = f == null ? 0.0f : f.floatValue();
                return builder;
            }

            @NotNull
            public final Builder typeface(@Nullable Typeface typeface) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$typeface_u24lambda_u2d3 = builder;
                boolean bl3 = false;
                $this$typeface_u24lambda_u2d3.typeface = typeface;
                return builder;
            }

            @NotNull
            public final Placeholder build() {
                return new Placeholder(this.text, this.color, this.size, this.typeface);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Volumetric;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "NONE", "ALL", "DRAWABLE", "PLACEHOLDER", "Companion", "avatar-view_release"})
    public static final class Volumetric
    extends Enum<Volumetric> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        public static final /* enum */ Volumetric NONE;
        public static final /* enum */ Volumetric ALL;
        public static final /* enum */ Volumetric DRAWABLE;
        public static final /* enum */ Volumetric PLACEHOLDER;
        private static final /* synthetic */ Volumetric[] $VALUES;

        private Volumetric(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static Volumetric[] values() {
            return (Volumetric[])$VALUES.clone();
        }

        public static Volumetric valueOf(String value) {
            return Enum.valueOf(Volumetric.class, value);
        }

        static {
            NONE = new Volumetric(-1);
            ALL = new Volumetric(0);
            DRAWABLE = new Volumetric(1);
            PLACEHOLDER = new Volumetric(2);
            $VALUES = volumetricArray = new Volumetric[]{Volumetric.NONE, Volumetric.ALL, Volumetric.DRAWABLE, Volumetric.PLACEHOLDER};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/goodayapps/widget/AvatarDrawable$Volumetric$Companion;", "", "()V", "from", "Lcom/goodayapps/widget/AvatarDrawable$Volumetric;", "value", "", "avatar-view_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Volumetric from(int value) {
                Volumetric volumetric;
                block1: {
                    Volumetric[] $this$firstOrNull$iv = Volumetric.values();
                    boolean $i$f$firstOrNull = false;
                    Volumetric[] volumetricArray = $this$firstOrNull$iv;
                    int n = volumetricArray.length;
                    for (int i = 0; i < n; ++i) {
                        Volumetric element$iv;
                        Volumetric it = element$iv = volumetricArray[i];
                        boolean bl = false;
                        if (!(it.getValue() == value)) continue;
                        volumetric = element$iv;
                        break block1;
                    }
                    volumetric = null;
                }
                Volumetric volumetric2 = volumetric;
                return volumetric2 == null ? NONE : volumetric2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

