/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api;

import android.content.Context;
import android.util.Log;
import com.gapps.library.api.models.api.base.VideoInfoModel;
import com.gapps.library.api.models.api.builder.EmbeddingRequest;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.api.models.video.base.BaseVideoResponse;
import com.gapps.library.cache.VideoModelORMKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002Ji\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00180\u001c26\u0010!\u001a2\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b($\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180\"J.\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010$\u001a\u00020#2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/gapps/library/api/VideoLoadHelper;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Landroid/content/Context;", "client", "Lokhttp3/OkHttpClient;", "isCacheEnabled", "", "isLogEnabled", "(Landroid/content/Context;Lokhttp3/OkHttpClient;ZZ)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "fromJson", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "json", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "getVideoInfo", "", "requestModel", "Lcom/gapps/library/api/models/api/builder/EmbeddingRequest;", "onSuccess", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "Lkotlin/ParameterName;", "name", "resultModel", "onError", "Lkotlin/Function2;", "", "url", "message", "makeCallGetBody", "headers", "", "embedded_video_lib_release"})
public final class VideoLoadHelper
implements CoroutineScope {
    @Nullable
    private final Context context;
    @NotNull
    private final OkHttpClient client;
    private final boolean isCacheEnabled;
    private final boolean isLogEnabled;
    private final Gson gson;

    public VideoLoadHelper(@Nullable Context context, @NotNull OkHttpClient client, boolean isCacheEnabled, boolean isLogEnabled) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.context = context;
        this.client = client;
        this.isCacheEnabled = isCacheEnabled;
        this.isLogEnabled = isLogEnabled;
        this.gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain());
    }

    public final void getVideoInfo(@NotNull EmbeddingRequest requestModel, @NotNull Function1<? super VideoPreviewModel, Unit> onSuccess, @NotNull Function2<? super String, ? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)requestModel, (String)"requestModel");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        VideoInfoModel<?> videoInfoModel = requestModel.getVideoInfoModel();
        String originalUrl = requestModel.getOriginalUrl();
        Map<String, String> headers = requestModel.getRequestHeaders();
        if (videoInfoModel == null) {
            onError.invoke((Object)originalUrl, (Object)"Err 1. Unknown video service. \nPlease, visit https://github.com/TalbotGooday/Android-Oembed-Video for more information about available services");
            return;
        }
        String finalUrl = videoInfoModel.getInfoUrl(originalUrl);
        String videoId = videoInfoModel.parseVideoId(originalUrl);
        if (finalUrl == null || videoId == null) {
            onError.invoke((Object)originalUrl, (Object)"Err 3. Can't get oEmbed url");
            return;
        }
        String playLink = videoInfoModel.getPlayLink(videoId);
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, playLink, onSuccess, originalUrl, onError, videoInfoModel, videoId, finalUrl, headers, null){
            int label;
            final /* synthetic */ VideoLoadHelper this$0;
            final /* synthetic */ String $playLink;
            final /* synthetic */ Function1<VideoPreviewModel, Unit> $onSuccess;
            final /* synthetic */ String $originalUrl;
            final /* synthetic */ Function2<String, String, Unit> $onError;
            final /* synthetic */ VideoInfoModel<?> $videoInfoModel;
            final /* synthetic */ String $videoId;
            final /* synthetic */ String $finalUrl;
            final /* synthetic */ Map<String, String> $headers;
            {
                this.this$0 = $receiver;
                this.$playLink = $playLink;
                this.$onSuccess = $onSuccess;
                this.$originalUrl = $originalUrl;
                this.$onError = $onError;
                this.$videoInfoModel = $videoInfoModel;
                this.$videoId = $videoId;
                this.$finalUrl = $finalUrl;
                this.$headers = $headers;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!VideoLoadHelper.access$isCacheEnabled$p(this.this$0) || VideoLoadHelper.access$getContext$p(this.this$0) == null) ** GOTO lbl22
                        this.label = 1;
                        v0 = VideoModelORMKt.getCachedVideoModel(VideoLoadHelper.access$getContext$p(this.this$0), this.$playLink, (Continuation<? super VideoPreviewModel>)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl12
lbl11:
                        // 1 sources

                        return var5_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if ((model = (VideoPreviewModel)v0) != null) {
                            this.$onSuccess.invoke((Object)model);
                            return Unit.INSTANCE;
                        }
lbl22:
                        // 3 sources

                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonElement>, Object>(this.this$0, this.$finalUrl, this.$headers, null){
                            int label;
                            final /* synthetic */ VideoLoadHelper this$0;
                            final /* synthetic */ String $finalUrl;
                            final /* synthetic */ Map<String, String> $headers;
                            {
                                this.this$0 = $receiver;
                                this.$finalUrl = $finalUrl;
                                this.$headers = $headers;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return VideoLoadHelper.access$makeCallGetBody(this.this$0, VideoLoadHelper.access$getClient$p(this.this$0), this.$finalUrl, this.$headers);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super JsonElement> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl26
lbl25:
                        // 1 sources

                        return var5_2;
lbl26:
                        // 1 sources

                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        jsonBody = (JsonElement)v1;
                        if (VideoLoadHelper.access$isLogEnabled$p(this.this$0)) {
                            Log.i((String)"VideoService", (String)("a response from " + this.$originalUrl + ":\n" + VideoLoadHelper.access$getGson$p(this.this$0).toJson(jsonBody)));
                        }
                        if (jsonBody == null) {
                            this.$onError.invoke((Object)this.$originalUrl, (Object)"Err 2. Can't parse response \n---> Response is null");
                            return Unit.INSTANCE;
                        }
                        result = VideoLoadHelper.access$fromJson(this.this$0, jsonBody, this.$videoInfoModel.getType()).toPreview(this.$originalUrl, this.$playLink, this.$videoInfoModel.getHostingName(), this.$videoId);
                        this.$onSuccess.invoke((Object)result);
                        if (VideoLoadHelper.access$getContext$p(this.this$0) == null || !VideoLoadHelper.access$isCacheEnabled$p(this.this$0)) ** GOTO lbl65
                        this.label = 3;
                        v2 = VideoModelORMKt.insertModel(VideoLoadHelper.access$getContext$p(this.this$0), result, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v2 != var5_2) goto lbl50
lbl49:
                        // 1 sources

                        return var5_2;
lbl50:
                        // 1 sources

                        ** GOTO lbl65
                    }
                    case 3: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            {
                                catch (Exception e) {
                                    this.$onError.invoke((Object)this.$originalUrl, (Object)("Err 2. Can't parse response\n---> " + e.getLocalizedMessage()));
                                }
                            }
                        }
                        catch (Exception var2_4) {
                            this.$onError.invoke((Object)this.$originalUrl, (Object)"Err 3. Can't get oEmbed url");
                        }
lbl65:
                        // 5 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final JsonElement makeCallGetBody(OkHttpClient client, String url, Map<String, String> headers) {
        return (JsonElement)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonElement>, Object>(url, headers, client, null){
            int label;
            final /* synthetic */ String $url;
            final /* synthetic */ Map<String, String> $headers;
            final /* synthetic */ OkHttpClient $client;
            {
                this.$url = $url;
                this.$headers = $headers;
                this.$client = $client;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Request.Builder requestBuilder = new Request.Builder().url(this.$url);
                        Iterable $this$forEach$iv = this.$headers.entrySet();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry header = (Map.Entry)element$iv;
                            boolean bl = false;
                            requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
                        }
                        Response response = this.$client.newCall(requestBuilder.build()).execute();
                        Object object2 = response.body();
                        if (object2 == null || (object2 = object2.string()) == null) {
                            return null;
                        }
                        Object stringBody = object2;
                        JsonElement jsonObject = JsonParser.parseString((String)stringBody);
                        return jsonObject.isJsonArray() ? jsonObject.getAsJsonArray().get(0) : jsonObject;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super JsonElement> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final BaseVideoResponse fromJson(JsonElement json, Type type) {
        Object object = this.gson.fromJson(json, type);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (BaseVideoResponse)object;
    }

    public static final /* synthetic */ boolean access$isCacheEnabled$p(VideoLoadHelper $this) {
        return $this.isCacheEnabled;
    }

    public static final /* synthetic */ Context access$getContext$p(VideoLoadHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ JsonElement access$makeCallGetBody(VideoLoadHelper $this, OkHttpClient client, String url, Map headers) {
        return $this.makeCallGetBody(client, url, headers);
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(VideoLoadHelper $this) {
        return $this.client;
    }

    public static final /* synthetic */ boolean access$isLogEnabled$p(VideoLoadHelper $this) {
        return $this.isLogEnabled;
    }

    public static final /* synthetic */ Gson access$getGson$p(VideoLoadHelper $this) {
        return $this.gson;
    }

    public static final /* synthetic */ BaseVideoResponse access$fromJson(VideoLoadHelper $this, JsonElement json, Type type) {
        return $this.fromJson(json, type);
    }
}

