/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.cache;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.cache.DatabaseWrapper;
import com.gapps.library.utils.MD5Kt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u001a\u0018\u0010\"\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u0019\u001a\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"COLUMN_HEIGHT", "", "COLUMN_HEIGHT_TYPE", "COLUMN_ID", "COLUMN_ID_TYPE", "COLUMN_PLAY_LINK", "COLUMN_PLAY_LINK_TYPE", "COLUMN_THUMBNAIL", "COLUMN_THUMBNAIL_TYPE", "COLUMN_TITLE", "COLUMN_TITLE_TYPE", "COLUMN_URL", "COLUMN_URL_TYPE", "COLUMN_VIDEO_HOSTING", "COLUMN_VIDEO_HOSTING_TYPE", "COLUMN_VIDEO_ID", "COLUMN_VIDEO_ID_TYPE", "COLUMN_WIDTH", "COLUMN_WIDTH_TYPE", "COMMA_SEP", "SQL_CREATE_TABLE", "SQL_DROP_TABLE", "TABLE_NAME", "TAG", "cursorToPost", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "cursor", "Landroid/database/Cursor;", "getCachedVideoModel", "context", "Landroid/content/Context;", "linkToPlay", "getCachedVideoModels", "", "insertModel", "", "post", "modelToContentValues", "Landroid/content/ContentValues;", "videoModel", "library_release"})
public final class VideoModelORMKt {
    private static final String TAG = "VideoServiceORM";
    private static final String TABLE_NAME = "video_model";
    private static final String COMMA_SEP = ", ";
    private static final String COLUMN_VIDEO_ID_TYPE = "TEXT PRIMARY KEY";
    private static final String COLUMN_VIDEO_ID = "video_id";
    private static final String COLUMN_ID_TYPE = "TEXT";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_URL_TYPE = "TEXT";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_TITLE_TYPE = "TEXT";
    private static final String COLUMN_TITLE = "title";
    private static final String COLUMN_THUMBNAIL_TYPE = "TEXT";
    private static final String COLUMN_THUMBNAIL = "thumbnail";
    private static final String COLUMN_VIDEO_HOSTING_TYPE = "TEXT";
    private static final String COLUMN_VIDEO_HOSTING = "video_hosting";
    private static final String COLUMN_PLAY_LINK_TYPE = "TEXT";
    private static final String COLUMN_PLAY_LINK = "play_link";
    private static final String COLUMN_WIDTH_TYPE = "INTEGER";
    private static final String COLUMN_WIDTH = "width";
    private static final String COLUMN_HEIGHT_TYPE = "INTEGER";
    private static final String COLUMN_HEIGHT = "height";
    @NotNull
    public static final String SQL_CREATE_TABLE = "CREATE TABLE video_model (video_id TEXT PRIMARY KEY, url TEXT, id TEXT, title TEXT, thumbnail TEXT, video_hosting TEXT, play_link TEXT, width INTEGER, height INTEGER)";
    @NotNull
    public static final String SQL_DROP_TABLE = "DROP TABLE IF EXISTS video_model";

    public static final void insertModel(@Nullable Context context, @NotNull VideoPreviewModel post) {
        Intrinsics.checkParameterIsNotNull((Object)post, (String)"post");
        DatabaseWrapper databaseWrapper = new DatabaseWrapper(context);
        SQLiteDatabase database = databaseWrapper.getWritableDatabase();
        ContentValues values = VideoModelORMKt.modelToContentValues(post);
        long modelId = database.replace(TABLE_NAME, "null", values);
        Log.i((String)TAG, (String)("Inserted new VideoPreviewModel with ID: " + modelId));
        database.close();
    }

    private static final ContentValues modelToContentValues(VideoPreviewModel videoModel) {
        ContentValues values = new ContentValues();
        String string = videoModel.getLinkToPlay();
        if (string == null) {
            string = "";
        }
        String hash = MD5Kt.toMD5(string);
        values.put(COLUMN_ID, hash);
        values.put(COLUMN_URL, videoModel.getUrl());
        values.put(COLUMN_TITLE, videoModel.getVideoTitle());
        values.put(COLUMN_THUMBNAIL, videoModel.getThumbnailUrl());
        values.put(COLUMN_VIDEO_HOSTING, videoModel.getVideoHosting());
        values.put(COLUMN_VIDEO_ID, videoModel.getVideoId());
        values.put(COLUMN_PLAY_LINK, videoModel.getLinkToPlay());
        values.put(COLUMN_WIDTH, Integer.valueOf(videoModel.getWidth()));
        values.put(COLUMN_HEIGHT, Integer.valueOf(videoModel.getHeight()));
        return values;
    }

    @Nullable
    public static final VideoPreviewModel getCachedVideoModel(@Nullable Context context, @NotNull String linkToPlay) {
        Intrinsics.checkParameterIsNotNull((Object)linkToPlay, (String)"linkToPlay");
        DatabaseWrapper databaseWrapper = new DatabaseWrapper(context);
        SQLiteDatabase database = databaseWrapper.getReadableDatabase();
        Cursor cursor = database.rawQuery("SELECT * FROM video_model WHERE id='" + MD5Kt.toMD5(linkToPlay) + "' " + "LIMIT 1", null);
        VideoPreviewModel model2 = null;
        Cursor cursor2 = cursor;
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
        if (cursor2.getCount() > 0) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                model2 = VideoModelORMKt.cursorToPost(cursor);
                cursor.moveToNext();
            }
            Log.i((String)TAG, (String)"VideoModel loaded successfully.");
        }
        database.close();
        return model2;
    }

    @NotNull
    public static final List<VideoPreviewModel> getCachedVideoModels(@Nullable Context context) {
        DatabaseWrapper databaseWrapper = new DatabaseWrapper(context);
        SQLiteDatabase database = databaseWrapper.getReadableDatabase();
        Cursor cursor = database.rawQuery("SELECT * FROM video_model", null);
        StringBuilder stringBuilder = new StringBuilder().append("Loaded ");
        Cursor cursor2 = cursor;
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
        Log.i((String)TAG, (String)stringBuilder.append(cursor2.getCount()).append(" VideoModels...").toString());
        List postList = new ArrayList();
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                VideoPreviewModel post = VideoModelORMKt.cursorToPost(cursor);
                postList.add(post);
                cursor.moveToNext();
            }
            Log.i((String)TAG, (String)"VideoModels loaded successfully.");
        }
        database.close();
        return postList;
    }

    private static final VideoPreviewModel cursorToPost(Cursor cursor) {
        VideoPreviewModel post = new VideoPreviewModel();
        post.setUrl(cursor.getString(cursor.getColumnIndex(COLUMN_URL)));
        post.setVideoTitle(cursor.getString(cursor.getColumnIndex(COLUMN_TITLE)));
        post.setThumbnailUrl(cursor.getString(cursor.getColumnIndex(COLUMN_THUMBNAIL)));
        post.setVideoHosting(cursor.getString(cursor.getColumnIndex(COLUMN_VIDEO_HOSTING)));
        post.setVideoId(cursor.getString(cursor.getColumnIndex(COLUMN_VIDEO_ID)));
        post.setLinkToPlay(cursor.getString(cursor.getColumnIndex(COLUMN_PLAY_LINK)));
        post.setWidth(cursor.getInt(cursor.getColumnIndex(COLUMN_WIDTH)));
        post.setHeight(cursor.getInt(cursor.getColumnIndex(COLUMN_HEIGHT)));
        return post;
    }
}

