/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api;

import android.content.Context;
import android.util.Log;
import com.gapps.library.api.VideoLoadHelper;
import com.gapps.library.api.models.api.CoubVideoInfoModel;
import com.gapps.library.api.models.api.DailymotionVideoInfoModel;
import com.gapps.library.api.models.api.FacebookVideoInfoModel;
import com.gapps.library.api.models.api.HuluVideoInfoModel;
import com.gapps.library.api.models.api.RutubeVideoInfoModel;
import com.gapps.library.api.models.api.TedTalksVideoInfoModel;
import com.gapps.library.api.models.api.UltimediaVideoInfoModel;
import com.gapps.library.api.models.api.UstreamVideoInfoModel;
import com.gapps.library.api.models.api.VimeoVideoInfoModel;
import com.gapps.library.api.models.api.VzaarVideoInfoModel;
import com.gapps.library.api.models.api.WistiaVideoInfoModel;
import com.gapps.library.api.models.api.YoutubeMusicVideoInfoModel;
import com.gapps.library.api.models.api.YoutubeVideoInfoModel;
import com.gapps.library.api.models.api.base.VideoInfoModel;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.api.models.video.base.BaseVideoResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B=\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e0\r\u00a2\u0006\u0002\u0010\u0010J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u00192\u001c\b\u0002\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001cR\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/gapps/library/api/VideoService;", "", "builder", "Lcom/gapps/library/api/VideoService$Builder;", "(Lcom/gapps/library/api/VideoService$Builder;)V", "context", "Landroid/content/Context;", "client", "Lokhttp3/OkHttpClient;", "isCacheEnabled", "", "isLogEnabled", "customModels", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "(Landroid/content/Context;Lokhttp3/OkHttpClient;ZZLjava/util/List;)V", "()Z", "videoHelper", "Lcom/gapps/library/api/VideoLoadHelper;", "loadVideoPreview", "", "url", "", "onSuccess", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "onError", "Lkotlin/Function2;", "Builder", "Companion", "library_release"})
public final class VideoService {
    private final VideoLoadHelper videoHelper;
    private final boolean isLogEnabled;
    private final List<VideoInfoModel<? extends BaseVideoResponse>> customModels;
    @NotNull
    public static final String TAG = "VideoService";
    @NotNull
    private static final List<VideoInfoModel<? extends BaseVideoResponse>> videoInfoModelsList;
    public static final Companion Companion;

    public final void loadVideoPreview(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> onSuccess, @Nullable Function2<? super String, ? super String, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        if (this.isLogEnabled) {
            Log.i((String)TAG, (String)("loading url: " + url));
        }
        Function1 callback2 = (Function1)new Function1<VideoPreviewModel, Unit>(onSuccess){
            final /* synthetic */ Function1 $onSuccess;

            public final void invoke(@NotNull VideoPreviewModel model2) {
                Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
                this.$onSuccess.invoke((Object)model2);
            }
            {
                this.$onSuccess = function1;
                super(1);
            }
        };
        Function2 callbackError2 = (Function2)new Function2<String, String, Unit>(onError){
            final /* synthetic */ Function2 $onError;

            public final void invoke(@NotNull String requestUrl, @NotNull String error) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)requestUrl, (String)"requestUrl");
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    Function2 function2 = this.$onError;
                    if (function2 == null) break block0;
                    Function2 function22 = function2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Function2 $this$run = function22;
                    boolean bl3 = false;
                    $this$run.invoke((Object)requestUrl, (Object)error);
                }
            }
            {
                this.$onError = function2;
                super(2);
            }
        };
        try {
            Iterable $this$forEach$iv = videoInfoModelsList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VideoInfoModel it = (VideoInfoModel)element$iv;
                boolean bl = false;
                if (!it.checkHostAffiliation(url)) continue;
                this.videoHelper.getVideoInfo(url, it, (Function1<? super VideoPreviewModel, Unit>)callback2, (Function2<? super String, ? super String, Unit>)callbackError2);
                return;
            }
        }
        catch (Exception e) {
            callbackError2.invoke((Object)url, (Object)"Err 1. Unknown video service. \nPlease, visit https://github.com/TalbotGooday/Android-Oembed-Video for more information about available services");
        }
    }

    public static /* synthetic */ void loadVideoPreview$default(VideoService videoService, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        videoService.loadVideoPreview(string, (Function1<? super VideoPreviewModel, Unit>)function1, (Function2<? super String, ? super String, Unit>)function2);
    }

    public final boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public VideoService(@Nullable Context context, @NotNull OkHttpClient client, boolean isCacheEnabled, boolean isLogEnabled, @NotNull List<? extends VideoInfoModel<? extends BaseVideoResponse>> customModels) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(customModels, (String)"customModels");
        this.isLogEnabled = isLogEnabled;
        this.customModels = customModels;
        this.videoHelper = new VideoLoadHelper(context, client, isCacheEnabled, this.isLogEnabled);
    }

    public VideoService(@NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this(builder.getContext(), builder.getOkHttpClient(), builder.isCacheEnabled(), builder.isLogEnabled(), builder.getCustomModels());
        Iterable $this$forEach$iv = this.customModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoInfoModel custom = (VideoInfoModel)element$iv;
            boolean bl = false;
            CollectionsKt.removeAll(videoInfoModelsList, (Function1)((Function1)new Function1<VideoInfoModel<? extends BaseVideoResponse>, Boolean>(custom){
                final /* synthetic */ VideoInfoModel $custom;

                public final boolean invoke(@NotNull VideoInfoModel<? extends BaseVideoResponse> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getHostingName(), (Object)this.$custom.getHostingName());
                }
                {
                    this.$custom = videoInfoModel;
                    super(1);
                }
            }));
        }
        videoInfoModelsList.addAll((Collection<VideoInfoModel<? extends BaseVideoResponse>>)this.customModels);
    }

    static {
        Companion = new Companion(null);
        videoInfoModelsList = CollectionsKt.mutableListOf((Object[])new VideoInfoModel[]{new CoubVideoInfoModel(), new DailymotionVideoInfoModel(), new FacebookVideoInfoModel(), new HuluVideoInfoModel(), new RutubeVideoInfoModel(), new TedTalksVideoInfoModel(), new UstreamVideoInfoModel(), new VimeoVideoInfoModel(), new VzaarVideoInfoModel(), new WistiaVideoInfoModel(), new YoutubeMusicVideoInfoModel(), new YoutubeVideoInfoModel(), new UltimediaVideoInfoModel()});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J1\u0010\u001e\u001a\u00020\u0000\"\u0010\b\u0000\u0010\u001f*\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001f0!\"\u0002H\u001f\u00a2\u0006\u0002\u0010\"R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/gapps/library/api/VideoService$Builder;", "", "()V", "<set-?>", "Landroid/content/Context;", "context", "getContext", "()Landroid/content/Context;", "customModels", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "getCustomModels", "()Ljava/util/List;", "", "isCacheEnabled", "()Z", "isLogEnabled", "Lokhttp3/OkHttpClient;", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "build", "Lcom/gapps/library/api/VideoService;", "enableCache", "isEnabled", "enableLog", "httpClient", "client", "with", "withCustomVideoInfoModels", "T", "models", "", "([Lcom/gapps/library/api/models/api/base/VideoInfoModel;)Lcom/gapps/library/api/VideoService$Builder;", "library_release"})
    public static final class Builder {
        @NotNull
        private OkHttpClient okHttpClient = new OkHttpClient();
        private boolean isLogEnabled;
        private boolean isCacheEnabled;
        @Nullable
        private Context context;
        @NotNull
        private final List<VideoInfoModel<? extends BaseVideoResponse>> customModels;

        @NotNull
        public final OkHttpClient getOkHttpClient() {
            return this.okHttpClient;
        }

        public final boolean isLogEnabled() {
            return this.isLogEnabled;
        }

        public final boolean isCacheEnabled() {
            return this.isCacheEnabled;
        }

        @Nullable
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final List<VideoInfoModel<? extends BaseVideoResponse>> getCustomModels() {
            return this.customModels;
        }

        @NotNull
        public final Builder with(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.context = context;
            return builder;
        }

        @NotNull
        public final Builder httpClient(@NotNull OkHttpClient client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.okHttpClient = client;
            return builder;
        }

        @NotNull
        public final Builder enableLog(boolean isEnabled) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isLogEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final Builder enableCache(boolean isEnabled) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isCacheEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final <T extends VideoInfoModel<? extends BaseVideoResponse>> Builder withCustomVideoInfoModels(T ... models) {
            Intrinsics.checkParameterIsNotNull(models, (String)"models");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            CollectionsKt.addAll((Collection)$this$apply.customModels, (Object[])models);
            return builder;
        }

        @NotNull
        public final VideoService build() {
            return new VideoService(this);
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.customModels = list = (List)new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011H\u0086\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/gapps/library/api/VideoService$Companion;", "", "()V", "TAG", "", "videoInfoModelsList", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "getVideoInfoModelsList", "()Ljava/util/List;", "build", "Lcom/gapps/library/api/VideoService;", "block", "Lkotlin/Function1;", "Lcom/gapps/library/api/VideoService$Builder;", "", "Lkotlin/ExtensionFunctionType;", "library_release"})
    public static final class Companion {
        @NotNull
        public final List<VideoInfoModel<? extends BaseVideoResponse>> getVideoInfoModelsList() {
            return videoInfoModelsList;
        }

        @NotNull
        public final VideoService build(@NotNull Function1<? super Builder, Unit> block) {
            int $i$f$build = 0;
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            Builder builder = new Builder();
            boolean bl = false;
            boolean bl2 = false;
            block.invoke((Object)builder);
            return builder.build();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

