/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api.models.api;

import com.gapps.library.api.models.api.base.VideoInfoModel;
import com.gapps.library.api.models.video.ustream.UstreamResponse;
import com.gapps.library.utils.RegexKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/gapps/library/api/models/api/UstreamVideoInfoModel;", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/ustream/UstreamResponse;", "()V", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "hostingName", "getHostingName", "idPattern", "getIdPattern", "pattern", "getPattern", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "getInfoUrl", "incomingUrl", "getPlayLink", "videoId", "library_release"})
public final class UstreamVideoInfoModel
extends VideoInfoModel<UstreamResponse> {
    @Override
    @NotNull
    public String getBaseUrl() {
        return "https://video.ibm.com/";
    }

    @Override
    @NotNull
    public String getPattern() {
        return "(?:http[s]?:\\/\\/)?(?:www\\.)?ustream.(?:com|tv)\\/(?:recorded|embed|channel)\\/?(?:([0-9]+)|(\\S+))(?:\\/\\S*)?";
    }

    @Override
    @NotNull
    public String getIdPattern() {
        return this.getPattern();
    }

    @Override
    @NotNull
    public Class<UstreamResponse> getType() {
        return UstreamResponse.class;
    }

    @Override
    @NotNull
    public String getHostingName() {
        return "Ustream";
    }

    @Override
    @Nullable
    public String getInfoUrl(@Nullable String incomingUrl) {
        String string;
        if (incomingUrl == null) {
            return null;
        }
        String id = this.parseVideoId(incomingUrl);
        String channelId = RegexKt.getGroupValue(this.getPattern(), incomingUrl, 2);
        if (id == null || StringsKt.contains$default((CharSequence)incomingUrl, (CharSequence)"channel", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append("https://ustream.tv/channel/");
            String string2 = channelId;
            if (string2 == null) {
                string2 = id;
            }
            string = stringBuilder.append(string2).toString();
        } else {
            string = "https://ustream.tv/recorded/" + id;
        }
        String url = string;
        return this.getBaseUrl() + "/oembed?url=" + url;
    }

    @Override
    @NotNull
    public String getPlayLink(@NotNull String videoId) {
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        return "http://www.ustream.tv/embed/" + videoId;
    }
}

