/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api;

import android.content.Context;
import android.util.Log;
import com.gapps.library.api.Helper2;
import com.gapps.library.api.models.api.CoubVideoInfoModel;
import com.gapps.library.api.models.api.DailymotionVideoInfoModel;
import com.gapps.library.api.models.api.FacebookVideoInfoModel;
import com.gapps.library.api.models.api.HuluVideoInfoModel;
import com.gapps.library.api.models.api.RutubeVideoInfoModel;
import com.gapps.library.api.models.api.TedTalksVideoInfoModel;
import com.gapps.library.api.models.api.UstreamVideoInfoModel;
import com.gapps.library.api.models.api.VimeoVideoInfoModel;
import com.gapps.library.api.models.api.VzaarVideoInfoModel;
import com.gapps.library.api.models.api.WistiaVideoInfoModel;
import com.gapps.library.api.models.api.YoutubeMusicVideoInfoModel;
import com.gapps.library.api.models.api.YoutubeVideoInfoModel;
import com.gapps.library.api.models.api.base.VideoInfoModel;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.api.models.video.base.BaseVideoResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u00192\u001c\b\u0002\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001cR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/gapps/library/api/VideoService;", "", "builder", "Lcom/gapps/library/api/VideoService$Builder;", "(Lcom/gapps/library/api/VideoService$Builder;)V", "context", "Landroid/content/Context;", "client", "Lokhttp3/OkHttpClient;", "isCacheEnabled", "", "isLogEnabled", "(Landroid/content/Context;Lokhttp3/OkHttpClient;ZZ)V", "()Z", "videoHelper", "Lcom/gapps/library/api/Helper2;", "videoInfoModelsList", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "loadVideoPreview", "", "url", "", "onSuccess", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "onError", "Lkotlin/Function2;", "Builder", "Companion", "library_release"})
public final class VideoService {
    private final List<VideoInfoModel<? extends BaseVideoResponse>> videoInfoModelsList;
    private final Helper2 videoHelper;
    private final boolean isLogEnabled;
    public static final Companion Companion = new Companion(null);

    public final void loadVideoPreview(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> onSuccess, @Nullable Function2<? super String, ? super String, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        if (this.isLogEnabled) {
            Log.i((String)"VideoService", (String)("loading url: " + url));
        }
        Function1 callback2 = (Function1)new Function1<VideoPreviewModel, Unit>(onSuccess){
            final /* synthetic */ Function1 $onSuccess;

            public final void invoke(@NotNull VideoPreviewModel model2) {
                Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
                this.$onSuccess.invoke((Object)model2);
            }
            {
                this.$onSuccess = function1;
                super(1);
            }
        };
        Function2 callbackError2 = (Function2)new Function2<String, String, Unit>(onError){
            final /* synthetic */ Function2 $onError;

            public final void invoke(@NotNull String requestUrl, @NotNull String error) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)requestUrl, (String)"requestUrl");
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    Function2 function2 = this.$onError;
                    if (function2 == null) break block0;
                    Function2 function22 = function2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Function2 $this$run = function22;
                    boolean bl3 = false;
                    $this$run.invoke((Object)requestUrl, (Object)error);
                }
            }
            {
                this.$onError = function2;
                super(2);
            }
        };
        try {
            Iterable $this$forEach$iv = this.videoInfoModelsList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VideoInfoModel it = (VideoInfoModel)element$iv;
                boolean bl = false;
                if (!it.checkHostAffiliation(url)) continue;
                this.videoHelper.getVideoInfo(url, it, (Function1<? super VideoPreviewModel, Unit>)callback2, (Function2<? super String, ? super String, Unit>)callbackError2);
                return;
            }
        }
        catch (Exception e) {
            callbackError2.invoke((Object)url, (Object)"Err 1. Unknown video service. \nPlease, visit https://github.com/TalbotGooday/Android-Oembed-Video for more information about available services");
        }
    }

    public static /* synthetic */ void loadVideoPreview$default(VideoService videoService, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        videoService.loadVideoPreview(string, (Function1<? super VideoPreviewModel, Unit>)function1, (Function2<? super String, ? super String, Unit>)function2);
    }

    public final boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public VideoService(@Nullable Context context, @NotNull OkHttpClient client, boolean isCacheEnabled, boolean isLogEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.isLogEnabled = isLogEnabled;
        this.videoInfoModelsList = CollectionsKt.mutableListOf((Object[])new VideoInfoModel[]{new CoubVideoInfoModel(), new DailymotionVideoInfoModel(), new FacebookVideoInfoModel(), new HuluVideoInfoModel(), new RutubeVideoInfoModel(), new TedTalksVideoInfoModel(), new UstreamVideoInfoModel(), new VimeoVideoInfoModel(), new VzaarVideoInfoModel(), new WistiaVideoInfoModel(), new YoutubeMusicVideoInfoModel(), new YoutubeVideoInfoModel()});
        this.videoHelper = new Helper2(context, client, isCacheEnabled);
    }

    public VideoService(@NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this(builder.getContext(), builder.getOkHttpClient(), builder.isCacheEnabled(), builder.isLogEnabled());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/gapps/library/api/VideoService$Builder;", "", "()V", "<set-?>", "Landroid/content/Context;", "context", "getContext", "()Landroid/content/Context;", "", "isCacheEnabled", "()Z", "isLogEnabled", "Lokhttp3/OkHttpClient;", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "build", "Lcom/gapps/library/api/VideoService;", "enableCache", "isEnabled", "enableLog", "httpClient", "client", "with", "library_release"})
    public static final class Builder {
        @NotNull
        private OkHttpClient okHttpClient = new OkHttpClient();
        private boolean isLogEnabled;
        private boolean isCacheEnabled;
        @Nullable
        private Context context;

        @NotNull
        public final OkHttpClient getOkHttpClient() {
            return this.okHttpClient;
        }

        public final boolean isLogEnabled() {
            return this.isLogEnabled;
        }

        public final boolean isCacheEnabled() {
            return this.isCacheEnabled;
        }

        @Nullable
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final Builder with(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.context = context;
            return builder;
        }

        @NotNull
        public final Builder httpClient(@NotNull OkHttpClient client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.okHttpClient = client;
            return builder;
        }

        @NotNull
        public final Builder enableLog(boolean isEnabled) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isLogEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final Builder enableCache(boolean isEnabled) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isCacheEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final VideoService build() {
            return new VideoService(this);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0086\b\u00a8\u0006\n"}, d2={"Lcom/gapps/library/api/VideoService$Companion;", "", "()V", "build", "Lcom/gapps/library/api/VideoService;", "block", "Lkotlin/Function1;", "Lcom/gapps/library/api/VideoService$Builder;", "", "Lkotlin/ExtensionFunctionType;", "library_release"})
    public static final class Companion {
        @NotNull
        public final VideoService build(@NotNull Function1<? super Builder, Unit> block) {
            int $i$f$build = 0;
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            Builder builder = new Builder();
            boolean bl = false;
            boolean bl2 = false;
            block.invoke((Object)builder);
            return builder.build();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

